/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web.channel;

import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.web.WebConnectorKt;
import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.WebMessage;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.ChannelDAO;
import ai.tock.bot.connector.web.channel.ChannelEvent;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072%\u0010\r\u001a!\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0014J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/bot/connector/web/channel/Channels;", "", "channelDAO", "Lai/tock/bot/connector/web/channel/ChannelDAO;", "(Lai/tock/bot/connector/web/channel/ChannelDAO;)V", "channelsByUser", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lai/tock/bot/connector/web/channel/Channel;", "register", "appId", "userId", "onAction", "Lkotlin/Function1;", "Lai/tock/bot/connector/web/WebConnectorResponse;", "Lkotlin/ParameterName;", "name", "webConnectorResponse", "", "Lai/tock/bot/connector/web/channel/ChannelCallback;", "send", "action", "Lai/tock/bot/engine/action/Action;", "unregister", "channel", "tock-bot-connector-web"})
public final class Channels {
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Channel>> channelsByUser;
    private final ChannelDAO channelDAO;

    @NotNull
    public final Channel register(@NotNull String appId, @NotNull String userId, @NotNull Function1<? super WebConnectorResponse, Unit> onAction) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        ConcurrentMap $this$getOrPut$iv = this.channelsByUser;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(userId);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            boolean bl2 = false;
            boolean bl3 = false;
            CopyOnWriteArrayList default$iv = copyOnWriteArrayList;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(userId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArrayList channels2 = (CopyOnWriteArrayList)object;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        Channel channel = new Channel(appId, uUID, userId, onAction);
        channels2.add(channel);
        return channel;
    }

    public final void unregister(@NotNull Channel channel) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            CopyOnWriteArrayList<Channel> copyOnWriteArrayList = this.channelsByUser.get(channel.getUserId());
            if (copyOnWriteArrayList == null) break block0;
            copyOnWriteArrayList.removeIf(new Predicate<Channel>(channel){
                final /* synthetic */ Channel $channel;

                public final boolean test(Channel _channel) {
                    return Intrinsics.areEqual((Object)_channel.getUuid(), (Object)this.$channel.getUuid());
                }
                {
                    this.$channel = channel;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void send(@NotNull Action action) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Iterable $this$filterIsInstance$iv = CollectionsKt.listOf((Object)action);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SendSentence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WebMessage webMessage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SendSentence it = (SendSentence)element$iv$iv;
            boolean bl2 = false;
            if (it.getStringText() != null) {
                String string = it.getStringText();
                Intrinsics.checkNotNull((Object)string);
                webMessage = new WebMessage(string, null, null, null, null, null, null, 126, null);
            } else if (it.message(WebConnectorKt.getWebConnectorType()) != null) {
                ConnectorMessage connectorMessage;
                boolean bl3 = false;
                boolean bl4 = false;
                ConnectorMessage it2 = connectorMessage;
                boolean bl5 = false;
                ConnectorMessage connectorMessage2 = it2;
                if (!(connectorMessage2 instanceof WebMessage)) {
                    connectorMessage2 = null;
                }
                webMessage = (WebMessage)connectorMessage2;
            } else {
                webMessage = null;
            }
            if (webMessage == null) continue;
            WebMessage webMessage2 = webMessage;
            boolean bl6 = false;
            boolean bl7 = false;
            WebMessage it$iv$iv = webMessage2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List messages = (List)destination$iv$iv;
        this.channelDAO.save(new ChannelEvent(action.getApplicationId(), action.getRecipientId().getId(), new WebConnectorResponse(messages)));
    }

    public Channels(@NotNull ChannelDAO channelDAO) {
        Intrinsics.checkNotNullParameter((Object)channelDAO, (String)"channelDAO");
        this.channelDAO = channelDAO;
        this.channelsByUser = new ConcurrentHashMap();
        this.channelDAO.listenChanges((Function1<? super ChannelEvent, Unit>)((Function1)new Function1<ChannelEvent, Unit>(){

            public final void invoke(@NotNull ChannelEvent channelEvent) {
                Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"channelEvent");
                CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)channelsByUser.get(channelEvent.getRecipientId());
                if (copyOnWriteArrayList != null) {
                    Iterable $this$forEach$iv = copyOnWriteArrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Channel channel = (Channel)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)channel.getAppId(), (Object)channelEvent.getAppId())) continue;
                        channel.getOnAction().invoke((Object)channelEvent.getWebConnectorResponse());
                    }
                }
            }
        }));
    }
}

