/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorFeature;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaCarousel;
import ai.tock.bot.connector.media.MediaFile;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.web.WebBuildersKt;
import ai.tock.bot.connector.web.WebConnector;
import ai.tock.bot.connector.web.WebConnectorCallback;
import ai.tock.bot.connector.web.WebConnectorKt;
import ai.tock.bot.connector.web.WebConnectorRequest;
import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.WebMessage;
import ai.tock.bot.connector.web.WebMessageProcessor;
import ai.tock.bot.connector.web.WebModelsKt;
import ai.tock.bot.connector.web.WebRequestInfos;
import ai.tock.bot.connector.web.WebRequestInfosByEvent;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.Channels;
import ai.tock.bot.connector.web.send.Button;
import ai.tock.bot.connector.web.send.PostbackButton;
import ai.tock.bot.connector.web.send.UrlButton;
import ai.tock.bot.connector.web.send.WebCard;
import ai.tock.bot.connector.web.send.WebCarousel;
import ai.tock.bot.connector.web.send.WebDeepLink;
import ai.tock.bot.connector.web.send.WebImage;
import ai.tock.bot.connector.web.send.WebMediaFile;
import ai.tock.bot.connector.web.send.WebWidget;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.MetadataEvent;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.orchestration.bot.secondary.OrchestrationCallback;
import ai.tock.bot.orchestration.bot.secondary.RestOrchestrationCallback;
import ai.tock.bot.orchestration.connector.OrchestrationConnector;
import ai.tock.bot.orchestration.connector.OrchestrationHandlers;
import ai.tock.bot.orchestration.shared.AskEligibilityToOrchestratedBotRequest;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.ResumeOrchestrationRequest;
import ai.tock.bot.orchestration.shared.SecondaryBotEligibilityResponse;
import ai.tock.bot.orchestration.shared.SecondaryBotResponse;
import ai.tock.shared.Dice;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J1\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J1\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013\u00a2\u0006\u0002\b\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010.\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010/\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0004H\u0002J\u0018\u00101\u001a\u00020&2\u0006\u0010*\u001a\u0002022\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u00103\u001a\u0002042\u0006\u0010*\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J \u00109\u001a\u00020&2\u0006\u0010,\u001a\u00020:2\u0006\u0010*\u001a\u0002052\u0006\u0010;\u001a\u00020<H\u0016J'\u0010=\u001a\u0019\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u0013\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020>H\u0016J\f\u0010?\u001a\u00020&*\u00020@H\u0002J\f\u0010A\u001a\u00020B*\u00020CH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006E"}, d2={"Lai/tock/bot/connector/web/WebConnector;", "Lai/tock/bot/connector/ConnectorBase;", "Lai/tock/bot/orchestration/connector/OrchestrationConnector;", "applicationId", "", "path", "(Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "getPath", "persistProfileLoaded", "", "getPersistProfileLoaded", "()Z", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "message", "suggestions", "", "", "text", "extraHeadersAsMetadata", "", "requestInfos", "Lai/tock/bot/connector/web/WebRequestInfos;", "getOrCreateUserIdCookie", "context", "Lio/vertx/ext/web/RoutingContext;", "getOrchestrationHandlers", "Lai/tock/bot/orchestration/connector/OrchestrationHandlers;", "handleEligibility", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "handleOrchestrationCallback", "callback", "Lai/tock/bot/orchestration/bot/secondary/OrchestrationCallback;", "event", "Lai/tock/bot/engine/action/Action;", "handleProxy", "handleRequest", "body", "handleWebConnectorCallback", "Lai/tock/bot/connector/web/WebConnectorCallback;", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "Lai/tock/bot/connector/ConnectorCallback;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "register", "send", "Lai/tock/bot/engine/event/Event;", "delayInMs", "", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "sendSsePing", "Lio/vertx/core/http/HttpServerResponse;", "toButton", "Lai/tock/bot/connector/web/send/Button;", "Lai/tock/bot/connector/media/MediaAction;", "Companion", "tock-bot-connector-web"})
@SourceDebugExtension(value={"SMAP\nWebConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConnector.kt\nai/tock/bot/connector/web/WebConnector\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n53#2,2:438\n51#3:440\n277#4:441\n50#5:442\n43#5:443\n50#5:447\n43#5:448\n50#5:449\n43#5:450\n1#6:444\n1855#7,2:445\n*S KotlinDebug\n*F\n+ 1 WebConnector.kt\nai/tock/bot/connector/web/WebConnector\n*L\n117#1:438,2\n117#1:440\n117#1:441\n225#1:442\n225#1:443\n286#1:447\n286#1:448\n310#1:449\n310#1:450\n270#1:445,2\n*E\n"})
public final class WebConnector
extends ConnectorBase
implements OrchestrationConnector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    private final boolean persistProfileLoaded;
    @NotNull
    private static final KLogger logger;
    private static final ObjectMapper webMapper;
    @NotNull
    private static final WebMessageProcessor messageProcessor;
    @NotNull
    private static final Lazy<Channels> channels$delegate;

    public WebConnector(@NotNull String applicationId2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(WebConnectorKt.getWebConnectorType(), SetsKt.setOf((Object)ConnectorFeature.CAROUSEL));
        this.applicationId = applicationId2;
        this.path = path;
        this.persistProfileLoaded = PropertiesKt.booleanProperty((String)"tock_web_connector_persist_profile", (boolean)false);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ WebConnector this$0;
            final /* synthetic */ ConnectorController $controller;
            {
                this.this$0 = $receiver;
                this.$controller = $controller;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Router router) {
                CorsHandler $this$invoke_u24lambda_u240;
                CorsHandler corsHandler;
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                WebConnector.access$getLogger$cp().debug("deploy web connector services for root path " + this.this$0.getPath() + " ");
                CorsHandler corsHandler2 = CorsHandler.create((String)(WebConnectorKt.access$getCookieAuth$p() ? ".*" : "*")).allowedMethod(HttpMethod.POST);
                Route route = router.route(this.this$0.getPath());
                boolean bl = false;
                $this$invoke_u24lambda_u240 = corsHandler = (WebConnectorKt.access$getSseEnabled$p() ? $this$invoke_u24lambda_u240.allowedMethod(HttpMethod.GET) : $this$invoke_u24lambda_u240).allowedHeader("Access-Control-Allow-Origin").allowedHeader("Content-Type").allowedHeader("X-Requested-With");
                boolean bl2 = false;
                Iterable $this$forEach$iv = WebConnectorKt.getWebConnectorExtraHeaders();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$invoke_u24lambda_u242;
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u242.allowedHeader(it);
                }
                route.handler((Handler)corsHandler.allowCredentials(WebConnectorKt.access$getCookieAuth$p()));
                if (WebConnectorKt.access$getSseEnabled$p()) {
                    router.route(this.this$0.getPath() + "/sse").handler(arg_0 -> register.1.invoke$lambda$5(this.this$0, arg_0));
                }
                router.post(this.this$0.getPath()).handler(arg_0 -> register.1.invoke$lambda$6(this.this$0, this.$controller, arg_0));
            }

            private static final void invoke$lambda$5$lambda$3(WebConnector this$0, HttpServerResponse $response, Long it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullExpressionValue((Object)$response, (String)"response");
                WebConnector.access$sendSsePing(this$0, $response);
            }

            private static final void invoke$lambda$5$lambda$4(long $timerId, Channel $channelId, Void it) {
                Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
                VertXsKt.getVertx().cancelTimer($timerId);
                ai.tock.bot.connector.web.WebConnector$Companion.access$getChannels(WebConnector.Companion).unregister($channelId);
            }

            private static final void invoke$lambda$5(WebConnector this$0, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                try {
                    String string;
                    if (WebConnectorKt.access$getCookieAuth$p()) {
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                        string = WebConnector.access$getOrCreateUserIdCookie(this$0, context);
                    } else {
                        string = context.queryParams().get("userId");
                    }
                    String userId = string;
                    HttpServerResponse response = context.response();
                    response.setChunked(true);
                    response.headers().add("Content-Type", "text/event-stream;charset=UTF-8");
                    response.headers().add("Connection", "keep-alive");
                    response.headers().add("Cache-Control", "no-cache");
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    WebConnector.access$sendSsePing(this$0, response);
                    long timerId = VertXsKt.getVertx().setPeriodic(Duration.ofSeconds(WebConnectorKt.access$getSseKeepaliveDelay$p()).toMillis(), arg_0 -> register.1.invoke$lambda$5$lambda$3(this$0, response, arg_0));
                    Channels channels2 = ai.tock.bot.connector.web.WebConnector$Companion.access$getChannels(WebConnector.Companion);
                    String string2 = this$0.getApplicationId();
                    Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
                    Channel channelId2 = channels2.register(string2, userId, (Function1<? super WebConnectorResponse, Unit>)((Function1)new Function1<WebConnectorResponse, Unit>(response){
                        final /* synthetic */ HttpServerResponse $response;
                        {
                            this.$response = $response;
                            super(1);
                        }

                        public final void invoke(@NotNull WebConnectorResponse webConnectorResponse) {
                            Intrinsics.checkNotNullParameter((Object)webConnectorResponse, (String)"webConnectorResponse");
                            this.$response.write("event: message\n");
                            this.$response.write("data: " + WebConnector.access$getWebMapper$cp().writeValueAsString((Object)webConnectorResponse) + "\n\n");
                        }
                    }));
                    response.closeHandler(arg_0 -> register.1.invoke$lambda$5$lambda$4(timerId, channelId2, arg_0));
                }
                catch (Throwable t) {
                    context.fail(t);
                }
            }

            private static final void invoke$lambda$6(WebConnector this$0, ConnectorController $controller, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                try {
                    WebConnector.access$getExecutor(this$0).executeBlocking((Function0)new Function0<Unit>(context, this$0, $controller){
                        final /* synthetic */ RoutingContext $context;
                        final /* synthetic */ WebConnector this$0;
                        final /* synthetic */ ConnectorController $controller;
                        {
                            this.$context = $context;
                            this.this$0 = $receiver;
                            this.$controller = $controller;
                            super(0);
                        }

                        public final void invoke() {
                            String string;
                            if (WebConnectorKt.access$getCookieAuth$p()) {
                                JsonObject jsonObject = this.$context.body().asJsonObject();
                                if (jsonObject == null) {
                                    jsonObject = new JsonObject();
                                }
                                JsonObject jsonBody = jsonObject;
                                RoutingContext routingContext = this.$context;
                                Intrinsics.checkNotNullExpressionValue((Object)routingContext, (String)"context");
                                String userId = WebConnector.access$getOrCreateUserIdCookie(this.this$0, routingContext);
                                jsonBody.put("userId", (Object)userId);
                                string = jsonBody.toString();
                            } else {
                                string = this.$context.body().asString();
                            }
                            String body = string;
                            RoutingContext routingContext = this.$context;
                            Intrinsics.checkNotNullExpressionValue((Object)routingContext, (String)"context");
                            Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                            WebConnector.access$handleRequest(this.this$0, this.$controller, routingContext, body);
                        }
                    });
                }
                catch (Throwable e) {
                    context.fail(e);
                }
            }
        });
    }

    private final String getOrCreateUserIdCookie(RoutingContext context) {
        String string;
        String string2;
        Cookie cookie = context.request().getCookie("tock_user_id");
        String string3 = string2 = cookie != null ? cookie.getValue() : null;
        if (string2 == null) {
            String string4;
            String uuid = string4 = UUID.randomUUID().toString();
            boolean bl = false;
            context.response().addCookie(Cookie.cookie((String)"tock_user_id", (String)uuid).setHttpOnly(true).setSecure(true).setSameSite(CookieSameSite.NONE));
            String string5 = string4;
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"randomUUID().toString().\u2026)\n            )\n        }");
        } else {
            string = string2;
        }
        return string;
    }

    private final void sendSsePing(HttpServerResponse $this$sendSsePing) {
        $this$sendSsePing.write("event: ping\n");
        $this$sendSsePing.write("data: 1\n\n");
    }

    @NotNull
    public OrchestrationHandlers getOrchestrationHandlers() {
        return new OrchestrationHandlers((Function2)new Function2<ConnectorController, RoutingContext, Unit>((Object)this){

            public final void invoke(@NotNull ConnectorController p0, @NotNull RoutingContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WebConnector.access$handleEligibility((WebConnector)((Object)this.receiver), p0, p1);
            }
        }, (Function2)new Function2<ConnectorController, RoutingContext, Unit>((Object)this){

            public final void invoke(@NotNull ConnectorController p0, @NotNull RoutingContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WebConnector.access$handleProxy((WebConnector)((Object)this.receiver), p0, p1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRequest(ConnectorController controller, RoutingContext context, String body) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook");
        try {
            String string;
            logger.debug((Function0)new Function0<Object>(body){
                final /* synthetic */ String $body;
                {
                    this.$body = $body;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Web request input : " + this.$body;
                }
            });
            ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            WebConnectorRequest request = (WebConnectorRequest)$this$readValue$iv.readValue(body, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<WebConnectorRequest>(){});
            String string2 = request.getConnectorId();
            boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
            if (bl) {
                if (WebConnectorKt.access$getWebConnectorBridgeEnabled$p()) {
                    String it = $i$f$readValue = request.getConnectorId();
                    boolean bl2 = false;
                    logger.debug((Function0)new Function0<Object>(this, it){
                        final /* synthetic */ WebConnector this$0;
                        final /* synthetic */ String $it;
                        {
                            this.this$0 = $receiver;
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Web bridge: " + this.this$0.getApplicationId() + " -> " + this.$it;
                        }
                    });
                    string = $i$f$readValue;
                } else {
                    String it = $i$f$readValue = this.applicationId;
                    boolean bl3 = false;
                    logger.warn((Function0)handleRequest.applicationId.2.1.INSTANCE);
                    string = $i$f$readValue;
                }
            } else {
                string = this.applicationId;
            }
            String applicationId2 = string;
            Event event = request.toEvent(applicationId2);
            HttpServerRequest httpServerRequest = context.request();
            Intrinsics.checkNotNullExpressionValue((Object)httpServerRequest, (String)"context.request()");
            WebRequestInfos requestInfos = new WebRequestInfos(httpServerRequest);
            WebRequestInfosByEvent.INSTANCE.put$tock_bot_connector_web(event.getId().toString(), requestInfos);
            Locale locale = request.getLocale();
            ObjectMapper objectMapper = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"webMapper");
            WebConnectorCallback callback = new WebConnectorCallback(applicationId2, locale, context, null, null, objectMapper, event.getId().toString(), messageProcessor, 24, null);
            controller.handle(event, new ConnectorData((ConnectorCallback)callback, null, false, null, null, this.extraHeadersAsMetadata(requestInfos), 30, null));
        }
        catch (Throwable t) {
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
            context.fail(t);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    private final Map<String, String> extraHeadersAsMetadata(WebRequestInfos requestInfos) {
        Map metaDataExtraHeaders = new LinkedHashMap();
        if (WebConnectorKt.getWebConnectorUseExtraHeadersAsMetadata()) {
            Iterable $this$forEach$iv = WebConnectorKt.getWebConnectorExtraHeaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String header = (String)element$iv;
                boolean bl = false;
                if (requestInfos.firstHeader(header) != null) {
                    String it;
                    boolean bl2 = false;
                    metaDataExtraHeaders.putIfAbsent(header, it);
                }
            }
        }
        return metaDataExtraHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleProxy(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_orchestred");
        try {
            void $this$readValue$iv;
            logger.debug((Function0)new Function0<Object>(context){
                final /* synthetic */ RoutingContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Web proxy request input : " + this.$context.body().asString();
                }
            });
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.body().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.body().asString()");
            String content$iv = string;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            ResumeOrchestrationRequest request = (ResumeOrchestrationRequest)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<ResumeOrchestrationRequest>(){});
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            controller.handle(request.toAction(), new ConnectorData((ConnectorCallback)callback, null, false, null, null, null, 62, null));
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleEligibility(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_support");
        try {
            void $this$readValue$iv;
            logger.debug((Function0)new Function0<Object>(context){
                final /* synthetic */ RoutingContext $context;
                {
                    this.$context = $context;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Web support request input : " + this.$context.body().asString();
                }
            });
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.body().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.body().asString()");
            String content$iv = string;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            AskEligibilityToOrchestratedBotRequest request = (AskEligibilityToOrchestratedBotRequest)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<AskEligibilityToOrchestratedBotRequest>(){});
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            double support = controller.support(request.toAction(this.applicationId), new ConnectorData((ConnectorCallback)callback, null, false, null, null, null, 62, null));
            PlayerId playerId = new PlayerId(this.applicationId, PlayerType.bot, null, 4, null);
            OrchestrationMetaData orchestrationMetaData = request.getMetadata();
            if (orchestrationMetaData == null || (orchestrationMetaData = orchestrationMetaData.getPlayerId()) == null) {
                orchestrationMetaData = new PlayerId(Dice.INSTANCE.newId(), PlayerType.user, null, 4, null);
            }
            SecondaryBotEligibilityResponse sendEligibility = new SecondaryBotEligibilityResponse(support, new OrchestrationMetaData(playerId, this.applicationId, (PlayerId)orchestrationMetaData));
            callback.sendResponse((SecondaryBotResponse)sendEligibility);
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Event event2 = event;
        if (event2 instanceof Action) {
            ConnectorCallback connectorCallback = callback;
            if (connectorCallback instanceof WebConnectorCallback) {
                this.handleWebConnectorCallback((WebConnectorCallback)callback, (Action)event);
            } else if (connectorCallback instanceof OrchestrationCallback) {
                this.handleOrchestrationCallback((OrchestrationCallback)callback, (Action)event);
            }
        } else if (event2 instanceof MetadataEvent) {
            WebConnectorCallback webConnectorCallback = callback instanceof WebConnectorCallback ? (WebConnectorCallback)callback : null;
            if (webConnectorCallback != null) {
                webConnectorCallback.addMetadata((MetadataEvent)event);
            }
        } else {
            logger.trace((Function0)new Function0<Object>(event){
                final /* synthetic */ Event $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "unsupported event: " + this.$event;
                }
            });
        }
    }

    private final void handleWebConnectorCallback(WebConnectorCallback callback, Action event) {
        callback.addAction(event);
        if (WebConnectorKt.access$getSseEnabled$p()) {
            WebConnector.Companion.getChannels().send(event);
        }
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    private final void handleOrchestrationCallback(OrchestrationCallback callback, Action event) {
        callback.getActions().add(event);
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    public boolean getPersistProfileLoaded() {
        return this.persistProfileLoaded;
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (callback instanceof WebConnectorCallback) {
            UserPreferences userPreferences2;
            UserPreferences $this$loadProfile_u24lambda_u245 = userPreferences2 = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
            boolean bl = false;
            $this$loadProfile_u24lambda_u245.setLocale(((WebConnectorCallback)callback).getLocale());
            userPreferences = userPreferences2;
        } else {
            userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
        }
        return userPreferences;
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, WebMessage>(text, suggestions){
            final /* synthetic */ CharSequence $text;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$text = $text;
                this.$suggestions = $suggestions;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final WebMessage invoke(@NotNull BotBus $this$null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Iterable iterable = this.$suggestions;
                String string = ((Object)this.$text).toString();
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CharSequence charSequence = (CharSequence)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)$this$null, (CharSequence)it, null, null, null, 14, null));
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 252;
                WebDeepLink webDeepLink = null;
                String string2 = null;
                WebImage webImage = null;
                WebWidget webWidget = null;
                WebCarousel webCarousel = null;
                WebCard webCard = null;
                List list = (List)destination$iv$iv;
                String string3 = string;
                return new WebMessage(string3, list, webCard, webCarousel, webWidget, webImage, string2, webDeepLink, n, defaultConstructorMarker);
            }
        };
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return (Function1)new Function1<BotBus, ConnectorMessage>(message, suggestions){
            final /* synthetic */ ConnectorMessage $message;
            final /* synthetic */ List<CharSequence> $suggestions;
            {
                this.$message = $message;
                this.$suggestions = $suggestions;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final ConnectorMessage invoke(@NotNull BotBus $this$null) {
                ConnectorMessage connectorMessage;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                ConnectorMessage connectorMessage2 = this.$message;
                WebMessage webMessage = connectorMessage2 instanceof WebMessage ? (WebMessage)connectorMessage2 : null;
                if (webMessage != null) {
                    WebMessage webMessage2;
                    WebMessage webMessage3 = webMessage;
                    List<CharSequence> list = this.$suggestions;
                    WebMessage it = webMessage3;
                    boolean bl = false;
                    if (it.getCard() != null && it.getCard().getButtons().isEmpty()) {
                        Collection<Button> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = list;
                        WebMediaFile webMediaFile = null;
                        CharSequence charSequence = null;
                        CharSequence charSequence2 = null;
                        WebCard webCard = it.getCard();
                        List list2 = null;
                        String string = null;
                        WebMessage webMessage4 = it;
                        boolean $i$f$map = false;
                        void var16_21 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void s;
                            CharSequence charSequence3 = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)$this$null, (CharSequence)s, null, null, null, 14, null));
                        }
                        collection = (List)destination$iv$iv;
                        webMessage2 = WebMessage.copy$default(webMessage4, string, list2, WebCard.copy$default((WebCard)webCard, charSequence2, charSequence, webMediaFile, (List)collection, (int)7, null), null, null, null, null, null, 251, null);
                    } else if (it.getCard() == null && it.getButtons().isEmpty()) {
                        Collection<Button> collection;
                        Iterable $this$map$iv = list;
                        String string = null;
                        WebMessage webMessage5 = it;
                        boolean $i$f$map = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            CharSequence s = (CharSequence)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl3 = false;
                            collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)$this$null, s, null, null, null, 14, null));
                        }
                        collection = (List)destination$iv$iv;
                        webMessage2 = WebMessage.copy$default(webMessage5, string, (List)collection, null, null, null, null, null, null, 253, null);
                    } else {
                        webMessage2 = null;
                    }
                    webMessage = webMessage2;
                    if (webMessage2 != null) {
                        connectorMessage = (ConnectorMessage)webMessage;
                        return connectorMessage;
                    }
                }
                connectorMessage = this.$message;
                return connectorMessage;
            }
        };
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (Function1)new Function1<BotBus, List<? extends WebMessage>>(message, this){
            final /* synthetic */ MediaMessage $message;
            final /* synthetic */ WebConnector this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<WebMessage> invoke(@NotNull BotBus $this$null) {
                WebMessage webMessage;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                MediaMessage mediaMessage = this.$message;
                if (mediaMessage instanceof MediaCard) {
                    Collection<Button> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    MediaFile mediaFile = ((MediaCard)this.$message).getFile();
                    Iterable iterable = ((MediaCard)this.$message).getActions();
                    WebConnector webConnector = this.this$0;
                    WebMediaFile webMediaFile = mediaFile != null ? WebModelsKt.toWebMediaFile(mediaFile) : null;
                    CharSequence charSequence = ((MediaCard)this.$message).getSubTitle();
                    CharSequence charSequence2 = ((MediaCard)this.$message).getTitle();
                    List list = null;
                    String string = null;
                    boolean $i$f$map = false;
                    void var6_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void button;
                        MediaAction mediaAction = (MediaAction)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(WebConnector.access$toButton(webConnector, (MediaAction)button));
                    }
                    Collection<Button> collection2 = collection = (List)destination$iv$iv;
                    WebMediaFile webMediaFile2 = webMediaFile;
                    CharSequence charSequence3 = charSequence;
                    CharSequence charSequence4 = charSequence2;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 251;
                    WebDeepLink webDeepLink = null;
                    String string2 = null;
                    WebImage webImage = null;
                    WebWidget webWidget = null;
                    WebCarousel webCarousel = null;
                    WebCard webCard = new WebCard(charSequence4, charSequence3, webMediaFile2, collection2);
                    List list2 = list;
                    String string3 = string;
                    webMessage = new WebMessage(string3, list2, webCard, webCarousel, webWidget, webImage, string2, webDeepLink, n, defaultConstructorMarker);
                } else if (mediaMessage instanceof MediaCarousel) {
                    Collection<WebCard> collection;
                    Iterable $this$map$iv = ((MediaCarousel)this.$message).getCards();
                    WebConnector webConnector = this.this$0;
                    WebCard webCard = null;
                    List list = null;
                    String string = null;
                    boolean $i$f$map = false;
                    Iterable $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        Collection<Button> collection3;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        void mediaCard;
                        MediaCard button = (MediaCard)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        MediaFile mediaFile = mediaCard.getFile();
                        Iterable iterable = mediaCard.getActions();
                        WebMediaFile webMediaFile = mediaFile != null ? WebModelsKt.toWebMediaFile(mediaFile) : null;
                        CharSequence charSequence = mediaCard.getSubTitle();
                        CharSequence charSequence5 = mediaCard.getTitle();
                        boolean $i$f$map2 = false;
                        void var18_52 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                            void button2;
                            MediaAction mediaAction = (MediaAction)item$iv$iv2;
                            collection3 = destination$iv$iv2;
                            boolean bl2 = false;
                            collection3.add(WebConnector.access$toButton(webConnector, (MediaAction)button2));
                        }
                        Collection<Button> collection4 = collection3 = (List)destination$iv$iv2;
                        WebMediaFile webMediaFile3 = webMediaFile;
                        CharSequence charSequence6 = charSequence;
                        CharSequence charSequence7 = charSequence5;
                        collection.add(new WebCard(charSequence7, charSequence6, webMediaFile3, collection4));
                    }
                    Collection<WebCard> collection5 = collection = (List)destination$iv$iv;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 247;
                    WebDeepLink webDeepLink = null;
                    String string4 = null;
                    WebImage webImage = null;
                    WebWidget webWidget = null;
                    WebCarousel webCarousel = new WebCarousel((List)collection5);
                    WebCard webCard2 = webCard;
                    List list3 = list;
                    String string5 = string;
                    webMessage = new WebMessage(string5, list3, webCard2, webCarousel, webWidget, webImage, string4, webDeepLink, n, defaultConstructorMarker);
                } else {
                    webMessage = null;
                }
                return CollectionsKt.listOfNotNull(webMessage);
            }
        };
    }

    private final Button toButton(MediaAction $this$toButton) {
        return $this$toButton.getUrl() == null ? (Button)new PostbackButton(((Object)$this$toButton.getTitle()).toString(), null, null, null, 12, null) : (Button)new UrlButton(((Object)$this$toButton.getTitle()).toString(), String.valueOf($this$toButton.getUrl()), null, null, null, 28, null);
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$sendSsePing(WebConnector $this, HttpServerResponse $receiver) {
        $this.sendSsePing($receiver);
    }

    public static final /* synthetic */ String access$getOrCreateUserIdCookie(WebConnector $this, RoutingContext context) {
        return $this.getOrCreateUserIdCookie(context);
    }

    public static final /* synthetic */ ObjectMapper access$getWebMapper$cp() {
        return webMapper;
    }

    public static final /* synthetic */ Executor access$getExecutor(WebConnector $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ void access$handleRequest(WebConnector $this, ConnectorController controller, RoutingContext context, String body) {
        $this.handleRequest(controller, context, body);
    }

    public static final /* synthetic */ void access$handleEligibility(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleEligibility(controller, context);
    }

    public static final /* synthetic */ void access$handleProxy(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleProxy(controller, context);
    }

    public static final /* synthetic */ Button access$toButton(WebConnector $this, MediaAction $receiver) {
        return $this.toButton($receiver);
    }

    public static final /* synthetic */ WebMessageProcessor access$getMessageProcessor$cp() {
        return messageProcessor;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$webMapper_u24lambda_u246;
        SimpleModule simpleModule;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        Module[] moduleArray = new Module[1];
        SimpleModule simpleModule2 = simpleModule = new SimpleModule();
        int n = 0;
        Module[] moduleArray2 = moduleArray;
        ObjectMapper objectMapper = JacksonKt.getMapper().copy();
        boolean bl = false;
        $this$webMapper_u24lambda_u246.addSerializer(CharSequence.class, (JsonSerializer)new ToStringSerializer());
        Unit unit = Unit.INSTANCE;
        moduleArray2[n] = simpleModule;
        webMapper = objectMapper.registerModules(moduleArray);
        String string = PropertiesKt.propertyOrNull((String)"tock_web_enable_markdown");
        messageProcessor = new WebMessageProcessor(string != null ? Boolean.parseBoolean(string) : Boolean.parseBoolean(PropertiesKt.propertyOrNull((String)"allow_markdown")));
        channels$delegate = LazyKt.lazy((Function0)Companion.channels.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/tock/bot/connector/web/WebConnector$Companion;", "", "()V", "channels", "Lai/tock/bot/connector/web/channel/Channels;", "getChannels", "()Lai/tock/bot/connector/web/channel/Channels;", "channels$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "messageProcessor", "Lai/tock/bot/connector/web/WebMessageProcessor;", "webMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "tock-bot-connector-web"})
    public static final class Companion {
        private Companion() {
        }

        private final Channels getChannels() {
            Lazy lazy = channels$delegate;
            return (Channels)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

