/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web.channel;

import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.WebMessageProcessor;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.ChannelDAO;
import ai.tock.bot.connector.web.channel.ChannelEvent;
import ai.tock.bot.engine.action.Action;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J=\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2%\u0010\u000f\u001a!\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010j\u0002`\u0016J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/tock/bot/connector/web/channel/Channels;", "", "channelDAO", "Lai/tock/bot/connector/web/channel/ChannelDAO;", "messageProcessor", "Lai/tock/bot/connector/web/WebMessageProcessor;", "(Lai/tock/bot/connector/web/channel/ChannelDAO;Lai/tock/bot/connector/web/WebMessageProcessor;)V", "channelsByUser", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lai/tock/bot/connector/web/channel/Channel;", "register", "appId", "userId", "onAction", "Lkotlin/Function1;", "Lai/tock/bot/connector/web/WebConnectorResponse;", "Lkotlin/ParameterName;", "name", "webConnectorResponse", "", "Lai/tock/bot/connector/web/channel/ChannelCallback;", "send", "action", "Lai/tock/bot/engine/action/Action;", "unregister", "channel", "tock-bot-connector-web"})
@SourceDebugExtension(value={"SMAP\nChannels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Channels.kt\nai/tock/bot/connector/web/channel/Channels\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n73#2,2:60\n1#3:62\n*S KotlinDebug\n*F\n+ 1 Channels.kt\nai/tock/bot/connector/web/channel/Channels\n*L\n40#1:60,2\n40#1:62\n*E\n"})
public final class Channels {
    @NotNull
    private final ChannelDAO channelDAO;
    @NotNull
    private final WebMessageProcessor messageProcessor;
    @NotNull
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Channel>> channelsByUser;

    public Channels(@NotNull ChannelDAO channelDAO, @NotNull WebMessageProcessor messageProcessor) {
        Intrinsics.checkNotNullParameter((Object)channelDAO, (String)"channelDAO");
        Intrinsics.checkNotNullParameter((Object)messageProcessor, (String)"messageProcessor");
        this.channelDAO = channelDAO;
        this.messageProcessor = messageProcessor;
        this.channelsByUser = new ConcurrentHashMap();
        this.channelDAO.listenChanges((Function1<? super ChannelEvent, Unit>)((Function1)new Function1<ChannelEvent, Unit>(){

            public final void invoke(@NotNull ChannelEvent channelEvent) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"channelEvent");
                    CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)channelsByUser.get(channelEvent.getRecipientId());
                    if (copyOnWriteArrayList == null) break block1;
                    Iterable $this$forEach$iv = copyOnWriteArrayList;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Channel channel = (Channel)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)channel.getAppId(), (Object)channelEvent.getAppId())) continue;
                        channel.getOnAction().invoke((Object)channelEvent.getWebConnectorResponse());
                    }
                }
            }
        }));
    }

    @NotNull
    public final Channel register(@NotNull String appId, @NotNull String userId, @NotNull Function1<? super WebConnectorResponse, Unit> onAction) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        ConcurrentMap $this$getOrPut$iv = this.channelsByUser;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(userId);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArrayList default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(userId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArrayList channels2 = (CopyOnWriteArrayList)object;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        Channel channel = new Channel(appId, uUID, userId, onAction);
        channels2.add(channel);
        return channel;
    }

    public final void unregister(@NotNull Channel channel) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            CopyOnWriteArrayList<Channel> copyOnWriteArrayList = this.channelsByUser.get(channel.getUserId());
            if (copyOnWriteArrayList == null) break block0;
            copyOnWriteArrayList.removeIf(arg_0 -> Channels.unregister$lambda$1((Function1)new Function1<Channel, Boolean>(channel){
                final /* synthetic */ Channel $channel;
                {
                    this.$channel = $channel;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Channel _channel) {
                    return Intrinsics.areEqual((Object)_channel.getUuid(), (Object)this.$channel.getUuid());
                }
            }, arg_0));
        }
    }

    public final void send(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        List messages = CollectionsKt.listOfNotNull((Object)this.messageProcessor.process(action));
        this.channelDAO.save(new ChannelEvent(action.getApplicationId(), action.getRecipientId().getId(), new WebConnectorResponse(messages, null, 2, null)));
    }

    private static final boolean unregister$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

