/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorFeature;
import ai.tock.bot.connector.ConnectorMessage;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.connector.media.MediaAction;
import ai.tock.bot.connector.media.MediaCard;
import ai.tock.bot.connector.media.MediaCarousel;
import ai.tock.bot.connector.media.MediaFile;
import ai.tock.bot.connector.media.MediaMessage;
import ai.tock.bot.connector.web.WebBuildersKt;
import ai.tock.bot.connector.web.WebConnectorCallback;
import ai.tock.bot.connector.web.WebConnectorKt;
import ai.tock.bot.connector.web.WebConnectorRequest;
import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.WebMessage;
import ai.tock.bot.connector.web.WebMessageProcessor;
import ai.tock.bot.connector.web.WebModelsKt;
import ai.tock.bot.connector.web.WebRequestInfos;
import ai.tock.bot.connector.web.WebRequestInfosByEvent;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.Channels;
import ai.tock.bot.connector.web.send.Button;
import ai.tock.bot.connector.web.send.PostbackButton;
import ai.tock.bot.connector.web.send.UrlButton;
import ai.tock.bot.connector.web.send.WebCard;
import ai.tock.bot.connector.web.send.WebCarousel;
import ai.tock.bot.connector.web.send.WebDeepLink;
import ai.tock.bot.connector.web.send.WebImage;
import ai.tock.bot.connector.web.send.WebMediaFile;
import ai.tock.bot.connector.web.send.WebWidget;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.MetadataEvent;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.orchestration.bot.secondary.OrchestrationCallback;
import ai.tock.bot.orchestration.bot.secondary.RestOrchestrationCallback;
import ai.tock.bot.orchestration.connector.OrchestrationConnector;
import ai.tock.bot.orchestration.connector.OrchestrationHandlers;
import ai.tock.bot.orchestration.shared.AskEligibilityToOrchestratedBotRequest;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.ResumeOrchestrationRequest;
import ai.tock.bot.orchestration.shared.SecondaryBotEligibilityResponse;
import ai.tock.bot.orchestration.shared.SecondaryBotResponse;
import ai.tock.shared.Dice;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.vertx.VertXsKt;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 E2\u00020\u00012\u00020\u0002:\u0001EB\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010%\u001a\u00020*2\u0006\u0010#\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010%\u001a\u00020-2\u0006\u0010#\u001a\u00020+H\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010%\u001a\u00020&2\u0006\u00104\u001a\u000205H\u0016J1\u00106\u001a\u0015\u0012\u0004\u0012\u000208\u0012\u0006\u0012\u0004\u0018\u00010907\u00a2\u0006\u0002\b:2\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0>H\u0016J1\u00106\u001a\u0015\u0012\u0004\u0012\u000208\u0012\u0006\u0012\u0004\u0018\u00010907\u00a2\u0006\u0002\b:2\u0006\u0010?\u001a\u0002092\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0>H\u0016J'\u0010@\u001a\u0019\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u0002090>07\u00a2\u0006\u0002\b:2\u0006\u0010?\u001a\u00020AH\u0016J\f\u0010B\u001a\u00020C*\u00020DH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006F"}, d2={"Lai/tock/bot/connector/web/WebConnector;", "Lai/tock/bot/connector/ConnectorBase;", "Lai/tock/bot/orchestration/connector/OrchestrationConnector;", "applicationId", "", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "getPath", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "getOrCreateUserIdCookie", "context", "Lio/vertx/ext/web/RoutingContext;", "sendSsePing", "Lio/vertx/core/http/HttpServerResponse;", "getOrchestrationHandlers", "Lai/tock/bot/orchestration/connector/OrchestrationHandlers;", "handleRequest", "body", "extraHeadersAsMetadata", "", "requestInfos", "Lai/tock/bot/connector/web/WebRequestInfos;", "handleProxy", "handleEligibility", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "handleWebConnectorCallback", "Lai/tock/bot/connector/web/WebConnectorCallback;", "Lai/tock/bot/engine/action/Action;", "handleOrchestrationCallback", "Lai/tock/bot/orchestration/bot/secondary/OrchestrationCallback;", "persistProfileLoaded", "", "getPersistProfileLoaded", "()Z", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "userId", "Lai/tock/bot/engine/user/PlayerId;", "addSuggestions", "Lkotlin/Function1;", "Lai/tock/bot/engine/BotBus;", "Lai/tock/bot/connector/ConnectorMessage;", "Lkotlin/ExtensionFunctionType;", "text", "", "suggestions", "", "message", "toConnectorMessage", "Lai/tock/bot/connector/media/MediaMessage;", "toButton", "Lai/tock/bot/connector/web/send/Button;", "Lai/tock/bot/connector/media/MediaAction;", "Companion", "tock-bot-connector-web"})
@SourceDebugExtension(value={"SMAP\nWebConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConnector.kt\nai/tock/bot/connector/web/WebConnector\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,467:1\n53#2,2:468\n51#3:470\n277#4:471\n56#5:472\n49#5:473\n56#5:477\n49#5:478\n56#5:479\n49#5:480\n1#6:474\n1863#7,2:475\n1863#7,2:481\n1557#7:483\n1628#7,3:484\n1557#7:487\n1628#7,3:488\n1557#7:491\n1628#7,3:492\n1557#7:495\n1628#7,3:496\n1557#7:499\n1628#7,2:500\n1557#7:502\n1628#7,3:503\n1630#7:506\n*S KotlinDebug\n*F\n+ 1 WebConnector.kt\nai/tock/bot/connector/web/WebConnector\n*L\n120#1:468,2\n120#1:470\n120#1:471\n251#1:472\n251#1:473\n316#1:477\n316#1:478\n340#1:479\n340#1:480\n300#1:475,2\n138#1:481,2\n409#1:483\n409#1:484,3\n417#1:487\n417#1:488,3\n419#1:491\n419#1:492,3\n435#1:495\n435#1:496,3\n443#1:499\n443#1:500,2\n448#1:502\n448#1:503,3\n443#1:506\n*E\n"})
public final class WebConnector
extends ConnectorBase
implements OrchestrationConnector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    private final boolean persistProfileLoaded;
    @NotNull
    private static final KLogger logger;
    private static final ObjectMapper webMapper;
    @NotNull
    private static final WebMessageProcessor messageProcessor;
    @NotNull
    private static final Lazy<Channels> channels$delegate;

    public WebConnector(@NotNull String applicationId, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(WebConnectorKt.getWebConnectorType(), SetsKt.setOf((Object)ConnectorFeature.CAROUSEL));
        this.applicationId = applicationId;
        this.path = path;
        this.persistProfileLoaded = PropertiesKt.booleanProperty((String)"tock_web_connector_persist_profile", (boolean)false);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, arg_0 -> WebConnector.register$lambda$9(this, controller, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final String getOrCreateUserIdCookie(RoutingContext context) {
        String string;
        String existing;
        Cookie cookie = context.request().getCookie("tock_user_id");
        String string2 = existing = cookie != null ? cookie.getValue() : null;
        if (existing != null && WebConnectorKt.access$getCookieAuthMaxAge$p() < 0L) {
            string = existing;
        } else {
            void var3_3;
            String string3 = existing;
            if (string3 == null) {
                String string4 = UUID.randomUUID().toString();
                string3 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            }
            String cookieValue = string3;
            Cookie cookie2 = Cookie.cookie((String)"tock_user_id", (String)cookieValue).setHttpOnly(true).setSecure(true).setSameSite(CookieSameSite.NONE);
            if (WebConnectorKt.access$getCookieAuthMaxAge$p() >= 0L) {
                cookie2.setMaxAge(WebConnectorKt.access$getCookieAuthMaxAge$p());
            }
            if (WebConnectorKt.access$getCookieAuthPath$p() != null) {
                cookie2.setPath(WebConnectorKt.access$getCookieAuthPath$p());
            }
            context.response().addCookie(cookie2);
            string = var3_3;
        }
        return string;
    }

    private final void sendSsePing(HttpServerResponse $this$sendSsePing) {
        $this$sendSsePing.write("event: ping\n");
        $this$sendSsePing.write("data: 1\n\n");
    }

    @NotNull
    public OrchestrationHandlers getOrchestrationHandlers() {
        return new OrchestrationHandlers((Function2)new Function2<ConnectorController, RoutingContext, Unit>((Object)this){

            public final void invoke(ConnectorController p0, RoutingContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WebConnector.access$handleEligibility((WebConnector)((Object)this.receiver), p0, p1);
            }
        }, (Function2)new Function2<ConnectorController, RoutingContext, Unit>((Object)this){

            public final void invoke(ConnectorController p0, RoutingContext p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WebConnector.access$handleProxy((WebConnector)((Object)this.receiver), p0, p1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRequest(ConnectorController controller, RoutingContext context, String body) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook");
        try {
            String string;
            logger.debug(() -> WebConnector.handleRequest$lambda$10(body));
            ObjectMapper $this$readValue$iv = JacksonKt.getMapper();
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            WebConnectorRequest request = (WebConnectorRequest)$this$readValue$iv.readValue(body, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<WebConnectorRequest>(){});
            String string2 = request.getConnectorId();
            boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
            if (bl) {
                if (WebConnectorKt.access$getWebConnectorBridgeEnabled$p()) {
                    String it = $i$f$readValue = request.getConnectorId();
                    boolean bl2 = false;
                    logger.debug(() -> WebConnector.handleRequest$lambda$12$lambda$11(this, it));
                    string = $i$f$readValue;
                } else {
                    String it = $i$f$readValue = this.applicationId;
                    boolean bl3 = false;
                    logger.warn(WebConnector::handleRequest$lambda$14$lambda$13);
                    string = $i$f$readValue;
                }
            } else {
                string = this.applicationId;
            }
            String applicationId = string;
            Event event = request.toEvent(applicationId);
            HttpServerRequest httpServerRequest = context.request();
            Intrinsics.checkNotNullExpressionValue((Object)httpServerRequest, (String)"request(...)");
            WebRequestInfos requestInfos = new WebRequestInfos(httpServerRequest);
            WebRequestInfosByEvent.INSTANCE.put$tock_bot_connector_web(event.getId().toString(), requestInfos);
            Locale locale = request.getLocale();
            ObjectMapper objectMapper = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"webMapper");
            WebConnectorCallback callback = new WebConnectorCallback(applicationId, locale, context, null, null, objectMapper, event.getId().toString(), messageProcessor, 24, null);
            if (WebConnectorKt.access$getSseEnabled$p()) {
                UUID uUID = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
                callback.addMetadata(MetadataEvent.Companion.responseId(uUID, applicationId));
            }
            controller.handle(event, new ConnectorData((ConnectorCallback)callback, null, false, null, null, this.extraHeadersAsMetadata(requestInfos), 30, null));
        }
        catch (Throwable t) {
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
            context.fail(t);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    private final Map<String, String> extraHeadersAsMetadata(WebRequestInfos requestInfos) {
        Map metaDataExtraHeaders = new LinkedHashMap();
        if (WebConnectorKt.getWebConnectorUseExtraHeadersAsMetadata()) {
            Iterable $this$forEach$iv = WebConnectorKt.getWebConnectorExtraHeaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String header = (String)element$iv;
                boolean bl = false;
                if (requestInfos.firstHeader(header) != null) {
                    String it;
                    boolean bl2 = false;
                    metaDataExtraHeaders.putIfAbsent(header, it);
                }
            }
        }
        return metaDataExtraHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleProxy(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_orchestred");
        try {
            void $this$readValue$iv;
            logger.debug(() -> WebConnector.handleProxy$lambda$17(context));
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.body().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String content$iv = string;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            ResumeOrchestrationRequest request = (ResumeOrchestrationRequest)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<ResumeOrchestrationRequest>(){});
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            controller.handle(request.toAction(), new ConnectorData((ConnectorCallback)callback, null, false, null, null, null, 62, null));
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleEligibility(ConnectorController controller, RoutingContext context) {
        RequestTimerData timerData = BotRepository.INSTANCE.getRequestTimer().start("web_webhook_support");
        try {
            void $this$readValue$iv;
            logger.debug(() -> WebConnector.handleEligibility$lambda$18(context));
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string = context.body().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String content$iv = string;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            AskEligibilityToOrchestratedBotRequest request = (AskEligibilityToOrchestratedBotRequest)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<AskEligibilityToOrchestratedBotRequest>(){});
            ConnectorType connectorType = WebConnectorKt.getWebConnectorType();
            ObjectMapper objectMapper2 = webMapper;
            Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"webMapper");
            RestOrchestrationCallback callback = new RestOrchestrationCallback(connectorType, this.applicationId, context, null, objectMapper2, 8, null);
            double support = controller.support(request.toAction(this.applicationId), new ConnectorData((ConnectorCallback)callback, null, false, null, null, null, 62, null));
            PlayerId playerId = new PlayerId(this.applicationId, PlayerType.bot, null, 4, null);
            OrchestrationMetaData orchestrationMetaData = request.getMetadata();
            if (orchestrationMetaData == null || (orchestrationMetaData = orchestrationMetaData.getPlayerId()) == null) {
                orchestrationMetaData = new PlayerId(Dice.INSTANCE.newId(), PlayerType.user, null, 4, null);
            }
            SecondaryBotEligibilityResponse sendEligibility = new SecondaryBotEligibilityResponse(support, new OrchestrationMetaData(playerId, this.applicationId, (PlayerId)orchestrationMetaData));
            callback.sendResponse((SecondaryBotResponse)sendEligibility);
        }
        catch (Throwable t) {
            new RestOrchestrationCallback(WebConnectorKt.getWebConnectorType(), this.applicationId, context, null, null, 24, null).sendError();
            BotRepository.INSTANCE.getRequestTimer().throwable(t, timerData);
        }
        finally {
            BotRepository.INSTANCE.getRequestTimer().end(timerData);
        }
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Event event2 = event;
        if (event2 instanceof Action) {
            ConnectorCallback connectorCallback = callback;
            if (connectorCallback instanceof WebConnectorCallback) {
                this.handleWebConnectorCallback((WebConnectorCallback)callback, (Action)event);
            } else if (connectorCallback instanceof OrchestrationCallback) {
                this.handleOrchestrationCallback((OrchestrationCallback)callback, (Action)event);
            }
        } else if (event2 instanceof MetadataEvent) {
            WebConnectorCallback webConnectorCallback = callback instanceof WebConnectorCallback ? (WebConnectorCallback)callback : null;
            if (webConnectorCallback != null) {
                webConnectorCallback.addMetadata((MetadataEvent)event);
            }
        } else {
            logger.trace(() -> WebConnector.send$lambda$19(event));
        }
    }

    private final void handleWebConnectorCallback(WebConnectorCallback callback, Action event) {
        callback.addAction(event);
        if (WebConnectorKt.access$getSseEnabled$p()) {
            WebConnector.Companion.getChannels().send(event.getApplicationId(), event.getRecipientId(), callback.createResponse(CollectionsKt.listOf((Object)event)));
        }
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    private final void handleOrchestrationCallback(OrchestrationCallback callback, Action event) {
        callback.getActions().add(event);
        if (event.getMetadata().getLastAnswer()) {
            callback.sendResponse();
        }
    }

    public boolean getPersistProfileLoaded() {
        return this.persistProfileLoaded;
    }

    @NotNull
    public UserPreferences loadProfile(@NotNull ConnectorCallback callback, @NotNull PlayerId userId) {
        UserPreferences userPreferences;
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (callback instanceof WebConnectorCallback) {
            UserPreferences userPreferences2;
            UserPreferences $this$loadProfile_u24lambda_u2420 = userPreferences2 = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
            boolean bl = false;
            $this$loadProfile_u24lambda_u2420.setLocale(((WebConnectorCallback)callback).getLocale());
            userPreferences = userPreferences2;
        } else {
            userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
        }
        return userPreferences;
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull CharSequence text, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> WebConnector.addSuggestions$lambda$22(text, suggestions, arg_0);
    }

    @NotNull
    public Function1<BotBus, ConnectorMessage> addSuggestions(@NotNull ConnectorMessage message, @NotNull List<? extends CharSequence> suggestions) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        return arg_0 -> WebConnector.addSuggestions$lambda$26(message, suggestions, arg_0);
    }

    @NotNull
    public Function1<BotBus, List<ConnectorMessage>> toConnectorMessage(@NotNull MediaMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return arg_0 -> WebConnector.toConnectorMessage$lambda$30(message, this, arg_0);
    }

    private final Button toButton(MediaAction $this$toButton) {
        return $this$toButton.getUrl() == null ? (Button)new PostbackButton(((Object)$this$toButton.getTitle()).toString(), null, null, null, 12, null) : (Button)new UrlButton(((Object)$this$toButton.getTitle()).toString(), String.valueOf($this$toButton.getUrl()), null, null, null, 28, null);
    }

    private static final void register$lambda$9$lambda$6$lambda$3(WebConnector this$0, HttpServerResponse $response, Long it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNull((Object)$response);
        this$0.sendSsePing($response);
    }

    private static final Unit register$lambda$9$lambda$6$lambda$4(HttpServerResponse $response, WebConnectorResponse webConnectorResponse) {
        Intrinsics.checkNotNullParameter((Object)webConnectorResponse, (String)"webConnectorResponse");
        $response.write("event: message\n");
        $response.write("data: " + webMapper.writeValueAsString((Object)webConnectorResponse) + "\n\n");
        return Unit.INSTANCE;
    }

    private static final void register$lambda$9$lambda$6$lambda$5(long $timerId, Channel $channelId, Void it) {
        Intrinsics.checkNotNullParameter((Object)$channelId, (String)"$channelId");
        VertXsKt.getVertx().cancelTimer($timerId);
        WebConnector.Companion.getChannels().unregister($channelId);
    }

    private static final void register$lambda$9$lambda$6(WebConnector this$0, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            String string;
            if (WebConnectorKt.access$getCookieAuth$p()) {
                Intrinsics.checkNotNull((Object)context);
                string = this$0.getOrCreateUserIdCookie(context);
            } else {
                string = context.queryParams().get("userId");
            }
            String userId = string;
            HttpServerResponse response = context.response();
            response.setChunked(true);
            response.headers().add("Content-Type", "text/event-stream;charset=UTF-8");
            response.headers().add("Connection", "keep-alive");
            response.headers().add("Cache-Control", "no-cache");
            Intrinsics.checkNotNull((Object)response);
            this$0.sendSsePing(response);
            long timerId = VertXsKt.getVertx().setPeriodic(Duration.ofSeconds(WebConnectorKt.access$getSseKeepaliveDelay$p()).toMillis(), arg_0 -> WebConnector.register$lambda$9$lambda$6$lambda$3(this$0, response, arg_0));
            Channels channels = WebConnector.Companion.getChannels();
            String string2 = this$0.applicationId;
            Intrinsics.checkNotNull((Object)userId);
            Channel channelId = channels.register(string2, userId, (Function1<? super WebConnectorResponse, Unit>)((Function1)arg_0 -> WebConnector.register$lambda$9$lambda$6$lambda$4(response, arg_0)));
            response.closeHandler(arg_0 -> WebConnector.register$lambda$9$lambda$6$lambda$5(timerId, channelId, arg_0));
        }
        catch (Throwable t) {
            context.fail(t);
        }
    }

    private static final Unit register$lambda$9$lambda$8$lambda$7(RoutingContext $context, WebConnector this$0, ConnectorController $controller) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        if (WebConnectorKt.access$getCookieAuth$p()) {
            JsonObject jsonObject = $context.body().asJsonObject();
            if (jsonObject == null) {
                jsonObject = new JsonObject();
            }
            JsonObject jsonBody = jsonObject;
            Intrinsics.checkNotNull((Object)$context);
            String userId = this$0.getOrCreateUserIdCookie($context);
            jsonBody.put("userId", (Object)userId);
            string = jsonBody.toString();
        } else {
            string = $context.body().asString();
        }
        String body = string;
        Intrinsics.checkNotNull((Object)$context);
        Intrinsics.checkNotNull((Object)body);
        this$0.handleRequest($controller, $context, body);
        return Unit.INSTANCE;
    }

    private static final void register$lambda$9$lambda$8(WebConnector this$0, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        try {
            this$0.getExecutor().executeBlocking(() -> WebConnector.register$lambda$9$lambda$8$lambda$7(context, this$0, $controller));
        }
        catch (Throwable e) {
            context.fail(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit register$lambda$9(WebConnector this$0, ConnectorController $controller, Router router) {
        CorsHandler $this$register_u24lambda_u249_u24lambda_u240;
        CorsHandler corsHandler;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        logger.debug("deploy web connector services for root path " + this$0.path + " ");
        CorsHandler corsHandler2 = CorsHandler.create().addRelativeOrigin(WebConnectorKt.access$getCorsPattern$p()).allowedMethod(HttpMethod.POST);
        Route route = router.route(this$0.path);
        boolean bl = false;
        $this$register_u24lambda_u249_u24lambda_u240 = corsHandler = (WebConnectorKt.access$getSseEnabled$p() ? $this$register_u24lambda_u249_u24lambda_u240.allowedMethod(HttpMethod.GET) : $this$register_u24lambda_u249_u24lambda_u240).allowedHeader("Access-Control-Allow-Origin").allowedHeader("Content-Type").allowedHeader("X-Requested-With");
        boolean bl2 = false;
        Iterable $this$forEach$iv = WebConnectorKt.getWebConnectorExtraHeaders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$register_u24lambda_u249_u24lambda_u242;
            String it = (String)element$iv;
            boolean bl3 = false;
            $this$register_u24lambda_u249_u24lambda_u242.allowedHeader(it);
        }
        route.handler((Handler)corsHandler.allowCredentials(WebConnectorKt.access$getCookieAuth$p()));
        if (WebConnectorKt.access$getSseEnabled$p()) {
            router.route(this$0.path + "/sse").handler(arg_0 -> WebConnector.register$lambda$9$lambda$6(this$0, arg_0));
        }
        router.post(this$0.path).handler(arg_0 -> WebConnector.register$lambda$9$lambda$8(this$0, $controller, arg_0));
        return Unit.INSTANCE;
    }

    private static final Object handleRequest$lambda$10(String $body) {
        Intrinsics.checkNotNullParameter((Object)$body, (String)"$body");
        return "Web request input : " + $body;
    }

    private static final Object handleRequest$lambda$12$lambda$11(WebConnector this$0, String $it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "Web bridge: " + this$0.applicationId + " -> " + $it;
    }

    private static final Object handleRequest$lambda$14$lambda$13() {
        return "Web bridge disabled.";
    }

    private static final Object handleProxy$lambda$17(RoutingContext $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return "Web proxy request input : " + $context.body().asString();
    }

    private static final Object handleEligibility$lambda$18(RoutingContext $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        return "Web support request input : " + $context.body().asString();
    }

    private static final Object send$lambda$19(Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        return "unsupported event: " + $event;
    }

    /*
     * WARNING - void declaration
     */
    private static final WebMessage addSuggestions$lambda$22(CharSequence $text, List $suggestions, BotBus botBus) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$suggestions, (String)"$suggestions");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        Iterable iterable = $suggestions;
        String string = ((Object)$text).toString();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CharSequence charSequence = (CharSequence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)botBus, (CharSequence)it, null, null, null, 14, null));
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 508;
        List list = null;
        WebDeepLink webDeepLink = null;
        String string2 = null;
        WebImage webImage = null;
        WebWidget webWidget = null;
        WebCarousel webCarousel = null;
        WebCard webCard = null;
        List list2 = (List)destination$iv$iv;
        String string3 = string;
        return new WebMessage(string3, list2, webCard, webCarousel, webWidget, webImage, string2, webDeepLink, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final ConnectorMessage addSuggestions$lambda$26(ConnectorMessage $message, List $suggestions, BotBus botBus) {
        ConnectorMessage connectorMessage;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$suggestions, (String)"$suggestions");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        WebMessage webMessage = $message instanceof WebMessage ? (WebMessage)$message : null;
        if (webMessage != null) {
            WebMessage webMessage2;
            WebMessage it = webMessage;
            boolean bl = false;
            if (it.getCard() != null && it.getCard().getButtons().isEmpty()) {
                Collection<Button> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = $suggestions;
                WebMediaFile webMediaFile = null;
                CharSequence charSequence = null;
                CharSequence charSequence2 = null;
                WebCard webCard = it.getCard();
                List list = null;
                String string = null;
                WebMessage webMessage3 = it;
                boolean $i$f$map = false;
                void var14_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void s;
                    CharSequence charSequence3 = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)botBus, (CharSequence)s, null, null, null, 14, null));
                }
                collection = (List)destination$iv$iv;
                webMessage2 = WebMessage.copy$default(webMessage3, string, list, WebCard.copy$default((WebCard)webCard, charSequence2, charSequence, webMediaFile, (List)collection, (int)7, null), null, null, null, null, null, null, 507, null);
            } else if (it.getCard() == null && it.getButtons().isEmpty()) {
                Collection<Button> collection;
                Iterable $this$map$iv = $suggestions;
                String string = null;
                WebMessage webMessage4 = it;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CharSequence s = (CharSequence)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(WebBuildersKt.webNlpQuickReply$default((Bus)botBus, s, null, null, null, 14, null));
                }
                collection = (List)destination$iv$iv;
                webMessage2 = WebMessage.copy$default(webMessage4, string, (List)collection, null, null, null, null, null, null, null, 509, null);
            } else {
                webMessage2 = null;
            }
            webMessage = webMessage2;
            if (webMessage2 != null) {
                connectorMessage = (ConnectorMessage)webMessage;
                return connectorMessage;
            }
        }
        connectorMessage = $message;
        return connectorMessage;
    }

    /*
     * WARNING - void declaration
     */
    private static final List toConnectorMessage$lambda$30(MediaMessage $message, WebConnector this$0, BotBus botBus) {
        WebMessage webMessage;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"<this>");
        MediaMessage mediaMessage = $message;
        if (mediaMessage instanceof MediaCard) {
            Collection<Button> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            MediaFile mediaFile = ((MediaCard)$message).getFile();
            Iterable iterable = ((MediaCard)$message).getActions();
            WebMediaFile webMediaFile = mediaFile != null ? WebModelsKt.toWebMediaFile(mediaFile) : null;
            CharSequence charSequence = ((MediaCard)$message).getSubTitle();
            CharSequence charSequence2 = ((MediaCard)$message).getTitle();
            List list = null;
            String string = null;
            boolean $i$f$map = false;
            void var6_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void button;
                MediaAction mediaAction = (MediaAction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this$0.toButton((MediaAction)button));
            }
            Collection<Button> collection2 = collection = (List)destination$iv$iv;
            WebMediaFile webMediaFile2 = webMediaFile;
            CharSequence charSequence3 = charSequence;
            CharSequence charSequence4 = charSequence2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 507;
            List list2 = null;
            WebDeepLink webDeepLink = null;
            String string2 = null;
            WebImage webImage = null;
            WebWidget webWidget = null;
            WebCarousel webCarousel = null;
            WebCard webCard = new WebCard(charSequence4, charSequence3, webMediaFile2, collection2);
            List list3 = list;
            String string3 = string;
            webMessage = new WebMessage(string3, list3, webCard, webCarousel, webWidget, webImage, string2, webDeepLink, list2, n, defaultConstructorMarker);
        } else if (mediaMessage instanceof MediaCarousel) {
            Collection<WebCard> collection;
            Iterable $this$map$iv = ((MediaCarousel)$message).getCards();
            WebCard webCard = null;
            List list = null;
            String string = null;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Collection<Button> collection3;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void mediaCard;
                MediaCard button = (MediaCard)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                MediaFile mediaFile = mediaCard.getFile();
                Iterable iterable = mediaCard.getActions();
                WebMediaFile webMediaFile = mediaFile != null ? WebModelsKt.toWebMediaFile(mediaFile) : null;
                CharSequence charSequence = mediaCard.getSubTitle();
                CharSequence charSequence5 = mediaCard.getTitle();
                boolean $i$f$map2 = false;
                void var18_52 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void button2;
                    MediaAction mediaAction = (MediaAction)item$iv$iv2;
                    collection3 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection3.add(this$0.toButton((MediaAction)button2));
                }
                Collection<Button> collection4 = collection3 = (List)destination$iv$iv2;
                WebMediaFile webMediaFile3 = webMediaFile;
                CharSequence charSequence6 = charSequence;
                CharSequence charSequence7 = charSequence5;
                collection.add(new WebCard(charSequence7, charSequence6, webMediaFile3, collection4));
            }
            Collection<WebCard> collection5 = collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 503;
            List list4 = null;
            WebDeepLink webDeepLink = null;
            String string4 = null;
            WebImage webImage = null;
            WebWidget webWidget = null;
            WebCarousel webCarousel = new WebCarousel((List)collection5);
            WebCard webCard2 = webCard;
            List list5 = list;
            String string5 = string;
            webMessage = new WebMessage(string5, list5, webCard2, webCarousel, webWidget, webImage, string4, webDeepLink, list4, n, defaultConstructorMarker);
        } else {
            webMessage = null;
        }
        return CollectionsKt.listOfNotNull(webMessage);
    }

    private static final Unit logger$lambda$31() {
        return Unit.INSTANCE;
    }

    private static final Channels channels_delegate$lambda$33() {
        return new Channels();
    }

    public static final /* synthetic */ void access$handleEligibility(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleEligibility(controller, context);
    }

    public static final /* synthetic */ void access$handleProxy(WebConnector $this, ConnectorController controller, RoutingContext context) {
        $this.handleProxy(controller, context);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$webMapper_u24lambda_u2432;
        SimpleModule simpleModule;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger(WebConnector::logger$lambda$31);
        Module[] moduleArray = new Module[1];
        SimpleModule simpleModule2 = simpleModule = new SimpleModule();
        int n = 0;
        Module[] moduleArray2 = moduleArray;
        ObjectMapper objectMapper = JacksonKt.getMapper().copy();
        boolean bl = false;
        $this$webMapper_u24lambda_u2432.addSerializer(CharSequence.class, (JsonSerializer)new ToStringSerializer());
        Unit unit = Unit.INSTANCE;
        moduleArray2[n] = simpleModule;
        webMapper = objectMapper.registerModules(moduleArray);
        String string = PropertiesKt.propertyOrNull((String)"tock_web_enable_markdown");
        messageProcessor = new WebMessageProcessor(string != null ? Boolean.parseBoolean(string) : Boolean.parseBoolean(PropertiesKt.propertyOrNull((String)"allow_markdown")));
        channels$delegate = LazyKt.lazy(WebConnector::channels_delegate$lambda$33);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lai/tock/bot/connector/web/WebConnector$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "webMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "messageProcessor", "Lai/tock/bot/connector/web/WebMessageProcessor;", "channels", "Lai/tock/bot/connector/web/channel/Channels;", "getChannels", "()Lai/tock/bot/connector/web/channel/Channels;", "channels$delegate", "Lkotlin/Lazy;", "tock-bot-connector-web"})
    public static final class Companion {
        private Companion() {
        }

        private final Channels getChannels() {
            Lazy lazy = channels$delegate;
            return (Channels)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

