/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.web.channel;

import ai.tock.bot.connector.web.WebConnectorResponse;
import ai.tock.bot.connector.web.channel.Channel;
import ai.tock.bot.connector.web.channel.ChannelDAO;
import ai.tock.bot.connector.web.channel.ChannelEvent;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.shared.IOCsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2%\u0010\u000e\u001a!\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010j\u0002`\u000f\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nJ\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/bot/connector/web/channel/Channels;", "", "<init>", "()V", "channelDAO", "Lai/tock/bot/connector/web/channel/ChannelDAO;", "channelsByUser", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lai/tock/bot/connector/web/channel/Channel;", "register", "appId", "userId", "onAction", "Lai/tock/bot/connector/web/channel/ChannelCallback;", "Lkotlin/Function1;", "Lai/tock/bot/connector/web/WebConnectorResponse;", "Lkotlin/ParameterName;", "name", "webConnectorResponse", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Lai/tock/bot/connector/web/channel/Channel;", "unregister", "channel", "send", "applicationId", "recipientId", "Lai/tock/bot/engine/user/PlayerId;", "response", "tock-bot-connector-web"})
@SourceDebugExtension(value={"SMAP\nChannels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Channels.kt\nai/tock/bot/connector/web/channel/Channels\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n53#2,2:63\n51#3:65\n277#4:66\n72#5,2:67\n1#6:69\n1#6:74\n774#7:70\n865#7,2:71\n2642#7:73\n*S KotlinDebug\n*F\n+ 1 Channels.kt\nai/tock/bot/connector/web/channel/Channels\n*L\n28#1:63,2\n28#1:65\n28#1:66\n40#1:67,2\n40#1:69\n33#1:74\n33#1:70\n33#1:71,2\n33#1:73\n*E\n"})
public final class Channels {
    @NotNull
    private final ChannelDAO channelDAO;
    @NotNull
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Channel>> channelsByUser;

    public Channels() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        this.channelDAO = (ChannelDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<ChannelDAO>(){}, tag$iv).getValue()).invoke();
        this.channelsByUser = new ConcurrentHashMap();
        this.channelDAO.listenChanges(arg_0 -> Channels._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final Channel register(@NotNull String appId, @NotNull String userId, @NotNull Function1<? super WebConnectorResponse, Unit> onAction) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        ConcurrentMap $this$getOrPut$iv = this.channelsByUser;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(userId);
        if (object == null) {
            boolean bl = false;
            CopyOnWriteArrayList default$iv = new CopyOnWriteArrayList();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(userId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CopyOnWriteArrayList channels = (CopyOnWriteArrayList)object;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Channel channel = new Channel(appId, uUID, userId, onAction);
        channels.add(channel);
        this.channelDAO.handleMissedEvents(appId, userId, arg_0 -> Channels.register$lambda$4(channel, arg_0));
        return channel;
    }

    public final void unregister(@NotNull Channel channel) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            CopyOnWriteArrayList<Channel> copyOnWriteArrayList = this.channelsByUser.get(channel.getUserId());
            if (copyOnWriteArrayList == null) break block0;
            copyOnWriteArrayList.removeIf(arg_0 -> Channels.unregister$lambda$6(arg_0 -> Channels.unregister$lambda$5(channel, arg_0), arg_0));
        }
    }

    public final void send(@NotNull String applicationId, @NotNull PlayerId recipientId, @NotNull WebConnectorResponse response) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)recipientId, (String)"recipientId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.channelDAO.save(new ChannelEvent(applicationId, recipientId.getId(), response, null, null, null, 56, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean _init_$lambda$2(Channels this$0, ChannelEvent channelEvent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"<destruct>");
        String appId = channelEvent.component1();
        String recipientId = channelEvent.component2();
        WebConnectorResponse response = channelEvent.component3();
        CopyOnWriteArrayList<Channel> copyOnWriteArrayList = this$0.channelsByUser.get(recipientId);
        if (copyOnWriteArrayList != null) {
            Iterable iterable;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = copyOnWriteArrayList;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getAppId(), (Object)appId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
            boolean bl3 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                Channel channel = (Channel)element$iv;
                boolean bl4 = false;
                channel.getOnAction().invoke((Object)response);
            }
            bl = !((Collection)((List)iterable)).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean register$lambda$4(Channel $channel, ChannelEvent channelEvent) {
        Intrinsics.checkNotNullParameter((Object)$channel, (String)"$channel");
        Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"<destruct>");
        WebConnectorResponse response = channelEvent.component3();
        $channel.getOnAction().invoke((Object)response);
        return true;
    }

    private static final boolean unregister$lambda$5(Channel $channel, Channel it) {
        Intrinsics.checkNotNullParameter((Object)$channel, (String)"$channel");
        return Intrinsics.areEqual((Object)it.getUuid(), (Object)$channel.getUuid());
    }

    private static final boolean unregister$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

