/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.whatsapp;

import ai.tock.bot.connector.whatsapp.WhatsAppClient;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppResponse;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotImageMessage;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotMessage;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotTextMessage;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0006\"#$%&'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient;", "", "whatsAppUrl", "", "login", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "api", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppApi;", "clientMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getClientMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lmu/KLogger;", "loginApi", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppLoginApi;", "token", "tokenExpiration", "Ljava/time/OffsetDateTime;", "checkLogin", "", "getMedia", "", "id", "sendMessage", "", "message", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppSendBotMessage;", "tokenInterceptor", "Lokhttp3/Interceptor;", "logError", "Lretrofit2/Response;", "LoginResponse", "LoginUser", "MediaId", "MediaResponse", "WhatsAppApi", "WhatsAppLoginApi", "tock-bot-connector-whatsapp"})
public final class WhatsAppClient {
    private final KLogger logger;
    private final WhatsAppLoginApi loginApi;
    private final WhatsAppApi api;
    private volatile OffsetDateTime tokenExpiration;
    private volatile String token;
    private final ObjectMapper clientMapper;

    public final ObjectMapper getClientMapper() {
        return this.clientMapper;
    }

    private final Interceptor tokenInterceptor() {
        Interceptor.Companion this_$iv = Interceptor.Companion;
        boolean $i$f$invoke = false;
        return new Interceptor(this){
            final /* synthetic */ WhatsAppClient this$0;
            {
                this.this$0 = whatsAppClient;
            }

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                Request original = chain2.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", "Bearer " + WhatsAppClient.access$getToken$p(this.this$0));
                Request request = requestBuilder.build();
                return chain2.proceed(request);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkLogin() {
        if (this.token != null) {
            OffsetDateTime offsetDateTime = this.tokenExpiration;
            if (offsetDateTime != null) {
                if (!offsetDateTime.isBefore(OffsetDateTime.now().plusHours(1L))) return true;
            }
        }
        boolean bl = this.login();
        return bl;
    }

    private final void logError(@NotNull retrofit2.Response<?> $this$logError) {
        String error = $this$logError.message();
        int errorCode = $this$logError.code();
        this.logger.warn((Function0)new Function0<String>(errorCode, error){
            final /* synthetic */ int $errorCode;
            final /* synthetic */ String $error;

            @NotNull
            public final String invoke() {
                return "WhatsApp Error : " + this.$errorCode + ' ' + this.$error;
            }
            {
                this.$errorCode = n;
                this.$error = string;
                super(0);
            }
        });
        ResponseBody responseBody = $this$logError.errorBody();
        String errorBody = responseBody != null ? responseBody.string() : null;
        this.logger.warn((Function0)new Function0<String>(errorBody){
            final /* synthetic */ String $errorBody;

            @NotNull
            public final String invoke() {
                return "Messenger Error body : " + this.$errorBody;
            }
            {
                this.$errorBody = string;
                super(0);
            }
        });
    }

    @Nullable
    public final byte[] getMedia(@NotNull String id) {
        Object object;
        block4: {
            block2: {
                retrofit2.Response $this$run;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                    if (!this.checkLogin()) break block2;
                    retrofit2.Response response = this.api.getMedia(id).execute();
                    boolean bl = false;
                    boolean bl2 = false;
                    $this$run = response;
                    boolean bl3 = false;
                    object = (ResponseBody)$this$run.body();
                    if (object == null) break block3;
                    byte[] byArray = object.bytes();
                    object = byArray;
                    if (byArray != null) break block4;
                }
                Object var7_7 = null;
                boolean bl = false;
                boolean bl4 = false;
                Void it = var7_7;
                boolean bl5 = false;
                this.logError($this$run);
                object = var7_7;
                break block4;
            }
            object = null;
        }
        return object;
    }

    public final void sendMessage(@NotNull WhatsAppSendBotMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.checkLogin()) {
            try {
                WhatsAppSendBotMessage whatsAppSendBotMessage = message;
                if (whatsAppSendBotMessage instanceof WhatsAppSendBotTextMessage) {
                    retrofit2.Response response;
                    retrofit2.Response response2 = response = this.api.sendMessage(message).execute();
                    Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
                    if (!response2.isSuccessful()) {
                        this.logError(response);
                    }
                } else if (whatsAppSendBotMessage instanceof WhatsAppSendBotImageMessage) {
                    String id;
                    retrofit2.Response response;
                    Object object;
                    String string = ((WhatsAppSendBotImageMessage)message).getImage().getContentType$tock_bot_connector_whatsapp();
                    byte[] byArray = ((WhatsAppSendBotImageMessage)message).getImage().getByteImages$tock_bot_connector_whatsapp();
                    if (byArray == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = (object = (MediaResponse)(response = this.api.sendMedia(string, RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.get(((WhatsAppSendBotImageMessage)message).getImage().getContentType$tock_bot_connector_whatsapp()), (int)0, (int)0, (int)6, null)).execute()).body()) != null && (object = ((MediaResponse)object).getMedia()) != null && (object = (MediaId)CollectionsKt.firstOrNull((List)object)) != null ? ((MediaId)object).getId() : (id = null);
                    if (id == null) {
                        retrofit2.Response response3 = response;
                        Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"response");
                        this.logError(response3);
                    } else {
                        retrofit2.Response response2;
                        ((WhatsAppSendBotImageMessage)message).getImage().setId(id);
                        retrofit2.Response response4 = response2 = this.api.sendMessage(message).execute();
                        Intrinsics.checkExpressionValueIsNotNull((Object)response4, (String)"response2");
                        if (!response4.isSuccessful()) {
                            this.logError(response2);
                        }
                    }
                }
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
            }
        }
    }

    public final boolean login() {
        boolean bl;
        try {
            boolean bl2;
            retrofit2.Response response;
            retrofit2.Response response2 = response = this.loginApi.login().execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            if (response2.isSuccessful()) {
                Object object = (LoginResponse)response.body();
                if (object != null && (object = ((LoginResponse)object).getUsers()) != null && (object = (LoginUser)CollectionsKt.firstOrNull((List)object)) != null) {
                    Object object2 = object;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Object it = object2;
                    boolean bl5 = false;
                    this.token = ((LoginUser)it).getToken();
                    this.tokenExpiration = ((LoginUser)it).getExpiresAfter();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                this.logError(response);
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    public WhatsAppClient(@NotNull String whatsAppUrl, @NotNull String login, @NotNull String password) {
        Retrofit $this$create$iv;
        Intrinsics.checkParameterIsNotNull((Object)whatsAppUrl, (String)"whatsAppUrl");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.clientMapper = JacksonKt.getMapper().copy().registerModule((Module)JacksonKt.addDeserializer((SimpleModule)new SimpleModule(), (KClass)Reflection.getOrCreateKotlinClass(OffsetDateTime.class), (JsonDeserializer)((JsonDeserializer)new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX"), (Function)clientMapper.2.INSTANCE, (Function)clientMapper.3.INSTANCE, (Function)clientMapper.4.INSTANCE, (BiFunction)clientMapper.5.INSTANCE, false){})));
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)RetrofitsKt.basicAuthInterceptor((String)login, (String)password)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(whatsAppUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"retrofitBuilderWithTimeo\u2026    .baseUrl(whatsAppUrl)");
        ObjectMapper objectMapper = this.clientMapper;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper, (String)"clientMapper");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)objectMapper).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        Retrofit retrofit2 = retrofit;
        WhatsAppClient whatsAppClient = this;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(WhatsAppLoginApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"create(T::class.java)");
        Object object2 = object;
        whatsAppClient.loginApi = (WhatsAppLoginApi)object2;
        Retrofit.Builder builder2 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)this.tokenInterceptor()), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(whatsAppUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"retrofitBuilderWithTimeo\u2026    .baseUrl(whatsAppUrl)");
        ObjectMapper objectMapper2 = this.clientMapper;
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"clientMapper");
        Retrofit retrofit3 = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder2, (ObjectMapper)objectMapper2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit3, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        $this$create$iv = retrofit3;
        whatsAppClient = this;
        $i$f$create = false;
        Object object3 = $this$create$iv.create(WhatsAppApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"create(T::class.java)");
        object2 = object3;
        whatsAppClient.api = (WhatsAppApi)object2;
    }

    public static final /* synthetic */ String access$getToken$p(WhatsAppClient $this) {
        return $this.token;
    }

    public static final /* synthetic */ void access$setToken$p(WhatsAppClient $this, String string) {
        $this.token = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginResponse;", "", "users", "", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginUser;", "(Ljava/util/List;)V", "getUsers", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-bot-connector-whatsapp"})
    public static final class LoginResponse {
        @NotNull
        private final List<LoginUser> users;

        @NotNull
        public final List<LoginUser> getUsers() {
            return this.users;
        }

        public LoginResponse(@NotNull List<LoginUser> users) {
            Intrinsics.checkParameterIsNotNull(users, (String)"users");
            this.users = users;
        }

        public /* synthetic */ LoginResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        public LoginResponse() {
            this(null, 1, null);
        }

        @NotNull
        public final List<LoginUser> component1() {
            return this.users;
        }

        @NotNull
        public final LoginResponse copy(@NotNull List<LoginUser> users) {
            Intrinsics.checkParameterIsNotNull(users, (String)"users");
            return new LoginResponse(users);
        }

        public static /* synthetic */ LoginResponse copy$default(LoginResponse loginResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = loginResponse.users;
            }
            return loginResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "LoginResponse(users=" + this.users + ")";
        }

        public int hashCode() {
            List<LoginUser> list = this.users;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LoginResponse)) break block3;
                    LoginResponse loginResponse = (LoginResponse)object;
                    if (!Intrinsics.areEqual(this.users, loginResponse.users)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginUser;", "", "token", "", "expiresAfter", "Ljava/time/OffsetDateTime;", "(Ljava/lang/String;Ljava/time/OffsetDateTime;)V", "getExpiresAfter", "()Ljava/time/OffsetDateTime;", "getToken", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-whatsapp"})
    public static final class LoginUser {
        @NotNull
        private final String token;
        @NotNull
        private final OffsetDateTime expiresAfter;

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @JsonProperty(value="expires_after")
        @NotNull
        public final OffsetDateTime getExpiresAfter() {
            return this.expiresAfter;
        }

        public LoginUser(@NotNull String token, @NotNull OffsetDateTime expiresAfter) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            Intrinsics.checkParameterIsNotNull((Object)expiresAfter, (String)"expiresAfter");
            this.token = token;
            this.expiresAfter = expiresAfter;
        }

        @NotNull
        public final String component1() {
            return this.token;
        }

        @NotNull
        public final OffsetDateTime component2() {
            return this.expiresAfter;
        }

        @NotNull
        public final LoginUser copy(@NotNull String token, @NotNull OffsetDateTime expiresAfter) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            Intrinsics.checkParameterIsNotNull((Object)expiresAfter, (String)"expiresAfter");
            return new LoginUser(token, expiresAfter);
        }

        public static /* synthetic */ LoginUser copy$default(LoginUser loginUser, String string, OffsetDateTime offsetDateTime, int n, Object object) {
            if ((n & 1) != 0) {
                string = loginUser.token;
            }
            if ((n & 2) != 0) {
                offsetDateTime = loginUser.expiresAfter;
            }
            return loginUser.copy(string, offsetDateTime);
        }

        @NotNull
        public String toString() {
            return "LoginUser(token=" + this.token + ", expiresAfter=" + this.expiresAfter + ")";
        }

        public int hashCode() {
            String string = this.token;
            OffsetDateTime offsetDateTime = this.expiresAfter;
            return (string != null ? string.hashCode() : 0) * 31 + (offsetDateTime != null ? ((Object)offsetDateTime).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LoginUser)) break block3;
                    LoginUser loginUser = (LoginUser)object;
                    if (!Intrinsics.areEqual((Object)this.token, (Object)loginUser.token) || !Intrinsics.areEqual((Object)this.expiresAfter, (Object)loginUser.expiresAfter)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaResponse;", "", "media", "", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaId;", "(Ljava/util/List;)V", "getMedia", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-bot-connector-whatsapp"})
    public static final class MediaResponse {
        @NotNull
        private final List<MediaId> media;

        @NotNull
        public final List<MediaId> getMedia() {
            return this.media;
        }

        public MediaResponse(@NotNull List<MediaId> media) {
            Intrinsics.checkParameterIsNotNull(media, (String)"media");
            this.media = media;
        }

        public /* synthetic */ MediaResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        public MediaResponse() {
            this(null, 1, null);
        }

        @NotNull
        public final List<MediaId> component1() {
            return this.media;
        }

        @NotNull
        public final MediaResponse copy(@NotNull List<MediaId> media) {
            Intrinsics.checkParameterIsNotNull(media, (String)"media");
            return new MediaResponse(media);
        }

        public static /* synthetic */ MediaResponse copy$default(MediaResponse mediaResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = mediaResponse.media;
            }
            return mediaResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "MediaResponse(media=" + this.media + ")";
        }

        public int hashCode() {
            List<MediaId> list = this.media;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MediaResponse)) break block3;
                    MediaResponse mediaResponse = (MediaResponse)object;
                    if (!Intrinsics.areEqual(this.media, mediaResponse.media)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaId;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-whatsapp"})
    public static final class MediaId {
        @NotNull
        private final String id;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public MediaId(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final MediaId copy(@NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new MediaId(id);
        }

        public static /* synthetic */ MediaId copy$default(MediaId mediaId, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = mediaId.id;
            }
            return mediaId.copy(string);
        }

        @NotNull
        public String toString() {
            return "MediaId(id=" + this.id + ")";
        }

        public int hashCode() {
            String string = this.id;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MediaId)) break block3;
                    MediaId mediaId = (MediaId)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)mediaId.id)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppLoginApi;", "", "login", "Lretrofit2/Call;", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginResponse;", "tock-bot-connector-whatsapp"})
    private static interface WhatsAppLoginApi {
        @Headers(value={"Content-Type: application/json"})
        @POST(value="v1/users/login")
        @NotNull
        public Call<LoginResponse> login();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH'J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u0010H'\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppApi;", "", "deleteMedia", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "mediaId", "", "getMedia", "sendMedia", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaResponse;", "contentType", "body", "Lokhttp3/RequestBody;", "sendMessage", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppResponse;", "message", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppSendBotMessage;", "tock-bot-connector-whatsapp"})
    private static interface WhatsAppApi {
        @Headers(value={"Content-Type: application/json"})
        @POST(value="v1/messages")
        @NotNull
        public Call<WhatsAppResponse> sendMessage(@Body @NotNull WhatsAppSendBotMessage var1);

        @GET(value="v1/media/{mediaId}")
        @NotNull
        public Call<ResponseBody> getMedia(@Path(value="mediaId") @NotNull String var1);

        @DELETE(value="v1/media/{mediaId}")
        @NotNull
        public Call<ResponseBody> deleteMedia(@Path(value="mediaId") @NotNull String var1);

        @POST(value="v1/media")
        @NotNull
        public Call<MediaResponse> sendMedia(@Header(value="Content-Type") @NotNull String var1, @Body @NotNull RequestBody var2);
    }
}

