/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.whatsapp;

import ai.tock.bot.connector.ConnectorBase;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.whatsapp.SendActionConverter;
import ai.tock.bot.connector.whatsapp.WebhookActionConverter;
import ai.tock.bot.connector.whatsapp.WhatsAppBuilderKt;
import ai.tock.bot.connector.whatsapp.WhatsAppClient;
import ai.tock.bot.connector.whatsapp.WhatsAppConnector;
import ai.tock.bot.connector.whatsapp.WhatsAppConnectorCallback;
import ai.tock.bot.connector.whatsapp.WhatsAppConnectorData;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppBotRecipientType;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotMessage;
import ai.tock.bot.connector.whatsapp.model.webhook.WhatsAppMessage;
import ai.tock.bot.connector.whatsapp.model.webhook.WhatsAppMessages;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import ai.tock.bot.engine.monitoring.RequestTimerKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.security.RequestFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppConnector;", "Lai/tock/bot/connector/ConnectorBase;", "applicationId", "", "path", "url", "login", "password", "requestFilter", "Lai/tock/shared/security/RequestFilter;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lai/tock/shared/security/RequestFilter;)V", "getApplicationId", "()Ljava/lang/String;", "client", "Lai/tock/bot/connector/whatsapp/WhatsAppClient;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "register", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "send", "event", "Lai/tock/bot/engine/event/Event;", "callback", "Lai/tock/bot/connector/ConnectorCallback;", "delayInMs", "", "Companion", "tock-bot-connector-whatsapp"})
public final class WhatsAppConnector
extends ConnectorBase {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String path;
    @NotNull
    private final RequestFilter requestFilter;
    @NotNull
    private final WhatsAppClient client;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private static final KLogger logger;

    public WhatsAppConnector(@NotNull String applicationId, @NotNull String path, @NotNull String url, @NotNull String login, @NotNull String password, @NotNull RequestFilter requestFilter) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)requestFilter, (String)"requestFilter");
        super(WhatsAppBuilderKt.getWhatsAppConnectorType(), null, 2, null);
        this.applicationId = applicationId;
        this.path = path;
        this.requestFilter = requestFilter;
        this.client = new WhatsAppClient(url, login, password);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void register(@NotNull ConnectorController controller) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        controller.registerServices(this.path, (Function1)new Function1<Router, Unit>(this, controller){
            final /* synthetic */ WhatsAppConnector this$0;
            final /* synthetic */ ConnectorController $controller;
            {
                this.this$0 = $receiver;
                this.$controller = $controller;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.post(WhatsAppConnector.access$getPath$p(this.this$0)).handler(arg_0 -> register.1.invoke$lambda$1(this.this$0, this.$controller, arg_0));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final void invoke$lambda$1(WhatsAppConnector this$0, ConnectorController $controller, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
                RequestFilter requestFilter = WhatsAppConnector.access$getRequestFilter$p(this$0);
                HttpServerRequest httpServerRequest = context.request();
                Intrinsics.checkNotNullExpressionValue((Object)httpServerRequest, (String)"context.request()");
                if (!requestFilter.accept(httpServerRequest)) {
                    context.response().setStatusCode(403).end();
                    return;
                }
                RequestTimerData requestTimerData = BotRepository.INSTANCE.getRequestTimer().start("whatsapp_webhook");
                try {
                    void $this$readValue$iv;
                    String body = context.getBodyAsString();
                    WhatsAppConnector.access$getLogger$cp().debug((Function0)new Function0<Object>(body){
                        final /* synthetic */ String $body;
                        {
                            this.$body = $body;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "WhatsApp request input : " + this.$body;
                        }
                    });
                    ObjectMapper objectMapper = JacksonKt.getMapper();
                    Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                    String content$iv = body;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    WhatsAppMessages messages = (WhatsAppMessages)$this$readValue$iv.readValue(content$iv, (com.fasterxml.jackson.core.type.TypeReference)new com.fasterxml.jackson.core.type.TypeReference<WhatsAppMessages>(){});
                    Iterable $this$forEach$iv = messages.getMessages();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        WhatsAppMessage m = (WhatsAppMessage)element$iv;
                        boolean bl = false;
                        WhatsAppConnector.access$getExecutor(this$0).executeBlocking((Function0)new Function0<Unit>(m, this$0, $controller){
                            final /* synthetic */ WhatsAppMessage $m;
                            final /* synthetic */ WhatsAppConnector this$0;
                            final /* synthetic */ ConnectorController $controller;
                            {
                                this.$m = $m;
                                this.this$0 = $receiver;
                                this.$controller = $controller;
                                super(0);
                            }

                            public final void invoke() {
                                Event e = WebhookActionConverter.INSTANCE.toEvent(this.$m, this.this$0.getApplicationId(), WhatsAppConnector.access$getClient$p(this.this$0));
                                if (e != null) {
                                    this.$controller.handle(e, (ConnectorData)new WhatsAppConnectorData(new WhatsAppConnectorCallback(this.this$0.getApplicationId(), this.$m.getGroupId() == null ? WhatsAppBotRecipientType.individual : WhatsAppBotRecipientType.group), this.$m.getGroupId(), this.$m.getFrom()));
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    RequestTimerKt.logError((KLogger)WhatsAppConnector.access$getLogger$cp(), (Throwable)e, (RequestTimerData)requestTimerData);
                }
                finally {
                    try {
                        BotRepository.INSTANCE.getRequestTimer().end(requestTimerData);
                        context.response().end();
                    }
                    catch (Throwable e) {
                        LoggersKt.error((KLogger)WhatsAppConnector.access$getLogger$cp(), (Throwable)e);
                    }
                }
            }
        });
    }

    public void send(@NotNull Event event, @NotNull ConnectorCallback callback, long delayInMs) {
        block0: {
            WhatsAppSendBotMessage whatsAppSendBotMessage;
            WhatsAppSendBotMessage whatsAppSendBotMessage2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            if (!(event instanceof Action) || (whatsAppSendBotMessage2 = SendActionConverter.INSTANCE.toBotMessage((Action)event)) == null) break block0;
            WhatsAppSendBotMessage it = whatsAppSendBotMessage = whatsAppSendBotMessage2;
            boolean bl = false;
            Duration delay = Duration.ofMillis(delayInMs);
            Executor executor = this.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)delay, (String)"delay");
            executor.executeBlocking(delay, (Function0)new Function0<Unit>(this, it){
                final /* synthetic */ WhatsAppConnector this$0;
                final /* synthetic */ WhatsAppSendBotMessage $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    WhatsAppConnector.access$getClient$p(this.this$0).sendMessage(this.$it);
                }
            });
        }
    }

    public static final /* synthetic */ String access$getPath$p(WhatsAppConnector $this) {
        return $this.path;
    }

    public static final /* synthetic */ Executor access$getExecutor(WhatsAppConnector $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ WhatsAppClient access$getClient$p(WhatsAppConnector $this) {
        return $this.client;
    }

    public static final /* synthetic */ RequestFilter access$getRequestFilter$p(WhatsAppConnector $this) {
        return $this.requestFilter;
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(WhatsAppConnector.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppConnector$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-connector-whatsapp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

