/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector.whatsapp;

import ai.tock.bot.connector.whatsapp.WhatsAppClient;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppResponse;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotImageMessage;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotInteractiveMessage;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotMessage;
import ai.tock.bot.connector.whatsapp.model.send.WhatsAppSendBotTextMessage;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0006\"#$%&'B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030!H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient;", "", "whatsAppUrl", "", "login", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "api", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppApi;", "clientMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "getClientMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "logger", "Lmu/KLogger;", "loginApi", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppLoginApi;", "token", "tokenExpiration", "Ljava/time/OffsetDateTime;", "checkLogin", "", "getMedia", "", "id", "sendMessage", "", "message", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppSendBotMessage;", "tokenInterceptor", "Lokhttp3/Interceptor;", "logError", "Lretrofit2/Response;", "LoginResponse", "LoginUser", "MediaId", "MediaResponse", "WhatsAppApi", "WhatsAppLoginApi", "tock-bot-connector-whatsapp"})
public final class WhatsAppClient {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final WhatsAppLoginApi loginApi;
    @NotNull
    private final WhatsAppApi api;
    @Nullable
    private volatile OffsetDateTime tokenExpiration;
    @Nullable
    private volatile String token;
    private final ObjectMapper clientMapper;

    public WhatsAppClient(@NotNull String whatsAppUrl, @NotNull String login, @NotNull String password) {
        Retrofit $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)whatsAppUrl, (String)"whatsAppUrl");
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        Retrofit retrofit = OffsetDateTime.class;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
        Function<TemporalAccessor, OffsetDateTime> function = WhatsAppClient::clientMapper$lambda$0;
        Function<InstantDeserializer.FromIntegerArguments, OffsetDateTime> function2 = WhatsAppClient::clientMapper$lambda$1;
        Function<InstantDeserializer.FromDecimalArguments, OffsetDateTime> function3 = WhatsAppClient::clientMapper$lambda$2;
        BiFunction<OffsetDateTime, ZoneId, OffsetDateTime> biFunction = WhatsAppClient::clientMapper$lambda$3;
        this.clientMapper = JacksonKt.getMapper().copy().registerModule((Module)JacksonKt.addDeserializer((SimpleModule)new SimpleModule(), (KClass)Reflection.getOrCreateKotlinClass(OffsetDateTime.class), (JsonDeserializer)((JsonDeserializer)new InstantDeserializer<OffsetDateTime>(retrofit, dateTimeFormatter, function, function2, function3, biFunction){})));
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)RetrofitsKt.basicAuthInterceptor((String)login, (String)password)), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(whatsAppUrl);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeo\u2026    .baseUrl(whatsAppUrl)");
        ObjectMapper objectMapper = this.clientMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"clientMapper");
        retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)objectMapper).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(WhatsAppLoginApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        this.loginApi = (WhatsAppLoginApi)object;
        Retrofit.Builder builder2 = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)PropertiesKt.longProperty((String)"tock_whatsapp_request_timeout_ms", (long)30000L), (KLogger)this.logger, null, (List)CollectionsKt.listOf((Object)this.tokenInterceptor()), (boolean)false, (boolean)false, null, (int)116, null).baseUrl(whatsAppUrl);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"retrofitBuilderWithTimeo\u2026    .baseUrl(whatsAppUrl)");
        ObjectMapper objectMapper2 = this.clientMapper;
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"clientMapper");
        $this$create$iv = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder2, (ObjectMapper)objectMapper2).build();
        Intrinsics.checkNotNullExpressionValue((Object)$this$create$iv, (String)"retrofitBuilderWithTimeo\u2026per)\n            .build()");
        $i$f$create = false;
        Object object2 = $this$create$iv.create(WhatsAppApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"create(T::class.java)");
        this.api = (WhatsAppApi)object2;
    }

    public final ObjectMapper getClientMapper() {
        return this.clientMapper;
    }

    private final Interceptor tokenInterceptor() {
        return arg_0 -> WhatsAppClient.tokenInterceptor$lambda$4(this, arg_0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkLogin() {
        if (this.token != null) {
            boolean bl;
            OffsetDateTime offsetDateTime = this.tokenExpiration;
            if (offsetDateTime != null) {
                if (!offsetDateTime.isBefore(OffsetDateTime.now().plusHours(1L))) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
        }
        boolean bl = this.login();
        return bl;
    }

    private final void logError(retrofit2.Response<?> $this$logError) {
        String error = $this$logError.message();
        int errorCode = $this$logError.code();
        this.logger.warn((Function0)new Function0<Object>(errorCode, error){
            final /* synthetic */ int $errorCode;
            final /* synthetic */ String $error;
            {
                this.$errorCode = $errorCode;
                this.$error = $error;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "WhatsApp Error : " + this.$errorCode + " " + this.$error;
            }
        });
        ResponseBody responseBody = $this$logError.errorBody();
        String errorBody = responseBody != null ? responseBody.string() : null;
        this.logger.warn((Function0)new Function0<Object>(errorBody){
            final /* synthetic */ String $errorBody;
            {
                this.$errorBody = $errorBody;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Messenger Error body : " + this.$errorBody;
            }
        });
    }

    @Nullable
    public final byte[] getMedia(@NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.checkLogin()) {
            retrofit2.Response $this$getMedia_u24lambda_u246 = this.api.getMedia(id).execute();
            boolean bl = false;
            ResponseBody responseBody = (ResponseBody)$this$getMedia_u24lambda_u246.body();
            object = responseBody;
            if (responseBody == null || (object = object.bytes()) == null) {
                Object var4_4 = null;
                Void it = var4_4;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$getMedia_u24lambda_u246, (String)"getMedia$lambda$6$lambda$5");
                this.logError($this$getMedia_u24lambda_u246);
                object = var4_4;
            }
        } else {
            object = null;
        }
        return object;
    }

    public final void sendMessage(@NotNull WhatsAppSendBotMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.checkLogin()) {
            try {
                retrofit2.Response response;
                WhatsAppSendBotMessage whatsAppSendBotMessage = message;
                if (whatsAppSendBotMessage instanceof WhatsAppSendBotTextMessage) {
                    retrofit2.Response response2 = this.api.sendMessage(message).execute();
                    if (!response2.isSuccessful()) {
                        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                        this.logError(response2);
                    }
                } else if (whatsAppSendBotMessage instanceof WhatsAppSendBotImageMessage) {
                    String id;
                    String string = ((WhatsAppSendBotImageMessage)message).getImage().getContentType$tock_bot_connector_whatsapp();
                    byte[] byArray = ((WhatsAppSendBotImageMessage)message).getImage().getByteImages$tock_bot_connector_whatsapp();
                    Intrinsics.checkNotNull((Object)byArray);
                    retrofit2.Response response3 = this.api.sendMedia(string, RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.get(((WhatsAppSendBotImageMessage)message).getImage().getContentType$tock_bot_connector_whatsapp()), (int)0, (int)0, (int)6, null)).execute();
                    Object object = (MediaResponse)response3.body();
                    String string2 = object != null && (object = ((MediaResponse)object).getMedia()) != null && (object = (MediaId)CollectionsKt.firstOrNull((List)object)) != null ? ((MediaId)object).getId() : (id = null);
                    if (id == null) {
                        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"response");
                        this.logError(response3);
                    } else {
                        ((WhatsAppSendBotImageMessage)message).getImage().setId(id);
                        retrofit2.Response response2 = this.api.sendMessage(message).execute();
                        if (!response2.isSuccessful()) {
                            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response2");
                            this.logError(response2);
                        }
                    }
                } else if (whatsAppSendBotMessage instanceof WhatsAppSendBotInteractiveMessage && !(response = this.api.sendMessage(message).execute()).isSuccessful()) {
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                    this.logError(response);
                }
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
            }
        }
    }

    public final boolean login() {
        boolean bl;
        try {
            boolean bl2;
            retrofit2.Response response = this.loginApi.login().execute();
            if (response.isSuccessful()) {
                Object object = (LoginResponse)response.body();
                if (object != null && (object = ((LoginResponse)object).getUsers()) != null && (object = (LoginUser)CollectionsKt.firstOrNull((List)object)) != null) {
                    Object it = object;
                    boolean bl3 = false;
                    this.token = ((LoginUser)it).getToken();
                    this.tokenExpiration = ((LoginUser)it).getExpiresAfter();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
                this.logError(response);
                bl2 = false;
            }
            bl = bl2;
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this.logger, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private static final OffsetDateTime clientMapper$lambda$0(TemporalAccessor it) {
        return OffsetDateTime.from(it);
    }

    private static final OffsetDateTime clientMapper$lambda$1(InstantDeserializer.FromIntegerArguments a) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId);
    }

    private static final OffsetDateTime clientMapper$lambda$2(InstantDeserializer.FromDecimalArguments a) {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId);
    }

    private static final OffsetDateTime clientMapper$lambda$3(OffsetDateTime d, ZoneId z) {
        return d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime()));
    }

    private static final Response tokenInterceptor$lambda$4(WhatsAppClient this$0, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request original = chain.request();
        Request.Builder requestBuilder = original.newBuilder().header("Authorization", "Bearer " + this$0.token);
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginResponse;", "", "users", "", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginUser;", "(Ljava/util/List;)V", "getUsers", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-bot-connector-whatsapp"})
    public static final class LoginResponse {
        @NotNull
        private final List<LoginUser> users;

        public LoginResponse(@NotNull List<LoginUser> users) {
            Intrinsics.checkNotNullParameter(users, (String)"users");
            this.users = users;
        }

        public /* synthetic */ LoginResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<LoginUser> getUsers() {
            return this.users;
        }

        @NotNull
        public final List<LoginUser> component1() {
            return this.users;
        }

        @NotNull
        public final LoginResponse copy(@NotNull List<LoginUser> users) {
            Intrinsics.checkNotNullParameter(users, (String)"users");
            return new LoginResponse(users);
        }

        public static /* synthetic */ LoginResponse copy$default(LoginResponse loginResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = loginResponse.users;
            }
            return loginResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "LoginResponse(users=" + this.users + ")";
        }

        public int hashCode() {
            return ((Object)this.users).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoginResponse)) {
                return false;
            }
            LoginResponse loginResponse = (LoginResponse)other;
            return Intrinsics.areEqual(this.users, loginResponse.users);
        }

        public LoginResponse() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginUser;", "", "token", "", "expiresAfter", "Ljava/time/OffsetDateTime;", "(Ljava/lang/String;Ljava/time/OffsetDateTime;)V", "getExpiresAfter", "()Ljava/time/OffsetDateTime;", "getToken", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-whatsapp"})
    public static final class LoginUser {
        @NotNull
        private final String token;
        @NotNull
        private final OffsetDateTime expiresAfter;

        public LoginUser(@NotNull String token, @NotNull OffsetDateTime expiresAfter) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)expiresAfter, (String)"expiresAfter");
            this.token = token;
            this.expiresAfter = expiresAfter;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @JsonProperty(value="expires_after")
        @NotNull
        public final OffsetDateTime getExpiresAfter() {
            return this.expiresAfter;
        }

        @NotNull
        public final String component1() {
            return this.token;
        }

        @NotNull
        public final OffsetDateTime component2() {
            return this.expiresAfter;
        }

        @NotNull
        public final LoginUser copy(@NotNull String token, @NotNull OffsetDateTime expiresAfter) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)expiresAfter, (String)"expiresAfter");
            return new LoginUser(token, expiresAfter);
        }

        public static /* synthetic */ LoginUser copy$default(LoginUser loginUser, String string, OffsetDateTime offsetDateTime, int n, Object object) {
            if ((n & 1) != 0) {
                string = loginUser.token;
            }
            if ((n & 2) != 0) {
                offsetDateTime = loginUser.expiresAfter;
            }
            return loginUser.copy(string, offsetDateTime);
        }

        @NotNull
        public String toString() {
            return "LoginUser(token=" + this.token + ", expiresAfter=" + this.expiresAfter + ")";
        }

        public int hashCode() {
            int result = this.token.hashCode();
            result = result * 31 + this.expiresAfter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoginUser)) {
                return false;
            }
            LoginUser loginUser = (LoginUser)other;
            if (!Intrinsics.areEqual((Object)this.token, (Object)loginUser.token)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expiresAfter, (Object)loginUser.expiresAfter);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaResponse;", "", "media", "", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaId;", "(Ljava/util/List;)V", "getMedia", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-bot-connector-whatsapp"})
    public static final class MediaResponse {
        @NotNull
        private final List<MediaId> media;

        public MediaResponse(@NotNull List<MediaId> media) {
            Intrinsics.checkNotNullParameter(media, (String)"media");
            this.media = media;
        }

        public /* synthetic */ MediaResponse(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<MediaId> getMedia() {
            return this.media;
        }

        @NotNull
        public final List<MediaId> component1() {
            return this.media;
        }

        @NotNull
        public final MediaResponse copy(@NotNull List<MediaId> media) {
            Intrinsics.checkNotNullParameter(media, (String)"media");
            return new MediaResponse(media);
        }

        public static /* synthetic */ MediaResponse copy$default(MediaResponse mediaResponse, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = mediaResponse.media;
            }
            return mediaResponse.copy(list);
        }

        @NotNull
        public String toString() {
            return "MediaResponse(media=" + this.media + ")";
        }

        public int hashCode() {
            return ((Object)this.media).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaResponse)) {
                return false;
            }
            MediaResponse mediaResponse = (MediaResponse)other;
            return Intrinsics.areEqual(this.media, mediaResponse.media);
        }

        public MediaResponse() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaId;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-bot-connector-whatsapp"})
    public static final class MediaId {
        @NotNull
        private final String id;

        public MediaId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final MediaId copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new MediaId(id);
        }

        public static /* synthetic */ MediaId copy$default(MediaId mediaId, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = mediaId.id;
            }
            return mediaId.copy(string);
        }

        @NotNull
        public String toString() {
            return "MediaId(id=" + this.id + ")";
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaId)) {
                return false;
            }
            MediaId mediaId = (MediaId)other;
            return Intrinsics.areEqual((Object)this.id, (Object)mediaId.id);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppLoginApi;", "", "login", "Lretrofit2/Call;", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$LoginResponse;", "tock-bot-connector-whatsapp"})
    private static interface WhatsAppLoginApi {
        @Headers(value={"Content-Type: application/json"})
        @POST(value="v1/users/login")
        @NotNull
        public Call<LoginResponse> login();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0001\u0010\u000b\u001a\u00020\fH'J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u0010H'\u00a8\u0006\u0011"}, d2={"Lai/tock/bot/connector/whatsapp/WhatsAppClient$WhatsAppApi;", "", "deleteMedia", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "mediaId", "", "getMedia", "sendMedia", "Lai/tock/bot/connector/whatsapp/WhatsAppClient$MediaResponse;", "contentType", "body", "Lokhttp3/RequestBody;", "sendMessage", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppResponse;", "message", "Lai/tock/bot/connector/whatsapp/model/send/WhatsAppSendBotMessage;", "tock-bot-connector-whatsapp"})
    private static interface WhatsAppApi {
        @Headers(value={"Content-Type: application/json"})
        @POST(value="v1/messages")
        @NotNull
        public Call<WhatsAppResponse> sendMessage(@Body @NotNull WhatsAppSendBotMessage var1);

        @GET(value="v1/media/{mediaId}")
        @NotNull
        public Call<ResponseBody> getMedia(@Path(value="mediaId") @NotNull String var1);

        @DELETE(value="v1/media/{mediaId}")
        @NotNull
        public Call<ResponseBody> deleteMedia(@Path(value="mediaId") @NotNull String var1);

        @POST(value="v1/media")
        @NotNull
        public Call<MediaResponse> sendMedia(@Header(value="Content-Type") @NotNull String var1, @Body @NotNull RequestBody var2);
    }
}

