/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.config;

import ai.tock.bot.connector.media.MediaFileDescriptor;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.TockBotBus;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.config.UploadedFilesService;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.cache.CachesKt;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J%\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J \u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lai/tock/bot/engine/config/UploadedFilesService;", "", "()V", "UPLOADED_TYPE", "", "audioTypes", "", "basePath", "imagesTypes", "videoTypes", "attachmentType", "Lai/tock/bot/engine/action/SendAttachment$AttachmentType;", "url", "botFilePath", "bus", "Lai/tock/bot/engine/BotBus;", "id", "suffix", "botFilePath$tock_bot_engine", "configure", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "configure$tock_bot_engine", "downloadFile", "context", "Lio/vertx/ext/web/RoutingContext;", "fileId", "fileId$tock_bot_engine", "getFileContentFromId", "", "getFileContentFromId$tock_bot_engine", "getFileContentFromUrl", "guessContentType", "fileName", "uploadFile", "Lai/tock/bot/connector/media/MediaFileDescriptor;", "namespace", "bytes", "tock-bot-engine"})
public final class UploadedFilesService {
    private static final String UPLOADED_TYPE = "_uploaded";
    private static final String basePath;
    private static final Set<String> imagesTypes;
    private static final Set<String> audioTypes;
    private static final Set<String> videoTypes;
    public static final UploadedFilesService INSTANCE;

    @NotNull
    public final SendAttachment.AttachmentType attachmentType(@NotNull String url) {
        SendAttachment.AttachmentType attachmentType;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (url.length() > 2) {
            String string = url;
            int n = url.length() - 3;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            string = string2;
            n = 0;
            bl = false;
            String suffix = string;
            boolean bl2 = false;
            attachmentType = imagesTypes.contains(suffix) ? SendAttachment.AttachmentType.image : (audioTypes.contains(suffix) ? SendAttachment.AttachmentType.audio : (videoTypes.contains(suffix) ? SendAttachment.AttachmentType.video : SendAttachment.AttachmentType.file));
        } else {
            attachmentType = SendAttachment.AttachmentType.file;
        }
        return attachmentType;
    }

    @Nullable
    public final MediaFileDescriptor uploadFile(@NotNull String namespace, @NotNull String fileName, @NotNull byte[] bytes) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        String string = namespace + UUID.randomUUID().toString();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String id = string3;
        String string4 = fileName;
        boolean bl2 = false;
        string4 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        String name = string6;
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
        if (lastDot == -1 || lastDot == name.length() - 1) {
            return null;
        }
        String string7 = name;
        int n = lastDot + 1;
        boolean bl3 = false;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
        String suffix = string9;
        String fileId = id + '.' + suffix;
        CachesKt.putInCache((Id)IdsKt.toId((String)fileId), (String)UPLOADED_TYPE, (Object)bytes);
        return new MediaFileDescriptor(suffix, fileName, id, null, 8, null);
    }

    public final void downloadFile(@NotNull RoutingContext context, @NotNull String id, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        this.downloadFile(context, id + '.' + suffix);
    }

    @NotNull
    public final String fileId$tock_bot_engine(@NotNull String id, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return id + '.' + suffix;
    }

    @NotNull
    public final String botFilePath$tock_bot_engine(@NotNull BotBus bus, @NotNull String id, @NotNull String suffix) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        StringBuilder stringBuilder = new StringBuilder();
        BotBus botBus = bus;
        if (!(botBus instanceof TockBotBus)) {
            botBus = null;
        }
        return stringBuilder.append((object = (TockBotBus)botBus) != null && (object = ((TockBotBus)object).getConnector()) != null ? ((TockConnectorController)object).getBaseUrl() : null).append(basePath).append(this.fileId$tock_bot_engine(id, suffix)).toString();
    }

    @Nullable
    public final byte[] getFileContentFromUrl(@NotNull String url) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String string = url;
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string;
        boolean bl3 = false;
        int start = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (start == -1) {
            byArray = null;
        } else {
            String string2 = url;
            int n = start + 1;
            UploadedFilesService uploadedFilesService = INSTANCE;
            boolean bl4 = false;
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            byArray = uploadedFilesService.getFileContentFromId$tock_bot_engine(string4);
        }
        return byArray;
    }

    @Nullable
    public final byte[] getFileContentFromId$tock_bot_engine(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Object object = CachesKt.getFromCache((Id)IdsKt.toId((String)id), (String)UPLOADED_TYPE);
        if (!(object instanceof byte[])) {
            object = null;
        }
        return (byte[])object;
    }

    private final void downloadFile(RoutingContext context, String id) {
        byte[] bytes = this.getFileContentFromId$tock_bot_engine(id);
        if (bytes != null) {
            context.response().putHeader("Content-Type", this.guessContentType(id)).end(Buffer.buffer((byte[])bytes));
        } else {
            context.response().setStatusCode(404).end();
        }
    }

    @NotNull
    public final String guessContentType(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        String string = fileName;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        string = string2;
        bl = false;
        boolean bl2 = false;
        String id = string;
        boolean bl3 = false;
        return StringsKt.endsWith$default((String)id, (String)".png", (boolean)false, (int)2, null) ? "image/png" : (StringsKt.endsWith$default((String)id, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)id, (String)".jpeg", (boolean)false, (int)2, null) ? "image/jpeg" : (StringsKt.endsWith$default((String)id, (String)".gif", (boolean)false, (int)2, null) ? "image/gif" : (StringsKt.endsWith$default((String)id, (String)".svg", (boolean)false, (int)2, null) ? "image/svg+xml" : (StringsKt.endsWith$default((String)id, (String)".ogg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)id, (String)".oga", (boolean)false, (int)2, null) ? "audio/ogg" : (StringsKt.endsWith$default((String)id, (String)".ogv", (boolean)false, (int)2, null) ? "video/ogg" : (StringsKt.endsWith$default((String)id, (String)".mp3", (boolean)false, (int)2, null) ? "audio/mpeg" : (StringsKt.endsWith$default((String)id, (String)".mp4", (boolean)false, (int)2, null) ? "video/mp4" : (StringsKt.endsWith$default((String)id, (String)".pdf", (boolean)false, (int)2, null) ? "application/pdf" : (StringsKt.endsWith$default((String)id, (String)".zip", (boolean)false, (int)2, null) ? "application/zip" : "application/octet-stream")))))))));
    }

    @NotNull
    public final Function1<Router, Unit> configure$tock_bot_engine() {
        return configure.1.INSTANCE;
    }

    private UploadedFilesService() {
    }

    static {
        UploadedFilesService uploadedFilesService;
        INSTANCE = uploadedFilesService = new UploadedFilesService();
        basePath = PropertiesKt.property((String)"tock_bot_serve_files_path", (String)"/f/");
        imagesTypes = SetsKt.setOf((Object[])new String[]{"png", "jpg", "jpeg", "svg", "gif"});
        audioTypes = SetsKt.setOf((Object[])new String[]{"ogg", "mp3", "oga"});
        videoTypes = SetsKt.setOf((Object[])new String[]{"ogv", "mp4"});
    }

    public static final /* synthetic */ String access$getBasePath$p(UploadedFilesService $this) {
        UploadedFilesService uploadedFilesService = $this;
        return basePath;
    }

    public static final /* synthetic */ void access$downloadFile(UploadedFilesService $this, RoutingContext context, String id) {
        $this.downloadFile(context, id);
    }
}

