/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.DialogState;
import ai.tock.bot.engine.dialog.EntityStateValue;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.dialog.NextUserActionState;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.nlp.Nlp;
import ai.tock.bot.engine.nlp.NlpCallStats;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.nlp.NlpEntityMergeContext;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.Entity;
import ai.tock.nlp.api.client.model.NlpEntityValue;
import ai.tock.nlp.api.client.model.NlpIntentQualifier;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpQueryContext;
import ai.tock.nlp.api.client.model.NlpQueryState;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationQuery;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationResult;
import ai.tock.nlp.api.client.model.evaluation.EntityToEvaluate;
import ai.tock.nlp.api.client.model.merge.ValueToMerge;
import ai.tock.nlp.api.client.model.merge.ValuesMergeQuery;
import ai.tock.nlp.api.client.model.merge.ValuesMergeResult;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.entity.Value;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lai/tock/bot/engine/nlp/Nlp;", "Lai/tock/bot/engine/nlp/NlpController;", "()V", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "markAsUnknown", "", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "parseSentence", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "waitAvailability", "timeToWaitInMs", "", "Companion", "SentenceParser", "tock-bot-engine"})
public final class Nlp
implements NlpController {
    private static final KLogger logger;
    public static final Companion Companion;

    private final NlpClient getNlpClient() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<NlpClient>(){};
        return (NlpClient)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<Executor>(){};
        return (Executor)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    @Override
    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        Intrinsics.checkParameterIsNotNull((Object)connector, (String)"connector");
        Intrinsics.checkParameterIsNotNull((Object)botDefinition, (String)"botDefinition");
        new SentenceParser(this.getNlpClient(), sentence, userTimeline, dialog, (TockConnectorController)connector, botDefinition).parse();
    }

    @Override
    public void markAsUnknown(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
        Intrinsics.checkParameterIsNotNull((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkParameterIsNotNull((Object)botDefinition, (String)"botDefinition");
        if (sentence.getStringText() != null) {
            this.getExecutor().executeBlocking((Function0)new Function0<Unit>(this, botDefinition, userTimeline, sentence){
                final /* synthetic */ Nlp this$0;
                final /* synthetic */ BotDefinition $botDefinition;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ SendSentence $sentence;

                public final void invoke() {
                    Nlp.access$getNlpClient$p(this.this$0).markAsUnknown(new MarkAsUnknownQuery(this.$botDefinition.getNamespace(), this.$botDefinition.getNlpModelName(), this.$userTimeline.getUserPreferences().getLocale(), this.$sentence.getStringText()));
                }
                {
                    this.this$0 = nlp;
                    this.$botDefinition = botDefinition;
                    this.$userTimeline = userTimeline;
                    this.$sentence = sendSentence;
                    super(0);
                }
            });
        }
    }

    @Override
    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    @Override
    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkParameterIsNotNull((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    @Override
    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkParameterIsNotNull((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    @Override
    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    @Override
    public void waitAvailability(long timeToWaitInMs) {
        long s = System.currentTimeMillis();
        while (!this.getNlpClient().healthcheck() && System.currentTimeMillis() - s < timeToWaitInMs) {
        }
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    public static final /* synthetic */ NlpClient access$getNlpClient$p(Nlp $this) {
        return $this.getNlpClient();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J(\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0004\u001a\u0004\u0018\u00010#H\u0002J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001cH\u0002J*\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\n\b\u0002\u00102\u001a\u0004\u0018\u00010,H\u0002J2\u00103\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00106\u001a\u0002012\n\b\u0002\u00107\u001a\u0004\u0018\u00010,H\u0002J\u0006\u00108\u001a\u00020%J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00109\u001a\u00020\u001eH\u0002J\b\u0010:\u001a\u00020\u001eH\u0002J\b\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020100*\u00020>2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lai/tock/bot/engine/nlp/Nlp$SentenceParser;", "", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/TockConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "(Lai/tock/nlp/api/client/NlpClient;Lai/tock/bot/engine/action/SendSentence;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/engine/dialog/Dialog;Lai/tock/bot/engine/TockConnectorController;Lai/tock/bot/definition/BotDefinition;)V", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "getConnector", "()Lai/tock/bot/engine/TockConnectorController;", "getDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getSentence", "()Lai/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lai/tock/bot/engine/user/UserTimeline;", "evaluateEntitiesForPrecomputedNlp", "Lai/tock/nlp/api/client/model/NlpResult;", "nlpQuery", "Lai/tock/nlp/api/client/model/NlpQuery;", "nlpResult", "findIntent", "Lai/tock/bot/definition/Intent;", "findKeyword", "", "listenNlpErrorCall", "", "query", "throwable", "", "listenNlpSuccessCall", "result", "mergeEntityValues", "Lai/tock/bot/engine/dialog/EntityStateValue;", "action", "Lai/tock/bot/engine/action/Action;", "newValues", "", "Lai/tock/bot/engine/dialog/EntityValue;", "oldValue", "mergeValues", "entity", "Lai/tock/nlp/api/client/model/Entity;", "defaultNewValue", "initialValue", "parse", "request", "toNlpQuery", "toQueryContext", "Lai/tock/nlp/api/client/model/NlpQueryContext;", "mergeEntityValuesFromAction", "Lai/tock/bot/engine/dialog/DialogState;", "tock-bot-engine"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final TockConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        public final void parse() {
            logger.debug((Function0)new Function0<String>(this){
                final /* synthetic */ SentenceParser this$0;

                @NotNull
                public final String invoke() {
                    return "Parse sentence : " + this.this$0.getSentence();
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent2;
                boolean bl3 = false;
                this.dialog.getState().setCurrentIntent($this$apply);
                return;
            }
            NlpQuery nlpQuery = this.toNlpQuery();
            boolean bl = false;
            boolean bl4 = false;
            NlpQuery query = nlpQuery;
            boolean bl5 = false;
            try {
                Object object;
                block7: {
                    block6: {
                        NlpResult result2 = this.sentence.getPrecomputedNlp() == null ? this.parse(query) : this.evaluateEntitiesForPrecomputedNlp(query, this.sentence.getPrecomputedNlp());
                        object = result2;
                        if (object == null) break block6;
                        NlpResult nlpResult = object;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        NlpResult nlpResult2 = nlpResult;
                        boolean bl8 = false;
                        this.listenNlpSuccessCall(query, nlpResult2);
                        Intent intent3 = this.findIntent(this.userTimeline, this.dialog, this.sentence, nlpResult2);
                        boolean bl9 = false;
                        List customEntityEvaluations = new ArrayList();
                        BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(customEntityEvaluations, nlpResult2, query, this){
                            final /* synthetic */ List $customEntityEvaluations;
                            final /* synthetic */ NlpResult $nlpResult;
                            final /* synthetic */ NlpQuery $query$inlined;
                            final /* synthetic */ SentenceParser this$0;
                            {
                                this.$customEntityEvaluations = list;
                                this.$nlpResult = nlpResult;
                                this.$query$inlined = nlpQuery;
                                this.this$0 = sentenceParser;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull NlpListener it) {
                                List<EntityValue> list;
                                List list2;
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                List list3 = this.$customEntityEvaluations;
                                try {
                                    list2 = list3;
                                    list = it.evaluateEntities(this.this$0.getUserTimeline(), this.this$0.getDialog(), this.this$0.getSentence(), this.$nlpResult);
                                }
                                catch (Exception exception) {
                                    void e;
                                    list2 = list3;
                                    LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                    list = CollectionsKt.emptyList();
                                }
                                list2.addAll((Collection)list);
                            }
                        }));
                        List entityEvaluations2 = CollectionsKt.plus((Collection)customEntityEvaluations, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)nlpResult2.getEntities()), (Function1)((Function1)new Function1<NlpEntityValue, Boolean>(customEntityEvaluations){
                            final /* synthetic */ List $customEntityEvaluations;

                            public final boolean invoke(@NotNull NlpEntityValue e) {
                                boolean bl;
                                block3: {
                                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                                    Iterable $this$none$iv = this.$customEntityEvaluations;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            EntityValue it = (EntityValue)element$iv;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it.getEntity(), (Object)e.getEntity())) continue;
                                            bl = false;
                                            break block3;
                                        }
                                        bl = true;
                                    }
                                }
                                return bl;
                            }
                            {
                                this.$customEntityEvaluations = list;
                                super(1);
                            }
                        })), (Function1)((Function1)new Function1<NlpEntityValue, EntityValue>(nlpResult2){
                            final /* synthetic */ NlpResult $nlpResult;

                            @NotNull
                            public final EntityValue invoke(@NotNull NlpEntityValue it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return new EntityValue(this.$nlpResult, it);
                            }
                            {
                                this.$nlpResult = nlpResult;
                                super(1);
                            }
                        })));
                        this.sentence.getState().getEntityValues().addAll(entityEvaluations2);
                        Dialog dialog = this.dialog;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        Dialog $this$apply = dialog;
                        boolean bl12 = false;
                        $this$apply.getState().setCurrentIntent(intent3);
                        List<EntityValue> finalEntityValues = this.mergeEntityValuesFromAction($this$apply.getState(), this.sentence);
                        this.sentence.setNlpStats(new NlpCallStats(this.userTimeline.getUserPreferences().getLocale(), intent3, entityEvaluations2, finalEntityValues, query, nlpResult2));
                        Dialog dialog2 = dialog;
                        object = dialog2;
                        if (dialog2 != null) break block7;
                    }
                    this.listenNlpErrorCall(query, this.dialog, null);
                    object = Unit.INSTANCE;
                }
                NlpResult nlpResult = object;
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                this.listenNlpErrorCall(query, this.dialog, t);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Intent findIntent(UserTimeline userTimeline, Dialog dialog, SendSentence sentence, NlpResult nlpResult) {
            void i;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)i, userTimeline, dialog, sentence, nlpResult){
                final /* synthetic */ Ref.ObjectRef $i;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ SendSentence $sentence;
                final /* synthetic */ NlpResult $nlpResult;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if ((Intent)this.$i.element == null) {
                        Intent intent;
                        Ref.ObjectRef objectRef;
                        Ref.ObjectRef objectRef2 = this.$i;
                        try {
                            objectRef = objectRef2;
                            IntentAware intentAware = it.findIntent(this.$userTimeline, this.$dialog, this.$sentence, this.$nlpResult);
                            intent = intentAware != null ? intentAware.wrappedIntent() : null;
                        }
                        catch (Exception exception) {
                            void e;
                            objectRef = objectRef2;
                            LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                            intent = null;
                        }
                        objectRef.element = intent;
                    }
                }
                {
                    this.$i = objectRef;
                    this.$userTimeline = userTimeline;
                    this.$dialog = dialog;
                    this.$sentence = sendSentence;
                    this.$nlpResult = nlpResult;
                    super(1);
                }
            }));
            Intent intent = (Intent)i.element;
            if (intent == null) {
                intent = this.botDefinition.findIntent(nlpResult.getIntent());
            }
            return intent;
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult evaluateEntitiesForPrecomputedNlp(NlpQuery nlpQuery, NlpResult nlpResult) {
            NlpResult nlpResult2;
            evaluateEntitiesForPrecomputedNlp.1 $fun$toEntityToEvaluate$1 = evaluateEntitiesForPrecomputedNlp.1.INSTANCE;
            try {
                NlpResult nlpResult3;
                if (nlpResult.getEntities().isEmpty()) {
                    nlpResult3 = nlpResult;
                } else {
                    Collection<EntityToEvaluate> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Iterable iterable = nlpResult.getEntities();
                    Object object = nlpQuery.getContext();
                    Object object2 = nlpQuery.getApplicationName();
                    String string = nlpQuery.getNamespace();
                    NlpClient nlpClient = this.nlpClient;
                    boolean $i$f$map = false;
                    void var7_11 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        NlpEntityValue nlpEntityValue = (NlpEntityValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        EntityToEvaluate entityToEvaluate = evaluateEntitiesForPrecomputedNlp.1.INSTANCE.invoke((NlpEntityValue)it);
                        collection.add(entityToEvaluate);
                    }
                    String string2 = string;
                    Object object3 = object2;
                    NlpQueryContext nlpQueryContext = object;
                    collection = (List)destination$iv$iv;
                    Collection<EntityToEvaluate> collection2 = collection;
                    String string3 = nlpResult.getRetainedQuery();
                    EntityEvaluationResult result2 = nlpClient.evaluateEntities(new EntityEvaluationQuery(string2, (String)object3, nlpQueryContext, collection2, string3));
                    if (result2 != null) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        $this$map$iv = nlpResult.getEntities();
                        object2 = result2.getValues();
                        string = null;
                        String string4 = null;
                        String string5 = null;
                        nlpClient = nlpResult;
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            boolean bl;
                            block11: {
                                NlpEntityValue e = (NlpEntityValue)element$iv$iv;
                                boolean bl2 = false;
                                Iterable $this$none$iv = result2.getValues();
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        NlpEntityValue it = (NlpEntityValue)element$iv;
                                        boolean bl3 = false;
                                        if (!(it.getStart() == e.getStart())) continue;
                                        bl = false;
                                        break block11;
                                    }
                                    bl = true;
                                }
                            }
                            if (!bl) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                        nlpResult3 = NlpResult.copy$default((NlpResult)nlpClient, string5, string4, (Locale)((Object)string), (List)CollectionsKt.plus((Collection)object2, (Iterable)((Iterable)object)), null, (double)0.0, (double)0.0, null, null, null, (int)1015, null);
                    } else {
                        nlpResult3 = nlpResult;
                    }
                }
                nlpResult2 = nlpResult3;
            }
            catch (Exception exception) {
                LoggersKt.error((KLogger)logger, (Throwable)exception);
                nlpResult2 = nlpResult;
            }
            return nlpResult2;
        }

        /*
         * WARNING - void declaration
         */
        private final Intent findKeyword(String sentence) {
            Intent intent;
            if (sentence != null) {
                void i;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)i, sentence){
                    final /* synthetic */ Ref.ObjectRef $i;
                    final /* synthetic */ String $sentence;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if ((Intent)this.$i.element == null) {
                            Intent intent;
                            Ref.ObjectRef objectRef;
                            Ref.ObjectRef objectRef2 = this.$i;
                            try {
                                objectRef = objectRef2;
                                intent = it.handleKeyword(this.$sentence);
                            }
                            catch (Exception exception) {
                                void e;
                                objectRef = objectRef2;
                                LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                intent = null;
                            }
                            objectRef.element = intent;
                        }
                    }
                    {
                        this.$i = objectRef;
                        this.$sentence = string;
                        super(1);
                    }
                }));
                intent = (Intent)i.element;
            } else {
                intent = null;
            }
            return intent;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result2) {
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(query, result2){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ NlpResult $result;

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    try {
                        it.success(this.$query, this.$result);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
                {
                    this.$query = nlpQuery;
                    this.$result = nlpResult;
                    super(1);
                }
            }));
        }

        private final void listenNlpErrorCall(NlpQuery query, Dialog dialog, Throwable throwable) {
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(query, dialog, throwable){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ Throwable $throwable;

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    try {
                        it.error(this.$query, this.$dialog, this.$throwable);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
                {
                    this.$query = nlpQuery;
                    this.$dialog = dialog;
                    this.$throwable = throwable;
                    super(1);
                }
            }));
        }

        private final NlpQueryContext toQueryContext() {
            Object object;
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            Object object2 = this.dialog.getState().getNextActionState();
            if (object2 == null || (object2 = ((NextUserActionState)object2).getReferenceDate()) == null) {
                ZonedDateTime zonedDateTime = ZonedDateTime.now(DatesKt.getDefaultZoneId());
                object2 = zonedDateTime;
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.now(defaultZoneId)");
            }
            if ((object = this.dialog.getState().getNextActionState()) == null || (object = ((NextUserActionState)object).getReferenceTimezone()) == null) {
                object = DatesKt.getDefaultZoneId();
            }
            return new NlpQueryContext(locale, string, string2, string3, (ZonedDateTime)object2, (ZoneId)object, test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            String string = this.sentence.getStringText();
            if (string == null) {
                string = "";
            }
            List list = CollectionsKt.listOf((Object)string);
            String string2 = this.botDefinition.getNamespace();
            String string3 = this.botDefinition.getNlpModelName();
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = ((NextUserActionState)object).getStates()) == null) {
                Object object2 = this.dialog.getCurrentStory();
                object = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull(object2 != null && (object2 = ((Story)object2).getDefinition()) != null && (object2 = object2.mainIntent()) != null ? ((Intent)object2).getName() : null));
            }
            return new NlpQuery(list, string2, string3, nlpQueryContext, new NlpQueryState((Set)object), null, 32, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final EntityStateValue mergeEntityValues(Action action, List<EntityValue> newValues, EntityStateValue oldValue) {
            Object result2;
            Object object;
            List eligibleToMergeValues;
            EntityValue defaultNewValue;
            Entity entity;
            block10: {
                Object $this$apply;
                boolean bl;
                block9: {
                    EntityValue entityValue2;
                    Object v0;
                    block8: {
                        entity = ((EntityValue)CollectionsKt.first(newValues)).getEntity();
                        Iterable $this$firstOrNull$iv = newValues;
                        boolean $i$f$firstOrNull = false;
                        for (Object t : $this$firstOrNull$iv) {
                            EntityValue it = (EntityValue)t;
                            boolean bl2 = false;
                            if (!(it.getValue() != null)) continue;
                            v0 = t;
                            break block8;
                        }
                        v0 = null;
                    }
                    if ((entityValue2 = (EntityValue)v0) == null) {
                        entityValue2 = (EntityValue)CollectionsKt.first(newValues);
                    }
                    defaultNewValue = entityValue2;
                    Object $this$filter$iv = newValues;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : iterable) {
                        EntityValue it = (EntityValue)element$iv$iv;
                        boolean bl3 = false;
                        if (!(it.getMergeSupport() && it.getValue() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    eligibleToMergeValues = (List)destination$iv$iv;
                    if (oldValue == null) {
                        if (eligibleToMergeValues.size() < 2) {
                            $this$filter$iv = new EntityStateValue(action, defaultNewValue);
                            bl = false;
                            boolean bl4 = false;
                            $this$apply = $this$filter$iv;
                            boolean bl5 = false;
                            ((EntityStateValue)$this$apply).setMultiRequestedValues$tock_bot_engine(newValues);
                            object = $this$filter$iv;
                            return object;
                        }
                        result2 = SentenceParser.mergeValues$default(this, entity, eligibleToMergeValues, defaultNewValue, null, 8, null);
                        object = new EntityStateValue(action, (EntityValue)result2);
                        return object;
                    }
                    if (eligibleToMergeValues.isEmpty()) break block9;
                    if (eligibleToMergeValues.size() != 1) break block10;
                    EntityValue entityValue3 = oldValue.getValue();
                    if ((entityValue3 != null ? entityValue3.getValue() : null) != null) break block10;
                }
                result2 = oldValue.changeValue$tock_bot_engine(defaultNewValue, action);
                bl = false;
                boolean bl6 = false;
                $this$apply = result2;
                boolean bl7 = false;
                ((EntityStateValue)$this$apply).setMultiRequestedValues$tock_bot_engine(newValues);
                object = result2;
                return object;
            }
            result2 = this.mergeValues(entity, eligibleToMergeValues, defaultNewValue, oldValue);
            object = oldValue.changeValue$tock_bot_engine((EntityValue)result2, action);
            return object;
        }

        static /* synthetic */ EntityStateValue mergeEntityValues$default(SentenceParser sentenceParser, Action action, List list, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 4) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeEntityValues(action, list, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final EntityValue mergeValues(Entity entity, List<EntityValue> newValues, EntityValue defaultNewValue, EntityStateValue initialValue) {
            ValuesMergeResult result2;
            ValueToMerge valueToMerge;
            ValueToMerge valueToMerge2;
            Collection<ValueToMerge> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = newValues;
            Entity entity2 = entity;
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            String string = this.botDefinition.getNlpModelName();
            String string2 = this.botDefinition.getNamespace();
            NlpClient nlpClient = this.nlpClient;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityValue entityValue2 = (EntityValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Value value = it.getValue();
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                valueToMerge2 = new ValueToMerge(value, it.getContent(), false, it.getStart(), it.getProbability());
                collection.add(valueToMerge2);
            }
            collection = (List)destination$iv$iv;
            NlpClient nlpClient2 = nlpClient;
            String string3 = string2;
            String string4 = string;
            NlpQueryContext nlpQueryContext2 = nlpQueryContext;
            Entity entity3 = entity2;
            Collection<ValueToMerge> collection2 = collection;
            Object object2 = initialValue;
            if (object2 != null && (object2 = ((EntityStateValue)object2).getValue()) != null) {
                ValueToMerge valueToMerge3;
                object = object2;
                collection = collection2;
                entity2 = entity3;
                nlpQueryContext = nlpQueryContext2;
                string = string4;
                string2 = string3;
                nlpClient = nlpClient2;
                boolean bl = false;
                boolean bl2 = false;
                Object value = object;
                boolean bl3 = false;
                Value value2 = ((EntityValue)value).getValue();
                if (value2 != null) {
                    Value value3 = value2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Value it = value3;
                    boolean bl6 = false;
                    valueToMerge3 = new ValueToMerge(it, ((EntityValue)value).getContent(), true, null, 0.0, 24, null);
                } else {
                    valueToMerge3 = null;
                }
                valueToMerge2 = valueToMerge3;
                nlpClient2 = nlpClient;
                string3 = string2;
                string4 = string;
                nlpQueryContext2 = nlpQueryContext;
                entity3 = entity2;
                collection2 = collection;
                valueToMerge = valueToMerge2;
            } else {
                valueToMerge = null;
            }
            List list = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOfNotNull(valueToMerge));
            Entity entity4 = entity3;
            NlpQueryContext nlpQueryContext3 = nlpQueryContext2;
            String string5 = string4;
            String string6 = string3;
            ValuesMergeResult valuesMergeResult = result2 = nlpClient2.mergeValues(new ValuesMergeQuery(string6, string5, nlpQueryContext3, entity4, list));
            return (valuesMergeResult != null ? valuesMergeResult.getValue() : null) == null ? defaultNewValue : new EntityValue(entity, result2.getValue(), result2.getContent());
        }

        static /* synthetic */ EntityValue mergeValues$default(SentenceParser sentenceParser, Entity entity, List list, EntityValue entityValue2, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 8) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeValues(entity, list, entityValue2, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final List<EntityValue> mergeEntityValuesFromAction(@NotNull DialogState $this$mergeEntityValuesFromAction, Action action) {
            void $this$mapNotNullTo$iv$iv;
            void merge;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Ref.ObjectRef answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            Sequence sequence = CollectionsKt.asSequence((Iterable)action.getState().getEntityValues());
            Ref.ObjectRef objectRef2 = objectRef;
            boolean $i$f$groupBy = false;
            void var6_7 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                EntityValue it = (EntityValue)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getEntity().getRole();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Object object = destination$iv$iv;
            $this$groupBy$iv = object;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            boolean element$iv$iv = false;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                void it;
                key$iv$iv = item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                NlpEntityMergeContext nlpEntityMergeContext = new NlpEntityMergeContext((String)it.getKey(), $this$mergeEntityValuesFromAction.getEntityValues().get(it.getKey()), (List)it.getValue());
                object.add(nlpEntityMergeContext);
            }
            objectRef2.element = object = (List)destination$iv$iv;
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)merge){
                final /* synthetic */ Ref.ObjectRef $merge;

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$merge.element = it.sortEntitiesToMerge((List)this.$merge.element);
                }
                {
                    this.$merge = objectRef;
                    super(1);
                }
            }));
            Iterable $this$mapNotNull$iv = (List)merge.element;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                EntityValue entityValue2;
                void context;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                NlpEntityMergeContext mergeContext = (NlpEntityMergeContext)((Object)element$iv$iv2);
                boolean bl3 = false;
                answer$iv$iv$iv = new Ref.ObjectRef();
                answer$iv$iv$iv.element = mergeContext;
                BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef)context, this, $this$mergeEntityValuesFromAction, action){
                    final /* synthetic */ Ref.ObjectRef $context;
                    final /* synthetic */ SentenceParser this$0;
                    final /* synthetic */ DialogState $this_mergeEntityValuesFromAction$inlined;
                    final /* synthetic */ Action $action$inlined;
                    {
                        this.$context = objectRef;
                        this.this$0 = sentenceParser;
                        this.$this_mergeEntityValuesFromAction$inlined = dialogState;
                        this.$action$inlined = action;
                        super(1);
                    }

                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$context.element = it.mergeEntityValues(this.$this_mergeEntityValuesFromAction$inlined, this.$action$inlined, (NlpEntityMergeContext)this.$context.element);
                    }
                }));
                EntityStateValue result2 = this.mergeEntityValues(action, ((NlpEntityMergeContext)context.element).getNewValues(), ((NlpEntityMergeContext)context.element).getInitialValue());
                $this$mergeEntityValuesFromAction.getEntityValues().put(((NlpEntityMergeContext)context.element).getEntityRole(), result2);
                if (result2.getValue() == null) continue;
                boolean bl4 = false;
                boolean bl5 = false;
                EntityValue it$iv$iv = entityValue2;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final NlpResult parse(NlpQuery request) {
            Nlp.access$getLogger$cp().debug((Function0)new Function0<String>(this){
                final /* synthetic */ SentenceParser this$0;

                @NotNull
                public final String invoke() {
                    return "Sending sentence '" + this.this$0.getSentence().getStringText() + "' to NLP";
                }
                {
                    this.this$0 = sentenceParser;
                    super(0);
                }
            });
            v0 = this.dialog.getState().getNextActionState();
            v1 /* !! */  = intentsQualifiers = v0 != null ? v0.getIntentsQualifiers() : null;
            if (intentsQualifiers == null) ** GOTO lbl-1000
            var4_3 = intentsQualifiers;
            var5_4 = false;
            if (var4_3.isEmpty() == false) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = useQualifiers = false;
            }
            if (!useQualifiers) {
                v3 = this.nlpClient.parse(request);
            } else {
                v4 = intentsQualifiers;
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                v3 = result = this.nlpClient.parse(NlpQuery.copy$default((NlpQuery)request, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v4), (Function1)((Function1)new Function1<NlpIntentQualifier, NlpIntentQualifier>(request){
                    final /* synthetic */ NlpQuery $request;

                    @NotNull
                    public final NlpIntentQualifier invoke(@NotNull NlpIntentQualifier it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)this.$request.getNamespace()), (double)0.0, (int)2, null);
                    }
                    {
                        this.$request = nlpQuery;
                        super(1);
                    }
                }))), (int)31, null));
            }
            if (result != null && useQualifiers) {
                block17: {
                    v5 = intentsQualifiers;
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$none$iv = v5;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        v6 = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (NlpIntentQualifier)element$iv;
                            $i$a$-none-Nlp$SentenceParser$parse$5 = false;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result.getIntent())) continue;
                            v6 = false;
                            break block17;
                        }
                        v6 = true;
                    }
                }
                if (v6) {
                    $this$none$iv = intentsQualifiers;
                    var15_16 = result;
                    $i$f$maxBy = false;
                    iterator$iv = $this$maxBy$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v7 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v7 = maxElem$iv;
                        } else {
                            it = (NlpIntentQualifier)maxElem$iv;
                            $i$a$-maxBy-Nlp$SentenceParser$parse$6 = false;
                            maxValue$iv = it.getModifier();
                            do {
                                e$iv = iterator$iv.next();
                                it = (NlpIntentQualifier)e$iv;
                                $i$a$-maxBy-Nlp$SentenceParser$parse$6 = false;
                                v$iv = it.getModifier();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v7 = var16_20 = maxElem$iv;
                        }
                    }
                    if ((v8 /* !! */  = (NlpIntentQualifier)var16_20) == null || (v8 /* !! */  = v8 /* !! */ .getIntent()) == null) {
                        v8 /* !! */  = ((NlpIntentQualifier)CollectionsKt.first(intentsQualifiers)).getIntent();
                    }
                    var5_5 = NlpResult.copy$default((NlpResult)var15_16, (String)v8 /* !! */ , null, null, null, null, (double)0.0, (double)0.0, null, null, null, (int)1022, null);
                    var6_7 = false;
                    var7_9 = false;
                    it = var5_5;
                    $i$a$-also-Nlp$SentenceParser$parse$7 = false;
                    Nlp.access$getLogger$cp().warn((Function0)new Function0<String>(it, result, intentsQualifiers){
                        final /* synthetic */ NlpResult $it;
                        final /* synthetic */ NlpResult $result$inlined;
                        final /* synthetic */ List $intentsQualifiers$inlined;
                        {
                            this.$it = nlpResult;
                            this.$result$inlined = nlpResult2;
                            this.$intentsQualifiers$inlined = list;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$result$inlined.getIntent() + " not in intents qualifier " + this.$intentsQualifiers$inlined + " - use " + this.$it;
                        }
                    });
                    return var5_5;
                }
            }
            return result;
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final TockConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull TockConnectorController connector, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkParameterIsNotNull((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkParameterIsNotNull((Object)sentence, (String)"sentence");
            Intrinsics.checkParameterIsNotNull((Object)userTimeline, (String)"userTimeline");
            Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
            Intrinsics.checkParameterIsNotNull((Object)connector, (String)"connector");
            Intrinsics.checkParameterIsNotNull((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline;
            this.dialog = dialog;
            this.connector = connector;
            this.botDefinition = botDefinition;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/engine/nlp/Nlp$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

