/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector;

import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorCallbackBase;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/tock/bot/connector/ConnectorCallbackBase;", "Lai/tock/bot/connector/ConnectorCallback;", "applicationId", "", "connectorType", "Lai/tock/bot/connector/ConnectorType;", "(Ljava/lang/String;Lai/tock/bot/connector/ConnectorType;)V", "getApplicationId", "()Ljava/lang/String;", "getConnectorType", "()Lai/tock/bot/connector/ConnectorType;", "lockTimerData", "Lai/tock/bot/engine/monitoring/RequestTimerData;", "requestTimerData", "eventAnswered", "", "event", "Lai/tock/bot/engine/event/Event;", "eventSkipped", "exceptionThrown", "throwable", "", "userLockReleased", "userLocked", "Companion", "tock-bot-engine"})
public class ConnectorCallbackBase
implements ConnectorCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final ConnectorType connectorType;
    @NotNull
    private final RequestTimerData requestTimerData;
    @Nullable
    private RequestTimerData lockTimerData;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public ConnectorCallbackBase(@NotNull String applicationId, @NotNull ConnectorType connectorType) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)connectorType, (String)"connectorType");
        this.applicationId = applicationId;
        this.connectorType = connectorType;
        this.requestTimerData = BotRepository.INSTANCE.getRequestTimer().start(this.connectorType.getId() + "_response");
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final ConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Override
    public void userLocked(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.lockTimerData = BotRepository.INSTANCE.getRequestTimer().start(this.connectorType.getId() + "_user_lock");
    }

    @Override
    public void userLockReleased(@NotNull Event event) {
        block0: {
            RequestTimerData requestTimerData;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            logger.trace((Function0)new Function0<Object>(event){
                final /* synthetic */ Event $event;
                {
                    this.$event = $event;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "lock released for " + this.$event;
                }
            });
            RequestTimerData requestTimerData2 = this.lockTimerData;
            if (requestTimerData2 == null) break block0;
            RequestTimerData it = requestTimerData = requestTimerData2;
            boolean bl = false;
            BotRepository.INSTANCE.getRequestTimer().end(it);
        }
    }

    @Override
    public void eventSkipped(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.warn((Function0)new Function0<Object>(event){
            final /* synthetic */ Event $event;
            {
                this.$event = $event;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "event skipped: " + this.$event;
            }
        });
        BotRepository.INSTANCE.getRequestTimer().error("event skipped: " + event, this.requestTimerData);
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    @Override
    public void eventAnswered(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.trace((Function0)new Function0<Object>(event){
            final /* synthetic */ Event $event;
            {
                this.$event = $event;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "event answered: " + this.$event;
            }
        });
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    @Override
    public void exceptionThrown(@NotNull Event event, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        logger.error("error thown for " + event, throwable);
        BotRepository.INSTANCE.getRequestTimer().throwable(throwable, this.requestTimerData);
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/connector/ConnectorCallbackBase$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

