/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine;

import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.BotVerticle;
import ai.tock.bot.engine.WebSocketController;
import ai.tock.bot.engine.config.UploadedFilesService;
import ai.tock.bot.engine.nlp.NlpProxyBotService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.auth.TockAuthProvider;
import ai.tock.shared.vertx.DetailedHealthcheckKt;
import ai.tock.shared.vertx.WebVerticle;
import ai.tock.translator.Translator;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!H\u0014J(\u0010\"\u001a\u00060\u000fR\u00020\u00002\u0006\u0010#\u001a\u00020\u00072\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010&0\u001cJ\u001e\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0014J\u0012\u0010-\u001a\u00020\u001a2\n\u0010$\u001a\u00060\u000fR\u00020\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u000fR\u00020\u00000\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lai/tock/bot/engine/BotVerticle;", "Lai/tock/shared/vertx/WebVerticle;", "nlpProxyOnBot", "", "serveUploadedFiles", "(ZZ)V", "defaultCorsOrigin", "", "getDefaultCorsOrigin", "()Ljava/lang/String;", "defaultCorsWithCredentials", "getDefaultCorsWithCredentials", "()Z", "handlers", "", "Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "initialized", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "secondaryInstallers", "", "authProvider", "Lai/tock/shared/security/auth/TockAuthProvider;", "configure", "", "defaultHealthcheck", "Lkotlin/Function1;", "Lio/vertx/ext/web/RoutingContext;", "detailedHealthcheck", "install", "protectedPaths", "", "registerServices", "serviceIdentifier", "installer", "Lio/vertx/ext/web/Router;", "", "startServer", "promise", "Lio/vertx/core/Promise;", "Ljava/lang/Void;", "port", "", "unregisterServices", "ServiceInstaller", "tock-bot-engine"})
public final class BotVerticle
extends WebVerticle {
    private final boolean nlpProxyOnBot;
    private final boolean serveUploadedFiles;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Map<String, ServiceInstaller> handlers;
    @NotNull
    private final Set<ServiceInstaller> secondaryInstallers;
    private boolean initialized;
    @NotNull
    private final String defaultCorsOrigin;
    private final boolean defaultCorsWithCredentials;

    public BotVerticle(boolean nlpProxyOnBot, boolean serveUploadedFiles) {
        this.nlpProxyOnBot = nlpProxyOnBot;
        this.serveUploadedFiles = serveUploadedFiles;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.handlers = new ConcurrentHashMap();
        this.secondaryInstallers = new CopyOnWriteArraySet();
        this.defaultCorsOrigin = "*";
    }

    public /* synthetic */ BotVerticle(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_nlp_proxy_on_bot", (boolean)false);
        }
        if ((n & 2) != 0) {
            bl2 = PropertiesKt.booleanProperty((String)"tock_bot_serve_files", (boolean)true);
        }
        this(bl, bl2);
    }

    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected String getDefaultCorsOrigin() {
        return this.defaultCorsOrigin;
    }

    protected boolean getDefaultCorsWithCredentials() {
        return this.defaultCorsWithCredentials;
    }

    @Nullable
    protected TockAuthProvider authProvider() {
        return this.defaultAuthProvider();
    }

    @NotNull
    public final ServiceInstaller registerServices(@NotNull String serviceIdentifier, @NotNull Function1<? super Router, ? extends Object> installer) {
        ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)serviceIdentifier, (String)"serviceIdentifier");
        Intrinsics.checkNotNullParameter(installer, (String)"installer");
        ServiceInstaller it = serviceInstaller = new ServiceInstaller(this, serviceIdentifier, installer, null, false, null, 28, null);
        boolean bl = false;
        if (!this.handlers.containsKey(serviceIdentifier)) {
            this.handlers.put(serviceIdentifier, it);
        } else {
            this.getLogger().debug("service " + serviceIdentifier + " already registered - skip it for now");
            this.secondaryInstallers.add(it);
        }
        return serviceInstaller;
    }

    public final void unregisterServices(@NotNull ServiceInstaller installer) {
        ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        if (this.secondaryInstallers.contains(installer)) {
            this.secondaryInstallers.remove(installer);
        }
        if (Intrinsics.areEqual((Object)this.handlers.get(installer.getServiceId()), (Object)installer) && (serviceInstaller = this.handlers.remove(installer.getServiceId())) != null) {
            Object v0;
            ServiceInstaller it;
            block4: {
                it = serviceInstaller;
                boolean bl = false;
                Iterable iterable = this.secondaryInstallers;
                for (Object t : iterable) {
                    ServiceInstaller it2 = (ServiceInstaller)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getServiceId(), (Object)installer.getServiceId())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            ServiceInstaller s = v0;
            this.getLogger().debug((Function0)new Function0<Object>(it){
                final /* synthetic */ ServiceInstaller $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "remove service " + this.$it.getServiceId();
                }
            });
            it.uninstall();
            if (s != null) {
                s.install();
                this.secondaryInstallers.remove(s);
                this.handlers.put(it.getServiceId(), s);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<String> protectedPaths() {
        void $this$mapTo$iv$iv;
        String path = PropertiesKt.property((String)"tock_bot_protected_path", (String)"/admin");
        List paths = PropertiesKt.listProperty$default((String)"tock_bot_protected_paths", (List)CollectionsKt.listOf((Object)"/admin"), null, (int)4, null);
        Iterable $this$map$iv = CollectionsKt.plus((Collection)paths, (Object)path);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public synchronized void configure() {
        if (!this.initialized) {
            this.initialized = true;
            EncryptorsKt.initEncryptor();
            Translator.INSTANCE.initTranslator();
            if (this.nlpProxyOnBot) {
                Vertx vertx = ((AbstractVerticle)this).vertx;
                Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                this.registerServices("nlp_proxy_bot", NlpProxyBotService.INSTANCE.configure(vertx));
            }
            if (this.serveUploadedFiles) {
                this.registerServices("serve_files", UploadedFilesService.INSTANCE.configure$tock_bot_engine());
            }
        }
        this.install();
    }

    private final void install() {
        Object it;
        boolean bl;
        block5: {
            Map<String, ServiceInstaller> $this$any$iv = this.handlers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry<String, ServiceInstaller> element$iv : $this$any$iv.entrySet()) {
                    it = element$iv;
                    boolean bl2 = false;
                    if (!(!it.getValue().getInstalled())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.getLogger().info((Function0)new Function0<Object>(this){
                final /* synthetic */ BotVerticle this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Install Bot Services / " + BotVerticle.access$getHandlers$p(this.this$0).size() + " registered";
                }
            });
            Iterable $this$sortedBy$iv = this.handlers.values();
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ServiceInstaller it = (ServiceInstaller)a;
                    boolean bl = false;
                    Comparable comparable = it.getRegistrationDate();
                    it = (ServiceInstaller)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getRegistrationDate());
                }
            });
            boolean $i$f$forEach = false;
            for (Map.Entry<String, ServiceInstaller> element$iv : $this$forEach$iv) {
                it = (ServiceInstaller)((Object)element$iv);
                boolean bl3 = false;
                ((ServiceInstaller)it).install();
            }
        }
    }

    @NotNull
    public Function1<RoutingContext, Unit> defaultHealthcheck() {
        return BotRepository.INSTANCE.getHealthcheckHandler();
    }

    @NotNull
    public Function1<RoutingContext, Unit> detailedHealthcheck() {
        return DetailedHealthcheckKt.detailedHealthcheck((List)CollectionsKt.listOf((Object)new Pair((Object)"nlp_client", (Object)detailedHealthcheck.1.INSTANCE)), (Function0)detailedHealthcheck.2.INSTANCE);
    }

    protected void startServer(@NotNull Promise<Void> promise, int port) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (WebSocketController.INSTANCE.getWebsocketEnabled()) {
            this.getLogger().info((Function0)startServer.1.INSTANCE);
            this.getServer().webSocketHandler(arg_0 -> BotVerticle.startServer$lambda$10(this, arg_0));
        }
        super.startServer(promise, port);
    }

    private static final void startServer$lambda$10$lambda$8(BotVerticle this$0, String $key, String json) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            this$0.getLogger().debug((Function0)new Function0<Object>(json){
                final /* synthetic */ String $json;
                {
                    this.$json = $json;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "receive " + this.$json;
                }
            });
            Function1<String, Unit> function1 = WebSocketController.INSTANCE.getReceiveHandler($key);
            if (function1 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
                function1.invoke((Object)json);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.getLogger(), (Throwable)e);
        }
    }

    private static final void startServer$lambda$10$lambda$9(String $key, Void it) {
        WebSocketController.INSTANCE.removePushHandler$tock_bot_engine($key);
    }

    private static final void startServer$lambda$10(BotVerticle this$0, ServerWebSocket context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            String key2;
            String string;
            String it = context.path();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
                String string2 = it.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            if (WebSocketController.INSTANCE.isAuthorizedKey$tock_bot_engine(key2 = string)) {
                this$0.getLogger().info((Function0)new Function0<Object>(context){
                    final /* synthetic */ ServerWebSocket $context;
                    {
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Install WebSocket push handler for " + this.$context.path();
                    }
                });
                String string3 = key2;
                Intrinsics.checkNotNull((Object)string3);
                WebSocketController.INSTANCE.setPushHandler$tock_bot_engine(string3, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this$0, context){
                    final /* synthetic */ BotVerticle this$0;
                    final /* synthetic */ ServerWebSocket $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        try {
                            this.this$0.getLogger().debug((Function0)new Function0<Object>(it){
                                final /* synthetic */ String $it;
                                {
                                    this.$it = $it;
                                    super(0);
                                }

                                @Nullable
                                public final Object invoke() {
                                    return "send: " + this.$it;
                                }
                            });
                            this.$context.writeTextMessage(it);
                        }
                        catch (Exception e) {
                            LoggersKt.error((KLogger)this.this$0.getLogger(), (Throwable)e);
                        }
                    }
                }));
                context.textMessageHandler(arg_0 -> BotVerticle.startServer$lambda$10$lambda$8(this$0, key2, arg_0)).closeHandler(arg_0 -> BotVerticle.startServer$lambda$10$lambda$9(key2, arg_0));
            } else {
                this$0.getLogger().warn((Function0)new Function0<Object>(key2){
                    final /* synthetic */ String $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "unknown key: " + this.$key;
                    }
                });
                context.reject();
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.getLogger(), (Throwable)e);
        }
    }

    public BotVerticle() {
        this(false, false, 3, null);
    }

    public static final /* synthetic */ Map access$getHandlers$p(BotVerticle $this) {
        return $this.handlers;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "", "serviceId", "", "installer", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "routes", "", "Lio/vertx/ext/web/Route;", "installed", "", "registrationDate", "Ljava/time/Instant;", "(Lai/tock/bot/engine/BotVerticle;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/util/List;ZLjava/time/Instant;)V", "getInstalled", "()Z", "setInstalled", "(Z)V", "getRegistrationDate", "()Ljava/time/Instant;", "getRoutes", "()Ljava/util/List;", "setRoutes", "(Ljava/util/List;)V", "getServiceId", "()Ljava/lang/String;", "install", "", "uninstall", "tock-bot-engine"})
    public final class ServiceInstaller {
        @NotNull
        private final String serviceId;
        @NotNull
        private final Function1<Router, Object> installer;
        @NotNull
        private List<Route> routes;
        private volatile boolean installed;
        @NotNull
        private final Instant registrationDate;
        final /* synthetic */ BotVerticle this$0;

        public ServiceInstaller(@NotNull BotVerticle this$0, @NotNull String serviceId, @NotNull Function1<? super Router, ? extends Object> installer, List<Route> routes, @NotNull boolean installed, Instant registrationDate) {
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            Intrinsics.checkNotNullParameter(installer, (String)"installer");
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            Intrinsics.checkNotNullParameter((Object)registrationDate, (String)"registrationDate");
            this.this$0 = this$0;
            this.serviceId = serviceId;
            this.installer = installer;
            this.routes = routes;
            this.installed = installed;
            this.registrationDate = registrationDate;
        }

        public /* synthetic */ ServiceInstaller(BotVerticle botVerticle, String string, Function1 function1, List list, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = new CopyOnWriteArrayList();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
                instant = instant2;
            }
            this(botVerticle, string, (Function1<? super Router, ? extends Object>)function1, list, bl, instant);
        }

        @NotNull
        public final String getServiceId() {
            return this.serviceId;
        }

        @NotNull
        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final void setRoutes(@NotNull List<Route> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.routes = list;
        }

        public final boolean getInstalled() {
            return this.installed;
        }

        public final void setInstalled(boolean bl) {
            this.installed = bl;
        }

        @NotNull
        public final Instant getRegistrationDate() {
            return this.registrationDate;
        }

        public final void install() {
            if (!this.installed) {
                this.installed = true;
                try {
                    this.this$0.getLogger().debug("install " + this.serviceId);
                    List registeredRoutes = this.this$0.getRouter().getRoutes();
                    this.installer.invoke((Object)this.this$0.getRouter());
                    List list = this.this$0.getRouter().getRoutes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"router.routes");
                    Iterable iterable = list;
                    Intrinsics.checkNotNullExpressionValue((Object)registeredRoutes, (String)"registeredRoutes");
                    this.routes.addAll(CollectionsKt.subtract((Iterable)iterable, (Iterable)registeredRoutes));
                }
                catch (Exception e) {
                    LoggersKt.error((KLogger)this.this$0.getLogger(), (Throwable)e);
                }
            }
        }

        public final void uninstall() {
            Iterable $this$forEach$iv = this.routes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Route it = (Route)element$iv;
                boolean bl = false;
                it.remove();
            }
        }
    }
}

