/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.connector.Connector;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorConfiguration;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.definition.StoryDefinition;
import ai.tock.bot.definition.StoryHandlerDefinition;
import ai.tock.bot.definition.StoryStep;
import ai.tock.bot.engine.Bot;
import ai.tock.bot.engine.BotVerticle;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.ActionNotificationType;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.MetadataEvent;
import ai.tock.bot.engine.event.TypingOnEvent;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.UserLock;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.bot.engine.user.UserTimelineDAO;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.stt.STT;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 R2\u00020\u0001:\u0001RB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00102\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00100\u001a\u000201H\u0002J\u0018\u00107\u001a\u0004\u0018\u0001082\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u0004\u0018\u0001082\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020:J$\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020+2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020-0?H\u0016J/\u0010A\u001a\u00020-2\u0006\u00100\u001a\u0002012\u0006\u0010B\u001a\u0002042\u0006\u00103\u001a\u0002042\b\b\u0002\u0010C\u001a\u00020DH\u0000\u00a2\u0006\u0002\bEJ\u001e\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020+2\u0006\u00100\u001a\u000201J\u0016\u0010J\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00100\u001a\u000201J\u0018\u0010K\u001a\u00020L2\u0006\u00103\u001a\u0002042\u0006\u00100\u001a\u000201H\u0016J\b\u0010M\u001a\u00020+H\u0016J\u0018\u0010N\u001a\u0002042\u0006\u00103\u001a\u0002042\u0006\u0010O\u001a\u00020PH\u0002J\b\u0010Q\u001a\u00020-H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u001fR\u00020\u00070\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001c\u001a\u0004\b\"\u0010#R\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001c\u001a\u0004\b'\u0010(R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lai/tock/bot/engine/TockConnectorController;", "Lai/tock/bot/engine/ConnectorController;", "bot", "Lai/tock/bot/engine/Bot;", "connector", "Lai/tock/bot/connector/Connector;", "verticle", "Lai/tock/bot/engine/BotVerticle;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "configuration", "Lai/tock/bot/connector/ConnectorConfiguration;", "(Lai/tock/bot/engine/Bot;Lai/tock/bot/connector/Connector;Lai/tock/bot/engine/BotVerticle;Lai/tock/bot/definition/BotDefinition;Lai/tock/bot/connector/ConnectorConfiguration;)V", "getBot", "()Lai/tock/bot/engine/Bot;", "botConfiguration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "getBotConfiguration", "()Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "getConnector", "()Lai/tock/bot/connector/Connector;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "serviceInstallers", "", "Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "userLock", "Lai/tock/bot/engine/user/UserLock;", "getUserLock", "()Lai/tock/bot/engine/user/UserLock;", "userLock$delegate", "userTimelineDAO", "Lai/tock/bot/engine/user/UserTimelineDAO;", "getUserTimelineDAO", "()Lai/tock/bot/engine/user/UserTimelineDAO;", "userTimelineDAO$delegate", "getBaseUrl", "", "handle", "", "event", "Lai/tock/bot/engine/event/Event;", "data", "Lai/tock/bot/connector/ConnectorData;", "handleAction", "action", "Lai/tock/bot/engine/action/Action;", "nbAttempts", "", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "refreshProfile", "registerServices", "serviceIdentifier", "installer", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "send", "userAction", "delay", "", "send$tock_bot_engine", "sendIntent", "intent", "Lai/tock/bot/definition/Intent;", "applicationId", "startTypingInAnswerTo", "support", "", "toString", "tryToParseVoiceAudio", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "unregisterServices", "Companion", "tock-bot-engine"})
public final class TockConnectorController
implements ConnectorController {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Bot bot;
    @NotNull
    private final Connector connector;
    @NotNull
    private final BotVerticle verticle;
    @NotNull
    private final BotDefinition botDefinition;
    @NotNull
    private final ConnectorConfiguration configuration;
    @NotNull
    private final BotApplicationConfiguration botConfiguration;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private final InjectedProperty userLock$delegate;
    @NotNull
    private final InjectedProperty userTimelineDAO$delegate;
    @NotNull
    private final List<BotVerticle.ServiceInstaller> serviceInstallers;
    @NotNull
    private static final KLogger logger;
    private static final int maxLockedAttempts;
    private static final long lockedAttemptsWaitInMs;
    private static final boolean parseAudioFileEnabled;
    private static final int audioNlpFileLimit;

    public TockConnectorController(@NotNull Bot bot2, @NotNull Connector connector, @NotNull BotVerticle verticle2, @NotNull BotDefinition botDefinition, @NotNull ConnectorConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)bot2, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)((Object)verticle2), (String)"verticle");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.bot = bot2;
        this.connector = connector;
        this.verticle = verticle2;
        this.botDefinition = botDefinition;
        this.configuration = configuration;
        this.botConfiguration = this.bot.getConfiguration();
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        this.userLock$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<UserLock>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        this.userTimelineDAO$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<UserTimelineDAO>(){}, tag$iv);
        this.serviceInstallers = new CopyOnWriteArrayList();
    }

    @NotNull
    public final Bot getBot() {
        return this.bot;
    }

    @Override
    @NotNull
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    @NotNull
    public BotDefinition getBotDefinition() {
        return this.botDefinition;
    }

    @Override
    @NotNull
    public BotApplicationConfiguration getBotConfiguration() {
        return this.botConfiguration;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final UserLock getUserLock() {
        return (UserLock)this.userLock$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final UserTimelineDAO getUserTimelineDAO() {
        return (UserTimelineDAO)this.userTimelineDAO$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.configuration.getBaseUrl();
    }

    @Override
    public void handle(@NotNull Event event, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (event.getState().getTargetConnectorType() == null) {
            event.getState().setTargetConnectorType(this.getConnector().getConnectorType());
        }
        ConnectorCallback callback = data.getCallback();
        try {
            if (!this.getBotDefinition().getEventListener().listenEvent(this, data, event)) {
                if (event instanceof Action) {
                    this.handleAction((Action)event, 0, data);
                } else {
                    callback.eventSkipped(event);
                }
            } else {
                callback.eventAnswered(event);
            }
        }
        catch (Throwable t) {
            callback.exceptionThrown(event, t);
        }
    }

    private final Action tryToParseVoiceAudio(Action action, UserTimeline userTimeline) {
        byte[] bytes;
        if (parseAudioFileEnabled && action instanceof SendAttachment && ((SendAttachment)action).getType() == SendAttachment.AttachmentType.audio && (bytes = TextStreamsKt.readBytes((URL)new URL(((SendAttachment)action).getUrl()))).length < audioNlpFileLimit) {
            KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
            Object tag$iv = null;
            boolean $i$f$provide = false;
            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
            STT stt = (STT)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<STT>(){}, tag$iv).getValue()).invoke();
            String text = stt.parse(bytes, userTimeline.getUserPreferences().getLocale());
            if (text != null) {
                return new SendSentence(action.getPlayerId(), action.getApplicationId(), action.getRecipientId(), text, null, null, null, null, null, null, null, 2032, null);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAction(Action action, int nbAttempts, ConnectorData data) {
        block11: {
            ConnectorCallback callback = data.getCallback();
            try {
                PlayerId playerId = action.getPlayerId();
                String id = playerId.getId();
                logger.debug((Function0)new Function0<Object>(playerId){
                    final /* synthetic */ PlayerId $playerId;
                    {
                        this.$playerId = $playerId;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "try to lock " + this.$playerId;
                    }
                });
                if (this.getUserLock().lock(id)) {
                    try {
                        callback.userLocked(action);
                        UserTimeline userTimeline = this.getUserTimelineDAO().loadWithLastValidDialog(this.getBotDefinition().getNamespace(), action.getPlayerId(), data.getPriorUserId(), data.getGroupId(), this.storyDefinitionLoader(action.getApplicationId()));
                        Action transformedAction = this.tryToParseVoiceAudio(action, userTimeline);
                        this.bot.handle(transformedAction, userTimeline, this, data);
                        if (data.getSaveTimeline()) {
                            this.getUserTimelineDAO().save(userTimeline, this.bot.getBotDefinition());
                        }
                        break block11;
                    }
                    catch (Throwable t) {
                        TockConnectorController.send$tock_bot_engine$default(this, data, action, this.errorMessage(action.getRecipientId(), action.getApplicationId(), action.getPlayerId()), 0L, 8, null);
                        callback.exceptionThrown(action, t);
                        break block11;
                    }
                    finally {
                        this.getUserLock().releaseLock(id);
                        callback.userLockReleased(action);
                    }
                }
                if (nbAttempts < maxLockedAttempts) {
                    logger.debug((Function0)new Function0<Object>(playerId){
                        final /* synthetic */ PlayerId $playerId;
                        {
                            this.$playerId = $playerId;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$playerId + " locked - wait";
                        }
                    });
                    Executor executor = this.getExecutor();
                    Duration duration = Duration.ofMillis(lockedAttemptsWaitInMs);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(lockedAttemptsWaitInMs)");
                    executor.executeBlocking(duration, (Function0)new Function0<Unit>(this, action, nbAttempts, data){
                        final /* synthetic */ TockConnectorController this$0;
                        final /* synthetic */ Action $action;
                        final /* synthetic */ int $nbAttempts;
                        final /* synthetic */ ConnectorData $data;
                        {
                            this.this$0 = $receiver;
                            this.$action = $action;
                            this.$nbAttempts = $nbAttempts;
                            this.$data = $data;
                            super(0);
                        }

                        public final void invoke() {
                            TockConnectorController.access$handleAction(this.this$0, this.$action, this.$nbAttempts + 1, this.$data);
                        }
                    });
                } else {
                    logger.debug((Function0)new Function0<Object>(playerId, action){
                        final /* synthetic */ PlayerId $playerId;
                        final /* synthetic */ Action $action;
                        {
                            this.$playerId = $playerId;
                            this.$action = $action;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$playerId + " locked for " + TockConnectorController.access$getMaxLockedAttempts$cp() + " times - skip " + this.$action;
                        }
                    });
                    callback.eventSkipped(action);
                }
            }
            catch (Throwable t) {
                callback.exceptionThrown(action, t);
            }
        }
    }

    @Override
    public double support(@NotNull Action action, @NotNull ConnectorData data) {
        double d;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (action.getState().getTargetConnectorType() == null) {
            action.getState().setTargetConnectorType(this.getConnector().getConnectorType());
        }
        ConnectorCallback callback = data.getCallback();
        try {
            UserTimeline userTimeline = this.getUserTimelineDAO().loadWithLastValidDialog(this.getBotDefinition().getNamespace(), action.getPlayerId(), data.getPriorUserId(), data.getGroupId(), this.storyDefinitionLoader(action.getApplicationId()));
            d = this.bot.support(action, userTimeline, this, data);
        }
        catch (Throwable t) {
            callback.exceptionThrown(action, t);
            d = 0.0;
        }
        return d;
    }

    @Override
    public void registerServices(@NotNull String serviceIdentifier, @NotNull Function1<? super Router, Unit> installer) {
        BotVerticle.ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)serviceIdentifier, (String)"serviceIdentifier");
        Intrinsics.checkNotNullParameter(installer, (String)"installer");
        BotVerticle.ServiceInstaller it = serviceInstaller = this.verticle.registerServices(serviceIdentifier, (Function1<? super Router, ? extends Object>)((Function1)new Function1<Router, Unit>(serviceIdentifier, installer){
            final /* synthetic */ String $serviceIdentifier;
            final /* synthetic */ Function1<Router, Unit> $installer;
            {
                this.$serviceIdentifier = $serviceIdentifier;
                this.$installer = $installer;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.get(this.$serviceIdentifier + "/healthcheck").handler(registerServices.1::invoke$lambda$0);
                this.$installer.invoke((Object)router);
            }

            private static final void invoke$lambda$0(RoutingContext it) {
                it.response().end();
            }
        }));
        boolean bl = false;
        this.serviceInstallers.add(it);
    }

    @Override
    public void unregisterServices() {
        Iterable $this$forEach$iv = this.serviceInstallers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BotVerticle.ServiceInstaller it = (BotVerticle.ServiceInstaller)element$iv;
            boolean bl = false;
            this.verticle.unregisterServices(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send$tock_bot_engine(@NotNull ConnectorData data, @NotNull Action userAction, @NotNull Action action, long delay) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)userAction, (String)"userAction");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        try {
            logger.debug((Function0)new Function0<Object>(action){
                final /* synthetic */ Action $action;
                {
                    this.$action = $action;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "message sent to connector: " + this.$action;
                }
            });
            this.getConnector().send(action, data.getCallback(), delay);
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)logger, (Throwable)t);
        }
        finally {
            if (action.getMetadata().getLastAnswer()) {
                data.getCallback().eventAnswered(userAction);
            }
        }
    }

    public static /* synthetic */ void send$tock_bot_engine$default(TockConnectorController tockConnectorController, ConnectorData connectorData, Action action, Action action2, long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        tockConnectorController.send$tock_bot_engine(connectorData, action, action2, l);
    }

    @Nullable
    public final UserPreferences loadProfile(@NotNull ConnectorData data, @NotNull PlayerId playerId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.getConnector().loadProfile(data.getCallback(), playerId);
    }

    @Nullable
    public final UserPreferences refreshProfile(@NotNull ConnectorData data, @NotNull PlayerId playerId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.getConnector().refreshProfile(data.getCallback(), playerId);
    }

    public final void startTypingInAnswerTo(@NotNull Action action, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Connector.DefaultImpls.send$default(this.getConnector(), new TypingOnEvent(action.getPlayerId(), action.getApplicationId()), data.getCallback(), 0L, 4, null);
    }

    public final void sendIntent(@NotNull Intent intent, @NotNull String applicationId, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Connector.DefaultImpls.send$default(this.getConnector(), MetadataEvent.Companion.intent(intent, applicationId), data.getCallback(), 0L, 4, null);
    }

    @NotNull
    public String toString() {
        return this.configuration.toString();
    }

    @Override
    @NotNull
    public ConnectorType getConnectorType() {
        return ConnectorController.DefaultImpls.getConnectorType(this);
    }

    @Override
    public void notify(@NotNull PlayerId recipientId, @NotNull IntentAware intent, @Nullable StoryStep<? extends StoryHandlerDefinition> step, @NotNull Map<String, String> parameters, @Nullable ActionNotificationType notificationType, @NotNull Function1<? super Throwable, Unit> errorListener) {
        ConnectorController.DefaultImpls.notify(this, recipientId, intent, step, parameters, notificationType, errorListener);
    }

    @Override
    @NotNull
    public Action errorMessage(@NotNull PlayerId playerId, @NotNull String applicationId, @NotNull PlayerId recipientId) {
        return ConnectorController.DefaultImpls.errorMessage(this, playerId, applicationId, recipientId);
    }

    @Override
    @NotNull
    public Function1<String, StoryDefinition> storyDefinitionLoader(@NotNull String applicationId) {
        return ConnectorController.DefaultImpls.storyDefinitionLoader(this, applicationId);
    }

    public static final /* synthetic */ void access$handleAction(TockConnectorController $this, Action action, int nbAttempts, ConnectorData data) {
        $this.handleAction(action, nbAttempts, data);
    }

    public static final /* synthetic */ int access$getMaxLockedAttempts$cp() {
        return maxLockedAttempts;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "userLock", "getUserLock()Lai/tock/bot/engine/user/UserLock;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "userTimelineDAO", "getUserTimelineDAO()Lai/tock/bot/engine/user/UserTimelineDAO;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        maxLockedAttempts = PropertiesKt.intProperty((String)"tock_bot_max_locked_attempts", (int)10);
        lockedAttemptsWaitInMs = PropertiesKt.longProperty((String)"tock_bot_locked_attempts_wait_in_ms", (long)500L);
        parseAudioFileEnabled = PropertiesKt.booleanProperty((String)"tock_bot_audio_nlp_enabled", (boolean)true);
        audioNlpFileLimit = PropertiesKt.intProperty((String)"tock_bot_audio_nlp_max_size", (int)0x100000);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/tock/bot/engine/TockConnectorController$Companion;", "", "()V", "audioNlpFileLimit", "", "lockedAttemptsWaitInMs", "", "logger", "Lmu/KLogger;", "maxLockedAttempts", "parseAudioFileEnabled", "", "register", "Lai/tock/bot/engine/TockConnectorController;", "connector", "Lai/tock/bot/connector/Connector;", "bot", "Lai/tock/bot/engine/Bot;", "verticle", "Lai/tock/bot/engine/BotVerticle;", "configuration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "register$tock_bot_engine", "unregister", "", "controller", "unregister$tock_bot_engine", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TockConnectorController register$tock_bot_engine(@NotNull Connector connector, @NotNull Bot bot2, @NotNull BotVerticle verticle2, @NotNull BotApplicationConfiguration configuration) {
            TockConnectorController tockConnectorController;
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)bot2, (String)"bot");
            Intrinsics.checkNotNullParameter((Object)((Object)verticle2), (String)"verticle");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            TockConnectorController $this$register_u24lambda_u240 = tockConnectorController = new TockConnectorController(bot2, connector, verticle2, bot2.getBotDefinition(), new ConnectorConfiguration(configuration));
            boolean bl = false;
            logger.info((Function0)new Function0<Object>(connector, bot2){
                final /* synthetic */ Connector $connector;
                final /* synthetic */ Bot $bot;
                {
                    this.$connector = $connector;
                    this.$bot = $bot;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Register connector " + this.$connector + " for bot " + this.$bot;
                }
            });
            connector.register($this$register_u24lambda_u240);
            return tockConnectorController;
        }

        public final void unregister$tock_bot_engine(@NotNull TockConnectorController controller) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            logger.info((Function0)new Function0<Object>(controller){
                final /* synthetic */ TockConnectorController $controller;
                {
                    this.$controller = $controller;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Unregister connector " + this.$controller.getConnector() + " for bot " + this.$controller.getBot();
                }
            });
            controller.getConnector().unregister(controller);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

