/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.bot.engine.nlp.NlpProxyBotService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/tock/bot/engine/nlp/NlpProxyBotService;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "tockNlpProxyOnBotPath", "", "tockNlpServiceHost", "tockNlpServicePort", "", "tockNlpServiceSsl", "", "configure", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "vertx", "Lio/vertx/core/Vertx;", "httpProxyToNlp", "context", "Lio/vertx/ext/web/RoutingContext;", "httpMethod", "Lio/vertx/core/http/HttpMethod;", "tock-bot-engine"})
public final class NlpProxyBotService {
    @NotNull
    public static final NlpProxyBotService INSTANCE = new NlpProxyBotService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final String tockNlpProxyOnBotPath = PropertiesKt.property((String)"tock_nlp_proxy_on_bot_path", (String)"/_proxy_nlp");
    @NotNull
    private static final String tockNlpServiceHost;
    private static final int tockNlpServicePort;
    private static final boolean tockNlpServiceSsl;

    private NlpProxyBotService() {
    }

    @NotNull
    public final KLogger getLogger() {
        return logger;
    }

    @NotNull
    public final Function1<Router, Unit> configure(@NotNull Vertx vertx) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        return (Function1)new Function1<Router, Unit>(vertx){
            final /* synthetic */ Vertx $vertx;
            {
                this.$vertx = $vertx;
                super(1);
            }

            public final void invoke(@NotNull Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.post(NlpProxyBotService.access$getTockNlpProxyOnBotPath$p() + "*").handler(arg_0 -> configure.1.invoke$lambda$0(this.$vertx, arg_0));
                router.get(NlpProxyBotService.access$getTockNlpProxyOnBotPath$p() + "*").handler(arg_0 -> configure.1.invoke$lambda$1(this.$vertx, arg_0));
            }

            private static final void invoke$lambda$0(Vertx $vertx, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)$vertx, (String)"$vertx");
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HttpMethod httpMethod = HttpMethod.POST;
                Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
                NlpProxyBotService.access$httpProxyToNlp(NlpProxyBotService.INSTANCE, context, $vertx, httpMethod);
            }

            private static final void invoke$lambda$1(Vertx $vertx, RoutingContext context) {
                Intrinsics.checkNotNullParameter((Object)$vertx, (String)"$vertx");
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                HttpMethod httpMethod = HttpMethod.GET;
                Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"GET");
                NlpProxyBotService.access$httpProxyToNlp(NlpProxyBotService.INSTANCE, context, $vertx, httpMethod);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void httpProxyToNlp(RoutingContext context, Vertx vertx, HttpMethod httpMethod) {
        try {
            void $this$httpProxyToNlp_u24lambda_u240;
            HttpClientOptions httpClientOptions;
            String string = context.request().uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.request().uri()");
            String uri = StringsKt.substringAfter$default((String)string, (String)tockNlpProxyOnBotPath, null, (int)2, null);
            HttpClientOptions httpClientOptions2 = httpClientOptions = new HttpClientOptions();
            Vertx vertx2 = vertx;
            boolean bl = false;
            $this$httpProxyToNlp_u24lambda_u240.setKeepAlive(false);
            HttpClient httpClient = vertx2.createHttpClient(httpClientOptions);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"vertx.createHttpClient(H\u2026 { isKeepAlive = false })");
            HttpClient client = httpClient;
            RequestOptions options = new RequestOptions().setHost(tockNlpServiceHost).setPort(Integer.valueOf(tockNlpServicePort)).setSsl(Boolean.valueOf(tockNlpServiceSsl)).setURI(uri).setMethod(httpMethod);
            HttpClientRequest cReq = (HttpClientRequest)client.request(options).result();
            cReq.send(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$3(context, arg_0));
            cReq.headers().setAll(context.response().headers().remove("Host").remove("Via").remove("X-Forwarded-For").remove("X-Forwarded-Port").remove("X-Forwarded-Proto").remove("X-Forwarded-Host").remove("X-Forwarded-Server").remove("Accept-Encoding"));
            cReq.end(context.getBody());
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            context.fail(500);
        }
    }

    private static final void httpProxyToNlp$lambda$3$lambda$1(RoutingContext $context, Buffer data) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            $context.response().write((Object)data);
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    private static final void httpProxyToNlp$lambda$3$lambda$2(RoutingContext $context, Void it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            $context.response().end();
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    private static final void httpProxyToNlp$lambda$3(RoutingContext $context, AsyncResult res) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            $context.response().setChunked(true);
            HttpClientResponse cRes = (HttpClientResponse)res.result();
            int resStatusCode = cRes.statusCode();
            if (resStatusCode != 200 && resStatusCode != 201) {
                logger.warn((Function0)new Function0<Object>(resStatusCode){
                    final /* synthetic */ int $resStatusCode;
                    {
                        this.$resStatusCode = $resStatusCode;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "target server status code error : " + this.$resStatusCode;
                    }
                });
            }
            $context.response().setStatusCode(resStatusCode);
            $context.response().headers().setAll(cRes.headers());
            cRes.handler(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$3$lambda$1($context, arg_0));
            cRes.endHandler(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$3$lambda$2($context, arg_0));
        }
        catch (Throwable e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    public static final /* synthetic */ String access$getTockNlpProxyOnBotPath$p() {
        return tockNlpProxyOnBotPath;
    }

    public static final /* synthetic */ void access$httpProxyToNlp(NlpProxyBotService $this, RoutingContext context, Vertx vertx, HttpMethod httpMethod) {
        $this.httpProxyToNlp(context, vertx, httpMethod);
    }

    static {
        String string = System.getenv("tock_nlp_service_url");
        if (string == null) {
            string = "http://localhost:8888";
        }
        URL tocNlpServiceUrl = new URL(string);
        String string2 = System.getenv("tock_nlp_service_host");
        if (string2 == null) {
            String string3 = tocNlpServiceUrl.getHost();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tocNlpServiceUrl.host");
        }
        tockNlpServiceHost = string2;
        String string4 = System.getenv("tock_nlp_service_port");
        tockNlpServicePort = string4 != null ? Integer.parseInt(string4) : tocNlpServiceUrl.getPort();
        String string5 = System.getenv("tock_nlp_service_SSL");
        if (string5 == null) {
            string5 = tocNlpServiceUrl.getProtocol();
        }
        tockNlpServiceSsl = Intrinsics.areEqual((Object)string5, (Object)"https");
    }
}

