/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.user;

import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.engine.user.UserState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\rH\u0016R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lai/tock/bot/engine/user/UserTimeline;", "", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "userPreferences", "Lai/tock/bot/engine/user/UserPreferences;", "userState", "Lai/tock/bot/engine/user/UserState;", "dialogs", "", "Lai/tock/bot/engine/dialog/Dialog;", "temporaryIds", "", "", "(Lai/tock/bot/engine/user/PlayerId;Lai/tock/bot/engine/user/UserPreferences;Lai/tock/bot/engine/user/UserState;Ljava/util/List;Ljava/util/Set;)V", "currentDialog", "getCurrentDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "currentStory", "Lai/tock/bot/engine/dialog/Story;", "getCurrentStory", "()Lai/tock/bot/engine/dialog/Story;", "getDialogs", "()Ljava/util/List;", "lastAction", "Lai/tock/bot/engine/action/Action;", "getLastAction", "()Lai/tock/bot/engine/action/Action;", "lastUserAction", "getLastUserAction", "getPlayerId", "()Lai/tock/bot/engine/user/PlayerId;", "getTemporaryIds", "()Ljava/util/Set;", "getUserPreferences", "()Lai/tock/bot/engine/user/UserPreferences;", "getUserState", "()Lai/tock/bot/engine/user/UserState;", "containsBotAction", "", "toString", "tock-bot-engine"})
public final class UserTimeline {
    @NotNull
    private final PlayerId playerId;
    @NotNull
    private final UserPreferences userPreferences;
    @NotNull
    private final UserState userState;
    @NotNull
    private final List<Dialog> dialogs;
    @NotNull
    private final Set<String> temporaryIds;

    public UserTimeline(@NotNull PlayerId playerId, @NotNull UserPreferences userPreferences, @NotNull UserState userState, @NotNull List<Dialog> dialogs, @NotNull Set<String> temporaryIds) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)userPreferences, (String)"userPreferences");
        Intrinsics.checkNotNullParameter((Object)userState, (String)"userState");
        Intrinsics.checkNotNullParameter(dialogs, (String)"dialogs");
        Intrinsics.checkNotNullParameter(temporaryIds, (String)"temporaryIds");
        this.playerId = playerId;
        this.userPreferences = userPreferences;
        this.userState = userState;
        this.dialogs = dialogs;
        this.temporaryIds = temporaryIds;
    }

    public /* synthetic */ UserTimeline(PlayerId playerId, UserPreferences userPreferences, UserState userState, List list, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            userPreferences = new UserPreferences(null, null, null, null, null, null, null, false, null, 511, null);
        }
        if ((n & 4) != 0) {
            userState = new UserState(null, null, 3, null);
        }
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            set = new LinkedHashSet();
        }
        this(playerId, userPreferences, userState, list, set);
    }

    @NotNull
    public final PlayerId getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    @NotNull
    public final UserState getUserState() {
        return this.userState;
    }

    @NotNull
    public final List<Dialog> getDialogs() {
        return this.dialogs;
    }

    @NotNull
    public final Set<String> getTemporaryIds() {
        return this.temporaryIds;
    }

    @Nullable
    public final Dialog getCurrentDialog() {
        return (Dialog)CollectionsKt.lastOrNull(this.dialogs);
    }

    @Nullable
    public final Story getCurrentStory() {
        Dialog dialog = this.getCurrentDialog();
        return dialog != null ? dialog.getCurrentStory() : null;
    }

    public final boolean containsBotAction() {
        boolean bl;
        block11: {
            Iterable $this$any$iv = this.dialogs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block10: {
                        Dialog it = (Dialog)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = it.getStories();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                boolean bl4;
                                block9: {
                                    Story it2 = (Story)element$iv2;
                                    boolean bl5 = false;
                                    Iterable $this$any$iv3 = it2.getActions();
                                    boolean $i$f$any3 = false;
                                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $this$any$iv3) {
                                            Action it3 = (Action)element$iv3;
                                            boolean bl6 = false;
                                            if (!(it3.getPlayerId().getType() == PlayerType.bot)) continue;
                                            bl4 = true;
                                            break block9;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public final Action getLastAction() {
        Dialog dialog;
        block1: {
            List<Dialog> list = this.dialogs;
            ListIterator<Dialog> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Dialog dialog2;
                Dialog it = dialog2 = listIterator.previous();
                boolean bl = false;
                if (!(it.getLastAction() != null)) continue;
                dialog = dialog2;
                break block1;
            }
            dialog = null;
        }
        Dialog dialog3 = dialog;
        return dialog3 != null ? dialog3.getLastAction() : null;
    }

    @Nullable
    public final Action getLastUserAction() {
        Dialog dialog;
        block1: {
            List<Dialog> list = this.dialogs;
            ListIterator<Dialog> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Dialog dialog2;
                Dialog it = dialog2 = listIterator.previous();
                boolean bl = false;
                if (!(it.getLastUserAction() != null)) continue;
                dialog = dialog2;
                break block1;
            }
            dialog = null;
        }
        Dialog dialog3 = dialog;
        return dialog3 != null ? dialog3.getLastUserAction() : null;
    }

    @NotNull
    public String toString() {
        return "UserTimeline(playerId=" + this.playerId + ")";
    }
}

