/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.config;

import ai.tock.bot.connector.media.MediaFileDescriptor;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.TockBotBus;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.config.UploadedFilesService;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.cache.CachesKt;
import ai.tock.translator.I18nLabel;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J%\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J,\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u001e2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/tock/bot/engine/config/UploadedFilesService;", "", "()V", "UPLOADED_TYPE", "", "audioTypes", "", "basePath", "imagesTypes", "videoTypes", "attachmentType", "Lai/tock/bot/engine/action/SendAttachment$AttachmentType;", "url", "botFilePath", "bus", "Lai/tock/bot/engine/BotBus;", "id", "suffix", "botFilePath$tock_bot_engine", "configure", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "configure$tock_bot_engine", "downloadFile", "context", "Lio/vertx/ext/web/RoutingContext;", "fileId", "fileId$tock_bot_engine", "getFileContentFromId", "", "getFileContentFromId$tock_bot_engine", "getFileContentFromUrl", "guessContentType", "fileName", "uploadFile", "Lai/tock/bot/connector/media/MediaFileDescriptor;", "namespace", "bytes", "description", "Lai/tock/translator/I18nLabel;", "tock-bot-engine"})
public final class UploadedFilesService {
    @NotNull
    public static final UploadedFilesService INSTANCE = new UploadedFilesService();
    @NotNull
    private static final String UPLOADED_TYPE = "_uploaded";
    @NotNull
    private static final String basePath = PropertiesKt.property((String)"tock_bot_serve_files_path", (String)"/f/");
    @NotNull
    private static final Set<String> imagesTypes;
    @NotNull
    private static final Set<String> audioTypes;
    @NotNull
    private static final Set<String> videoTypes;

    private UploadedFilesService() {
    }

    @NotNull
    public final SendAttachment.AttachmentType attachmentType(@NotNull String url) {
        SendAttachment.AttachmentType attachmentType;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url.length() > 2) {
            String string = url.substring(url.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String suffix = string2;
            boolean bl = false;
            attachmentType = imagesTypes.contains(suffix) ? SendAttachment.AttachmentType.image : (audioTypes.contains(suffix) ? SendAttachment.AttachmentType.audio : (videoTypes.contains(suffix) ? SendAttachment.AttachmentType.video : SendAttachment.AttachmentType.file));
        } else {
            attachmentType = SendAttachment.AttachmentType.file;
        }
        return attachmentType;
    }

    @Nullable
    public final MediaFileDescriptor uploadFile(@NotNull String namespace, @NotNull String fileName, @NotNull byte[] bytes, @Nullable I18nLabel description) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = (namespace + UUID.randomUUID()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String id = string;
        String string2 = ((Object)StringsKt.trim((CharSequence)fileName)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String name = string2;
        int lastDot = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
        if (lastDot == -1 || lastDot == name.length() - 1) {
            return null;
        }
        String string3 = name.substring(lastDot + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = string3;
        String fileId = id + "." + suffix;
        CachesKt.putInCache((Id)IdsKt.toId((String)fileId), (String)UPLOADED_TYPE, (Object)bytes);
        return new MediaFileDescriptor(suffix, fileName, id, null, null, description, 24, null);
    }

    public static /* synthetic */ MediaFileDescriptor uploadFile$default(UploadedFilesService uploadedFilesService, String string, String string2, byte[] byArray, I18nLabel i18nLabel, int n, Object object) {
        if ((n & 8) != 0) {
            i18nLabel = null;
        }
        return uploadedFilesService.uploadFile(string, string2, byArray, i18nLabel);
    }

    public final void downloadFile(@NotNull RoutingContext context, @NotNull String id, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.downloadFile(context, id + "." + suffix);
    }

    @NotNull
    public final String fileId$tock_bot_engine(@NotNull String id, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return id + "." + suffix;
    }

    @NotNull
    public final String botFilePath$tock_bot_engine(@NotNull BotBus bus, @NotNull String id, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Object object = bus instanceof TockBotBus ? (TockBotBus)bus : null;
        return (object != null && (object = ((TockBotBus)object).getConnector()) != null ? ((TockConnectorController)object).getBaseUrl() : null) + basePath + this.fileId$tock_bot_engine(id, suffix);
    }

    @Nullable
    public final byte[] getFileContentFromUrl(@NotNull String url) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String $this$getFileContentFromUrl_u24lambda_u241 = url;
        boolean bl = false;
        int start = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (start == -1) {
            byArray = null;
        } else {
            String string = url.substring(start + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            byArray = INSTANCE.getFileContentFromId$tock_bot_engine(string);
        }
        return byArray;
    }

    @Nullable
    public final byte[] getFileContentFromId$tock_bot_engine(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = CachesKt.getFromCache((Id)IdsKt.toId((String)id), (String)UPLOADED_TYPE);
        return object instanceof byte[] ? (byte[])object : null;
    }

    private final void downloadFile(RoutingContext context, String id) {
        byte[] bytes = this.getFileContentFromId$tock_bot_engine(id);
        if (bytes != null) {
            context.response().putHeader("Content-Type", this.guessContentType(id)).end(Buffer.buffer((byte[])bytes));
        } else {
            context.response().setStatusCode(404).end();
        }
    }

    @NotNull
    public final String guessContentType(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String id = string;
        boolean bl = false;
        return StringsKt.endsWith$default((String)id, (String)".png", (boolean)false, (int)2, null) ? "image/png" : (StringsKt.endsWith$default((String)id, (String)".jpg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)id, (String)".jpeg", (boolean)false, (int)2, null) ? "image/jpeg" : (StringsKt.endsWith$default((String)id, (String)".gif", (boolean)false, (int)2, null) ? "image/gif" : (StringsKt.endsWith$default((String)id, (String)".svg", (boolean)false, (int)2, null) ? "image/svg+xml" : (StringsKt.endsWith$default((String)id, (String)".ogg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)id, (String)".oga", (boolean)false, (int)2, null) ? "audio/ogg" : (StringsKt.endsWith$default((String)id, (String)".ogv", (boolean)false, (int)2, null) ? "video/ogg" : (StringsKt.endsWith$default((String)id, (String)".mp3", (boolean)false, (int)2, null) ? "audio/mpeg" : (StringsKt.endsWith$default((String)id, (String)".mp4", (boolean)false, (int)2, null) ? "video/mp4" : (StringsKt.endsWith$default((String)id, (String)".pdf", (boolean)false, (int)2, null) ? "application/pdf" : (StringsKt.endsWith$default((String)id, (String)".zip", (boolean)false, (int)2, null) ? "application/zip" : "application/octet-stream")))))))));
    }

    @NotNull
    public final Function1<Router, Unit> configure$tock_bot_engine() {
        return configure.1.INSTANCE;
    }

    public static final /* synthetic */ String access$getBasePath$p() {
        return basePath;
    }

    public static final /* synthetic */ void access$downloadFile(UploadedFilesService $this, RoutingContext context, String id) {
        $this.downloadFile(context, id);
    }

    static {
        Object[] objectArray = new String[]{"png", "jpg", "jpeg", "svg", "gif"};
        imagesTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"ogg", "mp3", "oga"};
        audioTypes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"ogv", "mp4"};
        videoTypes = SetsKt.setOf((Object[])objectArray);
    }
}

