/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.DialogState;
import ai.tock.bot.engine.dialog.EntityStateValue;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.dialog.NextUserActionState;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.nlp.Nlp;
import ai.tock.bot.engine.nlp.NlpCallStats;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.nlp.NlpEntityMergeContext;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.NlpClient;
import ai.tock.nlp.api.client.model.Entity;
import ai.tock.nlp.api.client.model.NlpEntityValue;
import ai.tock.nlp.api.client.model.NlpIntentQualifier;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpQueryContext;
import ai.tock.nlp.api.client.model.NlpQueryState;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.nlp.api.client.model.dump.ApplicationDump;
import ai.tock.nlp.api.client.model.dump.IntentDefinition;
import ai.tock.nlp.api.client.model.dump.SentencesDump;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationQuery;
import ai.tock.nlp.api.client.model.evaluation.EntityEvaluationResult;
import ai.tock.nlp.api.client.model.evaluation.EntityToEvaluate;
import ai.tock.nlp.api.client.model.merge.ValueToMerge;
import ai.tock.nlp.api.client.model.merge.ValuesMergeQuery;
import ai.tock.nlp.api.client.model.merge.ValuesMergeResult;
import ai.tock.nlp.api.client.model.monitoring.MarkAsUnknownQuery;
import ai.tock.nlp.entity.Value;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.StringsKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"Lai/tock/bot/engine/nlp/Nlp;", "Lai/tock/bot/engine/nlp/NlpController;", "()V", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getIntentsByNamespaceAndName", "", "Lai/tock/nlp/api/client/model/dump/IntentDefinition;", "namespace", "", "name", "importNlpDump", "", "stream", "Ljava/io/InputStream;", "importNlpPlainDump", "dump", "Lai/tock/nlp/api/client/model/dump/ApplicationDump;", "importNlpPlainSentencesDump", "Lai/tock/nlp/api/client/model/dump/SentencesDump;", "importNlpSentencesDump", "markAsUnknown", "", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "parseSentence", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/ConnectorController;", "waitAvailability", "timeToWaitInMs", "", "Companion", "SentenceParser", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nNlp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Nlp.kt\nai/tock/bot/engine/nlp/Nlp\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,459:1\n53#2,2:460\n53#2,2:464\n51#3:462\n51#3:466\n277#4:463\n277#4:467\n*S KotlinDebug\n*F\n+ 1 Nlp.kt\nai/tock/bot/engine/nlp/Nlp\n*L\n65#1:460,2\n66#1:464,2\n65#1:462\n66#1:466\n65#1:463\n66#1:467\n*E\n"})
public final class Nlp
implements NlpController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    private final NlpClient getNlpClient() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (NlpClient)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<NlpClient>(){}, tag$iv).getValue()).invoke();
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    @Override
    public void parseSentence(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull ConnectorController connector, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(sentence, userTimeline, dialog, botDefinition){
            final /* synthetic */ SendSentence $sentence;
            final /* synthetic */ UserTimeline $userTimeline;
            final /* synthetic */ Dialog $dialog;
            final /* synthetic */ BotDefinition $botDefinition;
            {
                this.$sentence = $sentence;
                this.$userTimeline = $userTimeline;
                this.$dialog = $dialog;
                this.$botDefinition = $botDefinition;
                super(1);
            }

            public final void invoke(@NotNull NlpListener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NlpResult result2 = it.precompute(this.$sentence, this.$userTimeline, this.$dialog, this.$botDefinition);
                if (result2 != null) {
                    this.$sentence.setPrecomputedNlp(result2);
                }
            }
        }));
        new SentenceParser(this.getNlpClient(), sentence, userTimeline, dialog, (TockConnectorController)connector, botDefinition).parse();
    }

    @Override
    public void markAsUnknown(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull BotDefinition botDefinition) {
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        if (sentence.getStringText() != null) {
            this.getExecutor().executeBlocking((Function0)new Function0<Unit>(this, botDefinition, userTimeline, sentence){
                final /* synthetic */ Nlp this$0;
                final /* synthetic */ BotDefinition $botDefinition;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ SendSentence $sentence;
                {
                    this.this$0 = $receiver;
                    this.$botDefinition = $botDefinition;
                    this.$userTimeline = $userTimeline;
                    this.$sentence = $sentence;
                    super(0);
                }

                public final void invoke() {
                    Nlp.access$getNlpClient(this.this$0).markAsUnknown(new MarkAsUnknownQuery(this.$botDefinition.getNamespace(), this.$botDefinition.getNlpModelName(), this.$userTimeline.getUserPreferences().getLocale(), this.$sentence.getStringText()));
                }
            });
        }
    }

    @Override
    @Nullable
    public List<IntentDefinition> getIntentsByNamespaceAndName(@NotNull String namespace, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = this.getNlpClient().getIntentsByNamespaceAndName(namespace, name);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean importNlpDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpDump(stream);
    }

    @Override
    public boolean importNlpPlainDump(@NotNull ApplicationDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainDump(dump);
    }

    @Override
    public boolean importNlpPlainSentencesDump(@NotNull SentencesDump dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return this.getNlpClient().importNlpPlainSentencesDump(dump);
    }

    @Override
    public boolean importNlpSentencesDump(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return this.getNlpClient().importNlpSentencesDump(stream);
    }

    @Override
    public void waitAvailability(long timeToWaitInMs) {
        long s = System.currentTimeMillis();
        while (!this.getNlpClient().healthcheck() && System.currentTimeMillis() - s < timeToWaitInMs) {
        }
    }

    public static final /* synthetic */ NlpClient access$getNlpClient(Nlp $this) {
        return $this.getNlpClient();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/bot/engine/nlp/Nlp$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J(\u0010 \u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0014\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0004\u001a\u0004\u0018\u00010#H\u0002J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0018\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u001cH\u0002J*\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\n\b\u0002\u00102\u001a\u0004\u0018\u00010,H\u0002J2\u00103\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00106\u001a\u0002012\n\b\u0002\u00107\u001a\u0004\u0018\u00010,H\u0002J\u0006\u00108\u001a\u00020%J\u0012\u00108\u001a\u0004\u0018\u00010\u001c2\u0006\u00109\u001a\u00020\u001eH\u0002J\b\u0010:\u001a\u00020\u001eH\u0002J\b\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020100*\u00020>2\u0006\u0010-\u001a\u00020.H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lai/tock/bot/engine/nlp/Nlp$SentenceParser;", "", "nlpClient", "Lai/tock/nlp/api/client/NlpClient;", "sentence", "Lai/tock/bot/engine/action/SendSentence;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "dialog", "Lai/tock/bot/engine/dialog/Dialog;", "connector", "Lai/tock/bot/engine/TockConnectorController;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "(Lai/tock/nlp/api/client/NlpClient;Lai/tock/bot/engine/action/SendSentence;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/engine/dialog/Dialog;Lai/tock/bot/engine/TockConnectorController;Lai/tock/bot/definition/BotDefinition;)V", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "getConnector", "()Lai/tock/bot/engine/TockConnectorController;", "getDialog", "()Lai/tock/bot/engine/dialog/Dialog;", "getNlpClient", "()Lai/tock/nlp/api/client/NlpClient;", "getSentence", "()Lai/tock/bot/engine/action/SendSentence;", "getUserTimeline", "()Lai/tock/bot/engine/user/UserTimeline;", "evaluateEntitiesForPrecomputedNlp", "Lai/tock/nlp/api/client/model/NlpResult;", "nlpQuery", "Lai/tock/nlp/api/client/model/NlpQuery;", "nlpResult", "findIntent", "Lai/tock/bot/definition/Intent;", "findKeyword", "", "listenNlpErrorCall", "", "query", "throwable", "", "listenNlpSuccessCall", "result", "mergeEntityValues", "Lai/tock/bot/engine/dialog/EntityStateValue;", "action", "Lai/tock/bot/engine/action/Action;", "newValues", "", "Lai/tock/bot/engine/dialog/EntityValue;", "oldValue", "mergeValues", "entity", "Lai/tock/nlp/api/client/model/Entity;", "defaultNewValue", "initialValue", "parse", "request", "toNlpQuery", "toQueryContext", "Lai/tock/nlp/api/client/model/NlpQueryContext;", "mergeEntityValuesFromAction", "Lai/tock/bot/engine/dialog/DialogState;", "tock-bot-engine"})
    @SourceDebugExtension(value={"SMAP\nNlp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Nlp.kt\nai/tock/bot/engine/nlp/Nlp$SentenceParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,459:1\n1549#2:460\n1620#2,3:461\n766#2:464\n857#2:465\n2624#2,3:466\n858#2:469\n288#2,2:470\n766#2:472\n857#2,2:473\n1549#2:475\n1620#2,3:476\n1603#2,9:497\n1855#2:506\n1856#2:508\n1612#2:509\n2624#2,3:510\n1963#2,14:513\n1549#2:527\n1620#2,3:528\n970#3:479\n999#3,3:480\n1002#3,3:490\n361#4,7:483\n125#5:493\n152#5,3:494\n1#6:507\n*S KotlinDebug\n*F\n+ 1 Nlp.kt\nai/tock/bot/engine/nlp/Nlp$SentenceParser\n*L\n178#1:460\n178#1:461,3\n185#1:464\n185#1:465\n186#1:466,3\n185#1:469\n278#1:470,2\n279#1:472\n279#1:473,2\n317#1:475\n317#1:476,3\n351#1:497,9\n351#1:506\n351#1:508\n351#1:509\n381#1:510,3\n383#1:513,14\n166#1:527\n166#1:528,3\n346#1:479\n346#1:480,3\n346#1:490,3\n346#1:483,7\n347#1:493\n347#1:494,3\n351#1:507\n*E\n"})
    private static final class SentenceParser {
        @NotNull
        private final NlpClient nlpClient;
        @NotNull
        private final SendSentence sentence;
        @NotNull
        private final UserTimeline userTimeline;
        @NotNull
        private final Dialog dialog;
        @NotNull
        private final TockConnectorController connector;
        @NotNull
        private final BotDefinition botDefinition;

        public SentenceParser(@NotNull NlpClient nlpClient, @NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull TockConnectorController connector, @NotNull BotDefinition botDefinition) {
            Intrinsics.checkNotNullParameter((Object)nlpClient, (String)"nlpClient");
            Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
            Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
            this.nlpClient = nlpClient;
            this.sentence = sentence;
            this.userTimeline = userTimeline;
            this.dialog = dialog;
            this.connector = connector;
            this.botDefinition = botDefinition;
        }

        @NotNull
        public final NlpClient getNlpClient() {
            return this.nlpClient;
        }

        @NotNull
        public final SendSentence getSentence() {
            return this.sentence;
        }

        @NotNull
        public final UserTimeline getUserTimeline() {
            return this.userTimeline;
        }

        @NotNull
        public final Dialog getDialog() {
            return this.dialog;
        }

        @NotNull
        public final TockConnectorController getConnector() {
            return this.connector;
        }

        @NotNull
        public final BotDefinition getBotDefinition() {
            return this.botDefinition;
        }

        public final void parse() {
            logger.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Parse sentence : " + this.this$0.getSentence();
                }
            });
            Intent intent = this.findKeyword(this.sentence.getStringText());
            if (intent != null) {
                Intent $this$parse_u24lambda_u240 = intent;
                boolean bl = false;
                this.dialog.getState().setCurrentIntent($this$parse_u24lambda_u240);
                return;
            }
            NlpQuery query = this.toNlpQuery();
            boolean bl = false;
            try {
                Object object;
                block7: {
                    block6: {
                        Dialog dialog;
                        NlpResult precomputedNlp = this.sentence.getPrecomputedNlp();
                        NlpResult result2 = precomputedNlp == null ? this.parse(query) : this.evaluateEntitiesForPrecomputedNlp(query, precomputedNlp);
                        object = result2;
                        if (object == null) break block6;
                        NlpResult nlpResult = object;
                        boolean bl2 = false;
                        this.listenNlpSuccessCall(query, nlpResult);
                        Intent intent2 = this.findIntent(this.userTimeline, this.dialog, this.sentence, nlpResult);
                        List customEntityEvaluations = new ArrayList();
                        BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((List<EntityValue>)customEntityEvaluations, this, nlpResult){
                            final /* synthetic */ List<EntityValue> $customEntityEvaluations;
                            final /* synthetic */ SentenceParser this$0;
                            final /* synthetic */ NlpResult $nlpResult;
                            {
                                this.$customEntityEvaluations = $customEntityEvaluations;
                                this.this$0 = $receiver;
                                this.$nlpResult = $nlpResult;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull NlpListener it) {
                                List<EntityValue> list;
                                List<EntityValue> list2;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                List<EntityValue> list3 = this.$customEntityEvaluations;
                                try {
                                    list2 = list3;
                                    list = it.evaluateEntities(this.this$0.getUserTimeline(), this.this$0.getDialog(), this.this$0.getSentence(), this.$nlpResult);
                                }
                                catch (Exception exception) {
                                    void e;
                                    list2 = list3;
                                    LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                    list = CollectionsKt.emptyList();
                                }
                                list2.addAll((Collection<EntityValue>)list);
                            }
                        }));
                        List entityEvaluations2 = CollectionsKt.plus((Collection)customEntityEvaluations, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)nlpResult.getEntities()), (Function1)((Function1)new Function1<NlpEntityValue, Boolean>((List<EntityValue>)customEntityEvaluations){
                            final /* synthetic */ List<EntityValue> $customEntityEvaluations;
                            {
                                this.$customEntityEvaluations = $customEntityEvaluations;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull NlpEntityValue e) {
                                boolean bl;
                                block3: {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    Iterable $this$none$iv = this.$customEntityEvaluations;
                                    boolean $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            EntityValue it = (EntityValue)element$iv;
                                            boolean bl2 = false;
                                            if (!Intrinsics.areEqual((Object)it.getEntity(), (Object)e.getEntity())) continue;
                                            bl = false;
                                            break block3;
                                        }
                                        bl = true;
                                    }
                                }
                                return bl;
                            }
                        })), (Function1)((Function1)new Function1<NlpEntityValue, EntityValue>(nlpResult){
                            final /* synthetic */ NlpResult $nlpResult;
                            {
                                this.$nlpResult = $nlpResult;
                                super(1);
                            }

                            @NotNull
                            public final EntityValue invoke(@NotNull NlpEntityValue it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return new EntityValue(this.$nlpResult, it);
                            }
                        })));
                        this.sentence.getState().getEntityValues().addAll(entityEvaluations2);
                        Dialog $this$parse_u24lambda_u243_u24lambda_u242_u24lambda_u241 = dialog = this.dialog;
                        boolean bl3 = false;
                        $this$parse_u24lambda_u243_u24lambda_u242_u24lambda_u241.getState().setCurrentIntent(intent2);
                        List<EntityValue> finalEntityValues = this.mergeEntityValuesFromAction($this$parse_u24lambda_u243_u24lambda_u242_u24lambda_u241.getState(), this.sentence);
                        this.sentence.setNlpStats(new NlpCallStats(this.userTimeline.getUserPreferences().getLocale(), intent2, entityEvaluations2, finalEntityValues, query, nlpResult));
                        Dialog dialog2 = dialog;
                        object = dialog2;
                        if (dialog2 != null) break block7;
                    }
                    this.listenNlpErrorCall(query, this.dialog, null);
                    object = Unit.INSTANCE;
                }
                NlpResult nlpResult = object;
            }
            catch (Throwable t) {
                LoggersKt.error((KLogger)logger, (Throwable)t);
                this.listenNlpErrorCall(query, this.dialog, t);
                Unit unit = Unit.INSTANCE;
            }
        }

        private final Intent findIntent(UserTimeline userTimeline, Dialog dialog, SendSentence sentence, NlpResult nlpResult) {
            Ref.ObjectRef i = new Ref.ObjectRef();
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<Intent>)i, userTimeline, dialog, sentence, nlpResult){
                final /* synthetic */ Ref.ObjectRef<Intent> $i;
                final /* synthetic */ UserTimeline $userTimeline;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ SendSentence $sentence;
                final /* synthetic */ NlpResult $nlpResult;
                {
                    this.$i = $i;
                    this.$userTimeline = $userTimeline;
                    this.$dialog = $dialog;
                    this.$sentence = $sentence;
                    this.$nlpResult = $nlpResult;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (this.$i.element == null) {
                        Intent intent;
                        Ref.ObjectRef<Intent> objectRef;
                        Ref.ObjectRef<Intent> objectRef2 = this.$i;
                        try {
                            objectRef = objectRef2;
                            IntentAware intentAware = it.findIntent(this.$userTimeline, this.$dialog, this.$sentence, this.$nlpResult);
                            intent = intentAware != null ? intentAware.wrappedIntent() : null;
                        }
                        catch (Exception exception) {
                            void e;
                            objectRef = objectRef2;
                            LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                            intent = null;
                        }
                        objectRef.element = intent;
                    }
                }
            }));
            Intent intent = (Intent)i.element;
            if (intent == null) {
                intent = this.botDefinition.findIntent(nlpResult.getIntent(), sentence.getApplicationId());
            }
            return intent;
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult evaluateEntitiesForPrecomputedNlp(NlpQuery nlpQuery, NlpResult nlpResult) {
            NlpResult nlpResult2;
            try {
                NlpResult nlpResult3;
                if (nlpResult.getEntities().isEmpty()) {
                    nlpResult3 = nlpResult;
                } else {
                    Collection<EntityToEvaluate> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Iterable iterable = nlpResult.getEntities();
                    Object object = nlpQuery.getContext();
                    Object object2 = nlpQuery.getApplicationName();
                    String string = nlpQuery.getNamespace();
                    NlpClient nlpClient = this.nlpClient;
                    boolean $i$f$map = false;
                    void var6_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        NlpEntityValue nlpEntityValue = (NlpEntityValue)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(SentenceParser.evaluateEntitiesForPrecomputedNlp$toEntityToEvaluate((NlpEntityValue)it));
                    }
                    String string2 = string;
                    Object object3 = object2;
                    NlpQueryContext nlpQueryContext = object;
                    collection = (List)destination$iv$iv;
                    Collection<EntityToEvaluate> collection2 = collection;
                    String string3 = nlpResult.getRetainedQuery();
                    EntityEvaluationResult result2 = nlpClient.evaluateEntities(new EntityEvaluationQuery(string2, (String)object3, nlpQueryContext, collection2, string3));
                    if (result2 != null) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        $this$map$iv = nlpResult.getEntities();
                        object2 = result2.getValues();
                        string = null;
                        String string4 = null;
                        String string5 = null;
                        nlpClient = nlpResult;
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            boolean bl;
                            block11: {
                                NlpEntityValue e = (NlpEntityValue)element$iv$iv;
                                boolean bl2 = false;
                                Iterable $this$none$iv = result2.getValues();
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        NlpEntityValue it = (NlpEntityValue)element$iv;
                                        boolean bl3 = false;
                                        if (!(it.getStart() == e.getStart())) continue;
                                        bl = false;
                                        break block11;
                                    }
                                    bl = true;
                                }
                            }
                            if (!bl) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                        nlpResult3 = NlpResult.copy$default((NlpResult)nlpClient, string5, string4, (Locale)((Object)string), (List)CollectionsKt.plus((Collection)object2, (Iterable)((Iterable)object)), null, (double)0.0, (double)0.0, null, null, null, (int)1015, null);
                    } else {
                        nlpResult3 = nlpResult;
                    }
                }
                nlpResult2 = nlpResult3;
            }
            catch (Exception exception) {
                LoggersKt.error((KLogger)logger, (Throwable)exception);
                nlpResult2 = nlpResult;
            }
            return nlpResult2;
        }

        private final Intent findKeyword(String sentence) {
            Intent intent;
            if (sentence != null) {
                Ref.ObjectRef i = new Ref.ObjectRef();
                BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<Intent>)i, sentence){
                    final /* synthetic */ Ref.ObjectRef<Intent> $i;
                    final /* synthetic */ String $sentence;
                    {
                        this.$i = $i;
                        this.$sentence = $sentence;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (this.$i.element == null) {
                            Intent intent;
                            Ref.ObjectRef<Intent> objectRef;
                            Ref.ObjectRef<Intent> objectRef2 = this.$i;
                            try {
                                objectRef = objectRef2;
                                intent = it.handleKeyword(this.$sentence);
                            }
                            catch (Exception exception) {
                                void e;
                                objectRef = objectRef2;
                                LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)((Throwable)e));
                                intent = null;
                            }
                            objectRef.element = intent;
                        }
                    }
                }));
                intent = (Intent)i.element;
            } else {
                intent = null;
            }
            return intent;
        }

        private final void listenNlpSuccessCall(NlpQuery query, NlpResult result2) {
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(query, result2){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ NlpResult $result;
                {
                    this.$query = $query;
                    this.$result = $result;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.success(this.$query, this.$result);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
            }));
        }

        private final void listenNlpErrorCall(NlpQuery query, Dialog dialog, Throwable throwable) {
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>(query, dialog, throwable){
                final /* synthetic */ NlpQuery $query;
                final /* synthetic */ Dialog $dialog;
                final /* synthetic */ Throwable $throwable;
                {
                    this.$query = $query;
                    this.$dialog = $dialog;
                    this.$throwable = $throwable;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    try {
                        it.error(this.$query, this.$dialog, this.$throwable);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)Nlp.access$getLogger$cp(), (Throwable)e);
                    }
                }
            }));
        }

        private final NlpQueryContext toQueryContext() {
            boolean test = this.userTimeline.getUserPreferences().getTest();
            Locale locale = this.userTimeline.getUserPreferences().getLocale();
            String string = this.sentence.getPlayerId().getId();
            String string2 = this.dialog.getId().toString();
            String string3 = this.connector.getConnectorType().toString();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = ((NextUserActionState)object).getReferenceDate()) == null) {
                object = ZonedDateTime.now(DatesKt.getDefaultZoneId());
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dialog.state.nextActionS\u2026teTime.now(defaultZoneId)");
            Object object2 = this.dialog.getState().getNextActionState();
            if (object2 == null || (object2 = ((NextUserActionState)object2).getReferenceTimezone()) == null) {
                object2 = DatesKt.getDefaultZoneId();
            }
            return new NlpQueryContext(locale, string, string2, string3, (ZonedDateTime)object, (ZoneId)object2, test, !test && !this.userTimeline.getUserState().getBotDisabled());
        }

        private final NlpQuery toNlpQuery() {
            String string = this.sentence.getStringText();
            if (string == null) {
                string = "";
            }
            List list = CollectionsKt.listOf((Object)string);
            String string2 = this.botDefinition.getNamespace();
            String string3 = this.botDefinition.getNlpModelName();
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            Object object = this.dialog.getState().getNextActionState();
            if (object == null || (object = ((NextUserActionState)object).getStates()) == null) {
                Object object2 = this.dialog.getCurrentStory();
                object = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull(object2 != null && (object2 = ((Story)object2).getDefinition()) != null && (object2 = object2.mainIntent()) != null ? ((Intent)object2).getName() : null));
            }
            NlpQuery $this$toNlpQuery_u24lambda_u248 = new NlpQuery(list, string2, string3, nlpQueryContext, new NlpQueryState((Set)object), null, this.connector.getBotConfiguration().getApplicationId(), 32, null);
            boolean bl = false;
            Ref.ObjectRef query = new Ref.ObjectRef();
            query.element = $this$toNlpQuery_u24lambda_u248;
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<NlpQuery>)query, this){
                final /* synthetic */ Ref.ObjectRef<NlpQuery> $query;
                final /* synthetic */ SentenceParser this$0;
                {
                    this.$query = $query;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$query.element = it.updateQuery(this.this$0.getSentence(), this.this$0.getUserTimeline(), this.this$0.getDialog(), this.this$0.getBotDefinition(), (NlpQuery)this.$query.element);
                }
            }));
            return (NlpQuery)query.element;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final EntityStateValue mergeEntityValues(Action action, List<EntityValue> newValues, EntityStateValue oldValue) {
            Object result2;
            Object object;
            List eligibleToMergeValues;
            EntityValue defaultNewValue;
            Entity entity;
            block10: {
                block9: {
                    void $this$filterTo$iv$iv;
                    EntityValue entityValue2;
                    Object v0;
                    block8: {
                        entity = ((EntityValue)CollectionsKt.first(newValues)).getEntity();
                        Iterable $this$firstOrNull$iv = newValues;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            EntityValue it = (EntityValue)element$iv;
                            boolean bl = false;
                            if (!(it.getValue() != null)) continue;
                            v0 = element$iv;
                            break block8;
                        }
                        v0 = null;
                    }
                    if ((entityValue2 = (EntityValue)v0) == null) {
                        entityValue2 = (EntityValue)CollectionsKt.first(newValues);
                    }
                    defaultNewValue = entityValue2;
                    Object $this$filter$iv = newValues;
                    boolean $i$f$filter = false;
                    Object object2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        EntityValue it = (EntityValue)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getMergeSupport() && it.getValue() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    eligibleToMergeValues = (List)destination$iv$iv;
                    if (oldValue == null) {
                        if (eligibleToMergeValues.size() < 2) {
                            Object $this$mergeEntityValues_u24lambda_u2411 = $this$filter$iv = new EntityStateValue(action, defaultNewValue);
                            boolean bl = false;
                            ((EntityStateValue)$this$mergeEntityValues_u24lambda_u2411).setMultiRequestedValues$tock_bot_engine(newValues);
                            object = $this$filter$iv;
                            return object;
                        }
                        result2 = SentenceParser.mergeValues$default(this, entity, eligibleToMergeValues, defaultNewValue, null, 8, null);
                        object = new EntityStateValue(action, (EntityValue)result2);
                        return object;
                    }
                    if (eligibleToMergeValues.isEmpty()) break block9;
                    if (eligibleToMergeValues.size() != 1) break block10;
                    EntityValue entityValue3 = oldValue.getValue();
                    if ((entityValue3 != null ? entityValue3.getValue() : null) != null) break block10;
                }
                result2 = oldValue.changeValue$tock_bot_engine(defaultNewValue, action);
                EntityStateValue $this$mergeEntityValues_u24lambda_u2412 = result2;
                boolean bl = false;
                $this$mergeEntityValues_u24lambda_u2412.setMultiRequestedValues$tock_bot_engine(newValues);
                object = result2;
                return object;
            }
            result2 = this.mergeValues(entity, eligibleToMergeValues, defaultNewValue, oldValue);
            object = oldValue.changeValue$tock_bot_engine((EntityValue)result2, action);
            return object;
        }

        static /* synthetic */ EntityStateValue mergeEntityValues$default(SentenceParser sentenceParser, Action action, List list, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 4) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeEntityValues(action, list, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final EntityValue mergeValues(Entity entity, List<EntityValue> newValues, EntityValue defaultNewValue, EntityStateValue initialValue) {
            ValuesMergeResult result2;
            ValueToMerge valueToMerge;
            Collection<ValueToMerge> collection;
            Object $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = newValues;
            Entity entity2 = entity;
            NlpQueryContext nlpQueryContext = this.toQueryContext();
            String string = this.botDefinition.getNlpModelName();
            String string2 = this.botDefinition.getNamespace();
            NlpClient nlpClient = this.nlpClient;
            boolean $i$f$map = false;
            void var8_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                EntityValue entityValue2 = (EntityValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Value value = it.getValue();
                Intrinsics.checkNotNull((Object)value);
                collection.add(new ValueToMerge(value, it.getContent(), false, it.getStart(), it.getProbability()));
            }
            collection = (List)destination$iv$iv;
            NlpClient nlpClient2 = nlpClient;
            String string3 = string2;
            String string4 = string;
            NlpQueryContext nlpQueryContext2 = nlpQueryContext;
            Entity entity3 = entity2;
            Collection<ValueToMerge> collection2 = collection;
            if (initialValue != null && (object = initialValue.getValue()) != null) {
                ValueToMerge valueToMerge2;
                void value;
                $this$mapTo$iv$iv = object;
                collection = collection2;
                entity2 = entity3;
                nlpQueryContext = nlpQueryContext2;
                string = string4;
                string2 = string3;
                nlpClient = nlpClient2;
                boolean bl = false;
                Value value2 = value.getValue();
                if (value2 != null) {
                    Value it = value2;
                    boolean bl2 = false;
                    valueToMerge2 = new ValueToMerge(it, value.getContent(), true, null, 0.0, 24, null);
                } else {
                    valueToMerge2 = null;
                }
                ValueToMerge valueToMerge3 = valueToMerge2;
                nlpClient2 = nlpClient;
                string3 = string2;
                string4 = string;
                nlpQueryContext2 = nlpQueryContext;
                entity3 = entity2;
                collection2 = collection;
                valueToMerge = valueToMerge3;
            } else {
                valueToMerge = null;
            }
            List list = CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.listOfNotNull(valueToMerge));
            Entity entity4 = entity3;
            NlpQueryContext nlpQueryContext3 = nlpQueryContext2;
            String string5 = string4;
            String string6 = string3;
            ValuesMergeResult valuesMergeResult = result2 = nlpClient2.mergeValues(new ValuesMergeQuery(string6, string5, nlpQueryContext3, entity4, list));
            return (valuesMergeResult != null ? valuesMergeResult.getValue() : null) == null ? defaultNewValue : new EntityValue(entity, result2.getValue(), result2.getContent());
        }

        static /* synthetic */ EntityValue mergeValues$default(SentenceParser sentenceParser, Entity entity, List list, EntityValue entityValue2, EntityStateValue entityStateValue, int n, Object object) {
            if ((n & 8) != 0) {
                entityStateValue = null;
            }
            return sentenceParser.mergeValues(entity, list, entityValue2, entityStateValue);
        }

        /*
         * WARNING - void declaration
         */
        private final List<EntityValue> mergeEntityValuesFromAction(DialogState $this$mergeEntityValuesFromAction, Action action) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Object list$iv$iv;
            EntityValue it;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Ref.ObjectRef merge = new Ref.ObjectRef();
            Sequence sequence = CollectionsKt.asSequence((Iterable)action.getState().getEntityValues());
            Ref.ObjectRef objectRef = merge;
            boolean $i$f$groupBy = false;
            void var6_7 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                it = (EntityValue)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getEntity().getRole();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                list$iv$iv = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(new NlpEntityMergeContext((String)it.getKey(), $this$mergeEntityValuesFromAction.getEntityValues().get(it.getKey()), (List)it.getValue()));
            }
            objectRef.element = (List)destination$iv$iv;
            BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<List<NlpEntityMergeContext>>)merge){
                final /* synthetic */ Ref.ObjectRef<List<NlpEntityMergeContext>> $merge;
                {
                    this.$merge = $merge;
                    super(1);
                }

                public final void invoke(@NotNull NlpListener it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$merge.element = it.sortEntitiesToMerge((List)this.$merge.element);
                }
            }));
            Iterable $this$mapNotNull$iv = (Iterable)merge.element;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EntityValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                NlpEntityMergeContext mergeContext = (NlpEntityMergeContext)element$iv$iv;
                boolean bl3 = false;
                Ref.ObjectRef context = new Ref.ObjectRef();
                context.element = mergeContext;
                BotRepository.INSTANCE.forEachNlpListener((Function1<? super NlpListener, Unit>)((Function1)new Function1<NlpListener, Unit>((Ref.ObjectRef<NlpEntityMergeContext>)context, $this$mergeEntityValuesFromAction, action){
                    final /* synthetic */ Ref.ObjectRef<NlpEntityMergeContext> $context;
                    final /* synthetic */ DialogState $this_mergeEntityValuesFromAction;
                    final /* synthetic */ Action $action;
                    {
                        this.$context = $context;
                        this.$this_mergeEntityValuesFromAction = $receiver;
                        this.$action = $action;
                        super(1);
                    }

                    public final void invoke(@NotNull NlpListener it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$context.element = it.mergeEntityValues(this.$this_mergeEntityValuesFromAction, this.$action, (NlpEntityMergeContext)this.$context.element);
                    }
                }));
                EntityStateValue result2 = this.mergeEntityValues(action, ((NlpEntityMergeContext)context.element).getNewValues(), ((NlpEntityMergeContext)context.element).getInitialValue());
                $this$mergeEntityValuesFromAction.getEntityValues().put(((NlpEntityMergeContext)context.element).getEntityRole(), result2);
                if (result2.getValue() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final NlpResult parse(NlpQuery request) {
            NlpResult result2;
            NlpResult nlpResult;
            boolean useQualifiers;
            List<NlpIntentQualifier> intentsQualifiers;
            logger.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ SentenceParser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sending sentence '" + this.this$0.getSentence().getStringText() + "' to NLP";
                }
            });
            NextUserActionState nextUserActionState = this.dialog.getState().getNextActionState();
            List<Object> list = intentsQualifiers = nextUserActionState != null ? nextUserActionState.getIntentsQualifiers() : null;
            boolean bl = intentsQualifiers != null && !((Collection)intentsQualifiers).isEmpty() ? true : (useQualifiers = false);
            if (!useQualifiers) {
                nlpResult = this.nlpClient.parse(request);
            } else {
                List<NlpIntentQualifier> list2 = intentsQualifiers;
                Intrinsics.checkNotNull(list2);
                nlpResult = result2 = this.nlpClient.parse(NlpQuery.copy$default((NlpQuery)request, null, null, null, null, null, (Set)SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<NlpIntentQualifier, NlpIntentQualifier>(request){
                    final /* synthetic */ NlpQuery $request;
                    {
                        this.$request = $request;
                        super(1);
                    }

                    @NotNull
                    public final NlpIntentQualifier invoke(@NotNull NlpIntentQualifier it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return NlpIntentQualifier.copy$default((NlpIntentQualifier)it, (String)StringsKt.withNamespace((String)it.getIntent(), (String)this.$request.getNamespace()), (double)0.0, (int)2, null);
                    }
                }))), null, (int)95, null));
            }
            if (result2 != null && useQualifiers) {
                boolean bl2;
                block13: {
                    List<NlpIntentQualifier> list3 = intentsQualifiers;
                    Intrinsics.checkNotNull(list3);
                    Iterable $this$none$iv = list3;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            NlpIntentQualifier it = (NlpIntentQualifier)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getIntent(), (Object)result2.getIntent())) continue;
                            bl2 = false;
                            break block13;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    NlpResult nlpResult2;
                    Object object;
                    Object v7;
                    void $this$maxByOrNull$iv;
                    Iterable $i$f$none = intentsQualifiers;
                    NlpResult nlpResult3 = result2;
                    boolean $i$f$maxByOrNull = false;
                    Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v7 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v7 = maxElem$iv;
                        } else {
                            NlpIntentQualifier it = (NlpIntentQualifier)maxElem$iv;
                            boolean bl4 = false;
                            double maxValue$iv = it.getModifier();
                            do {
                                Object e$iv = iterator$iv.next();
                                NlpIntentQualifier it2 = (NlpIntentQualifier)e$iv;
                                $i$a$-maxByOrNull-Nlp$SentenceParser$parse$6 = false;
                                double v$iv = it2.getModifier();
                                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v7 = maxElem$iv;
                        }
                    }
                    if ((object = (NlpIntentQualifier)v7) == null || (object = object.getIntent()) == null) {
                        object = ((NlpIntentQualifier)CollectionsKt.first(intentsQualifiers)).getIntent();
                    }
                    NlpResult it = nlpResult2 = NlpResult.copy$default((NlpResult)nlpResult3, (String)object, null, null, null, null, (double)0.0, (double)0.0, null, null, null, (int)1022, null);
                    boolean bl5 = false;
                    logger.warn((Function0)new Function0<Object>(result2, intentsQualifiers, it){
                        final /* synthetic */ NlpResult $result;
                        final /* synthetic */ List<NlpIntentQualifier> $intentsQualifiers;
                        final /* synthetic */ NlpResult $it;
                        {
                            this.$result = $result;
                            this.$intentsQualifiers = $intentsQualifiers;
                            this.$it = $it;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return this.$result.getIntent() + " not in intents qualifier " + this.$intentsQualifiers + " - use " + this.$it;
                        }
                    });
                    return nlpResult2;
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private static final EntityToEvaluate evaluateEntitiesForPrecomputedNlp$toEntityToEvaluate(NlpEntityValue $this$evaluateEntitiesForPrecomputedNlp_u24toEntityToEvaluate) {
            Collection<EntityToEvaluate> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $this$evaluateEntitiesForPrecomputedNlp_u24toEntityToEvaluate.getSubEntities();
            Entity entity = $this$evaluateEntitiesForPrecomputedNlp_u24toEntityToEvaluate.getEntity();
            int n = $this$evaluateEntitiesForPrecomputedNlp_u24toEntityToEvaluate.getEnd();
            int n2 = $this$evaluateEntitiesForPrecomputedNlp_u24toEntityToEvaluate.getStart();
            boolean $i$f$map = false;
            void var3_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NlpEntityValue nlpEntityValue = (NlpEntityValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SentenceParser.evaluateEntitiesForPrecomputedNlp$toEntityToEvaluate((NlpEntityValue)it));
            }
            Collection<EntityToEvaluate> collection2 = collection = (List)destination$iv$iv;
            Entity entity2 = entity;
            int n3 = n;
            int n4 = n2;
            return new EntityToEvaluate(n4, n3, entity2, collection2);
        }
    }
}

