/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine;

import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.WebSocketController;
import ai.tock.bot.engine.config.UploadedFilesService;
import ai.tock.bot.engine.nlp.NlpProxyBotService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.auth.TockAuthProvider;
import ai.tock.shared.vertx.DetailedHealthcheckKt;
import ai.tock.shared.vertx.WebVerticle;
import ai.tock.translator.Translator;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001/B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J(\u0010\u001a\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u001b\u001a\u00020\r2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001dJ\u0012\u0010 \u001a\u00020!2\n\u0010\u001c\u001a\u00060\u000eR\u00020\u0000J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0014J\b\u0010$\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020!H\u0002J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020!0\u001dH\u0016J\u0014\u0010(\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020!0\u001dH\u0016J\u001e\u0010)\u001a\u00020!2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u000eR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\rX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0003X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lai/tock/bot/engine/BotVerticle;", "Lai/tock/shared/vertx/WebVerticle;", "nlpProxyOnBot", "", "serveUploadedFiles", "<init>", "(ZZ)V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "handlers", "", "", "Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "secondaryInstallers", "", "initialized", "defaultCorsOrigin", "getDefaultCorsOrigin", "()Ljava/lang/String;", "defaultCorsWithCredentials", "getDefaultCorsWithCredentials", "()Z", "authProvider", "Lai/tock/shared/security/auth/TockAuthProvider;", "registerServices", "serviceIdentifier", "installer", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "unregisterServices", "", "protectedPaths", "", "configure", "install", "defaultHealthcheck", "Lio/vertx/ext/web/RoutingContext;", "detailedHealthcheck", "startServer", "promise", "Lio/vertx/core/Promise;", "Ljava/lang/Void;", "port", "", "ServiceInstaller", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nBotVerticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotVerticle.kt\nai/tock/bot/engine/BotVerticle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1557#2:209\n1628#2,3:210\n1053#2:216\n1863#2,2:217\n188#3,3:213\n1#4:219\n*S KotlinDebug\n*F\n+ 1 BotVerticle.kt\nai/tock/bot/engine/BotVerticle\n*L\n129#1:209\n129#1:210,3\n153#1:216\n153#1:217,2\n150#1:213,3\n*E\n"})
public final class BotVerticle
extends WebVerticle {
    private final boolean nlpProxyOnBot;
    private final boolean serveUploadedFiles;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Map<String, ServiceInstaller> handlers;
    @NotNull
    private final Set<ServiceInstaller> secondaryInstallers;
    private boolean initialized;
    @NotNull
    private final String defaultCorsOrigin;
    private final boolean defaultCorsWithCredentials;

    public BotVerticle(boolean nlpProxyOnBot, boolean serveUploadedFiles) {
        this.nlpProxyOnBot = nlpProxyOnBot;
        this.serveUploadedFiles = serveUploadedFiles;
        this.logger = KotlinLogging.INSTANCE.logger(BotVerticle::logger$lambda$0);
        this.handlers = new ConcurrentHashMap();
        this.secondaryInstallers = new CopyOnWriteArraySet();
        this.defaultCorsOrigin = "*";
    }

    public /* synthetic */ BotVerticle(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = PropertiesKt.booleanProperty((String)"tock_nlp_proxy_on_bot", (boolean)false);
        }
        if ((n & 2) != 0) {
            bl2 = PropertiesKt.booleanProperty((String)"tock_bot_serve_files", (boolean)true);
        }
        this(bl, bl2);
    }

    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected String getDefaultCorsOrigin() {
        return this.defaultCorsOrigin;
    }

    protected boolean getDefaultCorsWithCredentials() {
        return this.defaultCorsWithCredentials;
    }

    @Nullable
    protected TockAuthProvider authProvider() {
        return this.defaultAuthProvider();
    }

    @NotNull
    public final ServiceInstaller registerServices(@NotNull String serviceIdentifier, @NotNull Function1<? super Router, ? extends Object> installer) {
        ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)serviceIdentifier, (String)"serviceIdentifier");
        Intrinsics.checkNotNullParameter(installer, (String)"installer");
        ServiceInstaller it = serviceInstaller = new ServiceInstaller(this, serviceIdentifier, installer, null, false, null, 28, null);
        boolean bl = false;
        if (!this.handlers.containsKey(serviceIdentifier)) {
            this.handlers.put(serviceIdentifier, it);
        } else {
            this.getLogger().debug("service " + serviceIdentifier + " already registered - skip it for now");
            this.secondaryInstallers.add(it);
        }
        return serviceInstaller;
    }

    public final void unregisterServices(@NotNull ServiceInstaller installer) {
        ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)installer, (String)"installer");
        if (this.secondaryInstallers.contains(installer)) {
            this.secondaryInstallers.remove(installer);
        }
        if (Intrinsics.areEqual((Object)this.handlers.get(installer.getServiceId()), (Object)installer) && (serviceInstaller = this.handlers.remove(installer.getServiceId())) != null) {
            Object v0;
            ServiceInstaller it;
            block4: {
                it = serviceInstaller;
                boolean bl = false;
                Iterable iterable = this.secondaryInstallers;
                for (Object t : iterable) {
                    ServiceInstaller it2 = (ServiceInstaller)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getServiceId(), (Object)installer.getServiceId())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            ServiceInstaller s = v0;
            this.getLogger().debug(() -> BotVerticle.unregisterServices$lambda$4$lambda$3(it));
            it.uninstall();
            if (s != null) {
                s.install();
                this.secondaryInstallers.remove(s);
                this.handlers.put(it.getServiceId(), s);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<String> protectedPaths() {
        void $this$mapTo$iv$iv;
        String path = PropertiesKt.property((String)"tock_bot_protected_path", (String)"/admin");
        List paths = PropertiesKt.listProperty$default((String)"tock_bot_protected_paths", (List)CollectionsKt.listOf((Object)"/admin"), null, (int)4, null);
        Iterable $this$map$iv = CollectionsKt.plus((Collection)paths, (Object)path);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public synchronized void configure() {
        if (!this.initialized) {
            this.initialized = true;
            EncryptorsKt.initEncryptor();
            Translator.INSTANCE.initTranslator();
            if (this.nlpProxyOnBot) {
                Vertx vertx = ((AbstractVerticle)this).vertx;
                Intrinsics.checkNotNullExpressionValue((Object)vertx, (String)"vertx");
                this.registerServices("nlp_proxy_bot", NlpProxyBotService.INSTANCE.configure(vertx));
            }
            if (this.serveUploadedFiles) {
                this.registerServices("serve_files", UploadedFilesService.INSTANCE.configure$tock_bot_engine());
            }
        }
        this.install();
    }

    private final void install() {
        Object it;
        boolean bl;
        block5: {
            Map<String, ServiceInstaller> $this$any$iv = this.handlers;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry<String, ServiceInstaller> element$iv : $this$any$iv.entrySet()) {
                    it = element$iv;
                    boolean bl2 = false;
                    if (!(!it.getValue().getInstalled())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.getLogger().info(() -> BotVerticle.install$lambda$7(this));
            Iterable $this$sortedBy$iv = this.handlers.values();
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ServiceInstaller it = (ServiceInstaller)a;
                    boolean bl = false;
                    Comparable comparable = it.getRegistrationDate();
                    it = (ServiceInstaller)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getRegistrationDate());
                }
            });
            boolean $i$f$forEach = false;
            for (Map.Entry<String, ServiceInstaller> element$iv : $this$forEach$iv) {
                it = (ServiceInstaller)((Object)element$iv);
                boolean bl3 = false;
                ((ServiceInstaller)it).install();
            }
        }
    }

    @NotNull
    public Function1<RoutingContext, Unit> defaultHealthcheck() {
        return BotRepository.INSTANCE.getHealthcheckHandler();
    }

    @NotNull
    public Function1<RoutingContext, Unit> detailedHealthcheck() {
        return DetailedHealthcheckKt.detailedHealthcheck(BotRepository.INSTANCE.getDetailedHealthcheckTasks$tock_bot_engine(), BotVerticle::detailedHealthcheck$lambda$10);
    }

    protected void startServer(@NotNull Promise<Void> promise, int port) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (WebSocketController.INSTANCE.getWebsocketEnabled()) {
            this.getLogger().info(BotVerticle::startServer$lambda$11);
            this.getServer().webSocketHandler(arg_0 -> BotVerticle.startServer$lambda$20(this, arg_0));
        }
        super.startServer(promise, port);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object unregisterServices$lambda$4$lambda$3(ServiceInstaller $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "remove service " + $it.getServiceId();
    }

    private static final Object install$lambda$7(BotVerticle this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return "Install Bot Services / " + this$0.handlers.size() + " registered";
    }

    private static final boolean detailedHealthcheck$lambda$10() {
        return BotRepository.INSTANCE.getBotsInstalled$tock_bot_engine();
    }

    private static final Object startServer$lambda$11() {
        return "Install WebSocket handler";
    }

    private static final Object startServer$lambda$20$lambda$13(ServerWebSocket $context) {
        return "Install WebSocket push handler for " + $context.path();
    }

    private static final Object startServer$lambda$20$lambda$15$lambda$14(String $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "send: " + $it;
    }

    private static final Unit startServer$lambda$20$lambda$15(BotVerticle this$0, ServerWebSocket $context, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            this$0.getLogger().debug(() -> BotVerticle.startServer$lambda$20$lambda$15$lambda$14(it));
            $context.writeTextMessage(it);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.getLogger(), (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final Object startServer$lambda$20$lambda$17$lambda$16(String $json) {
        return "receive " + $json;
    }

    private static final void startServer$lambda$20$lambda$17(BotVerticle this$0, String $key, String json) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            this$0.getLogger().debug(() -> BotVerticle.startServer$lambda$20$lambda$17$lambda$16(json));
            Function1<String, Unit> function1 = WebSocketController.INSTANCE.getReceiveHandler($key);
            if (function1 != null) {
                Intrinsics.checkNotNull((Object)json);
                function1.invoke((Object)json);
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.getLogger(), (Throwable)e);
        }
    }

    private static final void startServer$lambda$20$lambda$18(String $key, Void it) {
        WebSocketController.INSTANCE.removePushHandler$tock_bot_engine($key);
    }

    private static final Object startServer$lambda$20$lambda$19(String $key) {
        return "unknown key: " + $key;
    }

    private static final void startServer$lambda$20(BotVerticle this$0, ServerWebSocket context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        try {
            String key;
            String string;
            String it = context.path();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
                String string2 = it.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            if (WebSocketController.INSTANCE.isAuthorizedKey$tock_bot_engine(key = string)) {
                this$0.getLogger().info(() -> BotVerticle.startServer$lambda$20$lambda$13(context));
                String string3 = key;
                Intrinsics.checkNotNull((Object)string3);
                WebSocketController.INSTANCE.setPushHandler$tock_bot_engine(string3, (Function1<? super String, Unit>)((Function1)arg_0 -> BotVerticle.startServer$lambda$20$lambda$15(this$0, context, arg_0)));
                context.textMessageHandler(arg_0 -> BotVerticle.startServer$lambda$20$lambda$17(this$0, key, arg_0)).closeHandler(arg_0 -> BotVerticle.startServer$lambda$20$lambda$18(key, arg_0));
            } else {
                this$0.getLogger().warn(() -> BotVerticle.startServer$lambda$20$lambda$19(key));
                context.reject();
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)this$0.getLogger(), (Throwable)e);
        }
    }

    public BotVerticle() {
        this(false, false, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "", "serviceId", "", "installer", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "routes", "", "Lio/vertx/ext/web/Route;", "installed", "", "registrationDate", "Ljava/time/Instant;", "<init>", "(Lai/tock/bot/engine/BotVerticle;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/util/List;ZLjava/time/Instant;)V", "getServiceId", "()Ljava/lang/String;", "getInstalled", "()Z", "setInstalled", "(Z)V", "getRegistrationDate", "()Ljava/time/Instant;", "install", "", "uninstall", "tock-bot-engine"})
    @SourceDebugExtension(value={"SMAP\nBotVerticle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BotVerticle.kt\nai/tock/bot/engine/BotVerticle$ServiceInstaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1863#2,2:209\n*S KotlinDebug\n*F\n+ 1 BotVerticle.kt\nai/tock/bot/engine/BotVerticle$ServiceInstaller\n*L\n74#1:209,2\n*E\n"})
    public final class ServiceInstaller {
        @NotNull
        private final String serviceId;
        @NotNull
        private final Function1<Router, Object> installer;
        @NotNull
        private final List<Route> routes;
        private volatile boolean installed;
        @NotNull
        private final Instant registrationDate;
        final /* synthetic */ BotVerticle this$0;

        public ServiceInstaller(@NotNull BotVerticle this$0, @NotNull String serviceId, @NotNull Function1<? super Router, ? extends Object> installer, List<Route> routes, @NotNull boolean installed, Instant registrationDate) {
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            Intrinsics.checkNotNullParameter(installer, (String)"installer");
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            Intrinsics.checkNotNullParameter((Object)registrationDate, (String)"registrationDate");
            this.this$0 = this$0;
            this.serviceId = serviceId;
            this.installer = installer;
            this.routes = routes;
            this.installed = installed;
            this.registrationDate = registrationDate;
        }

        public /* synthetic */ ServiceInstaller(BotVerticle botVerticle, String string, Function1 function1, List list, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = new CopyOnWriteArrayList();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                instant = Instant.now();
            }
            this(botVerticle, string, (Function1<? super Router, ? extends Object>)function1, list, bl, instant);
        }

        @NotNull
        public final String getServiceId() {
            return this.serviceId;
        }

        public final boolean getInstalled() {
            return this.installed;
        }

        public final void setInstalled(boolean bl) {
            this.installed = bl;
        }

        @NotNull
        public final Instant getRegistrationDate() {
            return this.registrationDate;
        }

        public final void install() {
            if (!this.installed) {
                this.installed = true;
                try {
                    this.this$0.getLogger().debug("install " + this.serviceId);
                    List registeredRoutes = this.this$0.getRouter().getRoutes();
                    this.installer.invoke((Object)this.this$0.getRouter());
                    List list = this.this$0.getRouter().getRoutes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getRoutes(...)");
                    Iterable iterable = list;
                    Intrinsics.checkNotNull((Object)registeredRoutes);
                    this.routes.addAll(CollectionsKt.subtract((Iterable)iterable, (Iterable)registeredRoutes));
                }
                catch (Exception e) {
                    LoggersKt.error((KLogger)this.this$0.getLogger(), (Throwable)e);
                }
            }
        }

        public final void uninstall() {
            Iterable $this$forEach$iv = this.routes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Route it = (Route)element$iv;
                boolean bl = false;
                it.remove();
            }
        }
    }
}

