/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.StoryDefinition;
import ai.tock.bot.definition.StoryTag;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.TockBotBus;
import ai.tock.bot.engine.TockConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.action.SendLocation;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.config.BotDefinitionWrapper;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.DialogState;
import ai.tock.bot.engine.dialog.Story;
import ai.tock.bot.engine.feature.DefaultFeatureType;
import ai.tock.bot.engine.nlp.NlpController;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.shared.IOCsKt;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J&\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010)\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010-\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020(2\u0006\u0010!\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020(H\u0002J\u0018\u00102\u001a\u00020&2\u0006\u00103\u001a\u0002042\u0006\u0010,\u001a\u00020(H\u0002J\u0018\u00105\u001a\u00020&2\u0006\u00106\u001a\u0002072\u0006\u0010,\u001a\u00020(H\u0002J(\u00108\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020.H\u0002J\u0016\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u001f\u001a\u00020 J\b\u0010<\u001a\u00020=H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lai/tock/bot/engine/Bot;", "", "botDefinitionBase", "Lai/tock/bot/definition/BotDefinition;", "configuration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "supportedLocales", "", "Ljava/util/Locale;", "<init>", "(Lai/tock/bot/definition/BotDefinition;Lai/tock/bot/admin/bot/BotApplicationConfiguration;Ljava/util/Set;)V", "getConfiguration", "()Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "getSupportedLocales", "()Ljava/util/Set;", "logger", "Lmu/KLogger;", "nlp", "Lai/tock/bot/engine/nlp/NlpController;", "getNlp", "()Lai/tock/bot/engine/nlp/NlpController;", "nlp$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "botDefinition", "Lai/tock/bot/engine/config/BotDefinitionWrapper;", "getBotDefinition", "()Lai/tock/bot/engine/config/BotDefinitionWrapper;", "support", "", "action", "Lai/tock/bot/engine/action/Action;", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "connector", "Lai/tock/bot/engine/ConnectorController;", "connectorData", "Lai/tock/bot/connector/ConnectorData;", "handle", "", "getDialog", "Lai/tock/bot/engine/dialog/Dialog;", "createDialog", "getStory", "Lai/tock/bot/engine/dialog/Story;", "dialog", "parseAction", "Lai/tock/bot/engine/TockConnectorController;", "parseAttachment", "attachment", "Lai/tock/bot/engine/action/SendAttachment;", "parseLocation", "location", "Lai/tock/bot/engine/action/SendLocation;", "parseChoice", "choice", "Lai/tock/bot/engine/action/SendChoice;", "loadProfileIfNotSet", "markAsUnknown", "sendSentence", "Lai/tock/bot/engine/action/SendSentence;", "toString", "", "Companion", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nBot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bot.kt\nai/tock/bot/engine/Bot\n+ 2 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 3 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,285:1\n80#2:286\n277#3:287\n*S KotlinDebug\n*F\n+ 1 Bot.kt\nai/tock/bot/engine/Bot\n*L\n60#1:286\n60#1:287\n*E\n"})
public final class Bot {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final BotApplicationConfiguration configuration;
    @NotNull
    private final Set<Locale> supportedLocales;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final InjectedProperty nlp$delegate;
    @NotNull
    private final BotDefinitionWrapper botDefinition;
    @NotNull
    private static final ThreadLocal<BotBus> currentBus;

    public Bot(@NotNull BotDefinition botDefinitionBase, @NotNull BotApplicationConfiguration configuration, @NotNull Set<Locale> supportedLocales) {
        Intrinsics.checkNotNullParameter((Object)botDefinitionBase, (String)"botDefinitionBase");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(supportedLocales, (String)"supportedLocales");
        this.configuration = configuration;
        this.supportedLocales = supportedLocales;
        this.logger = KotlinLogging.INSTANCE.logger(Bot::logger$lambda$0);
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.nlp$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<NlpController>(){}, tag$iv);
        this.botDefinition = new BotDefinitionWrapper(botDefinitionBase);
    }

    public /* synthetic */ Bot(BotDefinition botDefinition, BotApplicationConfiguration botApplicationConfiguration, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(botDefinition, botApplicationConfiguration, set);
    }

    @NotNull
    public final BotApplicationConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    private final NlpController getNlp() {
        return (NlpController)this.nlp$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final BotDefinitionWrapper getBotDefinition() {
        return this.botDefinition;
    }

    public final double support(@NotNull Action action, @NotNull UserTimeline userTimeline, @NotNull ConnectorController connector, @NotNull ConnectorData connectorData) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)connectorData, (String)"connectorData");
        TockConnectorController cfr_ignored_0 = (TockConnectorController)connector;
        this.loadProfileIfNotSet(connectorData, action, userTimeline, (TockConnectorController)connector);
        Dialog dialog = this.getDialog(action, userTimeline);
        this.parseAction(action, userTimeline, dialog, (TockConnectorController)connector);
        Story story2 = this.getStory(userTimeline, dialog, action);
        TockBotBus bus = new TockBotBus((TockConnectorController)connector, userTimeline, dialog, action, connectorData, this.botDefinition);
        return story2.support(bus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void handle(@NotNull Action action, @NotNull UserTimeline userTimeline, @NotNull ConnectorController connector, @NotNull ConnectorData connectorData) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)connectorData, (String)"connectorData");
        TockConnectorController cfr_ignored_0 = (TockConnectorController)connector;
        this.loadProfileIfNotSet(connectorData, action, userTimeline, (TockConnectorController)connector);
        Dialog dialog = this.getDialog(action, userTimeline);
        this.parseAction(action, userTimeline, dialog, (TockConnectorController)connector);
        boolean shouldRespondBeforeDisabling = false;
        if (userTimeline.getUserState().getBotDisabled() && this.botDefinition.enableBot(userTimeline, dialog, action)) {
            this.logger.debug(() -> Bot.handle$lambda$1(action));
            userTimeline.getUserState().setBotDisabled(false);
            this.botDefinition.getBotEnabledListener().invoke((Object)action);
        } else if (!userTimeline.getUserState().getBotDisabled() && this.botDefinition.disableBot(userTimeline, dialog, action)) {
            this.logger.debug(() -> Bot.handle$lambda$2(action));
            shouldRespondBeforeDisabling = this.botDefinition.hasDisableTagIntent(dialog);
            if (!shouldRespondBeforeDisabling) {
                userTimeline.getUserState().setBotDisabled(true);
            }
        } else if (!this.botDefinition.hasToPersistAction(userTimeline, action)) {
            connectorData.setSaveTimeline(false);
        }
        if (!userTimeline.getUserState().getBotDisabled()) {
            Intent intent = dialog.getState().getCurrentIntent();
            if (intent != null) {
                Intent intent2 = intent;
                boolean bl = false;
                ((TockConnectorController)connector).sendIntent(intent2, action.getApplicationId(), connectorData);
            }
            ((TockConnectorController)connector).startTypingInAnswerTo(action, connectorData);
            Story story2 = this.getStory(userTimeline, dialog, action);
            TockBotBus bus = new TockBotBus((TockConnectorController)connector, userTimeline, dialog, action, connectorData, this.botDefinition);
            if (BotBus.DefaultImpls.isFeatureEnabled$default(bus, DefaultFeatureType.DISABLE_BOT, false, 2, null)) {
                this.logger.info(Bot::handle$lambda$4);
                bus.end((CharSequence)"Bot is disabled", new Object[0]);
                return;
            }
            try {
                currentBus.set(bus);
                story2.handle(bus);
                if (!shouldRespondBeforeDisabling) return;
                userTimeline.getUserState().setBotDisabled(true);
                return;
            }
            finally {
                currentBus.remove();
            }
        }
        userTimeline.getUserState().setBotDisabled(true);
        this.logger.debug(Bot::handle$lambda$5);
    }

    private final Dialog getDialog(Action action, UserTimeline userTimeline) {
        Dialog dialog = userTimeline.getCurrentDialog();
        if (dialog == null) {
            dialog = this.createDialog(action, userTimeline);
        }
        return dialog;
    }

    private final Dialog createDialog(Action action, UserTimeline userTimeline) {
        Object[] objectArray = new PlayerId[]{userTimeline.getPlayerId(), action.getRecipientId()};
        Dialog newDialog = new Dialog(SetsKt.setOf((Object[])objectArray), null, null, null, null, null, null, 126, null);
        userTimeline.getDialogs().add(newDialog);
        return newDialog;
    }

    private final Story getStory(UserTimeline userTimeline, Dialog dialog, Action action) {
        Story story2;
        Intent newIntent = dialog.getState().getCurrentIntent();
        Story previousStory = dialog.getCurrentStory();
        if (previousStory == null || newIntent != null && !previousStory.supportAction(userTimeline, dialog, action, newIntent)) {
            Intent intent = newIntent;
            StoryDefinition storyDefinition = this.botDefinition.findStoryDefinition(intent != null ? intent.getName() : null, action.getApplicationId());
            Story newStory = new Story(storyDefinition, newIntent != null && storyDefinition.isStarterIntent(newIntent) ? newIntent : storyDefinition.mainIntent(), null, null, 12, null);
            Object object = previousStory;
            boolean bl = object != null && (object = ((Story)object).getDefinition()) != null ? object.hasTag(StoryTag.ASK_AGAIN) : false;
            if (bl && dialog.getState().getAskAgainRound$tock_bot_engine() > 0 && !previousStory.supportIntent(newStory.getDefinition().wrappedIntent())) {
                DialogState dialogState = dialog.getState();
                int n = dialogState.getAskAgainRound$tock_bot_engine();
                dialogState.setAskAgainRound$tock_bot_engine(n + -1);
                dialog.getState().setHasCurrentAskAgainProcess$tock_bot_engine(true);
                dialog.getStories().add(previousStory);
                story2 = previousStory;
            } else {
                dialog.getStories().add(newStory);
                story2 = newStory;
            }
        } else {
            story2 = previousStory;
        }
        Story story3 = story2;
        story3.computeCurrentStep(userTimeline, dialog, action, newIntent);
        story3.getActions().add(action);
        Intent intent = dialog.getState().getCurrentIntent();
        action.getState().setIntent(intent != null ? intent.getName() : null);
        action.getState().setStep(story3.getStep$tock_bot_engine());
        return story3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseAction(Action action, UserTimeline userTimeline, Dialog dialog, TockConnectorController connector) {
        try {
            Action action2 = action;
            if (action2 instanceof SendChoice) {
                this.parseChoice((SendChoice)action, dialog);
            } else if (action2 instanceof SendLocation) {
                this.parseLocation((SendLocation)action, dialog);
            } else if (action2 instanceof SendAttachment) {
                this.parseAttachment((SendAttachment)action, dialog);
            } else if (action2 instanceof SendSentence) {
                if (!((SendSentence)action).hasEmptyText()) {
                    this.getNlp().parseSentence((SendSentence)action, userTimeline, dialog, connector, this.botDefinition);
                }
            } else {
                this.logger.warn(() -> Bot.parseAction$lambda$6(action));
            }
        }
        finally {
            dialog.getState().setNextActionState(null);
        }
    }

    private final void parseAttachment(SendAttachment attachment, Dialog dialog) {
        block0: {
            StoryDefinition storyDefinition = this.botDefinition.getHandleAttachmentStory();
            if (storyDefinition == null) break block0;
            StoryDefinition definition = storyDefinition;
            boolean bl = false;
            Intent it = definition.mainIntent();
            boolean bl2 = false;
            dialog.getState().setCurrentIntent(it);
        }
    }

    private final void parseLocation(SendLocation location, Dialog dialog) {
        block0: {
            StoryDefinition storyDefinition = this.botDefinition.getUserLocationStory();
            if (storyDefinition == null) break block0;
            StoryDefinition definition = storyDefinition;
            boolean bl = false;
            Intent it = definition.mainIntent();
            boolean bl2 = false;
            dialog.getState().setCurrentIntent(it);
        }
    }

    private final void parseChoice(SendChoice choice, Dialog dialog) {
        Story currentStory;
        StoryDefinition storyDefinition;
        StoryDefinition previousStory;
        String previousIntentName;
        Intent intent = this.botDefinition.findIntent(choice.getIntentName(), choice.getApplicationId());
        boolean bl = false;
        if (!(Intrinsics.areEqual((Object)intent, (Object)Intent.Companion.getUnknown()) || (previousIntentName = choice.previousIntent$tock_bot_engine()) == null || Intrinsics.areEqual((Object)(previousStory = this.botDefinition.findStoryDefinition(previousIntentName, choice.getApplicationId())), (Object)this.botDefinition.getUnknownStory()) || !previousStory.supportIntent(intent) || !Intrinsics.areEqual((Object)(storyDefinition = this.botDefinition.findStoryDefinition(choice.getIntentName(), choice.getApplicationId())), (Object)this.botDefinition.getUnknownStory()) || (currentStory = dialog.getCurrentStory()) != null && currentStory.supportIntent(intent) && currentStory.supportIntent(this.botDefinition.findIntent(previousIntentName, choice.getApplicationId())))) {
            dialog.getStories().add(new Story(previousStory, intent, null, null, 12, null));
        }
        dialog.getState().setCurrentIntent(intent);
    }

    private final void loadProfileIfNotSet(ConnectorData connectorData, Action action, UserTimeline userTimeline, TockConnectorController connector) {
        UserTimeline $this$loadProfileIfNotSet_u24lambda_u2412 = userTimeline;
        boolean bl = false;
        boolean persistProfile = connector.getConnector().getPersistProfileLoaded();
        if (!persistProfile || !$this$loadProfileIfNotSet_u24lambda_u2412.getUserState().getProfileLoaded()) {
            UserPreferences pref = connector.loadProfile(connectorData, userTimeline.getPlayerId());
            if (pref != null) {
                if (persistProfile) {
                    $this$loadProfileIfNotSet_u24lambda_u2412.getUserState().setProfileLoaded(true);
                    $this$loadProfileIfNotSet_u24lambda_u2412.getUserState().setProfileRefreshed$tock_bot_engine(true);
                    $this$loadProfileIfNotSet_u24lambda_u2412.getUserPreferences().fillWith(pref);
                } else {
                    $this$loadProfileIfNotSet_u24lambda_u2412.getUserPreferences().refreshWith(pref);
                }
            }
        } else if (!$this$loadProfileIfNotSet_u24lambda_u2412.getUserState().getProfileRefreshed$tock_bot_engine()) {
            $this$loadProfileIfNotSet_u24lambda_u2412.getUserState().setProfileRefreshed$tock_bot_engine(true);
            UserPreferences pref = connector.refreshProfile(connectorData, userTimeline.getPlayerId());
            if (pref != null) {
                $this$loadProfileIfNotSet_u24lambda_u2412.getUserPreferences().refreshWith(pref);
            }
        }
        action.getState().setTestEvent($this$loadProfileIfNotSet_u24lambda_u2412.getUserPreferences().getTest());
    }

    public final void markAsUnknown(@NotNull SendSentence sendSentence, @NotNull UserTimeline userTimeline) {
        Intrinsics.checkNotNullParameter((Object)sendSentence, (String)"sendSentence");
        Intrinsics.checkNotNullParameter((Object)userTimeline, (String)"userTimeline");
        this.getNlp().markAsUnknown(sendSentence, userTimeline, this.botDefinition);
    }

    @NotNull
    public String toString() {
        return this.botDefinition + " - " + this.configuration.getName();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object handle$lambda$1(Action $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return "Enable bot for " + $action;
    }

    private static final Object handle$lambda$2(Action $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return "Disable bot for " + $action;
    }

    private static final Object handle$lambda$4() {
        return "bot is disabled for the application";
    }

    private static final Object handle$lambda$5() {
        return "bot is disabled for the user";
    }

    private static final Object parseAction$lambda$6(Action $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return Reflection.getOrCreateKotlinClass($action.getClass()).getSimpleName() + " not yet supported";
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Bot.class, "nlp", "getNlp()Lai/tock/bot/engine/nlp/NlpController;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        currentBus = new ThreadLocal();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/tock/bot/engine/Bot$Companion;", "", "<init>", "()V", "currentBus", "Ljava/lang/ThreadLocal;", "Lai/tock/bot/engine/BotBus;", "retrieveCurrentBus", "retrieveCurrentBus$tock_bot_engine", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BotBus retrieveCurrentBus$tock_bot_engine() {
            return (BotBus)currentBus.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

