/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.connector.Connector;
import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorConfiguration;
import ai.tock.bot.connector.ConnectorData;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.definition.StoryDefinition;
import ai.tock.bot.definition.StoryHandlerDefinition;
import ai.tock.bot.definition.StoryStep;
import ai.tock.bot.engine.Bot;
import ai.tock.bot.engine.BotVerticle;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.ActionNotificationType;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.event.MetadataEvent;
import ai.tock.bot.engine.event.TypingOnEvent;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.UserLock;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.bot.engine.user.UserTimelineDAO;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.stt.STT;
import com.github.salomonbrys.kodein.InjectedProperty;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 S2\u00020\u0001:\u0001SB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207H\u0002J \u00108\u001a\u00020.2\u0006\u00105\u001a\u0002042\u0006\u00109\u001a\u00020:2\u0006\u00101\u001a\u000202H\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u00105\u001a\u0002042\u0006\u00101\u001a\u000202H\u0016J$\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020,2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020.0@H\u0016J\b\u0010B\u001a\u00020.H\u0016J/\u0010C\u001a\u00020.2\u0006\u00101\u001a\u0002022\u0006\u0010D\u001a\u0002042\u0006\u00105\u001a\u0002042\b\b\u0002\u0010E\u001a\u00020FH\u0000\u00a2\u0006\u0002\bGJ\u0018\u0010H\u001a\u0004\u0018\u00010I2\u0006\u00101\u001a\u0002022\u0006\u0010J\u001a\u00020KJ\u0018\u0010L\u001a\u0004\u0018\u00010I2\u0006\u00101\u001a\u0002022\u0006\u0010J\u001a\u00020KJ\u0016\u0010M\u001a\u00020.2\u0006\u00105\u001a\u0002042\u0006\u00101\u001a\u000202J\u001e\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020,2\u0006\u00101\u001a\u000202J\b\u0010R\u001a\u00020,H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001d\u001a\u0004\b%\u0010&R\u0018\u0010(\u001a\f\u0012\b\u0012\u00060*R\u00020\u00070)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lai/tock/bot/engine/TockConnectorController;", "Lai/tock/bot/engine/ConnectorController;", "bot", "Lai/tock/bot/engine/Bot;", "connector", "Lai/tock/bot/connector/Connector;", "verticle", "Lai/tock/bot/engine/BotVerticle;", "botDefinition", "Lai/tock/bot/definition/BotDefinition;", "configuration", "Lai/tock/bot/connector/ConnectorConfiguration;", "<init>", "(Lai/tock/bot/engine/Bot;Lai/tock/bot/connector/Connector;Lai/tock/bot/engine/BotVerticle;Lai/tock/bot/definition/BotDefinition;Lai/tock/bot/connector/ConnectorConfiguration;)V", "getBot", "()Lai/tock/bot/engine/Bot;", "getConnector", "()Lai/tock/bot/connector/Connector;", "getBotDefinition", "()Lai/tock/bot/definition/BotDefinition;", "botConfiguration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "getBotConfiguration", "()Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "executor$delegate", "Lcom/github/salomonbrys/kodein/InjectedProperty;", "userLock", "Lai/tock/bot/engine/user/UserLock;", "getUserLock", "()Lai/tock/bot/engine/user/UserLock;", "userLock$delegate", "userTimelineDAO", "Lai/tock/bot/engine/user/UserTimelineDAO;", "getUserTimelineDAO", "()Lai/tock/bot/engine/user/UserTimelineDAO;", "userTimelineDAO$delegate", "serviceInstallers", "", "Lai/tock/bot/engine/BotVerticle$ServiceInstaller;", "getBaseUrl", "", "handle", "", "event", "Lai/tock/bot/engine/event/Event;", "data", "Lai/tock/bot/connector/ConnectorData;", "tryToParseVoiceAudio", "Lai/tock/bot/engine/action/Action;", "action", "userTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "handleAction", "nbAttempts", "", "support", "", "registerServices", "serviceIdentifier", "installer", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "unregisterServices", "send", "userAction", "delay", "", "send$tock_bot_engine", "loadProfile", "Lai/tock/bot/engine/user/UserPreferences;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "refreshProfile", "startTypingInAnswerTo", "sendIntent", "intent", "Lai/tock/bot/definition/Intent;", "applicationId", "toString", "Companion", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nTockConnectorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TockConnectorController.kt\nai/tock/bot/engine/TockConnectorController\n+ 2 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 3 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 4 IOCs.kt\nai/tock/shared/IOCsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,257:1\n80#2:258\n80#2:260\n80#2:262\n51#2:266\n277#3:259\n277#3:261\n277#3:263\n277#3:267\n53#4,2:264\n1#5:268\n1863#6,2:269\n*S KotlinDebug\n*F\n+ 1 TockConnectorController.kt\nai/tock/bot/engine/TockConnectorController\n*L\n93#1:258\n94#1:260\n95#1:262\n128#1:266\n93#1:259\n94#1:261\n95#1:263\n128#1:267\n128#1:264,2\n223#1:269,2\n*E\n"})
public final class TockConnectorController
implements ConnectorController {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Bot bot;
    @NotNull
    private final Connector connector;
    @NotNull
    private final BotVerticle verticle;
    @NotNull
    private final BotDefinition botDefinition;
    @NotNull
    private final ConnectorConfiguration configuration;
    @NotNull
    private final BotApplicationConfiguration botConfiguration;
    @NotNull
    private final InjectedProperty executor$delegate;
    @NotNull
    private final InjectedProperty userLock$delegate;
    @NotNull
    private final InjectedProperty userTimelineDAO$delegate;
    @NotNull
    private final List<BotVerticle.ServiceInstaller> serviceInstallers;
    @NotNull
    private static final KLogger logger;
    private static final int maxLockedAttempts;
    private static final long lockedAttemptsWaitInMs;
    private static final boolean parseAudioFileEnabled;
    private static final int audioNlpFileLimit;

    public TockConnectorController(@NotNull Bot bot, @NotNull Connector connector, @NotNull BotVerticle verticle, @NotNull BotDefinition botDefinition, @NotNull ConnectorConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        Intrinsics.checkNotNullParameter((Object)botDefinition, (String)"botDefinition");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.bot = bot;
        this.connector = connector;
        this.verticle = verticle;
        this.botDefinition = botDefinition;
        this.configuration = configuration;
        this.botConfiguration = this.bot.getConfiguration();
        KodeinInjectedBase $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        Object tag$iv = null;
        KodeinInjector kodeinInjector = $receiver$iv.getInjector();
        this.executor$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<Executor>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        this.userLock$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<UserLock>(){}, tag$iv);
        $receiver$iv = (KodeinInjectedBase)IOCsKt.getInjector();
        tag$iv = null;
        kodeinInjector = $receiver$iv.getInjector();
        this.userTimelineDAO$delegate = kodeinInjector.Instance((TypeToken)new TypeReference<UserTimelineDAO>(){}, tag$iv);
        this.serviceInstallers = new CopyOnWriteArrayList();
    }

    @NotNull
    public final Bot getBot() {
        return this.bot;
    }

    @Override
    @NotNull
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    @NotNull
    public BotDefinition getBotDefinition() {
        return this.botDefinition;
    }

    @Override
    @NotNull
    public BotApplicationConfiguration getBotConfiguration() {
        return this.botConfiguration;
    }

    private final Executor getExecutor() {
        return (Executor)this.executor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final UserLock getUserLock() {
        return (UserLock)this.userLock$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final UserTimelineDAO getUserTimelineDAO() {
        return (UserTimelineDAO)this.userTimelineDAO$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.configuration.getBaseUrl();
    }

    @Override
    public void handle(@NotNull Event event, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (event.getState().getSourceConnectorType() == null) {
            event.getState().setSourceConnectorType(this.getConnector().getConnectorType());
        }
        if (event.getState().getTargetConnectorType() == null) {
            event.getState().setTargetConnectorType(this.getConnector().getConnectorType());
        }
        ConnectorCallback callback = data.getCallback();
        try {
            if (!this.getBotDefinition().getEventListener().listenEvent(this, data, event)) {
                if (event instanceof Action) {
                    this.handleAction((Action)event, 0, data);
                } else {
                    callback.eventSkipped(event);
                }
            } else {
                callback.eventAnswered(event);
            }
        }
        catch (Throwable t) {
            callback.exceptionThrown(event, t);
        }
    }

    private final Action tryToParseVoiceAudio(Action action, UserTimeline userTimeline) {
        byte[] bytes;
        if (parseAudioFileEnabled && action instanceof SendAttachment && ((SendAttachment)action).getType() == SendAttachment.AttachmentType.audio && (bytes = TextStreamsKt.readBytes((URL)new URL(((SendAttachment)action).getUrl()))).length < audioNlpFileLimit) {
            KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
            Object tag$iv = null;
            boolean $i$f$provide = false;
            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
            STT stt = (STT)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<STT>(){}, tag$iv).getValue()).invoke();
            String text = stt.parse(bytes, userTimeline.getUserPreferences().getLocale());
            if (text != null) {
                return new SendSentence(action.getPlayerId(), action.getApplicationId(), action.getRecipientId(), text, null, null, null, null, null, null, null, 2032, null);
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAction(Action action, int nbAttempts, ConnectorData data) {
        block11: {
            ConnectorCallback callback = data.getCallback();
            try {
                PlayerId playerId = action.getPlayerId();
                String id = playerId.getId();
                logger.debug(() -> TockConnectorController.handleAction$lambda$0(playerId));
                if (this.getUserLock().lock(id)) {
                    try {
                        callback.userLocked(action);
                        UserTimeline userTimeline = this.getUserTimelineDAO().loadWithLastValidDialog(this.getBotDefinition().getNamespace(), action.getPlayerId(), data.getPriorUserId(), data.getGroupId(), this.storyDefinitionLoader(action.getApplicationId()));
                        Action transformedAction = this.tryToParseVoiceAudio(action, userTimeline);
                        this.bot.handle(transformedAction, userTimeline, this, data);
                        if (data.getSaveTimeline()) {
                            UserTimelineDAO.DefaultImpls.save$default(this.getUserTimelineDAO(), userTimeline, this.bot.getBotDefinition(), false, 4, null);
                        }
                        break block11;
                    }
                    catch (Throwable t) {
                        TockConnectorController.send$tock_bot_engine$default(this, data, action, this.errorMessage(action.getRecipientId(), action.getApplicationId(), action.getPlayerId()), 0L, 8, null);
                        callback.exceptionThrown(action, t);
                        break block11;
                    }
                    finally {
                        this.getUserLock().releaseLock(id);
                        callback.userLockReleased(action);
                    }
                }
                if (nbAttempts < maxLockedAttempts) {
                    logger.debug(() -> TockConnectorController.handleAction$lambda$1(playerId));
                    Executor executor = this.getExecutor();
                    Duration duration = Duration.ofMillis(lockedAttemptsWaitInMs);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                    executor.executeBlocking(duration, () -> TockConnectorController.handleAction$lambda$2(this, action, nbAttempts, data));
                } else {
                    logger.debug(() -> TockConnectorController.handleAction$lambda$3(playerId, action));
                    callback.eventSkipped(action);
                }
            }
            catch (Throwable t) {
                callback.exceptionThrown(action, t);
            }
        }
    }

    @Override
    public double support(@NotNull Action action, @NotNull ConnectorData data) {
        double d;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (action.getState().getTargetConnectorType() == null) {
            action.getState().setTargetConnectorType(this.getConnector().getConnectorType());
        }
        ConnectorCallback callback = data.getCallback();
        try {
            UserTimeline userTimeline = this.getUserTimelineDAO().loadWithLastValidDialog(this.getBotDefinition().getNamespace(), action.getPlayerId(), data.getPriorUserId(), data.getGroupId(), this.storyDefinitionLoader(action.getApplicationId()));
            d = this.bot.support(action, userTimeline, this, data);
        }
        catch (Throwable t) {
            callback.exceptionThrown(action, t);
            d = 0.0;
        }
        return d;
    }

    @Override
    public void registerServices(@NotNull String serviceIdentifier, @NotNull Function1<? super Router, Unit> installer) {
        BotVerticle.ServiceInstaller serviceInstaller;
        Intrinsics.checkNotNullParameter((Object)serviceIdentifier, (String)"serviceIdentifier");
        Intrinsics.checkNotNullParameter(installer, (String)"installer");
        BotVerticle.ServiceInstaller it = serviceInstaller = this.verticle.registerServices(serviceIdentifier, (Function1<? super Router, ? extends Object>)((Function1)arg_0 -> TockConnectorController.registerServices$lambda$5(serviceIdentifier, installer, arg_0)));
        boolean bl = false;
        this.serviceInstallers.add(it);
    }

    @Override
    public void unregisterServices() {
        Iterable $this$forEach$iv = this.serviceInstallers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BotVerticle.ServiceInstaller it = (BotVerticle.ServiceInstaller)element$iv;
            boolean bl = false;
            this.verticle.unregisterServices(it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send$tock_bot_engine(@NotNull ConnectorData data, @NotNull Action userAction, @NotNull Action action, long delay) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)userAction, (String)"userAction");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        try {
            logger.debug(() -> TockConnectorController.send$lambda$8(action));
            this.getConnector().send(action, data.getCallback(), delay);
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)logger, (Throwable)t);
        }
        finally {
            if (action.getMetadata().getLastAnswer()) {
                data.getCallback().eventAnswered(userAction);
            }
        }
    }

    public static /* synthetic */ void send$tock_bot_engine$default(TockConnectorController tockConnectorController, ConnectorData connectorData, Action action, Action action2, long l, int n, Object object) {
        if ((n & 8) != 0) {
            l = 0L;
        }
        tockConnectorController.send$tock_bot_engine(connectorData, action, action2, l);
    }

    @Nullable
    public final UserPreferences loadProfile(@NotNull ConnectorData data, @NotNull PlayerId playerId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.getConnector().loadProfile(data.getCallback(), playerId);
    }

    @Nullable
    public final UserPreferences refreshProfile(@NotNull ConnectorData data, @NotNull PlayerId playerId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        return this.getConnector().refreshProfile(data.getCallback(), playerId);
    }

    public final void startTypingInAnswerTo(@NotNull Action action, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Connector.DefaultImpls.send$default(this.getConnector(), new TypingOnEvent(action.getPlayerId(), action.getApplicationId()), data.getCallback(), 0L, 4, null);
    }

    public final void sendIntent(@NotNull Intent intent, @NotNull String applicationId, @NotNull ConnectorData data) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Connector.DefaultImpls.send$default(this.getConnector(), MetadataEvent.Companion.intent(intent, applicationId), data.getCallback(), 0L, 4, null);
    }

    @NotNull
    public String toString() {
        return this.configuration.toString();
    }

    @Override
    @NotNull
    public ConnectorType getConnectorType() {
        return ConnectorController.DefaultImpls.getConnectorType(this);
    }

    @Override
    public void notify(@NotNull PlayerId recipientId, @NotNull IntentAware intent, @Nullable StoryStep<? extends StoryHandlerDefinition> step, @NotNull Map<String, String> parameters, @Nullable ActionNotificationType notificationType, @NotNull Function1<? super Throwable, Unit> errorListener) {
        ConnectorController.DefaultImpls.notify(this, recipientId, intent, step, parameters, notificationType, errorListener);
    }

    @Override
    @NotNull
    public Action errorMessage(@NotNull PlayerId playerId, @NotNull String applicationId, @NotNull PlayerId recipientId) {
        return ConnectorController.DefaultImpls.errorMessage(this, playerId, applicationId, recipientId);
    }

    @Override
    @NotNull
    public Function1<String, StoryDefinition> storyDefinitionLoader(@NotNull String applicationId) {
        return ConnectorController.DefaultImpls.storyDefinitionLoader(this, applicationId);
    }

    private static final Object handleAction$lambda$0(PlayerId $playerId) {
        Intrinsics.checkNotNullParameter((Object)$playerId, (String)"$playerId");
        return "try to lock " + $playerId;
    }

    private static final Object handleAction$lambda$1(PlayerId $playerId) {
        Intrinsics.checkNotNullParameter((Object)$playerId, (String)"$playerId");
        return $playerId + " locked - wait";
    }

    private static final Unit handleAction$lambda$2(TockConnectorController this$0, Action $action, int $nbAttempts, ConnectorData $data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        this$0.handleAction($action, $nbAttempts + 1, $data);
        return Unit.INSTANCE;
    }

    private static final Object handleAction$lambda$3(PlayerId $playerId, Action $action) {
        Intrinsics.checkNotNullParameter((Object)$playerId, (String)"$playerId");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return $playerId + " locked for " + maxLockedAttempts + " times - skip " + $action;
    }

    private static final void registerServices$lambda$5$lambda$4(RoutingContext it) {
        it.response().end();
    }

    private static final Unit registerServices$lambda$5(String $serviceIdentifier, Function1 $installer, Router router) {
        Intrinsics.checkNotNullParameter((Object)$serviceIdentifier, (String)"$serviceIdentifier");
        Intrinsics.checkNotNullParameter((Object)$installer, (String)"$installer");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        router.get($serviceIdentifier + "/healthcheck").handler(TockConnectorController::registerServices$lambda$5$lambda$4);
        $installer.invoke((Object)router);
        return Unit.INSTANCE;
    }

    private static final Object send$lambda$8(Action $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return "message sent to connector: " + $action;
    }

    private static final Unit logger$lambda$9() {
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "executor", "getExecutor()Lai/tock/shared/Executor;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "userLock", "getUserLock()Lai/tock/bot/engine/user/UserLock;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TockConnectorController.class, "userTimelineDAO", "getUserTimelineDAO()Lai/tock/bot/engine/user/UserTimelineDAO;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger(TockConnectorController::logger$lambda$9);
        maxLockedAttempts = PropertiesKt.intProperty((String)"tock_bot_max_locked_attempts", (int)10);
        lockedAttemptsWaitInMs = PropertiesKt.longProperty((String)"tock_bot_locked_attempts_wait_in_ms", (long)500L);
        parseAudioFileEnabled = PropertiesKt.booleanProperty((String)"tock_bot_audio_nlp_enabled", (boolean)true);
        audioNlpFileLimit = PropertiesKt.intProperty((String)"tock_bot_audio_nlp_max_size", (int)0x100000);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/tock/bot/engine/TockConnectorController$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "maxLockedAttempts", "", "lockedAttemptsWaitInMs", "", "parseAudioFileEnabled", "", "audioNlpFileLimit", "register", "Lai/tock/bot/engine/TockConnectorController;", "connector", "Lai/tock/bot/connector/Connector;", "bot", "Lai/tock/bot/engine/Bot;", "verticle", "Lai/tock/bot/engine/BotVerticle;", "configuration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "register$tock_bot_engine", "unregister", "", "controller", "unregister$tock_bot_engine", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TockConnectorController register$tock_bot_engine(@NotNull Connector connector, @NotNull Bot bot, @NotNull BotVerticle verticle, @NotNull BotApplicationConfiguration configuration) {
            TockConnectorController tockConnectorController;
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
            Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            TockConnectorController $this$register_u24lambda_u241 = tockConnectorController = new TockConnectorController(bot, connector, verticle, bot.getBotDefinition(), new ConnectorConfiguration(configuration));
            boolean bl = false;
            logger.info(() -> Companion.register$lambda$1$lambda$0(connector, bot));
            connector.register($this$register_u24lambda_u241);
            return tockConnectorController;
        }

        public final void unregister$tock_bot_engine(@NotNull TockConnectorController controller) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            logger.info(() -> Companion.unregister$lambda$2(controller));
            controller.getConnector().unregister(controller);
        }

        private static final Object register$lambda$1$lambda$0(Connector $connector, Bot $bot) {
            Intrinsics.checkNotNullParameter((Object)$connector, (String)"$connector");
            Intrinsics.checkNotNullParameter((Object)$bot, (String)"$bot");
            return "Register connector " + $connector + " for bot " + $bot;
        }

        private static final Object unregister$lambda$2(TockConnectorController $controller) {
            Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
            return "Unregister connector " + $controller.getConnector() + " for bot " + $controller.getBot();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

