/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.dialog;

import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lai/tock/bot/engine/dialog/FlowAnalyticsQuery;", "", "namespace", "", "applicationName", "nlpModel", "from", "Ljava/time/LocalDateTime;", "to", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDateTime;Ljava/time/LocalDateTime;)V", "getNamespace", "()Ljava/lang/String;", "getApplicationName", "getNlpModel", "getFrom", "()Ljava/time/LocalDateTime;", "getTo", "formatQuery", "tock-bot-engine"})
public final class FlowAnalyticsQuery {
    @NotNull
    private final String namespace;
    @NotNull
    private final String applicationName;
    @NotNull
    private final String nlpModel;
    @NotNull
    private final LocalDateTime from;
    @NotNull
    private final LocalDateTime to;

    public FlowAnalyticsQuery(@NotNull String namespace, @NotNull String applicationName, @NotNull String nlpModel, @NotNull LocalDateTime from, @NotNull LocalDateTime to) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)nlpModel, (String)"nlpModel");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.namespace = namespace;
        this.applicationName = applicationName;
        this.nlpModel = nlpModel;
        this.from = from;
        this.to = to;
    }

    public /* synthetic */ FlowAnalyticsQuery(String string, String string2, String string3, LocalDateTime localDateTime, LocalDateTime localDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            localDateTime = LocalDateTime.now().minusDays(7L);
        }
        if ((n & 0x10) != 0) {
            localDateTime2 = LocalDateTime.now();
        }
        this(string, string2, string3, localDateTime, localDateTime2);
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getApplicationName() {
        return this.applicationName;
    }

    @NotNull
    public final String getNlpModel() {
        return this.nlpModel;
    }

    @NotNull
    public final LocalDateTime getFrom() {
        return this.from;
    }

    @NotNull
    public final LocalDateTime getTo() {
        return this.to;
    }

    @NotNull
    public final FlowAnalyticsQuery formatQuery() {
        LocalDateTime localDateTime = LocalDateTime.of(this.from.toLocalDate(), LocalTime.MIDNIGHT);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        LocalDateTime localDateTime2 = LocalDateTime.of(this.to.toLocalDate(), LocalTime.MAX);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"of(...)");
        return new FlowAnalyticsQuery(this.namespace, this.applicationName, this.nlpModel, localDateTime, localDateTime2);
    }
}

