/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.user;

import ai.tock.bot.engine.user.TimeBoxedFlag;
import ai.tock.shared.PropertiesKt;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/B'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0006J\u001e\u0010 \u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0006J\u001e\u0010 \u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0006J\u0016\u0010&\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010*\u001a\u00020\u00112\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R$\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u00060"}, d2={"Lai/tock/bot/engine/user/UserState;", "", "creationDate", "Ljava/time/Instant;", "flags", "", "", "Lai/tock/bot/engine/user/TimeBoxedFlag;", "<init>", "(Ljava/time/Instant;Ljava/util/Map;)V", "getCreationDate", "()Ljava/time/Instant;", "getFlags", "()Ljava/util/Map;", "cleanup", "", "value", "", "profileLoaded", "getProfileLoaded", "()Z", "setProfileLoaded", "(Z)V", "profileRefreshed", "getProfileRefreshed$tock_bot_engine", "setProfileRefreshed$tock_bot_engine", "botDisabled", "getBotDisabled", "setBotDisabled", "getFlag", "flag", "hasFlag", "setFlag", "timeoutInMinutes", "", "timeoutDuration", "Ljava/time/Duration;", "removeFlag", "setUnlimitedFlag", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "tock-bot-engine"})
public final class UserState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant creationDate;
    @NotNull
    private final Map<String, TimeBoxedFlag> flags;
    @NotNull
    private static final String PROFILE_LOADED_FLAG = "tock_profile_loaded";
    @NotNull
    private static final String PROFILE_REFRESHED_FLAG = "tock_profile_refreshed";
    @NotNull
    private static final String BOT_DISABLED_FLAG = "tock_bot_disabled";
    private static final long refreshDuration = PropertiesKt.longProperty((String)"tock_bot_refresh_profil_duration_in_minutes", (long)7200L);
    private static final long disabledDuration = PropertiesKt.longProperty((String)"tock_bot_disabled_duration_in_minutes", (long)7200L);

    public UserState(@NotNull Instant creationDate, @NotNull Map<String, TimeBoxedFlag> flags) {
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.creationDate = creationDate;
        this.flags = flags;
    }

    public /* synthetic */ UserState(Instant instant, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            instant = Instant.now();
        }
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(instant, map);
    }

    @NotNull
    public final Instant getCreationDate() {
        return this.creationDate;
    }

    @NotNull
    public final Map<String, TimeBoxedFlag> getFlags() {
        return this.flags;
    }

    public final void cleanup() {
        this.flags.clear();
    }

    public final boolean getProfileLoaded() {
        String string = this.getFlag(PROFILE_LOADED_FLAG);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final void setProfileLoaded(boolean value) {
        if (value) {
            this.setUnlimitedFlag(PROFILE_LOADED_FLAG, String.valueOf(value));
        } else {
            this.removeFlag(PROFILE_LOADED_FLAG);
        }
    }

    public final boolean getProfileRefreshed$tock_bot_engine() {
        String string = this.getFlag(PROFILE_REFRESHED_FLAG);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final void setProfileRefreshed$tock_bot_engine(boolean value) {
        if (value) {
            this.setFlag(PROFILE_REFRESHED_FLAG, refreshDuration, "true");
        } else {
            this.removeFlag(PROFILE_REFRESHED_FLAG);
        }
    }

    public final boolean getBotDisabled() {
        String string = this.getFlag(BOT_DISABLED_FLAG);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final void setBotDisabled(boolean value) {
        if (value) {
            this.setFlag(BOT_DISABLED_FLAG, disabledDuration, "true");
        } else {
            this.removeFlag(BOT_DISABLED_FLAG);
        }
    }

    @Nullable
    public final String getFlag(@NotNull String flag) {
        TimeBoxedFlag f;
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        TimeBoxedFlag timeBoxedFlag = f = this.flags.get(flag);
        return (timeBoxedFlag != null ? timeBoxedFlag.isValid() : false) ? f.getValue() : null;
    }

    public final boolean hasFlag(@NotNull String flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getFlag(flag) != null;
    }

    public final void setFlag(@NotNull String flag, long timeoutInMinutes, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Duration duration = Duration.ofMinutes(timeoutInMinutes);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        this.setFlag(flag, duration, value);
    }

    public final void setFlag(@NotNull String flag, @NotNull Duration timeoutDuration, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)timeoutDuration, (String)"timeoutDuration");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.flags.put(flag, new TimeBoxedFlag(value, Instant.now().plus(timeoutDuration)));
    }

    public final void removeFlag(@NotNull String flag) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        this.flags.remove(flag);
    }

    public final void setUnlimitedFlag(@NotNull String flag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.flags.put(flag, new TimeBoxedFlag(value, null));
    }

    @NotNull
    public final Instant component1() {
        return this.creationDate;
    }

    @NotNull
    public final Map<String, TimeBoxedFlag> component2() {
        return this.flags;
    }

    @NotNull
    public final UserState copy(@NotNull Instant creationDate, @NotNull Map<String, TimeBoxedFlag> flags) {
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        return new UserState(creationDate, flags);
    }

    public static /* synthetic */ UserState copy$default(UserState userState, Instant instant, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            instant = userState.creationDate;
        }
        if ((n & 2) != 0) {
            map = userState.flags;
        }
        return userState.copy(instant, map);
    }

    @NotNull
    public String toString() {
        return "UserState(creationDate=" + this.creationDate + ", flags=" + this.flags + ")";
    }

    public int hashCode() {
        int result = this.creationDate.hashCode();
        result = result * 31 + ((Object)this.flags).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UserState)) {
            return false;
        }
        UserState userState = (UserState)other;
        if (!Intrinsics.areEqual((Object)this.creationDate, (Object)userState.creationDate)) {
            return false;
        }
        return Intrinsics.areEqual(this.flags, userState.flags);
    }

    public UserState() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/tock/bot/engine/user/UserState$Companion;", "", "<init>", "()V", "PROFILE_LOADED_FLAG", "", "PROFILE_REFRESHED_FLAG", "BOT_DISABLED_FLAG", "refreshDuration", "", "disabledDuration", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

