/*
 * Copyright (C) 2017/2021 e-voyageurs technologies
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ai.tock.bot.admin.dialog

import ai.tock.bot.engine.dialog.Dialog
import ai.tock.translator.UserInterfaceType
import org.litote.kmongo.Id
import org.litote.kmongo.newId

/**
 *
 */
data class DialogReport(
    val actions: List<ActionReport> = emptyList(),
    val userInterface: UserInterfaceType,
    val id: Id<Dialog> = newId(),
    val obfuscated: Boolean = false,
    val rating : Int? = null,
    val review : String? = null
)
