/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector;

import ai.tock.bot.connector.ConnectorCallback;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.monitoring.RequestTimerData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/bot/connector/ConnectorCallbackBase;", "Lai/tock/bot/connector/ConnectorCallback;", "applicationId", "", "connectorType", "Lai/tock/bot/connector/ConnectorType;", "<init>", "(Ljava/lang/String;Lai/tock/bot/connector/ConnectorType;)V", "getApplicationId", "()Ljava/lang/String;", "getConnectorType", "()Lai/tock/bot/connector/ConnectorType;", "requestTimerData", "Lai/tock/bot/engine/monitoring/RequestTimerData;", "lockTimerData", "userLocked", "", "event", "Lai/tock/bot/engine/event/Event;", "userLockReleased", "eventSkipped", "eventAnswered", "exceptionThrown", "throwable", "", "Companion", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nConnectorCallbackBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorCallbackBase.kt\nai/tock/bot/connector/ConnectorCallbackBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public class ConnectorCallbackBase
implements ConnectorCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final ConnectorType connectorType;
    @NotNull
    private final RequestTimerData requestTimerData;
    @Nullable
    private RequestTimerData lockTimerData;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ConnectorCallbackBase::logger$lambda$4);

    public ConnectorCallbackBase(@NotNull String applicationId, @NotNull ConnectorType connectorType) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)connectorType, (String)"connectorType");
        this.applicationId = applicationId;
        this.connectorType = connectorType;
        this.requestTimerData = BotRepository.INSTANCE.getRequestTimer().start(this.connectorType.getId() + "_response");
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final ConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Override
    public void userLocked(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.lockTimerData = BotRepository.INSTANCE.getRequestTimer().start(this.connectorType.getId() + "_user_lock");
    }

    @Override
    public void userLockReleased(@NotNull Event event) {
        block0: {
            RequestTimerData requestTimerData;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            logger.trace(() -> ConnectorCallbackBase.userLockReleased$lambda$0(event));
            RequestTimerData requestTimerData2 = this.lockTimerData;
            if (requestTimerData2 == null) break block0;
            RequestTimerData it = requestTimerData = requestTimerData2;
            boolean bl = false;
            BotRepository.INSTANCE.getRequestTimer().end(it);
        }
    }

    @Override
    public void eventSkipped(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.warn(() -> ConnectorCallbackBase.eventSkipped$lambda$2(event));
        BotRepository.INSTANCE.getRequestTimer().error("event skipped: " + event, this.requestTimerData);
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    @Override
    public void eventAnswered(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.trace(() -> ConnectorCallbackBase.eventAnswered$lambda$3(event));
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    @Override
    public void exceptionThrown(@NotNull Event event, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        logger.error("error thown for " + event, throwable);
        BotRepository.INSTANCE.getRequestTimer().throwable(throwable, this.requestTimerData);
        BotRepository.INSTANCE.getRequestTimer().end(this.requestTimerData);
    }

    private static final Object userLockReleased$lambda$0(Event $event) {
        return "lock released for " + $event;
    }

    private static final Object eventSkipped$lambda$2(Event $event) {
        return "event skipped: " + $event;
    }

    private static final Object eventAnswered$lambda$3(Event $event) {
        return "event answered: " + $event;
    }

    private static final Unit logger$lambda$4() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/tock/bot/connector/ConnectorCallbackBase$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tock-bot-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

