/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.connector;

import ai.tock.bot.engine.action.Action;
import ai.tock.shared.Executor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0\u0012JA\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/tock/bot/connector/ConnectorQueue;", "", "executor", "Lai/tock/shared/Executor;", "<init>", "(Lai/tock/shared/Executor;)V", "messagesByRecipientMap", "Lcom/google/common/cache/Cache;", "", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lai/tock/bot/connector/ConnectorQueue$ActionWithTimestamp;", "add", "", "action", "Lai/tock/bot/engine/action/Action;", "delayInMs", "", "send", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "sendActionFromConnector", "queue", "ActionWithTimestamp", "tock-bot-engine"})
public final class ConnectorQueue {
    @NotNull
    private final Executor executor;
    @NotNull
    private final Cache<String, ConcurrentLinkedQueue<ActionWithTimestamp>> messagesByRecipientMap;

    public ConnectorQueue(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        Cache cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.messagesByRecipientMap = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull Action action, long delayInMs, @NotNull Function1<? super Action, Unit> send) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(send, (String)"send");
        ActionWithTimestamp actionWrapper = new ActionWithTimestamp(action, System.currentTimeMillis() + delayInMs);
        Object object = this.messagesByRecipientMap.get((Object)action.getRecipientId().getId(), ConnectorQueue::add$lambda$0);
        ConcurrentLinkedQueue $this$add_u24lambda_u243 = (ConcurrentLinkedQueue)object;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$add_u24lambda_u243);
        ConcurrentLinkedQueue concurrentLinkedQueue = $this$add_u24lambda_u243;
        synchronized (concurrentLinkedQueue) {
            boolean bl2 = false;
            Object e = $this$add_u24lambda_u243.peek();
            ActionWithTimestamp existingAction = (ActionWithTimestamp)e;
            boolean bl3 = false;
            $this$add_u24lambda_u243.offer(actionWrapper);
            if (existingAction != null) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        ConcurrentLinkedQueue queue = (ConcurrentLinkedQueue)object;
        Duration duration = Duration.ofMillis(delayInMs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        this.executor.executeBlocking(duration, () -> ConnectorQueue.add$lambda$4(this, actionWrapper, queue, send));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendActionFromConnector(ActionWithTimestamp action, ConcurrentLinkedQueue<ActionWithTimestamp> queue, Function1<? super Action, Unit> send) {
        try {
            long timeToWait = action.getTimestamp() - System.currentTimeMillis();
            if (timeToWait > 0L) {
                Thread.sleep(timeToWait);
            }
            send.invoke((Object)action.getAction());
        }
        finally {
            ActionWithTimestamp $i$a$-synchronized-ConnectorQueue$sendActionFromConnector$22;
            Object object = queue;
            synchronized (object) {
                boolean $i$a$-synchronized-ConnectorQueue$sendActionFromConnector$22 = false;
                queue.poll();
                $i$a$-synchronized-ConnectorQueue$sendActionFromConnector$22 = queue.peek();
            }
            ActionWithTimestamp actionWithTimestamp = $i$a$-synchronized-ConnectorQueue$sendActionFromConnector$22;
            if (actionWithTimestamp != null) {
                Object a = object = actionWithTimestamp;
                boolean bl = false;
                this.sendActionFromConnector((ActionWithTimestamp)a, queue, send);
            }
        }
    }

    private static final ConcurrentLinkedQueue add$lambda$0() {
        return new ConcurrentLinkedQueue();
    }

    private static final Unit add$lambda$4(ConnectorQueue this$0, ActionWithTimestamp $actionWrapper, ConcurrentLinkedQueue $queue, Function1 $send) {
        Intrinsics.checkNotNull((Object)$queue);
        this$0.sendActionFromConnector($actionWrapper, $queue, (Function1<? super Action, Unit>)$send);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lai/tock/bot/connector/ConnectorQueue$ActionWithTimestamp;", "", "action", "Lai/tock/bot/engine/action/Action;", "timestamp", "", "<init>", "(Lai/tock/bot/engine/action/Action;J)V", "getAction", "()Lai/tock/bot/engine/action/Action;", "getTimestamp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tock-bot-engine"})
    private static final class ActionWithTimestamp {
        @NotNull
        private final Action action;
        private final long timestamp;

        public ActionWithTimestamp(@NotNull Action action, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            this.action = action;
            this.timestamp = timestamp;
        }

        @NotNull
        public final Action getAction() {
            return this.action;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Action component1() {
            return this.action;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final ActionWithTimestamp copy(@NotNull Action action, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            return new ActionWithTimestamp(action, timestamp);
        }

        public static /* synthetic */ ActionWithTimestamp copy$default(ActionWithTimestamp actionWithTimestamp, Action action, long l, int n, Object object) {
            if ((n & 1) != 0) {
                action = actionWithTimestamp.action;
            }
            if ((n & 2) != 0) {
                l = actionWithTimestamp.timestamp;
            }
            return actionWithTimestamp.copy(action, l);
        }

        @NotNull
        public String toString() {
            return "ActionWithTimestamp(action=" + this.action + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = this.action.hashCode();
            result = result * 31 + Long.hashCode(this.timestamp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActionWithTimestamp)) {
                return false;
            }
            ActionWithTimestamp actionWithTimestamp = (ActionWithTimestamp)other;
            if (!Intrinsics.areEqual((Object)this.action, (Object)actionWithTimestamp.action)) {
                return false;
            }
            return this.timestamp == actionWithTimestamp.timestamp;
        }
    }
}

