/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.message;

import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.Footnote;
import ai.tock.bot.engine.action.SendSentenceWithFootnotes;
import ai.tock.bot.engine.event.EventType;
import ai.tock.bot.engine.message.Message;
import ai.tock.bot.engine.user.PlayerId;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J-\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lai/tock/bot/engine/message/SentenceWithFootnotes;", "Lai/tock/bot/engine/message/Message;", "text", "", "footnotes", "", "Lai/tock/bot/engine/action/Footnote;", "delay", "", "<init>", "(Ljava/lang/String;Ljava/util/List;J)V", "getText", "()Ljava/lang/String;", "getFootnotes", "()Ljava/util/List;", "getDelay", "()J", "eventType", "Lai/tock/bot/engine/event/EventType;", "getEventType", "()Lai/tock/bot/engine/event/EventType;", "toAction", "Lai/tock/bot/engine/action/Action;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "applicationId", "recipientId", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "tock-bot-engine"})
public final class SentenceWithFootnotes
implements Message {
    @NotNull
    private final String text;
    @NotNull
    private final List<Footnote> footnotes;
    private final long delay;
    @NotNull
    private final EventType eventType;

    public SentenceWithFootnotes(@NotNull String text, @NotNull List<Footnote> footnotes, long delay) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(footnotes, (String)"footnotes");
        this.text = text;
        this.footnotes = footnotes;
        this.delay = delay;
        this.eventType = EventType.sentenceWithFootnotes;
    }

    public /* synthetic */ SentenceWithFootnotes(String string, List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        this(string, list, l);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Footnote> getFootnotes() {
        return this.footnotes;
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    @NotNull
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    @NotNull
    public Action toAction(@NotNull PlayerId playerId, @NotNull String applicationId, @NotNull PlayerId recipientId) {
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)recipientId, (String)"recipientId");
        return new SendSentenceWithFootnotes(playerId, applicationId, recipientId, this.text, CollectionsKt.toMutableList((Collection)this.footnotes), null, null, null, null, 480, null);
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<Footnote> component2() {
        return this.footnotes;
    }

    public final long component3() {
        return this.delay;
    }

    @NotNull
    public final SentenceWithFootnotes copy(@NotNull String text, @NotNull List<Footnote> footnotes, long delay) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(footnotes, (String)"footnotes");
        return new SentenceWithFootnotes(text, footnotes, delay);
    }

    public static /* synthetic */ SentenceWithFootnotes copy$default(SentenceWithFootnotes sentenceWithFootnotes, String string, List list, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = sentenceWithFootnotes.text;
        }
        if ((n & 2) != 0) {
            list = sentenceWithFootnotes.footnotes;
        }
        if ((n & 4) != 0) {
            l = sentenceWithFootnotes.delay;
        }
        return sentenceWithFootnotes.copy(string, list, l);
    }

    @NotNull
    public String toString() {
        return "SentenceWithFootnotes(text=" + this.text + ", footnotes=" + this.footnotes + ", delay=" + this.delay + ")";
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = result * 31 + ((Object)this.footnotes).hashCode();
        result = result * 31 + Long.hashCode(this.delay);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SentenceWithFootnotes)) {
            return false;
        }
        SentenceWithFootnotes sentenceWithFootnotes = (SentenceWithFootnotes)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)sentenceWithFootnotes.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.footnotes, sentenceWithFootnotes.footnotes)) {
            return false;
        }
        return this.delay == sentenceWithFootnotes.delay;
    }

    @Override
    @NotNull
    public Action toAction(@NotNull BotBus bus) {
        return Message.DefaultImpls.toAction(this, bus);
    }

    @Override
    @NotNull
    public String toPrettyString() {
        return Message.DefaultImpls.toPrettyString(this);
    }

    @Override
    @NotNull
    public Message obfuscate() {
        return Message.DefaultImpls.obfuscate(this);
    }

    @Override
    public boolean isSimpleMessage() {
        return Message.DefaultImpls.isSimpleMessage(this);
    }
}

