/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/bot/engine/nlp/NlpProxyBotService;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tockNlpProxyOnBotPath", "", "tockNlpServiceHost", "tockNlpServicePort", "", "tockNlpServiceSsl", "", "nonForwardedHeaders", "", "configure", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "vertx", "Lio/vertx/core/Vertx;", "httpProxyToNlp", "context", "Lio/vertx/ext/web/RoutingContext;", "httpMethod", "Lio/vertx/core/http/HttpMethod;", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nNlpProxyBotService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpProxyBotService.kt\nai/tock/bot/engine/nlp/NlpProxyBotService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n1863#3,2:117\n*S KotlinDebug\n*F\n+ 1 NlpProxyBotService.kt\nai/tock/bot/engine/nlp/NlpProxyBotService\n*L\n89#1:117,2\n*E\n"})
public final class NlpProxyBotService {
    @NotNull
    public static final NlpProxyBotService INSTANCE = new NlpProxyBotService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(NlpProxyBotService::logger$lambda$0);
    @NotNull
    private static final String tockNlpProxyOnBotPath = PropertiesKt.property((String)"tock_nlp_proxy_on_bot_path", (String)"/_proxy_nlp");
    @NotNull
    private static final String tockNlpServiceHost;
    private static final int tockNlpServicePort;
    private static final boolean tockNlpServiceSsl;
    @NotNull
    private static final Set<String> nonForwardedHeaders;

    private NlpProxyBotService() {
    }

    @NotNull
    public final Function1<Router, Unit> configure(@NotNull Vertx vertx) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        return arg_0 -> NlpProxyBotService.configure$lambda$3(vertx, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final void httpProxyToNlp(RoutingContext context, Vertx vertx, HttpMethod httpMethod) {
        try {
            void $this$httpProxyToNlp_u24lambda_u244;
            HttpClientOptions httpClientOptions;
            String string = context.request().uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
            String uri = StringsKt.substringAfter$default((String)string, (String)tockNlpProxyOnBotPath, null, (int)2, null);
            HttpClientOptions httpClientOptions2 = httpClientOptions = new HttpClientOptions();
            Vertx vertx2 = vertx;
            boolean bl = false;
            $this$httpProxyToNlp_u24lambda_u244.setKeepAlive(false);
            HttpClient httpClient = vertx2.createHttpClient(httpClientOptions);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"createHttpClient(...)");
            HttpClient client = httpClient;
            HttpClientOptions $this$httpProxyToNlp_u24lambda_u246 = httpClientOptions = new RequestOptions().setHost(tockNlpServiceHost).setPort(Integer.valueOf(tockNlpServicePort)).setSsl(Boolean.valueOf(tockNlpServiceSsl)).setURI(uri).setMethod(httpMethod);
            boolean bl2 = false;
            MultiMap multiMap = context.response().headers();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"headers(...)");
            Iterable $this$forEach$iv = (Iterable)multiMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)entry);
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (nonForwardedHeaders.contains(key)) continue;
                $this$httpProxyToNlp_u24lambda_u246.addHeader(key, value);
            }
            HttpClientOptions options = httpClientOptions;
            client.request((RequestOptions)options).flatMap(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$7(httpMethod, context, arg_0)).flatMap(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$9(context, arg_0)).onFailure(NlpProxyBotService::httpProxyToNlp$lambda$10);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            context.fail(500);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void configure$lambda$3$lambda$1(Vertx $vertx, RoutingContext context) {
        Intrinsics.checkNotNull((Object)context);
        HttpMethod httpMethod = HttpMethod.POST;
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
        INSTANCE.httpProxyToNlp(context, $vertx, httpMethod);
    }

    private static final void configure$lambda$3$lambda$2(Vertx $vertx, RoutingContext context) {
        Intrinsics.checkNotNull((Object)context);
        HttpMethod httpMethod = HttpMethod.GET;
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"GET");
        INSTANCE.httpProxyToNlp(context, $vertx, httpMethod);
    }

    private static final Unit configure$lambda$3(Vertx $vertx, Router router) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        router.post(tockNlpProxyOnBotPath + "*").handler(arg_0 -> NlpProxyBotService.configure$lambda$3$lambda$1($vertx, arg_0));
        router.get(tockNlpProxyOnBotPath + "*").handler(arg_0 -> NlpProxyBotService.configure$lambda$3$lambda$2($vertx, arg_0));
        return Unit.INSTANCE;
    }

    private static final Future httpProxyToNlp$lambda$7(HttpMethod $httpMethod, RoutingContext $context, HttpClientRequest it) {
        return Intrinsics.areEqual((Object)$httpMethod, (Object)HttpMethod.POST) ? it.send($context.body().buffer()) : it.send();
    }

    private static final Object httpProxyToNlp$lambda$9$lambda$8(int $resStatusCode) {
        return "target server status code error : " + $resStatusCode;
    }

    private static final Future httpProxyToNlp$lambda$9(RoutingContext $context, HttpClientResponse nlpResponse) {
        $context.response().setChunked(true);
        int resStatusCode = nlpResponse.statusCode();
        if (resStatusCode != 200 && resStatusCode != 201) {
            logger.warn(() -> NlpProxyBotService.httpProxyToNlp$lambda$9$lambda$8(resStatusCode));
        }
        $context.response().setStatusCode(resStatusCode);
        $context.response().headers().setAll(nlpResponse.headers());
        return nlpResponse.pipeTo((WriteStream)$context.response());
    }

    private static final void httpProxyToNlp$lambda$10(Throwable t) {
        Intrinsics.checkNotNull((Object)t);
        LoggersKt.error((KLogger)logger, (Throwable)t);
    }

    static {
        Object[] objectArray = new String[]{"Accept-Encoding", "Host", "Via", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto", "X-Forwarded-Server"};
        nonForwardedHeaders = SetsKt.setOf((Object[])objectArray);
        String string = System.getenv("tock_nlp_service_url");
        if (string == null) {
            string = "http://localhost:8888";
        }
        URL tockNlpServiceUrl = new URL(string);
        String string2 = System.getenv("tock_nlp_service_host");
        if (string2 == null) {
            String string3 = tockNlpServiceUrl.getHost();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
        }
        tockNlpServiceHost = string2;
        String string4 = System.getenv("tock_nlp_service_port");
        tockNlpServicePort = string4 != null ? Integer.parseInt(string4) : tockNlpServiceUrl.getPort();
        String string5 = System.getenv("tock_nlp_service_SSL");
        if (string5 == null) {
            string5 = tockNlpServiceUrl.getProtocol();
        }
        tockNlpServiceSsl = Intrinsics.areEqual((Object)string5, (Object)"https");
    }
}

