/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.bot.definition.BotDefinition;
import ai.tock.bot.definition.Intent;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.dialog.Dialog;
import ai.tock.bot.engine.dialog.DialogState;
import ai.tock.bot.engine.dialog.EntityValue;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.nlp.KeywordService;
import ai.tock.bot.engine.nlp.KeywordServiceKt;
import ai.tock.bot.engine.nlp.NlpEntityMergeContext;
import ai.tock.bot.engine.nlp.NlpListener;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.nlp.api.client.model.NlpQuery;
import ai.tock.nlp.api.client.model.NlpResult;
import ai.tock.shared.PropertiesKt;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lai/tock/bot/engine/nlp/BuiltInKeywordListener;", "Lai/tock/bot/engine/nlp/NlpListener;", "()V", "deleteKeyword", "", "getDeleteKeyword", "()Ljava/lang/String;", "disableKeyword", "getDisableKeyword", "enableKeyword", "getEnableKeyword", "endTestContextKeyword", "getEndTestContextKeyword", "keywordRegexp", "Lkotlin/text/Regex;", "getKeywordRegexp", "()Lkotlin/text/Regex;", "setKeywordRegexp", "(Lkotlin/text/Regex;)V", "keywords", "", "getKeywords", "()Ljava/util/Set;", "testContextKeyword", "getTestContextKeyword", "handleKeyword", "Lai/tock/bot/definition/Intent;", "sentence", "tock-bot-engine"})
public final class BuiltInKeywordListener
implements NlpListener {
    @NotNull
    public static final BuiltInKeywordListener INSTANCE = new BuiltInKeywordListener();
    @NotNull
    private static final String deleteKeyword = PropertiesKt.property((String)"tock_bot_delete_keyword", (String)"_delete_user_");
    @NotNull
    private static final String enableKeyword = PropertiesKt.property((String)"tock_bot_enable_keyword", (String)"_enable_user_");
    @NotNull
    private static final String disableKeyword = PropertiesKt.property((String)"tock_bot_disable_keyword", (String)"_disable_user_");
    @NotNull
    private static final String testContextKeyword = PropertiesKt.property((String)"tock_bot_test_context_keyword", (String)"_test_");
    @NotNull
    private static final String endTestContextKeyword = PropertiesKt.property((String)"tock_bot_end_test_context_keyword", (String)"_end_test_");
    @NotNull
    private static final Set<String> keywords;
    @Nullable
    private static volatile Regex keywordRegexp;

    private BuiltInKeywordListener() {
    }

    @NotNull
    public final String getDeleteKeyword() {
        return deleteKeyword;
    }

    @NotNull
    public final String getEnableKeyword() {
        return enableKeyword;
    }

    @NotNull
    public final String getDisableKeyword() {
        return disableKeyword;
    }

    @NotNull
    public final String getTestContextKeyword() {
        return testContextKeyword;
    }

    @NotNull
    public final String getEndTestContextKeyword() {
        return endTestContextKeyword;
    }

    @NotNull
    public final Set<String> getKeywords() {
        return keywords;
    }

    @Nullable
    public final Regex getKeywordRegexp() {
        return keywordRegexp;
    }

    public final void setKeywordRegexp(@Nullable Regex regex) {
        keywordRegexp = regex;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Intent handleKeyword(@NotNull String sentence) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)sentence, (String)"sentence");
        if (!keywords.contains(sentence)) {
            Regex regex = keywordRegexp;
            if (!(regex != null ? regex.matches((CharSequence)sentence) : false)) {
                intent = (Intent)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KeywordServiceKt.getKeywordServices()), (Function1)((Function1)new Function1<KeywordService, Intent>(sentence){
                    final /* synthetic */ String $sentence;
                    {
                        this.$sentence = $sentence;
                        super(1);
                    }

                    public final Intent invoke(KeywordService it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.detectKeywordIntent(this.$sentence);
                    }
                })));
                return intent;
            }
        }
        intent = Intent.Companion.getKeyword();
        return intent;
    }

    @Override
    @Nullable
    public NlpResult precompute(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull BotDefinition botDefinition) {
        return NlpListener.DefaultImpls.precompute(this, sentence, userTimeline, dialog, botDefinition);
    }

    @Override
    @NotNull
    public NlpQuery updateQuery(@NotNull SendSentence sentence, @NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull BotDefinition botDefinition, @NotNull NlpQuery nlpQuery) {
        return NlpListener.DefaultImpls.updateQuery(this, sentence, userTimeline, dialog, botDefinition, nlpQuery);
    }

    @Override
    @Nullable
    public IntentAware findIntent(@NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull Event event, @NotNull NlpResult nlpResult) {
        return NlpListener.DefaultImpls.findIntent(this, userTimeline, dialog, event, nlpResult);
    }

    @Override
    @NotNull
    public List<EntityValue> evaluateEntities(@NotNull UserTimeline userTimeline, @NotNull Dialog dialog, @NotNull Event event, @NotNull NlpResult nlpResult) {
        return NlpListener.DefaultImpls.evaluateEntities(this, userTimeline, dialog, event, nlpResult);
    }

    @Override
    @NotNull
    public List<NlpEntityMergeContext> sortEntitiesToMerge(@NotNull List<NlpEntityMergeContext> entities) {
        return NlpListener.DefaultImpls.sortEntitiesToMerge(this, entities);
    }

    @Override
    @NotNull
    public NlpEntityMergeContext mergeEntityValues(@NotNull DialogState dialogState, @NotNull Action action, @NotNull NlpEntityMergeContext entityToMerge) {
        return NlpListener.DefaultImpls.mergeEntityValues(this, dialogState, action, entityToMerge);
    }

    @Override
    public void success(@NotNull NlpQuery query, @NotNull NlpResult result2) {
        NlpListener.DefaultImpls.success(this, query, result2);
    }

    @Override
    public void error(@NotNull NlpQuery query, @NotNull Dialog dialog, @Nullable Throwable throwable) {
        NlpListener.DefaultImpls.error(this, query, dialog, throwable);
    }

    static {
        Object[] objectArray = new String[5];
        objectArray[0] = deleteKeyword;
        objectArray[1] = enableKeyword;
        objectArray[2] = disableKeyword;
        objectArray[3] = testContextKeyword;
        objectArray[4] = endTestContextKeyword;
        keywords = new ConcurrentSkipListSet(CollectionsKt.listOf((Object[])objectArray));
    }
}

