/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.engine.nlp;

import ai.tock.bot.engine.nlp.NlpProxyBotService;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/tock/bot/engine/nlp/NlpProxyBotService;", "", "()V", "logger", "Lmu/KLogger;", "nonForwardedHeaders", "", "", "tockNlpProxyOnBotPath", "tockNlpServiceHost", "tockNlpServicePort", "", "tockNlpServiceSsl", "", "configure", "Lkotlin/Function1;", "Lio/vertx/ext/web/Router;", "", "vertx", "Lio/vertx/core/Vertx;", "httpProxyToNlp", "context", "Lio/vertx/ext/web/RoutingContext;", "httpMethod", "Lio/vertx/core/http/HttpMethod;", "tock-bot-engine"})
@SourceDebugExtension(value={"SMAP\nNlpProxyBotService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpProxyBotService.kt\nai/tock/bot/engine/nlp/NlpProxyBotService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n1863#3,2:117\n*S KotlinDebug\n*F\n+ 1 NlpProxyBotService.kt\nai/tock/bot/engine/nlp/NlpProxyBotService\n*L\n89#1:117,2\n*E\n"})
public final class NlpProxyBotService {
    @NotNull
    public static final NlpProxyBotService INSTANCE = new NlpProxyBotService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final String tockNlpProxyOnBotPath = PropertiesKt.property((String)"tock_nlp_proxy_on_bot_path", (String)"/_proxy_nlp");
    @NotNull
    private static final String tockNlpServiceHost;
    private static final int tockNlpServicePort;
    private static final boolean tockNlpServiceSsl;
    @NotNull
    private static final Set<String> nonForwardedHeaders;

    private NlpProxyBotService() {
    }

    @NotNull
    public final Function1<Router, Unit> configure(@NotNull Vertx vertx) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        return (Function1)new Function1<Router, Unit>(vertx){
            final /* synthetic */ Vertx $vertx;
            {
                this.$vertx = $vertx;
                super(1);
            }

            public final void invoke(Router router) {
                Intrinsics.checkNotNullParameter((Object)router, (String)"router");
                router.post(NlpProxyBotService.access$getTockNlpProxyOnBotPath$p() + "*").handler(arg_0 -> configure.1.invoke$lambda$0(this.$vertx, arg_0));
                router.get(NlpProxyBotService.access$getTockNlpProxyOnBotPath$p() + "*").handler(arg_0 -> configure.1.invoke$lambda$1(this.$vertx, arg_0));
            }

            private static final void invoke$lambda$0(Vertx $vertx, RoutingContext context) {
                Intrinsics.checkNotNull((Object)context);
                HttpMethod httpMethod = HttpMethod.POST;
                Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"POST");
                NlpProxyBotService.access$httpProxyToNlp(NlpProxyBotService.INSTANCE, context, $vertx, httpMethod);
            }

            private static final void invoke$lambda$1(Vertx $vertx, RoutingContext context) {
                Intrinsics.checkNotNull((Object)context);
                HttpMethod httpMethod = HttpMethod.GET;
                Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"GET");
                NlpProxyBotService.access$httpProxyToNlp(NlpProxyBotService.INSTANCE, context, $vertx, httpMethod);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void httpProxyToNlp(RoutingContext context, Vertx vertx, HttpMethod httpMethod) {
        try {
            void $this$httpProxyToNlp_u24lambda_u240;
            HttpClientOptions httpClientOptions;
            String string = context.request().uri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
            String uri = StringsKt.substringAfter$default((String)string, (String)tockNlpProxyOnBotPath, null, (int)2, null);
            HttpClientOptions httpClientOptions2 = httpClientOptions = new HttpClientOptions();
            Vertx vertx2 = vertx;
            boolean bl = false;
            $this$httpProxyToNlp_u24lambda_u240.setKeepAlive(false);
            HttpClient httpClient = vertx2.createHttpClient(httpClientOptions);
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"createHttpClient(...)");
            HttpClient client = httpClient;
            HttpClientOptions $this$httpProxyToNlp_u24lambda_u242 = httpClientOptions = new RequestOptions().setHost(tockNlpServiceHost).setPort(Integer.valueOf(tockNlpServicePort)).setSsl(Boolean.valueOf(tockNlpServiceSsl)).setURI(uri).setMethod(httpMethod);
            boolean bl2 = false;
            MultiMap multiMap = context.response().headers();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"headers(...)");
            Iterable $this$forEach$iv = (Iterable)multiMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)entry);
                String key2 = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (nonForwardedHeaders.contains(key2)) continue;
                $this$httpProxyToNlp_u24lambda_u242.addHeader(key2, value);
            }
            HttpClientOptions options = httpClientOptions;
            client.request((RequestOptions)options).flatMap(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$3(httpMethod, context, arg_0)).flatMap(arg_0 -> NlpProxyBotService.httpProxyToNlp$lambda$4(context, arg_0)).onFailure(NlpProxyBotService::httpProxyToNlp$lambda$5);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            context.fail(500);
        }
    }

    private static final Future httpProxyToNlp$lambda$3(HttpMethod $httpMethod, RoutingContext $context, HttpClientRequest it) {
        return Intrinsics.areEqual((Object)$httpMethod, (Object)HttpMethod.POST) ? it.send($context.body().buffer()) : it.send();
    }

    private static final Future httpProxyToNlp$lambda$4(RoutingContext $context, HttpClientResponse nlpResponse) {
        $context.response().setChunked(true);
        int resStatusCode = nlpResponse.statusCode();
        if (resStatusCode != 200 && resStatusCode != 201) {
            logger.warn((Function0)new Function0<Object>(resStatusCode){
                final /* synthetic */ int $resStatusCode;
                {
                    this.$resStatusCode = $resStatusCode;
                    super(0);
                }

                public final Object invoke() {
                    return "target server status code error : " + this.$resStatusCode;
                }
            });
        }
        $context.response().setStatusCode(resStatusCode);
        $context.response().headers().setAll(nlpResponse.headers());
        return nlpResponse.pipeTo((WriteStream)$context.response());
    }

    private static final void httpProxyToNlp$lambda$5(Throwable t) {
        Intrinsics.checkNotNull((Object)t);
        LoggersKt.error((KLogger)logger, (Throwable)t);
    }

    public static final /* synthetic */ String access$getTockNlpProxyOnBotPath$p() {
        return tockNlpProxyOnBotPath;
    }

    public static final /* synthetic */ void access$httpProxyToNlp(NlpProxyBotService $this, RoutingContext context, Vertx vertx, HttpMethod httpMethod) {
        $this.httpProxyToNlp(context, vertx, httpMethod);
    }

    static {
        Object[] objectArray = new String[]{"Accept-Encoding", "Host", "Via", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto", "X-Forwarded-Server"};
        nonForwardedHeaders = SetsKt.setOf((Object[])objectArray);
        String string = System.getenv("tock_nlp_service_url");
        if (string == null) {
            string = "http://localhost:8888";
        }
        URL tockNlpServiceUrl = new URL(string);
        String string2 = System.getenv("tock_nlp_service_host");
        if (string2 == null) {
            String string3 = tockNlpServiceUrl.getHost();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
        }
        tockNlpServiceHost = string2;
        String string4 = System.getenv("tock_nlp_service_port");
        tockNlpServicePort = string4 != null ? Integer.parseInt(string4) : tockNlpServiceUrl.getPort();
        String string5 = System.getenv("tock_nlp_service_SSL");
        if (string5 == null) {
            string5 = tockNlpServiceUrl.getProtocol();
        }
        tockNlpServiceSsl = Intrinsics.areEqual((Object)string5, (Object)"https");
    }
}

