/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.open.data.client.sncf;

import ai.tock.bot.open.data.OpenDataConfiguration;
import ai.tock.bot.open.data.client.sncf.SncfOpenDataApi;
import ai.tock.bot.open.data.client.sncf.SncfOpenDataClient;
import ai.tock.bot.open.data.client.sncf.model.ArrivalsResponse;
import ai.tock.bot.open.data.client.sncf.model.DeparturesResponse;
import ai.tock.bot.open.data.client.sncf.model.Journey;
import ai.tock.bot.open.data.client.sncf.model.JourneysResponse;
import ai.tock.bot.open.data.client.sncf.model.Place;
import ai.tock.bot.open.data.client.sncf.model.PlaceValue;
import ai.tock.bot.open.data.client.sncf.model.PlacesNearbyResponse;
import ai.tock.bot.open.data.client.sncf.model.PlacesResponse;
import ai.tock.bot.open.data.client.sncf.model.SncfPlace;
import ai.tock.bot.open.data.client.sncf.model.StationStop;
import ai.tock.bot.open.data.client.sncf.model.VehicleJourney;
import ai.tock.bot.open.data.client.sncf.model.VehicleJourneysResponse;
import ai.tock.shared.Level;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0014J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/tock/bot/open/data/client/sncf/SncfOpenDataClient;", "", "()V", "api", "Lai/tock/bot/open/data/client/sncf/SncfOpenDataApi;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "arrivals", "", "Lai/tock/bot/open/data/client/sncf/model/StationStop;", "from", "Lai/tock/bot/open/data/client/sncf/model/Place;", "datetime", "Ljava/time/LocalDateTime;", "bestPlaceMatch", "Lai/tock/bot/open/data/client/sncf/model/SncfPlace;", "query", "", "departures", "findPlace", "Lai/tock/bot/open/data/client/sncf/model/PlaceValue;", "name", "journey", "Lai/tock/bot/open/data/client/sncf/model/Journey;", "to", "places", "vehicleJourney", "Lai/tock/bot/open/data/client/sncf/model/VehicleJourney;", "id", "tock-bot-open-data"})
public final class SncfOpenDataClient {
    private static final KLogger logger;
    private static final DateTimeFormatter dateFormat;
    private static final SncfOpenDataApi api;
    public static final SncfOpenDataClient INSTANCE;

    @Nullable
    public final PlaceValue findPlace(@NotNull String name) {
        PlaceValue placeValue;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        SncfPlace sncfPlace = this.bestPlaceMatch(name);
        if (sncfPlace != null) {
            SncfPlace sncfPlace2 = sncfPlace;
            boolean bl = false;
            boolean bl2 = false;
            SncfPlace it = sncfPlace2;
            boolean bl3 = false;
            placeValue = new PlaceValue(it);
        } else {
            placeValue = null;
        }
        return placeValue;
    }

    @NotNull
    public final List<SncfPlace> places(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Object object = (PlacesResponse)api.places(query).execute().body();
        if (object == null || (object = ((PlacesResponse)object).getPlaces()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final SncfPlace bestPlaceMatch(@NotNull String query) {
        SncfPlace sncfPlace;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        SncfPlace p = (SncfPlace)CollectionsKt.firstOrNull(this.places(query));
        if (p != null && Intrinsics.areEqual((Object)p.getEmbeddedType(), (Object)"stop_area") ^ true) {
            Object object = (PlacesNearbyResponse)api.placesNearby(p.getId()).execute().body();
            if (object != null && (object = ((PlacesNearbyResponse)object).getPlaces()) != null) {
                Object v1;
                Object $this$run;
                block6: {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    $this$run = object2;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = (Iterable)$this$run;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SncfPlace it = (SncfPlace)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getEmbeddedType(), (Object)"stop_area")) continue;
                        v1 = element$iv;
                        break block6;
                    }
                    v1 = null;
                }
                if ((sncfPlace = (SncfPlace)v1) == null) {
                    sncfPlace = (SncfPlace)CollectionsKt.firstOrNull((List)$this$run);
                }
            } else {
                sncfPlace = null;
            }
        } else {
            sncfPlace = p;
        }
        return sncfPlace;
    }

    @NotNull
    public final List<Journey> journey(@NotNull Place from, @NotNull Place to, @NotNull LocalDateTime datetime) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = to.getId();
        String string3 = dateFormat.format(datetime);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dateFormat.format(datetime)");
        Object object = (JourneysResponse)api.journeys(string, string2, string3).execute().body();
        if (object == null || (object = ((JourneysResponse)object).getJourneys()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<StationStop> departures(@NotNull Place from, @NotNull LocalDateTime datetime) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = dateFormat.format(datetime);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(datetime)");
        Object object = (DeparturesResponse)api.departures(string, string2).execute().body();
        if (object == null || (object = ((DeparturesResponse)object).getDepartures()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<StationStop> arrivals(@NotNull Place from, @NotNull LocalDateTime datetime) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)datetime, (String)"datetime");
        String string = from.getId();
        String string2 = dateFormat.format(datetime);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(datetime)");
        Object object = (ArrivalsResponse)api.arrivals(string, string2).execute().body();
        if (object == null || (object = ((ArrivalsResponse)object).getArrivals()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final VehicleJourney vehicleJourney(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Object object = (VehicleJourneysResponse)api.vehicleJourneys(id).execute().body();
        return object != null && (object = ((VehicleJourneysResponse)object).getVehicleJourney()) != null ? (VehicleJourney)CollectionsKt.firstOrNull((List)object) : null;
    }

    private SncfOpenDataClient() {
    }

    static {
        SncfOpenDataClient sncfOpenDataClient;
        INSTANCE = sncfOpenDataClient = new SncfOpenDataClient();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        Interceptor.Companion companion = Interceptor.Companion;
        Level level = null;
        KLogger kLogger = logger;
        long l = 30000L;
        boolean $i$f$invoke = false;
        Interceptor interceptor = new Interceptor(){

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
                Interceptor.Chain chain2 = chain;
                boolean bl = false;
                return chain2.proceed(chain2.request().newBuilder().header("Authorization", Credentials.basic$default((String)OpenDataConfiguration.INSTANCE.getSncfApiUser(), (String)"", null, (int)4, null)).build());
            }
        };
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)l, (KLogger)kLogger, level, (List)CollectionsKt.listOf((Object)interceptor), (boolean)false, (boolean)false, null, (int)116, null).baseUrl("https://api.sncf.com/v1/coverage/sncf/");
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"retrofitBuilderWithTimeo\u2026f.com/v1/coverage/sncf/\")");
        ObjectMapper objectMapper = JacksonKt.getMapper().copy();
        SimpleModule simpleModule = JacksonKt.addDeserializer((SimpleModule)new SimpleModule(), (KClass)Reflection.getOrCreateKotlinClass(LocalDateTime.class), (JsonDeserializer)((JsonDeserializer)new LocalDateTimeDeserializer(dateFormat)));
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleModule, (String)"SimpleModule()\n         \u2026Deserializer(dateFormat))");
        ObjectMapper objectMapper2 = objectMapper.registerModule((Module)JacksonKt.addSerializer((SimpleModule)simpleModule, (KClass)Reflection.getOrCreateKotlinClass(LocalDateTime.class), (JsonSerializer)((JsonSerializer)new LocalDateTimeSerializer(dateFormat))));
        Intrinsics.checkExpressionValueIsNotNull((Object)objectMapper2, (String)"mapper.copy().registerMo\u2026ormat))\n                )");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter((Retrofit.Builder)builder, (ObjectMapper)objectMapper2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"retrofitBuilderWithTimeo\u2026   )\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(SncfOpenDataApi.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"create(T::class.java)");
        api = (SncfOpenDataApi)object;
    }
}

