/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.open.data.story;

import ai.tock.bot.engine.BotBus;
import ai.tock.bot.open.data.client.sncf.SncfOpenDataClient;
import ai.tock.bot.open.data.client.sncf.model.StationStop;
import ai.tock.bot.open.data.story.ScoreboardDef;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0017"}, d2={"Lai/tock/bot/open/data/story/DeparturesDef;", "Lai/tock/bot/open/data/story/ScoreboardDef;", "bus", "Lai/tock/bot/engine/BotBus;", "(Lai/tock/bot/engine/BotBus;)V", "headerMessage", "", "getHeaderMessage", "()Ljava/lang/String;", "itemSubtitleMessage", "getItemSubtitleMessage", "nextMessage", "getNextMessage", "noResultMessage", "getNoResultMessage", "itemTitle", "", "stop", "Lai/tock/bot/open/data/client/sncf/model/StationStop;", "retrieveStops", "", "timeFor", "Ljava/time/LocalDateTime;", "tock-bot-open-data"})
public final class DeparturesDef
extends ScoreboardDef {
    @NotNull
    private final String headerMessage = "Departures from: {0}";
    @NotNull
    private final String noResultMessage = "Oops, no departure currently found, sorry :(";
    @NotNull
    private final String nextMessage = "Next departures";
    @NotNull
    private final String itemSubtitleMessage = "Departure {0}";

    @Override
    @NotNull
    public String getHeaderMessage() {
        return this.headerMessage;
    }

    @Override
    @NotNull
    public String getNoResultMessage() {
        return this.noResultMessage;
    }

    @Override
    @NotNull
    public String getNextMessage() {
        return this.nextMessage;
    }

    @Override
    @NotNull
    public List<StationStop> retrieveStops() {
        return SncfOpenDataClient.INSTANCE.departures(this.getO(), this.getCurrentDate());
    }

    @Override
    @NotNull
    public LocalDateTime timeFor(@NotNull StationStop stop) {
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        return stop.getStopDateTime().getDepartureDateTime();
    }

    @Override
    @NotNull
    public CharSequence itemTitle(@NotNull StationStop stop) {
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        return (CharSequence)this.i18n("Direction {0}", new Object[]{stop.getDisplayInformations().getDirection()});
    }

    @Override
    @NotNull
    public String getItemSubtitleMessage() {
        return this.itemSubtitleMessage;
    }

    public DeparturesDef(@NotNull BotBus bus) {
        Intrinsics.checkParameterIsNotNull((Object)bus, (String)"bus");
        super(bus);
        this.headerMessage = "Departures from: {0}";
        this.noResultMessage = "Oops, no departure currently found, sorry :(";
        this.nextMessage = "Next departures";
        this.itemSubtitleMessage = "Departure {0}";
    }
}

