/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.orchestration.bot.secondary;

import ai.tock.bot.connector.ConnectorCallbackBase;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.orchestration.bot.secondary.OrchestrationCallback;
import ai.tock.bot.orchestration.bot.secondary.RestOrchestrationCallback;
import ai.tock.bot.orchestration.shared.NoOrchestrationStatus;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.SecondaryBotNoResponse;
import ai.tock.bot.orchestration.shared.SecondaryBotResponse;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/tock/bot/orchestration/bot/secondary/RestOrchestrationCallback;", "Lai/tock/bot/orchestration/bot/secondary/OrchestrationCallback;", "Lai/tock/bot/connector/ConnectorCallbackBase;", "connectorType", "Lai/tock/bot/connector/ConnectorType;", "applicationId", "", "context", "Lio/vertx/ext/web/RoutingContext;", "actions", "", "Lai/tock/bot/engine/action/Action;", "orchestrationMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lai/tock/bot/connector/ConnectorType;Ljava/lang/String;Lio/vertx/ext/web/RoutingContext;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getActions", "()Ljava/util/List;", "logger", "Lmu/KLogger;", "exceptionThrown", "", "event", "Lai/tock/bot/engine/event/Event;", "throwable", "", "sendError", "sendHttpResponse", "httpCode", "Lio/netty/handler/codec/http/HttpResponseStatus;", "response", "Lai/tock/bot/orchestration/shared/SecondaryBotResponse;", "sendResponse", "tock-bot-orchestration"})
public class RestOrchestrationCallback
extends ConnectorCallbackBase
implements OrchestrationCallback {
    @NotNull
    private final RoutingContext context;
    @NotNull
    private final List<Action> actions;
    @NotNull
    private final ObjectMapper orchestrationMapper;
    @NotNull
    private final KLogger logger;

    public RestOrchestrationCallback(@NotNull ConnectorType connectorType, @NotNull String applicationId, @NotNull RoutingContext context, @NotNull List<Action> actions, @NotNull ObjectMapper orchestrationMapper) {
        Intrinsics.checkNotNullParameter((Object)connectorType, (String)"connectorType");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)orchestrationMapper, (String)"orchestrationMapper");
        super(applicationId, connectorType);
        this.context = context;
        this.actions = actions;
        this.orchestrationMapper = orchestrationMapper;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    public /* synthetic */ RestOrchestrationCallback(ConnectorType connectorType, String string, RoutingContext routingContext, List list, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            objectMapper = JacksonKt.getMapper();
        }
        this(connectorType, string, routingContext, list, objectMapper);
    }

    @Override
    @NotNull
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public void sendResponse() {
        this.sendResponse(SecondaryBotResponse.Companion.fromActions(this.getApplicationId(), this.getActions()));
    }

    @Override
    public void sendResponse(@NotNull SecondaryBotResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            this.sendHttpResponse(httpResponseStatus, response);
        }
        catch (Exception exception) {
            LoggersKt.error((KLogger)this.logger, (Throwable)exception);
            this.sendError();
        }
    }

    @Override
    public void sendError() {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
        this.sendHttpResponse(httpResponseStatus, new SecondaryBotNoResponse(NoOrchestrationStatus.ERROR, 0.0, new OrchestrationMetaData(new PlayerId("unknownWithError", null, null, 6, null), this.getApplicationId(), new PlayerId("bot", null, null, 6, null)), 2, null));
    }

    public void exceptionThrown(@NotNull Event event, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        super.exceptionThrown(event, throwable);
        this.sendError();
    }

    private final void sendHttpResponse(HttpResponseStatus httpCode, SecondaryBotResponse response) {
        HttpServerResponse res = this.context.response();
        res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
        res.setStatusCode(httpCode.code());
        res.end(this.orchestrationMapper.writeValueAsString((Object)response));
    }
}

