/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.orchestration.bot.primary;

import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.orchestration.bot.primary.OrchestrationStatus;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.OrchestrationTargetedBot;
import ai.tock.bot.orchestration.shared.SecondaryBotAction;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u000eJ\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\u000bH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JQ\u0010+\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u0010,\u001a\u00020 2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00062"}, d2={"Lai/tock/bot/orchestration/bot/primary/Orchestration;", "", "id", "Lorg/litote/kmongo/Id;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "targetMetadata", "Lai/tock/bot/orchestration/shared/OrchestrationMetaData;", "targetBot", "Lai/tock/bot/orchestration/shared/OrchestrationTargetedBot;", "status", "Lai/tock/bot/orchestration/bot/primary/OrchestrationStatus;", "history", "", "Lai/tock/bot/orchestration/shared/SecondaryBotAction;", "<init>", "(Lorg/litote/kmongo/Id;Lai/tock/bot/engine/user/PlayerId;Lai/tock/bot/orchestration/shared/OrchestrationMetaData;Lai/tock/bot/orchestration/shared/OrchestrationTargetedBot;Lai/tock/bot/orchestration/bot/primary/OrchestrationStatus;Ljava/util/List;)V", "getId", "()Lorg/litote/kmongo/Id;", "getPlayerId", "()Lai/tock/bot/engine/user/PlayerId;", "getTargetMetadata", "()Lai/tock/bot/orchestration/shared/OrchestrationMetaData;", "getTargetBot", "()Lai/tock/bot/orchestration/shared/OrchestrationTargetedBot;", "getStatus", "()Lai/tock/bot/orchestration/bot/primary/OrchestrationStatus;", "setStatus", "(Lai/tock/bot/orchestration/bot/primary/OrchestrationStatus;)V", "getHistory", "()Ljava/util/List;", "locked", "", "getLocked", "()Z", "update", "action", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "tock-bot-orchestration"})
public final class Orchestration {
    @NotNull
    private final Id<Orchestration> id;
    @NotNull
    private final PlayerId playerId;
    @NotNull
    private final OrchestrationMetaData targetMetadata;
    @NotNull
    private final OrchestrationTargetedBot targetBot;
    @NotNull
    private OrchestrationStatus status;
    @NotNull
    private final List<SecondaryBotAction> history;

    public Orchestration(@NotNull Id<Orchestration> id, @NotNull PlayerId playerId, @NotNull OrchestrationMetaData targetMetadata, @NotNull OrchestrationTargetedBot targetBot, @NotNull OrchestrationStatus status, @NotNull List<SecondaryBotAction> history) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)targetMetadata, (String)"targetMetadata");
        Intrinsics.checkNotNullParameter((Object)targetBot, (String)"targetBot");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.id = id;
        this.playerId = playerId;
        this.targetMetadata = targetMetadata;
        this.targetBot = targetBot;
        this.status = status;
        this.history = history;
    }

    public /* synthetic */ Orchestration(Id id, PlayerId playerId, OrchestrationMetaData orchestrationMetaData, OrchestrationTargetedBot orchestrationTargetedBot, OrchestrationStatus orchestrationStatus, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            id = IdsKt.newId();
        }
        if ((n & 0x10) != 0) {
            orchestrationStatus = OrchestrationStatus.ACTIVE;
        }
        if ((n & 0x20) != 0) {
            list = new ArrayList();
        }
        this((Id<Orchestration>)id, playerId, orchestrationMetaData, orchestrationTargetedBot, orchestrationStatus, list);
    }

    @NotNull
    public final Id<Orchestration> getId() {
        return this.id;
    }

    @NotNull
    public final PlayerId getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final OrchestrationMetaData getTargetMetadata() {
        return this.targetMetadata;
    }

    @NotNull
    public final OrchestrationTargetedBot getTargetBot() {
        return this.targetBot;
    }

    @NotNull
    public final OrchestrationStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull OrchestrationStatus orchestrationStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)orchestrationStatus), (String)"<set-?>");
        this.status = orchestrationStatus;
    }

    @NotNull
    public final List<SecondaryBotAction> getHistory() {
        return this.history;
    }

    @JsonIgnore
    public final boolean getLocked() {
        SecondaryBotAction secondaryBotAction = (SecondaryBotAction)CollectionsKt.lastOrNull(this.history);
        return secondaryBotAction != null && (secondaryBotAction = secondaryBotAction.getMetadata()) != null ? secondaryBotAction.getOrchestrationLock() : false;
    }

    public final boolean update(@NotNull SecondaryBotAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        return this.history.add(action);
    }

    @NotNull
    public final Id<Orchestration> component1() {
        return this.id;
    }

    @NotNull
    public final PlayerId component2() {
        return this.playerId;
    }

    @NotNull
    public final OrchestrationMetaData component3() {
        return this.targetMetadata;
    }

    @NotNull
    public final OrchestrationTargetedBot component4() {
        return this.targetBot;
    }

    @NotNull
    public final OrchestrationStatus component5() {
        return this.status;
    }

    @NotNull
    public final List<SecondaryBotAction> component6() {
        return this.history;
    }

    @NotNull
    public final Orchestration copy(@NotNull Id<Orchestration> id, @NotNull PlayerId playerId, @NotNull OrchestrationMetaData targetMetadata, @NotNull OrchestrationTargetedBot targetBot, @NotNull OrchestrationStatus status, @NotNull List<SecondaryBotAction> history) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)playerId, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)targetMetadata, (String)"targetMetadata");
        Intrinsics.checkNotNullParameter((Object)targetBot, (String)"targetBot");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        return new Orchestration(id, playerId, targetMetadata, targetBot, status, history);
    }

    public static /* synthetic */ Orchestration copy$default(Orchestration orchestration, Id id, PlayerId playerId, OrchestrationMetaData orchestrationMetaData, OrchestrationTargetedBot orchestrationTargetedBot, OrchestrationStatus orchestrationStatus, List list, int n, Object object) {
        if ((n & 1) != 0) {
            id = orchestration.id;
        }
        if ((n & 2) != 0) {
            playerId = orchestration.playerId;
        }
        if ((n & 4) != 0) {
            orchestrationMetaData = orchestration.targetMetadata;
        }
        if ((n & 8) != 0) {
            orchestrationTargetedBot = orchestration.targetBot;
        }
        if ((n & 0x10) != 0) {
            orchestrationStatus = orchestration.status;
        }
        if ((n & 0x20) != 0) {
            list = orchestration.history;
        }
        return orchestration.copy(id, playerId, orchestrationMetaData, orchestrationTargetedBot, orchestrationStatus, list);
    }

    @NotNull
    public String toString() {
        return "Orchestration(id=" + this.id + ", playerId=" + this.playerId + ", targetMetadata=" + this.targetMetadata + ", targetBot=" + this.targetBot + ", status=" + this.status + ", history=" + this.history + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.playerId.hashCode();
        result = result * 31 + this.targetMetadata.hashCode();
        result = result * 31 + this.targetBot.hashCode();
        result = result * 31 + this.status.hashCode();
        result = result * 31 + ((Object)this.history).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Orchestration)) {
            return false;
        }
        Orchestration orchestration = (Orchestration)other;
        if (!Intrinsics.areEqual(this.id, orchestration.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerId, (Object)orchestration.playerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetMetadata, (Object)orchestration.targetMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetBot, (Object)orchestration.targetBot)) {
            return false;
        }
        if (this.status != orchestration.status) {
            return false;
        }
        return Intrinsics.areEqual(this.history, orchestration.history);
    }
}

