/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.orchestration.bot.primary;

import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.definition.IntentAware;
import ai.tock.bot.definition.StoryDefinition;
import ai.tock.bot.definition.StoryHandler;
import ai.tock.bot.definition.StoryHandlerListener;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.orchestration.bot.primary.ComeBackFromSecondary;
import ai.tock.bot.orchestration.bot.primary.MongoOrchestrationRepository;
import ai.tock.bot.orchestration.bot.primary.Orchestration;
import ai.tock.bot.orchestration.bot.primary.OrchestrationRepository;
import ai.tock.bot.orchestration.bot.primary.PrimaryBotConfiguration;
import ai.tock.bot.orchestration.bot.primary.RunOrchestrationStoryListenerKt;
import ai.tock.bot.orchestration.orchestrator.OrchestratorService;
import ai.tock.bot.orchestration.shared.AskEligibilityToOrchestratorRequest;
import ai.tock.bot.orchestration.shared.AvailableOrchestrationResponse;
import ai.tock.bot.orchestration.shared.EligibilityOrchestrationResponse;
import ai.tock.bot.orchestration.shared.OrchestrationData;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.OrchestrationResponse;
import ai.tock.bot.orchestration.shared.OrchestrationTargetedBot;
import ai.tock.bot.orchestration.shared.ResumeOrchestrationRequest;
import ai.tock.bot.orchestration.shared.SecondaryBotAction;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\n*\u00020\u000fH\u0002J\u001c\u0010\u0013\u001a\u00020\n*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u0019*\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0019*\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001b\u001a\u00020\n*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f*\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\n*\u0004\u0018\u00010#H\u0002J\u000e\u0010$\u001a\u00020\n*\u0004\u0018\u00010#H\u0002J\u000e\u0010%\u001a\u00020\n*\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lai/tock/bot/orchestration/bot/primary/RunOrchestrationStoryListener;", "Lai/tock/bot/definition/StoryHandlerListener;", "configuration", "Lai/tock/bot/orchestration/bot/primary/PrimaryBotConfiguration;", "orchestrator", "Lai/tock/bot/orchestration/orchestrator/OrchestratorService;", "orchestrationRepository", "Lai/tock/bot/orchestration/bot/primary/OrchestrationRepository;", "orchestrationEnabled", "Lkotlin/Function0;", "", "<init>", "(Lai/tock/bot/orchestration/bot/primary/PrimaryBotConfiguration;Lai/tock/bot/orchestration/orchestrator/OrchestratorService;Lai/tock/bot/orchestration/bot/primary/OrchestrationRepository;Lkotlin/jvm/functions/Function0;)V", "startAction", "botBus", "Lai/tock/bot/engine/BotBus;", "handler", "Lai/tock/bot/definition/StoryHandler;", "startOrchestration", "handleEligibleOrchestration", "eligibility", "Lai/tock/bot/orchestration/shared/EligibilityOrchestrationResponse;", "botAction", "Lai/tock/bot/orchestration/shared/SecondaryBotAction;", "callOrchestrationForFirstAction", "Lai/tock/bot/orchestration/shared/OrchestrationResponse;", "callOrchestrationForEligibility", "resumeOrchestration", "orchestration", "Lai/tock/bot/orchestration/bot/primary/Orchestration;", "getEligibleBots", "", "Lai/tock/bot/orchestration/shared/OrchestrationTargetedBot;", "Lai/tock/bot/connector/ConnectorType;", "inStartOrchestrationList", "Lai/tock/bot/definition/IntentAware;", "inStopOrchestrationList", "inNoOrchestrationList", "tock-bot-orchestration"})
@SourceDebugExtension(value={"SMAP\nRunOrchestrationStoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunOrchestrationStoryListener.kt\nai/tock/bot/orchestration/bot/primary/RunOrchestrationStoryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1863#2,2:250\n1863#2,2:252\n*S KotlinDebug\n*F\n+ 1 RunOrchestrationStoryListener.kt\nai/tock/bot/orchestration/bot/primary/RunOrchestrationStoryListener\n*L\n105#1:250,2\n192#1:252,2\n*E\n"})
public final class RunOrchestrationStoryListener
implements StoryHandlerListener {
    @NotNull
    private final PrimaryBotConfiguration configuration;
    @NotNull
    private final OrchestratorService orchestrator;
    @NotNull
    private final OrchestrationRepository orchestrationRepository;
    @NotNull
    private final Function0<Boolean> orchestrationEnabled;

    public RunOrchestrationStoryListener(@NotNull PrimaryBotConfiguration configuration, @NotNull OrchestratorService orchestrator, @NotNull OrchestrationRepository orchestrationRepository, @NotNull Function0<Boolean> orchestrationEnabled) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)orchestrator, (String)"orchestrator");
        Intrinsics.checkNotNullParameter((Object)orchestrationRepository, (String)"orchestrationRepository");
        Intrinsics.checkNotNullParameter(orchestrationEnabled, (String)"orchestrationEnabled");
        this.configuration = configuration;
        this.orchestrator = orchestrator;
        this.orchestrationRepository = orchestrationRepository;
        this.orchestrationEnabled = orchestrationEnabled;
    }

    public /* synthetic */ RunOrchestrationStoryListener(PrimaryBotConfiguration primaryBotConfiguration, OrchestratorService orchestratorService, OrchestrationRepository orchestrationRepository, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            orchestrationRepository = MongoOrchestrationRepository.INSTANCE;
        }
        if ((n & 8) != 0) {
            function0 = RunOrchestrationStoryListener::_init_$lambda$0;
        }
        this(primaryBotConfiguration, orchestratorService, orchestrationRepository, (Function0<Boolean>)function0);
    }

    public boolean startAction(@NotNull BotBus botBus, @NotNull StoryHandler handler) {
        Intrinsics.checkNotNullParameter((Object)botBus, (String)"botBus");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        BotBus $this$startAction_u24lambda_u241 = botBus;
        boolean bl = false;
        Orchestration currentOrchestration = this.orchestrationRepository.get($this$startAction_u24lambda_u241.getAction().getPlayerId());
        return RunOrchestrationStoryListenerKt.getBlockHandoverToSecondaryBot(botBus) ? true : (currentOrchestration != null ? this.resumeOrchestration($this$startAction_u24lambda_u241, currentOrchestration) : (this.inStartOrchestrationList($this$startAction_u24lambda_u241.getIntent()) && (Boolean)this.orchestrationEnabled.invoke() != false ? this.startOrchestration($this$startAction_u24lambda_u241) : true));
    }

    private final boolean startOrchestration(BotBus $this$startOrchestration) {
        boolean bl;
        RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.startOrchestration$lambda$2($this$startOrchestration));
        SecondaryBotAction botAction = SecondaryBotAction.Companion.from($this$startOrchestration.getAction(), $this$startOrchestration.getBotDefinition().getBotId());
        if (botAction == null) {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.startOrchestration$lambda$3($this$startOrchestration));
            return true;
        }
        OrchestrationResponse eligibility = this.callOrchestrationForEligibility($this$startOrchestration, botAction);
        if (eligibility instanceof EligibilityOrchestrationResponse) {
            bl = this.handleEligibleOrchestration($this$startOrchestration, (EligibilityOrchestrationResponse)eligibility, botAction);
        } else {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.startOrchestration$lambda$4(eligibility));
            bl = true;
        }
        return bl;
    }

    private final boolean handleEligibleOrchestration(BotBus $this$handleEligibleOrchestration, EligibilityOrchestrationResponse eligibility, SecondaryBotAction botAction) {
        boolean bl;
        RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.handleEligibleOrchestration$lambda$5(eligibility));
        OrchestrationResponse response = this.callOrchestrationForFirstAction($this$handleEligibleOrchestration, eligibility, botAction);
        if (response instanceof AvailableOrchestrationResponse) {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.handleEligibleOrchestration$lambda$6(response));
            this.orchestrationRepository.create($this$handleEligibleOrchestration.getAction().getPlayerId(), ((AvailableOrchestrationResponse)response).getBotResponse().getMetaData(), ((AvailableOrchestrationResponse)response).getTargetBot(), ((AvailableOrchestrationResponse)response).getBotResponse().getActions());
            this.configuration.getPrimaryBotOrchestrationEventHandler().onStarOrchestration($this$handleEligibleOrchestration, (AvailableOrchestrationResponse)response);
            Iterable $this$forEach$iv = ((AvailableOrchestrationResponse)response).getBotResponse().getActions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SecondaryBotAction it = (SecondaryBotAction)element$iv;
                boolean bl2 = false;
                BotBus.DefaultImpls.send$default((BotBus)$this$handleEligibleOrchestration, (Action)it.toAction(((AvailableOrchestrationResponse)response).getBotResponse().getMetaData()), (long)0L, (int)2, null);
            }
            Bus.DefaultImpls.end$default((Bus)((Bus)$this$handleEligibleOrchestration), (long)0L, (int)1, null);
            bl = false;
        } else {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.handleEligibleOrchestration$lambda$8(response));
            bl = true;
        }
        return bl;
    }

    private final OrchestrationResponse callOrchestrationForFirstAction(BotBus $this$callOrchestrationForFirstAction, EligibilityOrchestrationResponse eligibility, SecondaryBotAction botAction) {
        return this.orchestrator.resumeOrchestration(new ResumeOrchestrationRequest(eligibility.getTargetBot(), botAction, new OrchestrationMetaData($this$callOrchestrationForFirstAction.getUserId(), $this$callOrchestrationForFirstAction.getApplicationId(), $this$callOrchestrationForFirstAction.getBotId())));
    }

    private final OrchestrationResponse callOrchestrationForEligibility(BotBus $this$callOrchestrationForEligibility, SecondaryBotAction botAction) {
        OrchestrationResponse orchestrationResponse;
        OrchestrationData orchestrationData = this.configuration.getOrchestrationData($this$callOrchestrationForEligibility);
        if (orchestrationData != null) {
            OrchestrationData data = orchestrationData;
            boolean bl = false;
            orchestrationResponse = this.orchestrator.askOrchestration(new AskEligibilityToOrchestratorRequest(this.getEligibleBots($this$callOrchestrationForEligibility.getTargetConnectorType()), data, botAction, new OrchestrationMetaData($this$callOrchestrationForEligibility.getUserId(), $this$callOrchestrationForEligibility.getApplicationId(), $this$callOrchestrationForEligibility.getBotId())));
        } else {
            orchestrationResponse = null;
        }
        return orchestrationResponse;
    }

    private final boolean resumeOrchestration(BotBus $this$resumeOrchestration, Orchestration orchestration) {
        boolean bl;
        SecondaryBotAction botAction;
        RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$10(orchestration));
        if (!orchestration.getLocked()) {
            if (this.inStopOrchestrationList($this$resumeOrchestration.getIntent())) {
                RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$11($this$resumeOrchestration));
                this.orchestrationRepository.end(orchestration.getPlayerId());
                return this.configuration.getPrimaryBotOrchestrationEventHandler().onStopOrchestration($this$resumeOrchestration, orchestration) == ComeBackFromSecondary.EXECUTE_INITIAL_STORY;
            }
            if (this.inNoOrchestrationList($this$resumeOrchestration.getIntent())) {
                RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$12($this$resumeOrchestration));
                this.orchestrationRepository.end(orchestration.getPlayerId());
                return this.configuration.getPrimaryBotOrchestrationEventHandler().onNoOrchestration($this$resumeOrchestration, orchestration) == ComeBackFromSecondary.EXECUTE_INITIAL_STORY;
            }
            Function1<BotBus, Boolean> function1 = this.configuration.getTakeBackOrchestration();
            boolean bl2 = function1 != null ? ((Boolean)function1.invoke((Object)$this$resumeOrchestration)).booleanValue() : false;
            if (bl2) {
                RunOrchestrationStoryListenerKt.access$getLogger$p().info(RunOrchestrationStoryListener::resumeOrchestration$lambda$13);
                this.orchestrationRepository.end(orchestration.getPlayerId());
                return this.configuration.getPrimaryBotOrchestrationEventHandler().onTakeBackOrchestration($this$resumeOrchestration, orchestration) == ComeBackFromSecondary.EXECUTE_INITIAL_STORY;
            }
        }
        if ((botAction = SecondaryBotAction.Companion.from($this$resumeOrchestration.getAction(), $this$resumeOrchestration.getBotDefinition().getBotId())) == null) {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$14($this$resumeOrchestration));
            this.orchestrationRepository.end(orchestration.getPlayerId());
            $this$resumeOrchestration.send((CharSequence)("Damn, the conversation with " + orchestration.getTargetBot().getBotLabel() + " was interrupted."), new Object[0]);
            return true;
        }
        OrchestrationResponse response = this.orchestrator.resumeOrchestration(new ResumeOrchestrationRequest(orchestration.getTargetBot(), botAction, new OrchestrationMetaData($this$resumeOrchestration.getUserId(), $this$resumeOrchestration.getApplicationId(), $this$resumeOrchestration.getBotId())));
        if (response instanceof AvailableOrchestrationResponse) {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$15(orchestration));
            Iterable $this$forEach$iv = ((AvailableOrchestrationResponse)response).getBotResponse().getActions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SecondaryBotAction secondaryBotAction = (SecondaryBotAction)element$iv;
                boolean bl3 = false;
                this.orchestrationRepository.update(orchestration.getId(), secondaryBotAction);
                BotBus.DefaultImpls.send$default((BotBus)$this$resumeOrchestration, (Action)secondaryBotAction.toAction(((AvailableOrchestrationResponse)response).getBotResponse().getMetaData()), (long)0L, (int)2, null);
            }
            Bus.DefaultImpls.end$default((Bus)((Bus)$this$resumeOrchestration), (long)0L, (int)1, null);
            bl = false;
        } else {
            RunOrchestrationStoryListenerKt.access$getLogger$p().info(() -> RunOrchestrationStoryListener.resumeOrchestration$lambda$17(response));
            this.orchestrationRepository.end(orchestration.getPlayerId());
            if (orchestration.getTargetBot().getFallbackStory() != null) {
                BotBus.DefaultImpls.handleAndSwitchStory$default((BotBus)$this$resumeOrchestration, (StoryDefinition)orchestration.getTargetBot().getFallbackStory(), null, (int)2, null);
            } else {
                $this$resumeOrchestration.end((CharSequence)("Damn, the conversation with " + orchestration.getTargetBot().getBotLabel() + " was interrupted."), new Object[0]);
                BotBus.DefaultImpls.handleAndSwitchStory$default((BotBus)$this$resumeOrchestration, (StoryDefinition)this.configuration.getComebackStory(), null, (int)2, null);
            }
            bl = false;
        }
        return bl;
    }

    private final List<OrchestrationTargetedBot> getEligibleBots(ConnectorType $this$getEligibleBots) {
        return this.configuration.getEligibleTargetBots($this$getEligibleBots);
    }

    private final boolean inStartOrchestrationList(IntentAware $this$inStartOrchestrationList) {
        IntentAware intentAware = $this$inStartOrchestrationList;
        return CollectionsKt.contains((Iterable)this.configuration.getStartOrchestrationIntentList(), (Object)(intentAware != null ? intentAware.wrappedIntent() : null));
    }

    private final boolean inStopOrchestrationList(IntentAware $this$inStopOrchestrationList) {
        IntentAware intentAware = $this$inStopOrchestrationList;
        return CollectionsKt.contains((Iterable)this.configuration.getStopOrchestrationIntentList(), (Object)(intentAware != null ? intentAware.wrappedIntent() : null));
    }

    private final boolean inNoOrchestrationList(IntentAware $this$inNoOrchestrationList) {
        IntentAware intentAware = $this$inNoOrchestrationList;
        return CollectionsKt.contains((Iterable)this.configuration.getNoOrchestrationIntentList(), (Object)(intentAware != null ? intentAware.wrappedIntent() : null));
    }

    public void endAction(@NotNull BotBus botBus, @NotNull StoryHandler handler) {
        StoryHandlerListener.DefaultImpls.endAction((StoryHandlerListener)this, (BotBus)botBus, (StoryHandler)handler);
    }

    private static final boolean _init_$lambda$0() {
        return true;
    }

    private static final Object startOrchestration$lambda$2(BotBus $this_startOrchestration) {
        Intrinsics.checkNotNullParameter((Object)$this_startOrchestration, (String)"$this_startOrchestration");
        Object object = $this_startOrchestration.getIntent();
        if (object == null || (object = object.wrappedIntent()) == null || (object = object.getName()) == null) {
            object = "???";
        }
        return "Try to start an orchestration for intent " + (String)object;
    }

    private static final Object startOrchestration$lambda$3(BotBus $this_startOrchestration) {
        Intrinsics.checkNotNullParameter((Object)$this_startOrchestration, (String)"$this_startOrchestration");
        return "Failed to start orchestration caused by an unhandled Tock action " + $this_startOrchestration.getAction().getClass().getName();
    }

    private static final Object startOrchestration$lambda$4(OrchestrationResponse $eligibility) {
        Object object = $eligibility;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getName()) == null) {
            object = "null";
        }
        return "Fail to start an orchestration caused by a " + (String)object + " eligibility from the orchestrator";
    }

    private static final Object handleEligibleOrchestration$lambda$5(EligibilityOrchestrationResponse $eligibility) {
        Intrinsics.checkNotNullParameter((Object)$eligibility, (String)"$eligibility");
        return "Eligibility with " + $eligibility.getTargetBot() + " : " + $eligibility.getBotResponse().getIndice();
    }

    private static final Object handleEligibleOrchestration$lambda$6(OrchestrationResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return "Start an orchestration with " + ((AvailableOrchestrationResponse)$response).getTargetBot();
    }

    private static final Object handleEligibleOrchestration$lambda$8(OrchestrationResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        String string = $response.getClass().getName();
        if (string == null) {
            string = "null";
        }
        return "Fail to start an orchestration caused by a " + string + " response from the orchestrator";
    }

    private static final Object resumeOrchestration$lambda$10(Orchestration $orchestration) {
        Intrinsics.checkNotNullParameter((Object)$orchestration, (String)"$orchestration");
        return "Try to resume the orchestration to " + $orchestration.getTargetBot();
    }

    private static final Object resumeOrchestration$lambda$11(BotBus $this_resumeOrchestration) {
        Intrinsics.checkNotNullParameter((Object)$this_resumeOrchestration, (String)"$this_resumeOrchestration");
        Object object = $this_resumeOrchestration.getIntent();
        if (object == null || (object = object.wrappedIntent()) == null || (object = object.getName()) == null) {
            object = "???";
        }
        return "End of the orchestration caused by the " + (String)object + " intent";
    }

    private static final Object resumeOrchestration$lambda$12(BotBus $this_resumeOrchestration) {
        Intrinsics.checkNotNullParameter((Object)$this_resumeOrchestration, (String)"$this_resumeOrchestration");
        Object object = $this_resumeOrchestration.getIntent();
        if (object == null || (object = object.wrappedIntent()) == null || (object = object.getName()) == null) {
            object = "???";
        }
        return "End of the orchestration caused by the " + (String)object + " intent";
    }

    private static final Object resumeOrchestration$lambda$13() {
        return "End of the orchestration caused by take back";
    }

    private static final Object resumeOrchestration$lambda$14(BotBus $this_resumeOrchestration) {
        Intrinsics.checkNotNullParameter((Object)$this_resumeOrchestration, (String)"$this_resumeOrchestration");
        return "End of the orchestration caused by an unhandled Tock action " + $this_resumeOrchestration.getAction().getClass().getName();
    }

    private static final Object resumeOrchestration$lambda$15(Orchestration $orchestration) {
        Intrinsics.checkNotNullParameter((Object)$orchestration, (String)"$orchestration");
        return "Resume the orchestration to " + $orchestration.getTargetBot();
    }

    private static final Object resumeOrchestration$lambda$17(OrchestrationResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return "End of the orchestration caused by a " + $response.getClass().getName() + " response from the orchestrator";
    }
}

