/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.orchestration.bot.secondary;

import ai.tock.bot.connector.ConnectorCallbackBase;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.event.Event;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.orchestration.bot.secondary.OrchestrationCallback;
import ai.tock.bot.orchestration.shared.NoOrchestrationStatus;
import ai.tock.bot.orchestration.shared.OrchestrationMetaData;
import ai.tock.bot.orchestration.shared.SecondaryBotNoResponse;
import ai.tock.bot.orchestration.shared.SecondaryBotResponse;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/tock/bot/orchestration/bot/secondary/RestOrchestrationCallback;", "Lai/tock/bot/orchestration/bot/secondary/OrchestrationCallback;", "Lai/tock/bot/connector/ConnectorCallbackBase;", "connectorType", "Lai/tock/bot/connector/ConnectorType;", "applicationId", "", "context", "Lio/vertx/ext/web/RoutingContext;", "actions", "", "Lai/tock/bot/engine/action/Action;", "orchestrationMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lai/tock/bot/connector/ConnectorType;Ljava/lang/String;Lio/vertx/ext/web/RoutingContext;Ljava/util/List;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getActions", "()Ljava/util/List;", "logger", "Lmu/KLogger;", "sendResponse", "", "response", "Lai/tock/bot/orchestration/shared/SecondaryBotResponse;", "sendError", "exceptionThrown", "event", "Lai/tock/bot/engine/event/Event;", "throwable", "", "sendHttpResponse", "httpCode", "Lio/netty/handler/codec/http/HttpResponseStatus;", "tock-bot-orchestration"})
public class RestOrchestrationCallback
extends ConnectorCallbackBase
implements OrchestrationCallback {
    @NotNull
    private final RoutingContext context;
    @NotNull
    private final List<Action> actions;
    @NotNull
    private final ObjectMapper orchestrationMapper;
    @NotNull
    private final KLogger logger;

    public RestOrchestrationCallback(@NotNull ConnectorType connectorType, @NotNull String applicationId, @NotNull RoutingContext context, @NotNull List<Action> actions, @NotNull ObjectMapper orchestrationMapper) {
        Intrinsics.checkNotNullParameter((Object)connectorType, (String)"connectorType");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)orchestrationMapper, (String)"orchestrationMapper");
        super(applicationId, connectorType);
        this.context = context;
        this.actions = actions;
        this.orchestrationMapper = orchestrationMapper;
        this.logger = KotlinLogging.INSTANCE.logger(RestOrchestrationCallback::logger$lambda$0);
    }

    public /* synthetic */ RestOrchestrationCallback(ConnectorType connectorType, String string, RoutingContext routingContext, List list, ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            objectMapper = JacksonKt.getMapper();
        }
        this(connectorType, string, routingContext, list, objectMapper);
    }

    @Override
    @NotNull
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public void sendResponse() {
        this.sendResponse(SecondaryBotResponse.Companion.fromActions(this.getApplicationId(), this.getActions()));
    }

    @Override
    public void sendResponse(@NotNull SecondaryBotResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            this.sendHttpResponse(httpResponseStatus, response);
        }
        catch (Exception exception) {
            LoggersKt.error((KLogger)this.logger, (Throwable)exception);
            this.sendError();
        }
    }

    @Override
    public void sendError() {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
        this.sendHttpResponse(httpResponseStatus, new SecondaryBotNoResponse(NoOrchestrationStatus.ERROR, 0.0, new OrchestrationMetaData(new PlayerId("unknownWithError", null, null, 6, null), this.getApplicationId(), new PlayerId("bot", null, null, 6, null)), 2, null));
    }

    public void exceptionThrown(@NotNull Event event, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        super.exceptionThrown(event, throwable);
        this.sendError();
    }

    private final void sendHttpResponse(HttpResponseStatus httpCode, SecondaryBotResponse response) {
        HttpServerResponse res = this.context.response();
        res.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
        res.setStatusCode(httpCode.code());
        res.end(this.orchestrationMapper.writeValueAsString((Object)response));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }
}

