/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.orchestration.connector;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.connector.Connector;
import ai.tock.bot.connector.ConnectorService;
import ai.tock.bot.definition.BotAnswerInterceptor;
import ai.tock.bot.engine.BotRepository;
import ai.tock.bot.engine.ConnectorController;
import ai.tock.bot.orchestration.bot.primary.OrchestrationSecondaryBotResponseInterceptor;
import ai.tock.bot.orchestration.connector.OrchestrationConnector;
import ai.tock.bot.orchestration.connector.OrchestrationHandlers;
import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/tock/bot/orchestration/connector/OrchestrationService;", "Lai/tock/bot/connector/ConnectorService;", "<init>", "()V", "logger", "Lmu/KLogger;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "orchestrationEnabled", "", "install", "", "controller", "Lai/tock/bot/engine/ConnectorController;", "configuration", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "tock-bot-orchestration"})
@SourceDebugExtension(value={"SMAP\nOrchestrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrchestrationService.kt\nai/tock/bot/orchestration/connector/OrchestrationService\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,58:1\n53#2,2:59\n51#3:61\n277#4:62\n*S KotlinDebug\n*F\n+ 1 OrchestrationService.kt\nai/tock/bot/orchestration/connector/OrchestrationService\n*L\n33#1:59,2\n33#1:61\n33#1:62\n*E\n"})
public final class OrchestrationService
implements ConnectorService {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(OrchestrationService::logger$lambda$0);
    private final boolean orchestrationEnabled = PropertiesKt.booleanProperty((String)"tock_orchestration", (boolean)false);

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    public void install(@NotNull ConnectorController controller, @NotNull BotApplicationConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (this.orchestrationEnabled && controller.getConnector() instanceof OrchestrationConnector) {
            OrchestrationHandlers orchestrationHandlers;
            BotRepository.INSTANCE.registerBotAnswerInterceptor((BotAnswerInterceptor)new OrchestrationSecondaryBotResponseInterceptor());
            Connector connector = controller.getConnector();
            Intrinsics.checkNotNull((Object)connector, (String)"null cannot be cast to non-null type ai.tock.bot.orchestration.connector.OrchestrationConnector");
            OrchestrationHandlers $this$install_u24lambda_u246 = orchestrationHandlers = ((OrchestrationConnector)connector).getOrchestrationHandlers();
            boolean bl = false;
            String path = configuration.toConnectorConfiguration().getPath() + "/orchestration";
            controller.registerServices(path, arg_0 -> OrchestrationService.install$lambda$6$lambda$5(this, path, $this$install_u24lambda_u246, controller, arg_0));
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit install$lambda$6$lambda$5$lambda$2$lambda$1(OrchestrationHandlers $this_apply, ConnectorController $controller, RoutingContext $context) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Function2<ConnectorController, RoutingContext, Unit> function2 = $this_apply.getEligibilityHandler();
        Intrinsics.checkNotNull((Object)$context);
        function2.invoke((Object)$controller, (Object)$context);
        return Unit.INSTANCE;
    }

    private static final void install$lambda$6$lambda$5$lambda$2(OrchestrationService this$0, OrchestrationHandlers $this_apply, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        this$0.getExecutor().executeBlocking(() -> OrchestrationService.install$lambda$6$lambda$5$lambda$2$lambda$1($this_apply, $controller, context));
    }

    private static final Unit install$lambda$6$lambda$5$lambda$4$lambda$3(OrchestrationHandlers $this_apply, ConnectorController $controller, RoutingContext $context) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Function2<ConnectorController, RoutingContext, Unit> function2 = $this_apply.getProxyHandler();
        Intrinsics.checkNotNull((Object)$context);
        function2.invoke((Object)$controller, (Object)$context);
        return Unit.INSTANCE;
    }

    private static final void install$lambda$6$lambda$5$lambda$4(OrchestrationService this$0, OrchestrationHandlers $this_apply, ConnectorController $controller, RoutingContext context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        this$0.getExecutor().executeBlocking(() -> OrchestrationService.install$lambda$6$lambda$5$lambda$4$lambda$3($this_apply, $controller, context));
    }

    private static final Unit install$lambda$6$lambda$5(OrchestrationService this$0, String $path, OrchestrationHandlers $this_apply, ConnectorController $controller, Router router) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$controller, (String)"$controller");
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        this$0.logger.info("deploy orchestration services for root path " + $path + " ");
        router.post($path + "/eligibility").handler(arg_0 -> OrchestrationService.install$lambda$6$lambda$5$lambda$2(this$0, $this_apply, $controller, arg_0));
        router.post($path + "/proxy").handler(arg_0 -> OrchestrationService.install$lambda$6$lambda$5$lambda$4(this$0, $this_apply, $controller, arg_0));
        return Unit.INSTANCE;
    }
}

