/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.engine.feature.FeatureDAO;
import ai.tock.bot.engine.feature.FeatureState;
import ai.tock.bot.engine.feature.FeatureType;
import ai.tock.bot.mongo.Feature;
import ai.tock.bot.mongo.FeatureMongoDAO;
import ai.tock.bot.mongo.FeatureMongoDAO$$special$;
import ai.tock.bot.mongo.Feature_;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.shared.DatesKt;
import ai.tock.shared.LoggersKt;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;
import org.litote.kmongo.reactivestreams.PublishersKt;
import org.litote.kmongo.util.KMongoUtil;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J(\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J<\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0016J0\u0010\"\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lai/tock/bot/mongo/FeatureMongoDAO;", "Lai/tock/bot/engine/feature/FeatureDAO;", "()V", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lai/tock/bot/mongo/Feature;", "col", "Lcom/mongodb/client/MongoCollection;", "features", "Ljava/util/concurrent/ConcurrentHashMap;", "", "listener", "Lkotlin/Function1;", "Lcom/mongodb/client/model/changestream/ChangeStreamDocument;", "", "logger", "Lmu/KLogger;", "addFeature", "botId", "namespace", "enabled", "", "category", "name", "startDate", "Ljava/time/ZonedDateTime;", "endDate", "calculateId", "deleteFeature", "disable", "enable", "getFeatures", "", "Lai/tock/bot/engine/feature/FeatureState;", "isEnabled", "default", "tock-bot-storage-mongo"})
public final class FeatureMongoDAO
implements FeatureDAO {
    private static final KLogger logger;
    private static final MongoCollection<Feature> col;
    private static final com.mongodb.reactivestreams.client.MongoCollection<Feature> asyncCol;
    private static final ConcurrentHashMap<String, Feature> features;
    private static final Function1<ChangeStreamDocument<Feature>, Unit> listener;
    public static final FeatureMongoDAO INSTANCE;

    private final String calculateId(String botId, String namespace, String category, String name) {
        return botId + ',' + namespace + ',' + category + ',' + name;
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, boolean bl) {
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name);
        ZonedDateTime now = ZonedDateTime.now(DatesKt.getInternalDefaultZoneId());
        Feature feature = features.get(id);
        if (feature == null) {
            feature = (Feature)MongoCollectionsKt.findOne(col, (Bson)FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)id));
        }
        Feature feature2 = feature;
        boolean bl3 = false;
        boolean bl4 = false;
        Feature f = feature2;
        boolean bl5 = false;
        if (f == null) {
            boolean bl6 = bl;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean it = bl6;
            boolean bl9 = false;
            INSTANCE.addFeature(botId, namespace, bl, category, name, null, null);
            bl2 = bl6;
        } else {
            ((Map)features).put(id, f);
            bl2 = f.getStartDate() != null && f.getEndDate() == null ? f.getEnabled() && now.isAfter(f.getStartDate()) : (f.getStartDate() != null && f.getEndDate() != null ? f.getEnabled() && now.isAfter(f.getStartDate()) && now.isBefore(f.getEndDate()) : f.getEnabled());
        }
        return bl2;
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name);
        Feature feature = new Feature(id, category + ',' + name, true, botId, namespace, startDate, endDate);
        ((Map)features).put(id, feature);
        col.replaceOne(FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)id), (Object)feature, new ReplaceOptions().upsert(true));
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name);
        Feature feature = new Feature(id, category + ',' + name, false, botId, namespace, null, null, 96, null);
        ((Map)features).put(id, feature);
        col.replaceOne(FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)id), (Object)feature, new ReplaceOptions().upsert(true));
    }

    @NotNull
    public List<FeatureState> getFeatures(@NotNull String botId, @NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        MongoIterable $this$mapNotNull$iv = (MongoIterable)MongoCollectionsKt.find(col, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getNamespace()), (Object)namespace)});
        boolean $i$f$mapNotNull = false;
        return (List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends Feature>, List<? extends FeatureState>>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<FeatureState> invoke(@NotNull Iterable<? extends Feature> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Iterable<? extends Feature> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends Feature> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FeatureState featureState;
                    FeatureState featureState2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Feature it2 = (Feature)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        String string;
                        int n;
                        String string2;
                        int index = StringsKt.lastIndexOf$default((CharSequence)it2.getKey(), (char)',', (int)0, (boolean)false, (int)6, null);
                        if (index == -1) {
                            string2 = "";
                        } else {
                            String string3 = it2.getKey();
                            int n2 = 0;
                            n = 0;
                            String string4 = string3;
                            if (string4 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string5 = string4.substring(n2, index);
                            string2 = string5;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String category = string2;
                        if (index == -1) {
                            string = it2.getKey();
                        } else {
                            String string6 = it2.getKey();
                            n = index + 1;
                            int n3 = it2.getKey().length();
                            boolean bl3 = false;
                            String string7 = string6;
                            if (string7 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string8 = string7.substring(n, n3);
                            string = string8;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String name = string;
                        featureState2 = new FeatureState(category, name, it2.getEnabled(), it2.getStartDate(), it2.getEndDate());
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)FeatureMongoDAO.access$getLogger$p(FeatureMongoDAO.INSTANCE), (Throwable)e);
                        featureState2 = null;
                    }
                    if (featureState2 == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    FeatureState it$iv$iv = featureState;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name);
        Feature feature = new Feature(id, category + ',' + name, enabled, botId, namespace, startDate, endDate);
        ((Map)features).put(id, feature);
        MongoCollectionsKt.save(col, (Object)feature);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name);
        features.remove(id);
        MongoCollectionsKt.deleteOneById(col, (Object)id);
    }

    private FeatureMongoDAO() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        FeatureMongoDAO featureMongoDAO;
        INSTANCE = featureMongoDAO = new FeatureMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        com.mongodb.reactivestreams.client.MongoCollection<Feature> $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(Feature.class)), Feature.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        col = mongoCollection;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getAsyncDatabase();
        $i$f$getCollection = false;
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection2 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(Feature.class)), Feature.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection2, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        asyncCol = mongoCollection2;
        features = new ConcurrentHashMap();
        listener = listener.1.INSTANCE;
        try {
            void reopenListener$iv$iv;
            void errorListener$iv$iv;
            void subscribeListener$iv$iv;
            void fullDocument$iv;
            void $this$watchIndefinitely$iv$iv;
            void $this$watch$iv;
            FindPublisher findPublisher = asyncCol.find();
            Intrinsics.checkExpressionValueIsNotNull((Object)findPublisher, (String)"asyncCol.find()");
            PublishersKt.forEach((Publisher)((Publisher)findPublisher), (Function2)1.INSTANCE);
            $this$getCollection$iv = asyncCol;
            FullDocument $i$f$getCollection2 = FullDocument.UPDATE_LOOKUP;
            Function1<ChangeStreamDocument<Feature>, Unit> listener$iv = listener;
            boolean $i$f$watch = false;
            void var5_7 = $this$watch$iv;
            Function0 function0 = $special$$inlined$watch$1.INSTANCE;
            Function1 function1 = $special$$inlined$watch$2.INSTANCE;
            Function0 function02 = $special$$inlined$watch$3.INSTANCE;
            long reopenDelayInMS$iv$iv = 5000L;
            boolean $i$f$watchIndefinitely = false;
            MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<Feature>, ChangeStreamPublisher<Feature>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely$iv$iv, (FullDocument)fullDocument$iv){
                final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
                final /* synthetic */ FullDocument $fullDocument;
                {
                    this.$this_watchIndefinitely = mongoCollection;
                    this.$fullDocument = fullDocument;
                    super(1);
                }

                public final ChangeStreamPublisher<Feature> invoke(@NotNull com.mongodb.reactivestreams.client.MongoCollection<Feature> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(Feature.class).fullDocument(this.$fullDocument);
                    Intrinsics.checkExpressionValueIsNotNull((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                    return changeStreamPublisher;
                }
            }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, listener$iv);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, boolean bl) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (boolean)bl);
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FeatureDAO.DefaultImpls.enable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate);
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FeatureDAO.DefaultImpls.disable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type);
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FeatureDAO.DefaultImpls.addFeature((FeatureDAO)this, (String)botId, (String)namespace, (boolean)enabled, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type) {
        Intrinsics.checkParameterIsNotNull((Object)botId, (String)"botId");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        FeatureDAO.DefaultImpls.deleteFeature((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(FeatureMongoDAO $this) {
        FeatureMongoDAO featureMongoDAO = $this;
        return logger;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getFeatures$p(FeatureMongoDAO $this) {
        FeatureMongoDAO featureMongoDAO = $this;
        return features;
    }
}

