/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.mongo.I18nAlternativeIndex;
import ai.tock.bot.mongo.I18nAlternativeIndex_;
import ai.tock.bot.mongo.I18nMongoDAO;
import ai.tock.bot.mongo.I18nMongoDAO$alternativeIndexesFilter$1;
import ai.tock.bot.mongo.I18nMongoDAO$listenI18n$;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.translator.I18nDAO;
import ai.tock.translator.I18nLabel;
import ai.tock.translator.I18nLabelStat;
import ai.tock.translator.I18nLabelStat_;
import ai.tock.translator.I18nLabel_;
import ai.tock.translator.I18nLocalizedLabel;
import com.mongodb.Function;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.KMongoIterableKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.ProjectionsKt;
import org.litote.kmongo.UpdatesKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u0004\u0018\u00010\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\"2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\rH\u0016J\"\u0010&\u001a\u00020\u000f2\u0018\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001d\u0012\u0004\u0012\u00020\u000f0(H\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\bH\u0016J\u0016\u0010)\u001a\u00020\u000f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0016J\u0016\u0010+\u001a\u00020\u000f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J&\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u00120/j\b\u0012\u0004\u0012\u00020\u0012`02\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001201H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lai/tock/bot/mongo/I18nMongoDAO;", "Lai/tock/translator/I18nDAO;", "()V", "alternativeIndexCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/mongo/I18nAlternativeIndex;", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lai/tock/translator/I18nLabel;", "col", "logger", "Lmu/KLogger;", "statCol", "Lai/tock/translator/I18nLabelStat;", "addAlternativeIndex", "", "label", "localized", "Lai/tock/translator/I18nLocalizedLabel;", "alternativeIndex", "", "contextId", "", "alternativeIndexesFilter", "Lorg/bson/conversions/Bson;", "deleteAlternativeIndexes", "deleteByNamespaceAndId", "namespace", "id", "Lorg/litote/kmongo/Id;", "getAlternativeIndexes", "", "getLabelById", "getLabelStats", "", "getLabels", "incrementLabelStat", "stat", "listenI18n", "listener", "Lkotlin/Function1;", "save", "i18n", "saveIfNotExist", "sortLabels", "list", "sortLocalizedLabels", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "", "tock-bot-storage-mongo"})
public final class I18nMongoDAO
implements I18nDAO {
    private static final KLogger logger;
    private static final MongoCollection<I18nLabel> col;
    private static final com.mongodb.reactivestreams.client.MongoCollection<I18nLabel> asyncCol;
    private static final MongoCollection<I18nAlternativeIndex> alternativeIndexCol;
    private static final MongoCollection<I18nLabelStat> statCol;
    public static final I18nMongoDAO INSTANCE;

    private final List<I18nLabel> sortLabels(List<I18nLabel> list2) {
        return CollectionsKt.sortedWith((Iterable)list2, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{sortLabels.1.INSTANCE, sortLabels.2.INSTANCE}));
    }

    private final LinkedHashSet<I18nLocalizedLabel> sortLocalizedLabels(Set<I18nLocalizedLabel> list2) {
        return new LinkedHashSet<I18nLocalizedLabel>(CollectionsKt.sortedWith((Iterable)list2, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{sortLocalizedLabels.1.INSTANCE, sortLocalizedLabels.2.INSTANCE, sortLocalizedLabels.3.INSTANCE})));
    }

    private final I18nLabel sortLocalizedLabels(I18nLabel label) {
        return I18nLabel.copy$default((I18nLabel)label, null, null, null, this.sortLocalizedLabels(label.getI18n()), null, null, (int)(label.getVersion() + 1), (int)55, null);
    }

    /*
     * WARNING - void declaration
     */
    public void listenI18n(@NotNull Function1<? super Id<I18nLabel>, Unit> listener2) {
        void reopenListener$iv$iv;
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void $this$watchIndefinitely$iv$iv;
        void $this$watch$iv;
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<I18nLabel> mongoCollection = asyncCol;
        Function1 listener$iv = (Function1)new Function1<ChangeStreamDocument<I18nLabel>, Unit>(listener2){
            final /* synthetic */ Function1 $listener;

            public final void invoke(@NotNull ChangeStreamDocument<I18nLabel> it) {
                block1: {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    BsonDocument bsonDocument = it.getDocumentKey();
                    if (bsonDocument == null || (bsonDocument = (BsonValue)bsonDocument.get((Object)"_id")) == null) break block1;
                    BsonDocument bsonDocument2 = bsonDocument;
                    boolean bl = false;
                    boolean bl2 = false;
                    BsonDocument id = bsonDocument2;
                    boolean bl3 = false;
                    BsonDocument bsonDocument3 = id;
                    if (bsonDocument3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.bson.BsonString");
                    }
                    String string = ((BsonString)bsonDocument3).getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(id as BsonString).value");
                    this.$listener.invoke((Object)IdsKt.toId((String)string));
                }
            }
            {
                this.$listener = function1;
                super(1);
            }
        };
        FullDocument fullDocument$iv = FullDocument.DEFAULT;
        boolean $i$f$watch = false;
        void var6_6 = $this$watch$iv;
        Function0 function0 = listenI18n$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenI18n$$inlined$watch$2.INSTANCE;
        Function0 function02 = listenI18n$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<I18nLabel>, ChangeStreamPublisher<I18nLabel>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely$iv$iv, fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = mongoCollection;
                this.$fullDocument = fullDocument;
                super(1);
            }

            public final ChangeStreamPublisher<I18nLabel> invoke(@NotNull com.mongodb.reactivestreams.client.MongoCollection<I18nLabel> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(I18nLabel.class).fullDocument(this.$fullDocument);
                Intrinsics.checkExpressionValueIsNotNull((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    @NotNull
    public List<I18nLabel> getLabels(@NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        FindIterable findIterable = col.find(FiltersKt.eq((KProperty)((KProperty)I18nLabel_.Companion.getNamespace()), (Object)namespace));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find(I18nLabel_.Namespace eq namespace)");
        return this.sortLabels(KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable)));
    }

    @Nullable
    public I18nLabel getLabelById(@NotNull Id<I18nLabel> id) {
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        return (I18nLabel)MongoCollectionsKt.findOneById(col, id);
    }

    public void save(@NotNull I18nLabel i18n2) {
        Intrinsics.checkParameterIsNotNull((Object)i18n2, (String)"i18n");
        MongoCollectionsKt.save(col, (Object)this.sortLocalizedLabels(i18n2));
    }

    public void save(@NotNull List<I18nLabel> i18n2) {
        Intrinsics.checkParameterIsNotNull(i18n2, (String)"i18n");
        Iterable $this$forEach$iv = i18n2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            I18nLabel it = (I18nLabel)element$iv;
            boolean bl = false;
            INSTANCE.save(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveIfNotExist(@NotNull List<I18nLabel> i18n2) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object object;
        I18nLabel it;
        Object object2;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(i18n2, (String)"i18n");
        FindIterable findIterable = col.find();
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col.find()");
        Iterable $this$map$iv = this.sortLabels(KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable)));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            I18nLabel i18nLabel = (I18nLabel)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.get_id();
            object2.add(object);
        }
        Set existingIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = i18n2;
        object2 = this;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (I18nLabel)element$iv$iv;
            boolean bl = false;
            if (existingIds.contains(it.get_id())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        ((I18nMongoDAO)object2).save((List<I18nLabel>)object);
    }

    public void deleteByNamespaceAndId(@NotNull String namespace, @NotNull Id<I18nLabel> id) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull(id, (String)"id");
        MongoCollectionsKt.deleteOne(col, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)I18nLabel_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)I18nLabel_.Companion.get_id()), id)});
    }

    public void addAlternativeIndex(@NotNull I18nLabel label, @NotNull I18nLocalizedLabel localized, int alternativeIndex, @NotNull String contextId) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)localized, (String)"localized");
        Intrinsics.checkParameterIsNotNull((Object)contextId, (String)"contextId");
        try {
            alternativeIndexCol.insertOne((Object)new I18nAlternativeIndex(label, localized, alternativeIndex, contextId));
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    private final Bson alternativeIndexesFilter(I18nLabel label, I18nLocalizedLabel localized, String contextId) {
        return FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)I18nAlternativeIndex_.Companion.getContextId()), (Object)contextId), FiltersKt.eq((KProperty)((KProperty)I18nAlternativeIndex_.Companion.getLabelId()), (Object)label.get_id()), FiltersKt.eq((KProperty)((KProperty)new I18nMongoDAO$alternativeIndexesFilter$1(label)), (Object)label.getNamespace()), FiltersKt.eq((KProperty)((KProperty)I18nAlternativeIndex_.Companion.getLocale()), (Object)localized.getLocale()), FiltersKt.eq((KProperty)((KProperty)I18nAlternativeIndex_.Companion.getInterfaceType()), (Object)localized.getInterfaceType()), FiltersKt.eq((KProperty)((KProperty)I18nAlternativeIndex_.Companion.getConnectorId()), (Object)localized.getConnectorId())});
    }

    public void deleteAlternativeIndexes(@NotNull I18nLabel label, @NotNull I18nLocalizedLabel localized, @NotNull String contextId) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)localized, (String)"localized");
        Intrinsics.checkParameterIsNotNull((Object)contextId, (String)"contextId");
        try {
            alternativeIndexCol.deleteMany(this.alternativeIndexesFilter(label, localized, contextId));
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    @NotNull
    public Set<Integer> getAlternativeIndexes(@NotNull I18nLabel label, @NotNull I18nLocalizedLabel localized, @NotNull String contextId) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)localized, (String)"localized");
        Intrinsics.checkParameterIsNotNull((Object)contextId, (String)"contextId");
        try {
            MongoCollection<I18nAlternativeIndex> $this$withDocumentClass$iv = alternativeIndexCol;
            boolean $i$f$withDocumentClass = false;
            MongoCollection mongoCollection = $this$withDocumentClass$iv.withDocumentClass(Document.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"withDocumentClass(NewTDocument::class.java)");
            MongoIterable mongoIterable = mongoCollection.find(this.alternativeIndexesFilter(label, localized, contextId)).projection(ProjectionsKt.fields((Bson[])new Bson[]{ProjectionsKt.include((KProperty[])new KProperty[]{(KProperty)I18nAlternativeIndex_.Companion.getIndex()}), ProjectionsKt.excludeId()})).map((Function)getAlternativeIndexes.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)mongoIterable, (String)"alternativeIndexCol\n    \u2026.getInteger(Index.name) }");
            set = KMongoIterableKt.toSet((MongoIterable)mongoIterable);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
            set = SetsKt.emptySet();
        }
        return set;
    }

    public void incrementLabelStat(@NotNull I18nLabelStat stat) {
        Intrinsics.checkParameterIsNotNull((Object)stat, (String)"stat");
        I18nLabelStat_.Companion companion = I18nLabelStat_.Companion;
        boolean bl = false;
        boolean bl2 = false;
        I18nLabelStat_.Companion $this$apply = companion;
        boolean bl3 = false;
        statCol.updateOne(FiltersKt.and((Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)$this$apply.getLabelId()), (Object)stat.getLabelId()), FiltersKt.eq((KProperty)((KProperty)$this$apply.getLocale()), (Object)stat.getLocale()), FiltersKt.eq((KProperty)((KProperty)$this$apply.getInterfaceType()), (Object)stat.getInterfaceType()), FiltersKt.eq((KProperty)((KProperty)$this$apply.getConnectorId()), (Object)stat.getConnectorId())}), UpdatesKt.combine((Bson[])new Bson[]{UpdatesKt.inc((KProperty)((KProperty)$this$apply.getCount()), (Number)stat.getCount()), UpdatesKt.currentDate((KProperty)((KProperty)$this$apply.getLastUpdate())), UpdatesKt.setValue((KProperty)((KProperty)$this$apply.getNamespace()), (Object)stat.getNamespace())}), UpdatesKt.upsert());
    }

    @NotNull
    public List<I18nLabelStat> getLabelStats(@NotNull String namespace) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        FindIterable findIterable = statCol.find(FiltersKt.eq((KProperty)((KProperty)I18nLabelStat_.Companion.getNamespace()), (Object)namespace));
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"statCol.find(I18nLabelSt\u2026_.Namespace eq namespace)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    private I18nMongoDAO() {
    }

    static {
        I18nMongoDAO i18nMongoDAO;
        INSTANCE = i18nMongoDAO = new I18nMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        MongoDatabase $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(I18nLabel.class)), I18nLabel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        col = mongoCollection;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getAsyncDatabase();
        $i$f$getCollection = false;
        com.mongodb.reactivestreams.client.MongoCollection mongoCollection2 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(I18nLabel.class)), I18nLabel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection2, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        asyncCol = mongoCollection2;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        $i$f$getCollection = false;
        MongoCollection mongoCollection3 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(I18nAlternativeIndex.class)), I18nAlternativeIndex.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection3, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        $this$getCollection$iv = mongoCollection3;
        $i$f$getCollection = false;
        boolean bl = false;
        MongoDatabase $this$apply = $this$getCollection$iv;
        boolean bl2 = false;
        MongoCollectionsKt.ensureIndex$default((MongoCollection)$this$apply, (KProperty[])new KProperty[]{(KProperty)I18nAlternativeIndex_.Companion.getContextId(), (KProperty)I18nAlternativeIndex_.Companion.getLabelId(), (KProperty)I18nAlternativeIndex_.Companion.getNamespace(), (KProperty)I18nAlternativeIndex_.Companion.getLocale(), (KProperty)I18nAlternativeIndex_.Companion.getInterfaceType(), (KProperty)I18nAlternativeIndex_.Companion.getConnectorId()}, null, (int)2, null);
        IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"tock_bot_alternative_index_ttl_hours", (long)1L)), TimeUnit.HOURS);
        Intrinsics.checkExpressionValueIsNotNull((Object)indexOptions, (String)"IndexOptions().expireAft\u2026eUnit.HOURS\n            )");
        Object object = new KProperty[]{(KProperty)I18nAlternativeIndex_.Companion.getDate()};
        IndexOptions indexOptions2 = indexOptions;
        MongoCollectionsKt.ensureIndex((MongoCollection)$this$apply, (KProperty[])object, (IndexOptions)indexOptions2);
        alternativeIndexCol = $this$getCollection$iv;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        $i$f$getCollection = false;
        MongoCollection mongoCollection4 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(I18nLabelStat.class)), I18nLabelStat.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection4, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        MongoCollection mongoCollection5 = mongoCollection4;
        boolean bl3 = false;
        bl = false;
        $this$apply = mongoCollection5;
        boolean bl4 = false;
        object = I18nLabelStat_.Companion;
        boolean bl5 = false;
        boolean bl6 = false;
        Object $this$apply2 = object;
        boolean bl7 = false;
        MongoCollectionsKt.ensureUniqueIndex$default((MongoCollection)$this$apply, (KProperty[])new KProperty[]{(KProperty)((I18nLabelStat_.Companion)$this$apply2).getLabelId(), (KProperty)((I18nLabelStat_.Companion)$this$apply2).getLocale(), (KProperty)((I18nLabelStat_.Companion)$this$apply2).getInterfaceType(), (KProperty)((I18nLabelStat_.Companion)$this$apply2).getConnectorId()}, null, (int)2, null);
        MongoCollectionsKt.ensureIndex$default((MongoCollection)$this$apply, (KProperty[])new KProperty[]{(KProperty)((I18nLabelStat_.Companion)$this$apply2).getNamespace()}, null, (int)2, null);
        statCol = mongoCollection5;
    }
}

