/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.admin.test.TestPlan;
import ai.tock.bot.admin.test.TestPlanDAO;
import ai.tock.bot.admin.test.TestPlanExecution;
import ai.tock.bot.admin.test.TestPlanExecution_;
import ai.tock.bot.admin.test.TestPlan_;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J \u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/tock/bot/mongo/TestPlanMongoDAO;", "Lai/tock/bot/admin/test/TestPlanDAO;", "()V", "testPlanCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/admin/test/TestPlan;", "testPlanExecutionCol", "Lai/tock/bot/admin/test/TestPlanExecution;", "getPlanExecution", "testPlanId", "Lorg/litote/kmongo/Id;", "getPlanExecutions", "", "getPlansByApplicationId", "applicationId", "", "getTestPlan", "getTestPlanExecution", "testPlan", "testPlanExecutionId", "getTestPlans", "removeTestPlan", "", "planId", "saveTestExecution", "testPlanExecution", "saveTestPlan", "tock-bot-storage-mongo"})
public final class TestPlanMongoDAO
implements TestPlanDAO {
    private static final MongoCollection<TestPlan> testPlanCol;
    private static final MongoCollection<TestPlanExecution> testPlanExecutionCol;
    @NotNull
    public static final TestPlanMongoDAO INSTANCE;

    public void saveTestPlan(@NotNull TestPlan testPlan) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        MongoCollectionsKt.save(testPlanCol, (Object)testPlan);
    }

    public void removeTestPlan(@NotNull Id<TestPlan> planId) {
        Intrinsics.checkNotNullParameter(planId, (String)"planId");
        MongoCollectionsKt.deleteOneById(testPlanCol, planId);
        testPlanExecutionCol.deleteMany(FiltersKt.eq((KProperty)((KProperty)TestPlanExecution_.Companion.getTestPlanId()), planId));
    }

    public void saveTestExecution(@NotNull TestPlanExecution testPlanExecution) {
        Intrinsics.checkNotNullParameter((Object)testPlanExecution, (String)"testPlanExecution");
        MongoCollectionsKt.save(testPlanExecutionCol, (Object)testPlanExecution);
    }

    @Nullable
    public TestPlan getTestPlan(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        return (TestPlan)MongoCollectionsKt.findOneById(testPlanCol, testPlanId);
    }

    @Nullable
    public TestPlanExecution getTestPlanExecution(@NotNull TestPlan testPlan, @NotNull Id<TestPlanExecution> testPlanExecutionId) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        Intrinsics.checkNotNullParameter(testPlanExecutionId, (String)"testPlanExecutionId");
        return (TestPlanExecution)MongoCollectionsKt.findOneById(testPlanExecutionCol, testPlanExecutionId);
    }

    @NotNull
    public List<TestPlan> getPlansByApplicationId(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        FindIterable findIterable = testPlanCol.find(FiltersKt.eq((KProperty)((KProperty)TestPlan_.Companion.getApplicationId()), (Object)applicationId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"testPlanCol.find(ApplicationId eq applicationId)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.ascendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)TestPlan_.Companion.getName()})));
    }

    @NotNull
    public List<TestPlan> getTestPlans() {
        FindIterable findIterable = testPlanCol.find();
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"testPlanCol.find()");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.ascendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)TestPlan_.Companion.getName()})));
    }

    @NotNull
    public List<TestPlanExecution> getPlanExecutions(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        FindIterable findIterable = testPlanExecutionCol.find(FiltersKt.eq((KProperty)((KProperty)TestPlanExecution_.Companion.getTestPlanId()), testPlanId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"testPlanExecutionCol.fin\u2026TestPlanId eq testPlanId)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])new KProperty[]{(KProperty)TestPlanExecution_.Companion.getDate()})));
    }

    @Nullable
    public TestPlanExecution getPlanExecution(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        return (TestPlanExecution)MongoCollectionsKt.findOneById(testPlanExecutionCol, testPlanId);
    }

    private TestPlanMongoDAO() {
    }

    static {
        TestPlanMongoDAO testPlanMongoDAO;
        INSTANCE = testPlanMongoDAO = new TestPlanMongoDAO();
        MongoDatabase $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(TestPlan.class)), TestPlan.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        testPlanCol = mongoCollection;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        $i$f$getCollection = false;
        MongoCollection mongoCollection2 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(TestPlanExecution.class)), TestPlanExecution.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection2, (String)"getCollection(defaultCol\u2026T::class), T::class.java)");
        testPlanExecutionCol = mongoCollection2;
        MongosKt.ensureIndex$default(testPlanCol, (KProperty[])new KProperty[]{(KProperty)TestPlan_.Companion.getApplicationId()}, null, (int)2, null);
    }
}

