/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.engine.feature.FeatureDAO;
import ai.tock.bot.engine.feature.FeatureState;
import ai.tock.bot.engine.feature.FeatureType;
import ai.tock.bot.mongo.Feature;
import ai.tock.bot.mongo.FeatureMongoDAO;
import ai.tock.bot.mongo.Feature_;
import ai.tock.bot.mongo.ai.tock.bot.mongo.FeatureCache;
import ai.tock.shared.DatesKt;
import ai.tock.shared.LoggersKt;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007JN\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0002J2\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002J2\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J2\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016JF\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J(\u0010 \u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0006H\u0002J:\u0010$\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010&\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lai/tock/bot/mongo/FeatureMongoDAO;", "Lai/tock/bot/engine/feature/FeatureDAO;", "cache", "Lai/tock/bot/mongo/ai/tock/bot/mongo/FeatureCache;", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/mongo/Feature;", "(Lai/tock/bot/mongo/ai/tock/bot/mongo/FeatureCache;Lcom/mongodb/client/MongoCollection;)V", "logger", "Lmu/KLogger;", "addFeature", "", "botId", "", "namespace", "enabled", "", "category", "name", "startDate", "Ljava/time/ZonedDateTime;", "endDate", "applicationId", "cacheAllConnectorFeatureWithId", "globalId", "calculateId", "deleteFeature", "disable", "enable", "getFeatures", "", "Lai/tock/bot/engine/feature/FeatureState;", "getValues", "Lkotlin/Pair;", "id", "idWithoutApplicationId", "isEnabled", "feature", "default", "tock-bot-storage-mongo"})
public final class FeatureMongoDAO
implements FeatureDAO {
    @NotNull
    private final FeatureCache cache;
    @NotNull
    private final MongoCollection<Feature> col;
    @NotNull
    private final KLogger logger;

    public FeatureMongoDAO(@NotNull FeatureCache cache, @NotNull MongoCollection<Feature> col) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter(col, (String)"col");
        this.cache = cache;
        this.col = col;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final String calculateId(String botId, String namespace, String category, String name, String applicationId) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(botId).append(',').append(namespace).append(',').append(category).append(',').append(name);
        String string2 = applicationId;
        if (string2 == null) {
            string = "";
        } else {
            void it;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String string4 = string3;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl3 = false;
            String string5 = Intrinsics.stringPlus((String)"+", (Object)it);
            stringBuilder = stringBuilder2;
            String string6 = string5;
            string = string6 == null ? "" : string6;
        }
        return stringBuilder.append(string).toString();
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        String idWithoutApplicationId = this.calculateId(botId, namespace, category, name, null);
        Pair<Feature, Feature> pair = this.getValues(id, idWithoutApplicationId);
        Feature connectorFeature = (Feature)pair.component1();
        Feature globalFeature = (Feature)pair.component2();
        if (connectorFeature == null && globalFeature == null) {
            boolean bl3 = bl;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean it = bl3;
            boolean bl6 = false;
            this.addFeature(botId, namespace, bl, category, name, null, null, null);
            bl2 = bl3;
        } else {
            Feature feature = connectorFeature;
            Feature feature2 = feature == null ? globalFeature : feature;
            Intrinsics.checkNotNull((Object)feature2);
            Feature feature3 = feature2;
            bl2 = this.isEnabled(feature3);
        }
        return bl2;
    }

    private final boolean isEnabled(Feature feature) {
        ZonedDateTime now = ZonedDateTime.now(DatesKt.getInternalDefaultZoneId());
        return feature.getStartDate() != null && feature.getEndDate() == null ? feature.getEnabled() && now.isAfter(feature.getStartDate()) : (feature.getStartDate() != null && feature.getEndDate() != null ? feature.getEnabled() && now.isAfter(feature.getStartDate()) && now.isBefore(feature.getEndDate()) : feature.getEnabled());
    }

    private final Pair<Feature, Feature> getValues(String id, String idWithoutApplicationId) {
        Pair pair;
        Feature cacheForId = this.cache.stateOf(id);
        Feature cacheForIdWithoutApplicationId = this.cache.stateOf(idWithoutApplicationId);
        if (cacheForId == null && cacheForIdWithoutApplicationId == null) {
            Feature feature;
            Object object;
            Feature it;
            boolean bl;
            boolean bl2;
            Feature feature2;
            Feature feature3;
            this.cacheAllConnectorFeatureWithId(idWithoutApplicationId);
            Feature feature4 = (Feature)MongoCollectionsKt.findOne(this.col, (Bson)FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)id));
            if (feature4 == null) {
                feature3 = null;
            } else {
                feature2 = feature4;
                bl2 = false;
                bl = false;
                it = feature2;
                boolean bl3 = false;
                this.cache.setState(id, it);
                object = Unit.INSTANCE;
                feature3 = feature2;
            }
            feature4 = (Feature)MongoCollectionsKt.findOne(this.col, (Bson)FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)idWithoutApplicationId));
            if (feature4 == null) {
                feature = null;
            } else {
                feature2 = feature4;
                bl2 = false;
                bl = false;
                it = feature2;
                object = feature3;
                boolean bl4 = false;
                this.cache.setState(idWithoutApplicationId, it);
                Unit unit = Unit.INSTANCE;
                feature3 = object;
                feature = feature2;
            }
            Feature feature5 = feature;
            Feature feature6 = feature3;
            pair = new Pair((Object)feature6, feature5);
        } else {
            pair = new Pair((Object)cacheForId, (Object)cacheForIdWithoutApplicationId);
        }
        Pair pair2 = pair;
        return pair2;
    }

    private final void cacheAllConnectorFeatureWithId(String globalId) {
        Iterable $this$forEach$iv = KMongoIterableKt.toList((MongoIterable)((MongoIterable)MongoCollectionsKt.find(this.col, (String)("{\"_id\": /^" + globalId + "\\+/}"))));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Feature it = (Feature)element$iv;
            boolean bl = false;
            String string = it.get_id();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.cache.setState(string, it);
        }
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + ',' + name, true, botId, namespace, startDate, endDate);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + ',' + name, false, botId, namespace, null, null, 96, null);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    @NotNull
    public List<FeatureState> getFeatures(@NotNull String botId, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getNamespace()), (Object)namespace)};
        MongoIterable $this$mapNotNull$iv = (MongoIterable)MongoCollectionsKt.find(this.col, (Bson[])bsonArray);
        boolean $i$f$mapNotNull = false;
        return (List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends Feature>, List<? extends FeatureState>>(this){
            final /* synthetic */ FeatureMongoDAO this$0;
            {
                this.this$0 = featureMongoDAO;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<FeatureState> invoke(@NotNull Iterable<? extends Feature> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Iterable<? extends Feature> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends Feature> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FeatureState featureState;
                    FeatureState featureState2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Feature it2 = (Feature)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        String string;
                        boolean bl3;
                        int n;
                        String string2;
                        int n2;
                        String string3;
                        int index = StringsKt.lastIndexOf$default((CharSequence)it2.getKey(), (char)',', (int)0, (boolean)false, (int)6, null);
                        int applicationIndex = StringsKt.lastIndexOf$default((CharSequence)it2.get_id(), (char)'+', (int)0, (boolean)false, (int)6, null);
                        if (index == -1) {
                            string3 = "";
                        } else {
                            String string4 = it2.getKey();
                            int n3 = 0;
                            n2 = 0;
                            String string5 = string4;
                            if (string5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string6 = string5.substring(n3, index);
                            string3 = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String category = string3;
                        if (index == -1) {
                            string2 = it2.getKey();
                        } else {
                            String string7 = it2.getKey();
                            n2 = index + 1;
                            n = it2.getKey().length();
                            bl3 = false;
                            String string8 = string7;
                            if (string8 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string9 = string8.substring(n2, n);
                            string2 = string9;
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String name = string2;
                        if (applicationIndex == -1) {
                            string = null;
                        } else {
                            String string10 = it2.get_id();
                            n = applicationIndex + 1;
                            bl3 = false;
                            String string11 = string10;
                            if (string11 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string12 = string11.substring(n);
                            string = string12;
                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                        }
                        String applicationId = string;
                        featureState2 = new FeatureState(category, name, it2.getEnabled(), it2.getStartDate(), it2.getEndDate(), applicationId);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)FeatureMongoDAO.access$getLogger$p(this.this$0), (Throwable)e);
                        featureState2 = null;
                    }
                    if (featureState2 == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    FeatureState it$iv$iv = featureState;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + ',' + name, enabled, botId, namespace, startDate, endDate);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        MongoCollectionsKt.deleteOneById(this.col, (Object)id);
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.addFeature((FeatureDAO)this, (String)botId, (String)namespace, (boolean)enabled, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate, (String)applicationId);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.deleteFeature((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId);
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.disable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId);
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.enable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate, (String)applicationId);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (String)category, (String)name, (boolean)bl);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId, (boolean)bl);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (boolean)bl);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(FeatureMongoDAO $this) {
        return $this.logger;
    }
}

