/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.admin.answer.AnswerConfigurationType;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationDAO;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationSummary;
import ai.tock.bot.admin.story.StoryDefinitionConfigurationSummaryRequest;
import ai.tock.bot.admin.story.StoryDefinitionConfiguration_;
import ai.tock.bot.definition.StoryTag;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.bot.mongo.StoryDefinitionConfigurationHistoryCol_;
import ai.tock.bot.mongo.StoryDefinitionConfigurationMongoDAO;
import ai.tock.bot.mongo.StoryDefinitionConfigurationMongoDAO$listenChanges$;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.SortsKt;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aH\u0016J\"\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0016\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"H\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/tock/bot/mongo/StoryDefinitionConfigurationMongoDAO;", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationDAO;", "()V", "asyncCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lai/tock/bot/admin/story/StoryDefinitionConfiguration;", "col", "Lcom/mongodb/client/MongoCollection;", "historyCol", "Lai/tock/bot/mongo/StoryDefinitionConfigurationMongoDAO$StoryDefinitionConfigurationHistoryCol;", "logger", "Lmu/KLogger;", "createBuiltInStoriesIfNotExist", "", "stories", "", "delete", "story", "getConfiguredStoryDefinitionByNamespaceAndBotIdAndIntent", "namespace", "", "botId", "intent", "getRuntimeStorySettings", "getStoryDefinitionById", "id", "Lorg/litote/kmongo/Id;", "getStoryDefinitionByNamespaceAndBotIdAndIntent", "getStoryDefinitionByNamespaceAndBotIdAndStoryId", "storyId", "getStoryDefinitionsByNamespaceAndBotId", "getStoryDefinitionsByNamespaceBotIdStoryId", "listenChanges", "listener", "Lkotlin/Function0;", "save", "searchStoryDefinitionSummaries", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationSummary;", "request", "Lai/tock/bot/admin/story/StoryDefinitionConfigurationSummaryRequest;", "StoryDefinitionConfigurationHistoryCol", "tock-bot-storage-mongo"})
public final class StoryDefinitionConfigurationMongoDAO
implements StoryDefinitionConfigurationDAO {
    @NotNull
    public static final StoryDefinitionConfigurationMongoDAO INSTANCE;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final MongoCollection<StoryDefinitionConfiguration> col;
    @NotNull
    private static final com.mongodb.reactivestreams.client.MongoCollection<StoryDefinitionConfiguration> asyncCol;
    @NotNull
    private static final MongoCollection<StoryDefinitionConfigurationHistoryCol> historyCol;

    private StoryDefinitionConfigurationMongoDAO() {
    }

    /*
     * WARNING - void declaration
     */
    public void listenChanges(@NotNull Function0<Unit> listener) {
        void reopenListener$iv$iv;
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void $this$watchIndefinitely_u24default$iv$iv;
        void $this$watch_u24default$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<StoryDefinitionConfiguration> mongoCollection = asyncCol;
        Function1 listener$iv = (Function1)new Function1<ChangeStreamDocument<StoryDefinitionConfiguration>, Unit>(listener){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
                super(1);
            }

            public final void invoke(@NotNull ChangeStreamDocument<StoryDefinitionConfiguration> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$listener.invoke();
            }
        };
        FullDocument fullDocument$iv = FullDocument.DEFAULT;
        boolean $i$f$watch = false;
        void var6_6 = $this$watch_u24default$iv;
        Function0 function0 = listenChanges$$inlined$watch$default$1.INSTANCE;
        Function1 function1 = listenChanges$$inlined$watch$default$2.INSTANCE;
        Function0 function02 = listenChanges$$inlined$watch$default$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<StoryDefinitionConfiguration>, ChangeStreamPublisher<StoryDefinitionConfiguration>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = $receiver;
                this.$fullDocument = $fullDocument;
                super(1);
            }

            @NotNull
            public final ChangeStreamPublisher<StoryDefinitionConfiguration> invoke(@NotNull com.mongodb.reactivestreams.client.MongoCollection<StoryDefinitionConfiguration> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(StoryDefinitionConfiguration.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    @Nullable
    public StoryDefinitionConfiguration getStoryDefinitionById(@NotNull Id<StoryDefinitionConfiguration> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return (StoryDefinitionConfiguration)MongoCollectionsKt.findOneById(col, id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<StoryDefinitionConfiguration> getRuntimeStorySettings(@NotNull String namespace, @NotNull String botId) {
        Collection<Bson> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Bson[] bsonArray = new Bson[3];
        bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace);
        bsonArray[1] = FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId);
        StoryTag[] storyTagArray = StoryTag.values();
        int n = 2;
        Bson[] bsonArray2 = bsonArray;
        MongoCollection<StoryDefinitionConfiguration> mongoCollection = col;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var10_12 = $this$mapTo$iv$iv;
        int n2 = ((void)var10_12).length;
        for (int i = 0; i < n2; ++i) {
            void it;
            void item$iv$iv;
            void var14_16 = item$iv$iv = var10_12[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Bson bson = FiltersKt.contains((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getTags()), (Object)it);
            collection.add(bson);
        }
        collection = (List)destination$iv$iv;
        bsonArray2[n] = FiltersKt.or((Iterable)collection);
        FindIterable findIterable = mongoCollection.find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"col.find(\n            and(\n                Namespace eq namespace,\n                BotId eq botId,\n                or(StoryTag.values().map { Tags contains it })\n            )\n        )");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @Nullable
    public StoryDefinitionConfiguration getConfiguredStoryDefinitionByNamespaceAndBotIdAndIntent(@NotNull String namespace, @NotNull String botId, @NotNull String intent2) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId), FiltersKt.ne((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getCurrentType()), (Object)AnswerConfigurationType.builtin), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getIntent().getName_()), (Object)intent2)};
        return (StoryDefinitionConfiguration)MongoCollectionsKt.findOne(col, (Bson[])bsonArray);
    }

    @Nullable
    public StoryDefinitionConfiguration getStoryDefinitionByNamespaceAndBotIdAndIntent(@NotNull String namespace, @NotNull String botId, @NotNull String intent2) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getIntent().getName_()), (Object)intent2)};
        return (StoryDefinitionConfiguration)MongoCollectionsKt.findOne(col, (Bson[])bsonArray);
    }

    @Nullable
    public StoryDefinitionConfiguration getStoryDefinitionByNamespaceAndBotIdAndStoryId(@NotNull String namespace, @NotNull String botId, @NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getStoryId()), (Object)storyId)};
        return (StoryDefinitionConfiguration)MongoCollectionsKt.findOne(col, (Bson[])bsonArray);
    }

    @NotNull
    public List<StoryDefinitionConfiguration> getStoryDefinitionsByNamespaceAndBotId(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId)};
        FindIterable findIterable = col.find(FiltersKt.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"col.find(and(Namespace eq namespace, BotId eq botId))");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @Nullable
    public StoryDefinitionConfiguration getStoryDefinitionsByNamespaceBotIdStoryId(@NotNull String namespace, @NotNull String botId, @NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)namespace), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getStoryId()), (Object)storyId)};
        return (StoryDefinitionConfiguration)MongoCollectionsKt.findOne(col, (Bson)FiltersKt.and((Bson[])bsonArray));
    }

    @NotNull
    public List<StoryDefinitionConfigurationSummary> searchStoryDefinitionSummaries(@NotNull StoryDefinitionConfigurationSummaryRequest request) {
        Bson bson;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        MongoCollection<StoryDefinitionConfiguration> $this$withDocumentClass$iv = col;
        boolean $i$f$withDocumentClass = false;
        MongoCollection mongoCollection = $this$withDocumentClass$iv.withDocumentClass(StoryDefinitionConfigurationSummary.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"withDocumentClass(NewTDocument::class.java)");
        MongoCollection mongoCollection2 = mongoCollection;
        KProperty[] kPropertyArray = new Bson[5];
        kPropertyArray[0] = FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getNamespace()), (Object)request.getNamespace());
        kPropertyArray[1] = FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getBotId()), (Object)request.getBotId());
        CharSequence charSequence = request.getCategory();
        boolean bl = false;
        boolean bl2 = false;
        kPropertyArray[2] = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getCategory()), (Object)request.getCategory());
        KProperty[] kPropertyArray2 = kPropertyArray;
        int n = 3;
        charSequence = request.getTextSearch();
        if (charSequence == null) {
            bson = null;
        } else {
            CharSequence charSequence2;
            CharSequence it;
            CharSequence charSequence3 = charSequence;
            boolean bl3 = false;
            boolean bl4 = false;
            CharSequence charSequence4 = charSequence3;
            int n2 = n;
            KProperty[] kPropertyArray3 = kPropertyArray2;
            MongoCollection mongoCollection3 = mongoCollection2;
            boolean bl5 = false;
            boolean bl6 = StringsKt.isBlank((CharSequence)it);
            mongoCollection2 = mongoCollection3;
            kPropertyArray2 = kPropertyArray3;
            n = n2;
            CharSequence charSequence5 = charSequence2 = !bl6 ? charSequence3 : null;
            if (charSequence2 == null) {
                bson = null;
            } else {
                charSequence3 = charSequence2;
                bl3 = false;
                bl4 = false;
                it = charSequence3;
                n2 = n;
                kPropertyArray3 = kPropertyArray2;
                mongoCollection3 = mongoCollection2;
                boolean bl7 = false;
                CharSequence charSequence6 = it;
                boolean bl8 = false;
                Bson bson2 = FiltersKt.regex((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getName()), (String)((Object)StringsKt.trim((CharSequence)charSequence6)).toString(), (String)"i");
                mongoCollection2 = mongoCollection3;
                kPropertyArray2 = kPropertyArray3;
                n = n2;
                bson = bson2;
            }
        }
        kPropertyArray2[n] = bson;
        kPropertyArray[4] = request.getOnlyConfiguredStory() ? FiltersKt.ne((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getCurrentType()), (Object)AnswerConfigurationType.builtin) : null;
        FindIterable findIterable = MongoCollectionsKt.find((MongoCollection)mongoCollection2, (Bson[])kPropertyArray);
        kPropertyArray = new KProperty[]{(KProperty)searchStoryDefinitionSummaries.3.INSTANCE, (KProperty)searchStoryDefinitionSummaries.4.INSTANCE, (KProperty)searchStoryDefinitionSummaries.5.INSTANCE, (KProperty)searchStoryDefinitionSummaries.6.INSTANCE, (KProperty)searchStoryDefinitionSummaries.7.INSTANCE, (KProperty)searchStoryDefinitionSummaries.8.INSTANCE, (KProperty)searchStoryDefinitionSummaries.9.INSTANCE, (KProperty)searchStoryDefinitionSummaries.10.INSTANCE};
        FindIterable findIterable2 = FindIterablesKt.projection((FindIterable)findIterable, (KProperty[])kPropertyArray);
        kPropertyArray = Collation.builder().locale(LocalesKt.getDefaultLocale().getLanguage()).build();
        Intrinsics.checkNotNullExpressionValue((Object)kPropertyArray, (String)"builder().locale(defaultLocale.language).build()");
        FindIterable findIterable3 = MongosKt.safeCollation((FindIterable)findIterable2, (Collation)kPropertyArray);
        kPropertyArray = new KProperty[]{(KProperty)searchStoryDefinitionSummaries.11.INSTANCE};
        FindIterable findIterable4 = findIterable3.sort(SortsKt.ascending((KProperty[])kPropertyArray));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable4, (String)"col.withDocumentClass<StoryDefinitionConfigurationSummary>()\n            .find(\n                Namespace eq request.namespace,\n                BotId eq request.botId,\n                if (request.category.isNullOrBlank()) null else Category eq request.category,\n                request.textSearch?.takeUnless { it.isBlank() }?.let { Name.regex(it.trim(), \"i\") },\n                if (request.onlyConfiguredStory) CurrentType ne AnswerConfigurationType.builtin else null\n            )\n            .projection(\n                StoryDefinitionConfigurationSummary::_id,\n                StoryDefinitionConfigurationSummary::storyId,\n                StoryDefinitionConfigurationSummary::botId,\n                StoryDefinitionConfigurationSummary::intent,\n                StoryDefinitionConfigurationSummary::currentType,\n                StoryDefinitionConfigurationSummary::name,\n                StoryDefinitionConfigurationSummary::category,\n                StoryDefinitionConfigurationSummary::description\n            )\n            .safeCollation(Collation.builder().locale(defaultLocale.language).build())\n            .sort(ascending(StoryDefinitionConfigurationSummary::name))");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable4));
    }

    public void save(@NotNull StoryDefinitionConfiguration story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        StoryDefinitionConfiguration previous = (StoryDefinitionConfiguration)MongoCollectionsKt.findOneById(col, (Object)story.get_id());
        StoryDefinitionConfiguration toSave = previous != null ? StoryDefinitionConfiguration.copy$default((StoryDefinitionConfiguration)story, null, null, null, null, null, (int)(previous.getVersion() + 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, (int)1048543, null) : story;
        MongoCollectionsKt.save(historyCol, (Object)new StoryDefinitionConfigurationHistoryCol(toSave, false, null, 6, null));
        MongoCollectionsKt.save(col, (Object)toSave);
    }

    public void delete(@NotNull StoryDefinitionConfiguration story) {
        Intrinsics.checkNotNullParameter((Object)story, (String)"story");
        StoryDefinitionConfiguration previous = (StoryDefinitionConfiguration)MongoCollectionsKt.findOneById(col, (Object)story.get_id());
        if (previous != null) {
            MongoCollectionsKt.save(historyCol, (Object)new StoryDefinitionConfigurationHistoryCol(previous, true, null, 4, null));
        }
        MongoCollectionsKt.deleteOneById(col, (Object)story.get_id());
    }

    public void createBuiltInStoriesIfNotExist(@NotNull List<StoryDefinitionConfiguration> stories2) {
        Intrinsics.checkNotNullParameter(stories2, (String)"stories");
        Iterable $this$forEach$iv = stories2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StoryDefinitionConfiguration it = (StoryDefinitionConfiguration)element$iv;
            boolean bl = false;
            try {
                col.insertOne((Object)it);
            }
            catch (Exception e) {
                LoggersKt.trace((KLogger)logger, (Throwable)e);
            }
        }
    }

    static {
        KProperty[] $this$getCollection$iv;
        com.mongodb.reactivestreams.client.MongoDatabase $this$getCollectionOfName$iv;
        INSTANCE = new StoryDefinitionConfigurationMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        MongoDatabase mongoDatabase = MongoBotConfiguration.INSTANCE.getDatabase();
        KProperty[] collectionName$iv = "story_configuration";
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv.getCollection((String)collectionName$iv, StoryDefinitionConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        col = mongoCollection;
        $this$getCollectionOfName$iv = MongoBotConfiguration.INSTANCE.getAsyncDatabase();
        collectionName$iv = "story_configuration";
        $i$f$getCollectionOfName = false;
        mongoCollection = $this$getCollectionOfName$iv.getCollection((String)collectionName$iv, StoryDefinitionConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        asyncCol = mongoCollection;
        $this$getCollectionOfName$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        collectionName$iv = "story_configuration_history";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName2 = false;
        MongoCollection mongoCollection2 = $this$getCollectionOfName$iv$iv.getCollection((String)collectionName$iv, StoryDefinitionConfigurationHistoryCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection2, (String)"getCollection(collectionName, T::class.java)");
        historyCol = mongoCollection2;
        try {
            $this$getCollection$iv = new KProperty[]{(KProperty)StoryDefinitionConfiguration_.Companion.getNamespace(), (KProperty)StoryDefinitionConfiguration_.Companion.getBotId()};
            MongosKt.ensureIndex$default(col, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{(KProperty)StoryDefinitionConfiguration_.Companion.getNamespace(), (KProperty)StoryDefinitionConfiguration_.Companion.getBotId(), (KProperty)StoryDefinitionConfiguration_.Companion.getIntent().getName_()};
            MongosKt.ensureIndex$default(col, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{(KProperty)StoryDefinitionConfiguration_.Companion.getNamespace(), (KProperty)StoryDefinitionConfiguration_.Companion.getBotId(), (KProperty)StoryDefinitionConfiguration_.Companion.getIntent().getName_()};
            MongosKt.ensureUniqueIndex$default(col, (KProperty[])$this$getCollection$iv, null, (int)2, null);
            $this$getCollection$iv = new KProperty[]{(KProperty)StoryDefinitionConfigurationHistoryCol_.Companion.getDate()};
            MongosKt.ensureIndex$default(historyCol, (KProperty[])$this$getCollection$iv, null, (int)2, null);
        }
        catch (Exception e) {
            LoggersKt.warn((KLogger)logger, (Throwable)e);
            logger.warn("try to remove builtin stories and set the index");
            try {
                col.deleteMany(FiltersKt.eq((KProperty)((KProperty)StoryDefinitionConfiguration_.Companion.getCurrentType()), (Object)AnswerConfigurationType.builtin));
                collectionName$iv = new KProperty[]{(KProperty)StoryDefinitionConfiguration_.Companion.getNamespace(), (KProperty)StoryDefinitionConfiguration_.Companion.getBotId(), (KProperty)StoryDefinitionConfiguration_.Companion.getIntent().getName_()};
                MongosKt.ensureUniqueIndex$default(col, (KProperty[])collectionName$iv, null, (int)2, null);
            }
            catch (Exception e2) {
                LoggersKt.error((KLogger)logger, (Throwable)e2);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lai/tock/bot/mongo/StoryDefinitionConfigurationMongoDAO$StoryDefinitionConfigurationHistoryCol;", "", "conf", "Lai/tock/bot/admin/story/StoryDefinitionConfiguration;", "deleted", "", "date", "Ljava/time/Instant;", "(Lai/tock/bot/admin/story/StoryDefinitionConfiguration;ZLjava/time/Instant;)V", "getConf", "()Lai/tock/bot/admin/story/StoryDefinitionConfiguration;", "getDate", "()Ljava/time/Instant;", "getDeleted", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "tock-bot-storage-mongo"})
    public static final class StoryDefinitionConfigurationHistoryCol {
        @NotNull
        private final StoryDefinitionConfiguration conf;
        private final boolean deleted;
        @NotNull
        private final Instant date;

        public StoryDefinitionConfigurationHistoryCol(@NotNull StoryDefinitionConfiguration conf2, boolean deleted, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)conf2, (String)"conf");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.conf = conf2;
            this.deleted = deleted;
            this.date = date;
        }

        public /* synthetic */ StoryDefinitionConfigurationHistoryCol(StoryDefinitionConfiguration storyDefinitionConfiguration, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
                instant = instant2;
            }
            this(storyDefinitionConfiguration, bl, instant);
        }

        @NotNull
        public final StoryDefinitionConfiguration getConf() {
            return this.conf;
        }

        public final boolean getDeleted() {
            return this.deleted;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        @NotNull
        public final StoryDefinitionConfiguration component1() {
            return this.conf;
        }

        public final boolean component2() {
            return this.deleted;
        }

        @NotNull
        public final Instant component3() {
            return this.date;
        }

        @NotNull
        public final StoryDefinitionConfigurationHistoryCol copy(@NotNull StoryDefinitionConfiguration conf2, boolean deleted, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)conf2, (String)"conf");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new StoryDefinitionConfigurationHistoryCol(conf2, deleted, date);
        }

        public static /* synthetic */ StoryDefinitionConfigurationHistoryCol copy$default(StoryDefinitionConfigurationHistoryCol storyDefinitionConfigurationHistoryCol, StoryDefinitionConfiguration storyDefinitionConfiguration, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                storyDefinitionConfiguration = storyDefinitionConfigurationHistoryCol.conf;
            }
            if ((n & 2) != 0) {
                bl = storyDefinitionConfigurationHistoryCol.deleted;
            }
            if ((n & 4) != 0) {
                instant = storyDefinitionConfigurationHistoryCol.date;
            }
            return storyDefinitionConfigurationHistoryCol.copy(storyDefinitionConfiguration, bl, instant);
        }

        @NotNull
        public String toString() {
            return "StoryDefinitionConfigurationHistoryCol(conf=" + this.conf + ", deleted=" + this.deleted + ", date=" + this.date + ')';
        }

        public int hashCode() {
            int result = this.conf.hashCode();
            int n = this.deleted ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + this.date.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StoryDefinitionConfigurationHistoryCol)) {
                return false;
            }
            StoryDefinitionConfigurationHistoryCol storyDefinitionConfigurationHistoryCol = (StoryDefinitionConfigurationHistoryCol)other;
            if (!Intrinsics.areEqual((Object)this.conf, (Object)storyDefinitionConfigurationHistoryCol.conf)) {
                return false;
            }
            if (this.deleted != storyDefinitionConfigurationHistoryCol.deleted) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)storyDefinitionConfigurationHistoryCol.date);
        }
    }
}

