/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.engine.feature.FeatureDAO;
import ai.tock.bot.engine.feature.FeatureState;
import ai.tock.bot.engine.feature.FeatureType;
import ai.tock.bot.mongo.Feature;
import ai.tock.bot.mongo.Feature_;
import ai.tock.bot.mongo.ai.tock.bot.mongo.FeatureCache;
import ai.tock.shared.DatesKt;
import ai.tock.shared.LoggersKt;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J:\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J(\u0010\u0016\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0002JF\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J2\u0010!\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016JN\u0010%\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016J2\u0010'\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lai/tock/bot/mongo/FeatureMongoDAO;", "Lai/tock/bot/engine/feature/FeatureDAO;", "cache", "Lai/tock/bot/mongo/ai/tock/bot/mongo/FeatureCache;", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/mongo/Feature;", "<init>", "(Lai/tock/bot/mongo/ai/tock/bot/mongo/FeatureCache;Lcom/mongodb/client/MongoCollection;)V", "logger", "Lmu/KLogger;", "calculateId", "", "botId", "namespace", "category", "name", "applicationId", "isEnabled", "", "default", "feature", "getValues", "Lkotlin/Pair;", "id", "idWithoutApplicationId", "cacheAllConnectorFeatureWithId", "", "globalId", "enable", "startDate", "Ljava/time/ZonedDateTime;", "endDate", "disable", "getFeatures", "", "Lai/tock/bot/engine/feature/FeatureState;", "addFeature", "enabled", "deleteFeature", "tock-bot-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nFeatureMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureMongoDAO.kt\nai/tock/bot/mongo/FeatureMongoDAO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KMongoIterable.kt\nkotlin/collections/KMongoIterableKt\n*L\n1#1,183:1\n1#2:184\n1863#3,2:185\n725#4:187\n*S KotlinDebug\n*F\n+ 1 FeatureMongoDAO.kt\nai/tock/bot/mongo/FeatureMongoDAO\n*L\n109#1:185,2\n143#1:187\n*E\n"})
public final class FeatureMongoDAO
implements FeatureDAO {
    @NotNull
    private final FeatureCache cache;
    @NotNull
    private final MongoCollection<Feature> col;
    @NotNull
    private final KLogger logger;

    public FeatureMongoDAO(@NotNull FeatureCache cache, @NotNull MongoCollection<Feature> col2) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter(col2, (String)"col");
        this.cache = cache;
        this.col = col2;
        this.logger = KotlinLogging.INSTANCE.logger(FeatureMongoDAO::logger$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private final String calculateId(String botId, String namespace, String category, String name, String applicationId) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        block3: {
            block2: {
                void it;
                string4 = botId;
                string3 = namespace;
                string2 = category;
                string = name;
                object = applicationId;
                if (object == null) break block2;
                String string5 = object;
                String string6 = string;
                String string7 = string2;
                String string8 = string3;
                String string9 = string4;
                boolean bl = false;
                String string10 = "+" + (String)it;
                string4 = string9;
                string3 = string8;
                string2 = string7;
                string = string6;
                String string11 = string10;
                object = string11;
                if (string11 != null) break block3;
            }
            object = "";
        }
        return string4 + "," + string3 + "," + string2 + "," + string + (String)object;
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        String idWithoutApplicationId = this.calculateId(botId, namespace, category, name, null);
        Pair<Feature, Feature> pair = this.getValues(id, idWithoutApplicationId);
        Feature connectorFeature = (Feature)pair.component1();
        Feature globalFeature = (Feature)pair.component2();
        if (connectorFeature == null && globalFeature == null) {
            boolean bl3;
            boolean it = bl3 = bl;
            boolean bl4 = false;
            this.addFeature(botId, namespace, bl, category, name, null, null, null);
            bl2 = bl3;
        } else {
            Feature feature = connectorFeature;
            if (feature == null) {
                feature = globalFeature;
            }
            Intrinsics.checkNotNull((Object)feature);
            Feature feature2 = feature;
            bl2 = this.isEnabled(feature2);
        }
        return bl2;
    }

    private final boolean isEnabled(Feature feature) {
        ZonedDateTime now = ZonedDateTime.now(DatesKt.getInternalDefaultZoneId());
        return feature.getStartDate() != null && feature.getEndDate() == null ? feature.getEnabled() && now.isAfter(feature.getStartDate()) : (feature.getStartDate() != null && feature.getEndDate() != null ? feature.getEnabled() && now.isAfter(feature.getStartDate()) && now.isBefore(feature.getEndDate()) : feature.getEnabled());
    }

    private final Pair<Feature, Feature> getValues(String id, String idWithoutApplicationId) {
        Pair pair;
        Feature cacheForId = this.cache.stateOf(id);
        Feature cacheForIdWithoutApplicationId = this.cache.stateOf(idWithoutApplicationId);
        if (cacheForId == null && cacheForIdWithoutApplicationId == null) {
            Feature feature;
            Feature feature2;
            Feature it;
            Feature feature3;
            this.cacheAllConnectorFeatureWithId(idWithoutApplicationId);
            Feature feature4 = (Feature)MongoCollectionsKt.findOne(this.col, (Bson)FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)id));
            if (feature4 != null) {
                it = feature3 = feature4;
                boolean bl = false;
                this.cache.setState(id, it);
                feature2 = feature3;
            } else {
                feature2 = null;
            }
            Feature feature5 = (Feature)MongoCollectionsKt.findOne(this.col, (Bson)FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.get_id()), (Object)idWithoutApplicationId));
            if (feature5 != null) {
                it = feature3 = feature5;
                Feature feature6 = feature2;
                boolean bl = false;
                this.cache.setState(idWithoutApplicationId, it);
                feature2 = feature6;
                feature = feature3;
            } else {
                feature = null;
            }
            Feature feature7 = feature;
            Feature feature8 = feature2;
            pair = new Pair((Object)feature8, feature7);
        } else {
            pair = new Pair((Object)cacheForId, (Object)cacheForIdWithoutApplicationId);
        }
        Pair pair2 = pair;
        return pair2;
    }

    private final void cacheAllConnectorFeatureWithId(String globalId) {
        Iterable $this$forEach$iv = KMongoIterableKt.toList((MongoIterable)((MongoIterable)MongoCollectionsKt.find(this.col, (String)("{\"_id\": /^" + globalId + "\\+/}"))));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Feature it = (Feature)element$iv;
            boolean bl = false;
            String string = it.get_id();
            Intrinsics.checkNotNull((Object)it);
            this.cache.setState(string, it);
        }
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + "," + name, true, botId, namespace, startDate, endDate);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + "," + name, false, botId, namespace, null, null, 96, null);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    @NotNull
    public List<FeatureState> getFeatures(@NotNull String botId, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getBotId()), (Object)botId), FiltersKt.eq((KProperty)((KProperty)Feature_.Companion.getNamespace()), (Object)namespace)};
        MongoIterable $this$mapNotNull$iv = (MongoIterable)MongoCollectionsKt.find(this.col, (Bson[])bsonArray);
        boolean $i$f$mapNotNull = false;
        return (List)KMongoIterableKt.useCursor((MongoIterable)$this$mapNotNull$iv, (Function1)((Function1)new Function1<Iterable<? extends Feature>, List<? extends FeatureState>>(this){
            final /* synthetic */ FeatureMongoDAO this$0;
            {
                this.this$0 = featureMongoDAO;
            }

            /*
             * WARNING - void declaration
             */
            public final List<FeatureState> invoke(Iterable<? extends Feature> it) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Iterable<? extends Feature> $this$mapNotNull$iv = it;
                boolean $i$f$mapNotNull = false;
                Iterable<? extends Feature> iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FeatureState it$iv$iv;
                    FeatureState featureState;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Feature it2 = (Feature)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        String string;
                        String string2;
                        String string3;
                        int index = StringsKt.lastIndexOf$default((CharSequence)it2.getKey(), (char)',', (int)0, (boolean)false, (int)6, null);
                        int applicationIndex = StringsKt.lastIndexOf$default((CharSequence)it2.get_id(), (char)'+', (int)0, (boolean)false, (int)6, null);
                        if (index == -1) {
                            string3 = "";
                        } else {
                            String string4 = it2.getKey().substring(0, index);
                            string3 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                        }
                        String category = string3;
                        if (index == -1) {
                            string2 = it2.getKey();
                        } else {
                            String string5 = it2.getKey().substring(index + 1, it2.getKey().length());
                            string2 = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        }
                        String name = string2;
                        if (applicationIndex == -1) {
                            string = null;
                        } else {
                            String string6 = it2.get_id().substring(applicationIndex + 1);
                            string = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        }
                        String applicationId = string;
                        featureState = new FeatureState(category, name, it2.getEnabled(), it2.getStartDate(), it2.getEndDate(), applicationId);
                    }
                    catch (Exception e) {
                        LoggersKt.error((KLogger)FeatureMongoDAO.access$getLogger$p(this.this$0), (Throwable)e);
                        featureState = null;
                    }
                    if (featureState == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }));
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull String category, @NotNull String name, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        Feature feature = new Feature(id, category + "," + name, enabled, botId, namespace, startDate, endDate);
        MongoCollectionsKt.save(this.col, (Object)feature);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, @Nullable String applicationId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String id = this.calculateId(botId, namespace, category, name, applicationId);
        MongoCollectionsKt.deleteOneById(this.col, (Object)id);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (boolean)bl);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull String category, @NotNull String name, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (String)category, (String)name, (boolean)bl);
    }

    public boolean isEnabled(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId, boolean bl) {
        return FeatureDAO.DefaultImpls.isEnabled((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId, (boolean)bl);
    }

    public void enable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.enable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate, (String)applicationId);
    }

    public void disable(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.disable((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId);
    }

    public void addFeature(@NotNull String botId, @NotNull String namespace, boolean enabled, @NotNull FeatureType type, @Nullable ZonedDateTime startDate, @Nullable ZonedDateTime endDate, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.addFeature((FeatureDAO)this, (String)botId, (String)namespace, (boolean)enabled, (FeatureType)type, (ZonedDateTime)startDate, (ZonedDateTime)endDate, (String)applicationId);
    }

    public void deleteFeature(@NotNull String botId, @NotNull String namespace, @NotNull FeatureType type, @Nullable String applicationId) {
        FeatureDAO.DefaultImpls.deleteFeature((FeatureDAO)this, (String)botId, (String)namespace, (FeatureType)type, (String)applicationId);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(FeatureMongoDAO $this) {
        return $this.logger;
    }
}

