/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.admin.test.TestPlan;
import ai.tock.bot.admin.test.TestPlanDAO;
import ai.tock.bot.admin.test.TestPlanExecution;
import ai.tock.bot.admin.test.TestPlanExecution_;
import ai.tock.bot.admin.test.TestPlan_;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/bot/mongo/TestPlanMongoDAO;", "Lai/tock/bot/admin/test/TestPlanDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "testPlanCol", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/admin/test/TestPlan;", "testPlanExecutionCol", "Lai/tock/bot/admin/test/TestPlanExecution;", "saveTestPlan", "", "testPlan", "removeTestPlan", "planId", "Lorg/litote/kmongo/Id;", "saveTestExecution", "testPlanExecution", "getTestPlan", "testPlanId", "getTestPlanExecution", "testPlanExecutionId", "getPlansByApplicationId", "", "applicationId", "", "getTestPlans", "getPlanExecutions", "getPlanExecution", "tock-bot-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nTestPlanMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestPlanMongoDAO.kt\nai/tock/bot/mongo/TestPlanMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,105:1\n61#2:106\n61#2:107\n*S KotlinDebug\n*F\n+ 1 TestPlanMongoDAO.kt\nai/tock/bot/mongo/TestPlanMongoDAO\n*L\n44#1:106\n45#1:107\n*E\n"})
public final class TestPlanMongoDAO
implements TestPlanDAO {
    @NotNull
    public static final TestPlanMongoDAO INSTANCE = new TestPlanMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(TestPlanMongoDAO::logger$lambda$0);
    @NotNull
    private static final MongoCollection<TestPlan> testPlanCol;
    @NotNull
    private static final MongoCollection<TestPlanExecution> testPlanExecutionCol;

    private TestPlanMongoDAO() {
    }

    public void saveTestPlan(@NotNull TestPlan testPlan) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        MongoCollectionsKt.save(testPlanCol, (Object)testPlan);
    }

    public void removeTestPlan(@NotNull Id<TestPlan> planId) {
        Intrinsics.checkNotNullParameter(planId, (String)"planId");
        MongoCollectionsKt.deleteOneById(testPlanCol, planId);
        testPlanExecutionCol.deleteMany(FiltersKt.eq((KProperty)((KProperty)TestPlanExecution_.Companion.getTestPlanId()), planId));
    }

    public void saveTestExecution(@NotNull TestPlanExecution testPlanExecution) {
        Intrinsics.checkNotNullParameter((Object)testPlanExecution, (String)"testPlanExecution");
        MongoCollectionsKt.save(testPlanExecutionCol, (Object)testPlanExecution);
    }

    @Nullable
    public TestPlan getTestPlan(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        return (TestPlan)MongoCollectionsKt.findOneById(testPlanCol, testPlanId);
    }

    @Nullable
    public TestPlanExecution getTestPlanExecution(@NotNull TestPlan testPlan, @NotNull Id<TestPlanExecution> testPlanExecutionId) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        Intrinsics.checkNotNullParameter(testPlanExecutionId, (String)"testPlanExecutionId");
        return (TestPlanExecution)MongoCollectionsKt.findOneById(testPlanExecutionCol, testPlanExecutionId);
    }

    @NotNull
    public List<TestPlan> getPlansByApplicationId(@NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        FindIterable findIterable = testPlanCol.find(FiltersKt.eq((KProperty)((KProperty)TestPlan_.Companion.getApplicationId()), (Object)applicationId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{TestPlan_.Companion.getName()};
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.ascendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray)));
    }

    @NotNull
    public List<TestPlan> getTestPlans() {
        FindIterable findIterable = testPlanCol.find();
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{TestPlan_.Companion.getName()};
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.ascendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray)));
    }

    @NotNull
    public List<TestPlanExecution> getPlanExecutions(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        FindIterable findIterable = testPlanExecutionCol.find(FiltersKt.eq((KProperty)((KProperty)TestPlanExecution_.Companion.getTestPlanId()), testPlanId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        KProperty[] kPropertyArray = new KProperty[]{TestPlanExecution_.Companion.getDate()};
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])kPropertyArray)));
    }

    @Nullable
    public TestPlanExecution getPlanExecution(@NotNull Id<TestPlan> testPlanId) {
        Intrinsics.checkNotNullParameter(testPlanId, (String)"testPlanId");
        return (TestPlanExecution)MongoCollectionsKt.findOneById(testPlanExecutionCol, testPlanId);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    static {
        MongoDatabase $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(TestPlan.class)), TestPlan.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        testPlanCol = mongoCollection;
        $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        $i$f$getCollection = false;
        MongoCollection mongoCollection2 = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(TestPlanExecution.class)), TestPlanExecution.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection2, (String)"getCollection(...)");
        testPlanExecutionCol = mongoCollection2;
        try {
            KProperty[] kPropertyArray = new KProperty[]{TestPlan_.Companion.getApplicationId()};
            MongosKt.ensureIndex$default(testPlanCol, (KProperty[])kPropertyArray, null, (int)2, null);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }
}

