/*
 * Decompiled with CFR 0.152.
 */
package indicator;

import ai.tock.bot.admin.indicators.Indicator;
import ai.tock.bot.admin.indicators.IndicatorDAO;
import ai.tock.bot.mongo.MongoBotConfiguration;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import indicator.IndicatorMongoDAO;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoCollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lindicator/IndicatorMongoDAO;", "Lai/tock/bot/admin/indicators/IndicatorDAO;", "<init>", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/admin/indicators/Indicator;", "getCol$tock_bot_storage_mongo", "()Lcom/mongodb/client/MongoCollection;", "save", "", "indicator", "existByNameAndBotId", "", "name", "", "botId", "findByNameAndBotId", "findAllByBotId", "", "findAll", "delete", "id", "Lorg/litote/kmongo/Id;", "deleteByNameAndApplicationName", "applicationName", "tock-bot-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nIndicatorMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndicatorMongoDAO.kt\nindicator/IndicatorMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,69:1\n50#2:70\n*S KotlinDebug\n*F\n+ 1 IndicatorMongoDAO.kt\nindicator/IndicatorMongoDAO\n*L\n34#1:70\n*E\n"})
public final class IndicatorMongoDAO
implements IndicatorDAO {
    @NotNull
    public static final IndicatorMongoDAO INSTANCE;
    @NotNull
    private static final MongoCollection<Indicator> col;

    private IndicatorMongoDAO() {
    }

    @NotNull
    public final MongoCollection<Indicator> getCol$tock_bot_storage_mongo() {
        return col;
    }

    public void save(@NotNull Indicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        MongoCollectionsKt.save(col, (Object)indicator);
    }

    public boolean existByNameAndBotId(@NotNull String name, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)existByNameAndBotId.1.INSTANCE), (Object)botId), FiltersKt.eq((KProperty)((KProperty)existByNameAndBotId.2.INSTANCE), (Object)name)};
        return col.countDocuments(FiltersKt.and((Bson[])bsonArray)) > 0L;
    }

    @Nullable
    public Indicator findByNameAndBotId(@NotNull String name, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)findByNameAndBotId.1.INSTANCE), (Object)name), FiltersKt.eq((KProperty)((KProperty)findByNameAndBotId.2.INSTANCE), (Object)botId)};
        return (Indicator)MongoCollectionsKt.findOne(col, (Bson)FiltersKt.and((Bson[])bsonArray));
    }

    @NotNull
    public List<Indicator> findAllByBotId(@NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        FindIterable findIterable = col.find(FiltersKt.eq((KProperty)((KProperty)findAllByBotId.1.INSTANCE), (Object)botId));
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    @NotNull
    public List<Indicator> findAll() {
        FindIterable findIterable = col.find();
        Intrinsics.checkNotNullExpressionValue((Object)findIterable, (String)"find(...)");
        return KMongoIterableKt.toList((MongoIterable)((MongoIterable)findIterable));
    }

    public boolean delete(@NotNull Id<Indicator> id) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return col.deleteOne(FiltersKt.eq((KProperty)((KProperty)delete.1.INSTANCE), id)).getDeletedCount() == 1L;
    }

    public boolean deleteByNameAndApplicationName(@NotNull String name, @NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)deleteByNameAndApplicationName.1.INSTANCE), (Object)name), FiltersKt.eq((KProperty)((KProperty)deleteByNameAndApplicationName.2.INSTANCE), (Object)applicationName)};
        return MongoCollectionsKt.deleteOne(col, (Bson[])bsonArray).getDeletedCount() == 1L;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$getCollectionOfName$iv;
        INSTANCE = new IndicatorMongoDAO();
        MongoDatabase mongoDatabase = MongoBotConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "indicator";
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv.getCollection(collectionName$iv, Indicator.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoDatabase it = mongoDatabase = mongoCollection;
        boolean bl = false;
        KProperty[] kPropertyArray = new KProperty[]{col.1.1.INSTANCE, col.1.2.INSTANCE};
        MongoCollectionsKt.ensureUniqueIndex$default((MongoCollection)it, (KProperty[])kPropertyArray, null, (int)2, null);
        col = mongoDatabase;
    }
}

