/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.bot.mongo.MongoUserLock;
import ai.tock.bot.mongo.UserLock_;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.MongosKt;
import ai.tock.shared.PropertiesKt;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.UpdatesKt;
import org.litote.kmongo.util.KMongoUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/tock/bot/mongo/MongoUserLock;", "Lai/tock/bot/engine/user/UserLock;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/bot/mongo/MongoUserLock$UserLock;", "lockTimeout", "", "logger", "Lmu/KLogger;", "deleteLock", "", "userId", "", "lock", "", "releaseLock", "UserLock", "tock-bot-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nMongoUserLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoUserLock.kt\nai/tock/bot/mongo/MongoUserLock\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,144:1\n61#2:145\n*S KotlinDebug\n*F\n+ 1 MongoUserLock.kt\nai/tock/bot/mongo/MongoUserLock\n*L\n59#1:145\n*E\n"})
public final class MongoUserLock
implements ai.tock.bot.engine.user.UserLock {
    @NotNull
    public static final MongoUserLock INSTANCE = new MongoUserLock();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final MongoCollection<UserLock> col;
    private static final long lockTimeout;

    private MongoUserLock() {
    }

    public boolean lock(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserLock lock2 = new UserLock(IdsKt.toId((String)userId), false, null, 6, null);
        Instant validLockDatesLimit = Instant.now().minusMillis(lockTimeout);
        try {
            if (logger.isDebugEnabled()) {
                UserLock existingLock = (UserLock)MongoCollectionsKt.findOneById(col, (Object)userId);
                logger.debug("lock user : " + userId);
                if (existingLock != null && existingLock.getLocked() && existingLock.getDate().isBefore(validLockDatesLimit)) {
                    logger.debug("previous lock date is too old");
                }
            }
            Bson[] bsonArray = new Bson[2];
            bsonArray[0] = FiltersKt.eq((KProperty)((KProperty)UserLock_.Companion.get_id()), lock2.get_id());
            Bson[] bsonArray2 = new Bson[]{FiltersKt.eq((KProperty)((KProperty)UserLock_.Companion.getLocked()), (Object)false), FiltersKt.lt((KProperty)((KProperty)UserLock_.Companion.getDate()), (Object)validLockDatesLimit)};
            bsonArray[1] = FiltersKt.or((Bson[])bsonArray2);
            Bson query = FiltersKt.and((Bson[])bsonArray);
            MongoCollectionsKt.updateOne$default(col, (Bson)query, (Object)lock2, (UpdateOptions)UpdatesKt.upsert(), (boolean)false, (int)8, null);
            return true;
        }
        catch (Exception e) {
            if (e instanceof MongoWriteException && ((MongoWriteException)e).getCode() == 11000) {
                logger.debug((Function0)new Function0<Object>(userId){
                    final /* synthetic */ String $userId;
                    {
                        this.$userId = $userId;
                        super(0);
                    }

                    public final Object invoke() {
                        return "lock for user " + this.$userId + " already taken";
                    }
                });
            } else {
                LoggersKt.error((KLogger)logger, (Throwable)e);
            }
            return false;
        }
    }

    public void releaseLock(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            logger.debug((Function0)new Function0<Object>(userId){
                final /* synthetic */ String $userId;
                {
                    this.$userId = $userId;
                    super(0);
                }

                public final Object invoke() {
                    return "release lock for user : " + this.$userId;
                }
            });
            UpdateResult r = MongoCollectionsKt.updateOneById$default(col, (Object)userId, (Object)UpdatesKt.setValue((KProperty)((KProperty)UserLock_.Companion.getLocked()), (Object)false), null, (boolean)false, (int)12, null);
            if (r.getModifiedCount() == 0L) {
                logger.warn((Function0)new Function0<Object>(userId){
                    final /* synthetic */ String $userId;
                    {
                        this.$userId = $userId;
                        super(0);
                    }

                    public final Object invoke() {
                        return "lock deleted or updated??? : " + this.$userId;
                    }
                });
            }
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    public final void deleteLock(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            MongoCollectionsKt.deleteOneById(col, (Object)userId);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    static {
        KProperty[] $this$getCollection$iv = MongoBotConfiguration.INSTANCE.getDatabase();
        boolean $i$f$getCollection = false;
        MongoCollection mongoCollection = $this$getCollection$iv.getCollection(KMongoUtil.INSTANCE.defaultCollectionName(Reflection.getOrCreateKotlinClass(UserLock.class)), UserLock.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        col = mongoCollection;
        lockTimeout = PropertiesKt.longProperty((String)"tock_bot_lock_timeout_in_ms", (long)5000L);
        try {
            $this$getCollection$iv = new KProperty[]{UserLock_.Companion.getDate()};
            IndexOptions indexOptions = new IndexOptions().expireAfter(Long.valueOf(PropertiesKt.longProperty((String)"mongo_user_ttl_hours", (long)6L)), TimeUnit.HOURS);
            Intrinsics.checkNotNullExpressionValue((Object)indexOptions, (String)"expireAfter(...)");
            MongosKt.ensureIndex(col, (KProperty[])$this$getCollection$iv, (IndexOptions)indexOptions);
        }
        catch (Exception e) {
            LoggersKt.error((KLogger)logger, (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lai/tock/bot/mongo/MongoUserLock$UserLock;", "", "_id", "Lorg/litote/kmongo/Id;", "locked", "", "date", "Ljava/time/Instant;", "(Lorg/litote/kmongo/Id;ZLjava/time/Instant;)V", "get_id", "()Lorg/litote/kmongo/Id;", "getDate", "()Ljava/time/Instant;", "getLocked", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "tock-bot-storage-mongo"})
    public static final class UserLock {
        @NotNull
        private final Id<UserLock> _id;
        private final boolean locked;
        @NotNull
        private final Instant date;

        public UserLock(@NotNull Id<UserLock> _id2, boolean locked, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter(_id2, (String)"_id");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this._id = _id2;
            this.locked = locked;
            this.date = date;
        }

        public /* synthetic */ UserLock(Id id, boolean bl, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
                instant = instant2;
            }
            this((Id<UserLock>)id, bl, instant);
        }

        @NotNull
        public final Id<UserLock> get_id() {
            return this._id;
        }

        public final boolean getLocked() {
            return this.locked;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        @NotNull
        public final Id<UserLock> component1() {
            return this._id;
        }

        public final boolean component2() {
            return this.locked;
        }

        @NotNull
        public final Instant component3() {
            return this.date;
        }

        @NotNull
        public final UserLock copy(@NotNull Id<UserLock> _id2, boolean locked, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter(_id2, (String)"_id");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new UserLock(_id2, locked, date);
        }

        public static /* synthetic */ UserLock copy$default(UserLock userLock, Id id, boolean bl, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                id = userLock._id;
            }
            if ((n & 2) != 0) {
                bl = userLock.locked;
            }
            if ((n & 4) != 0) {
                instant = userLock.date;
            }
            return userLock.copy(id, bl, instant);
        }

        @NotNull
        public String toString() {
            return "UserLock(_id=" + this._id + ", locked=" + this.locked + ", date=" + this.date + ")";
        }

        public int hashCode() {
            int result = this._id.hashCode();
            result = result * 31 + Boolean.hashCode(this.locked);
            result = result * 31 + this.date.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserLock)) {
                return false;
            }
            UserLock userLock = (UserLock)other;
            if (!Intrinsics.areEqual(this._id, userLock._id)) {
                return false;
            }
            if (this.locked != userLock.locked) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)userLock.date);
        }
    }
}

