/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.mongo;

import ai.tock.bot.admin.user.UserAnalytics;
import ai.tock.bot.admin.user.UserReport;
import ai.tock.bot.engine.action.Action;
import ai.tock.bot.engine.action.SendAttachment;
import ai.tock.bot.engine.action.SendChoice;
import ai.tock.bot.engine.action.SendLocation;
import ai.tock.bot.engine.action.SendSentence;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.TimeBoxedFlag;
import ai.tock.bot.engine.user.UserPreferences;
import ai.tock.bot.engine.user.UserState;
import ai.tock.bot.engine.user.UserTimeline;
import ai.tock.bot.mongo.MongoBotConfiguration;
import ai.tock.shared.DatesKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.TockObfuscatorService;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\b\u0018\u00002\u00020\u0001:\u0004GHIJB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bB\u0081\u0001\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0016\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0016H\u00c6\u0003J\t\u00103\u001a\u00020\fH\u00c6\u0003J\t\u00104\u001a\u00020\u000eH\u00c6\u0003J\t\u00105\u001a\u00020\u0010H\u00c6\u0003J\u000f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0016H\u00c6\u0003J\t\u0010:\u001a\u00020\u0016H\u00c6\u0003J\u008d\u0001\u0010;\u001a\u00020\u00002\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0016H\u00c6\u0001J\u0013\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\t\u0010A\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010B\u001a\u00020CJ\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020\u0006R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u001a\u0010\u0017\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001f\"\u0004\b&\u0010'R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010!R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001dR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006K"}, d2={"Lai/tock/bot/mongo/UserTimelineCol;", "", "timelineId", "", "namespace", "newTimeline", "Lai/tock/bot/engine/user/UserTimeline;", "oldTimeline", "(Ljava/lang/String;Ljava/lang/String;Lai/tock/bot/engine/user/UserTimeline;Lai/tock/bot/mongo/UserTimelineCol;)V", "_id", "Lorg/litote/kmongo/Id;", "playerId", "Lai/tock/bot/engine/user/PlayerId;", "userPreferences", "Lai/tock/bot/mongo/UserTimelineCol$UserPreferencesWrapper;", "userState", "Lai/tock/bot/mongo/UserTimelineCol$UserStateWrapper;", "temporaryIds", "", "applicationIds", "lastActionText", "lastUpdateDate", "Ljava/time/Instant;", "lastUserActionDate", "creationDate", "(Lorg/litote/kmongo/Id;Lai/tock/bot/engine/user/PlayerId;Lai/tock/bot/mongo/UserTimelineCol$UserPreferencesWrapper;Lai/tock/bot/mongo/UserTimelineCol$UserStateWrapper;Ljava/util/Set;Ljava/util/Set;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/time/Instant;)V", "get_id", "()Lorg/litote/kmongo/Id;", "getApplicationIds", "()Ljava/util/Set;", "getCreationDate", "()Ljava/time/Instant;", "getLastActionText", "()Ljava/lang/String;", "setLastActionText", "(Ljava/lang/String;)V", "getLastUpdateDate", "getLastUserActionDate", "setLastUserActionDate", "(Ljava/time/Instant;)V", "getNamespace", "getPlayerId", "()Lai/tock/bot/engine/user/PlayerId;", "getTemporaryIds", "getUserPreferences", "()Lai/tock/bot/mongo/UserTimelineCol$UserPreferencesWrapper;", "getUserState", "()Lai/tock/bot/mongo/UserTimelineCol$UserStateWrapper;", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "toUserAnalytics", "Lai/tock/bot/admin/user/UserAnalytics;", "toUserReport", "Lai/tock/bot/admin/user/UserReport;", "toUserTimeline", "FlagsDeserializer", "TimeBoxedFlagWrapper", "UserPreferencesWrapper", "UserStateWrapper", "tock-bot-storage-mongo"})
public final class UserTimelineCol {
    @NotNull
    private final Id<UserTimelineCol> _id;
    @NotNull
    private final PlayerId playerId;
    @NotNull
    private final UserPreferencesWrapper userPreferences;
    @NotNull
    private final UserStateWrapper userState;
    @NotNull
    private final Set<String> temporaryIds;
    @NotNull
    private final Set<String> applicationIds;
    @Nullable
    private String lastActionText;
    @NotNull
    private final Instant lastUpdateDate;
    @NotNull
    private Instant lastUserActionDate;
    @Nullable
    private final String namespace;
    @NotNull
    private final Instant creationDate;

    public UserTimelineCol(@NotNull Id<UserTimelineCol> _id2, @NotNull PlayerId playerId2, @NotNull UserPreferencesWrapper userPreferences2, @NotNull UserStateWrapper userState2, @NotNull Set<String> temporaryIds2, @NotNull Set<String> applicationIds2, @Nullable String lastActionText, @NotNull Instant lastUpdateDate, @NotNull Instant lastUserActionDate, @Nullable String namespace, @NotNull Instant creationDate) {
        Intrinsics.checkNotNullParameter(_id2, (String)"_id");
        Intrinsics.checkNotNullParameter((Object)playerId2, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)userPreferences2, (String)"userPreferences");
        Intrinsics.checkNotNullParameter((Object)userState2, (String)"userState");
        Intrinsics.checkNotNullParameter(temporaryIds2, (String)"temporaryIds");
        Intrinsics.checkNotNullParameter(applicationIds2, (String)"applicationIds");
        Intrinsics.checkNotNullParameter((Object)lastUpdateDate, (String)"lastUpdateDate");
        Intrinsics.checkNotNullParameter((Object)lastUserActionDate, (String)"lastUserActionDate");
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        this._id = _id2;
        this.playerId = playerId2;
        this.userPreferences = userPreferences2;
        this.userState = userState2;
        this.temporaryIds = temporaryIds2;
        this.applicationIds = applicationIds2;
        this.lastActionText = lastActionText;
        this.lastUpdateDate = lastUpdateDate;
        this.lastUserActionDate = lastUserActionDate;
        this.namespace = namespace;
        this.creationDate = creationDate;
    }

    public /* synthetic */ UserTimelineCol(Id id, PlayerId playerId2, UserPreferencesWrapper userPreferencesWrapper, UserStateWrapper userStateWrapper, Set set, Set set2, String string, Instant instant, Instant instant2, String string2, Instant instant3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 0x20) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        if ((n & 0x80) != 0) {
            Instant instant4 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"now(...)");
            instant = instant4;
        }
        if ((n & 0x100) != 0) {
            instant2 = instant;
        }
        if ((n & 0x200) != 0) {
            string2 = null;
        }
        if ((n & 0x400) != 0) {
            Instant instant5 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"now(...)");
            instant3 = instant5;
        }
        this((Id<UserTimelineCol>)id, playerId2, userPreferencesWrapper, userStateWrapper, set, set2, string, instant, instant2, string2, instant3);
    }

    @NotNull
    public final Id<UserTimelineCol> get_id() {
        return this._id;
    }

    @NotNull
    public final PlayerId getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final UserPreferencesWrapper getUserPreferences() {
        return this.userPreferences;
    }

    @NotNull
    public final UserStateWrapper getUserState() {
        return this.userState;
    }

    @NotNull
    public final Set<String> getTemporaryIds() {
        return this.temporaryIds;
    }

    @NotNull
    public final Set<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Nullable
    public final String getLastActionText() {
        return this.lastActionText;
    }

    public final void setLastActionText(@Nullable String string) {
        this.lastActionText = string;
    }

    @NotNull
    public final Instant getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @NotNull
    public final Instant getLastUserActionDate() {
        return this.lastUserActionDate;
    }

    public final void setLastUserActionDate(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.lastUserActionDate = instant;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final Instant getCreationDate() {
        return this.creationDate;
    }

    public UserTimelineCol(@NotNull String timelineId, @NotNull String namespace, @NotNull UserTimeline newTimeline, @Nullable UserTimelineCol oldTimeline) {
        block5: {
            Action action;
            Intrinsics.checkNotNullParameter((Object)timelineId, (String)"timelineId");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)newTimeline, (String)"newTimeline");
            this(IdsKt.toId((String)timelineId), newTimeline.getPlayerId(), new UserPreferencesWrapper(newTimeline.getUserPreferences()), new UserStateWrapper(newTimeline.getUserState()), newTimeline.getTemporaryIds(), null, null, null, null, namespace, null, 1504, null);
            Action action2 = newTimeline.getLastUserAction();
            if (action2 != null) {
                Object object;
                Action it = action2;
                boolean bl = false;
                this.lastUserActionDate = it.getDate();
                Action action3 = it;
                if (action3 instanceof SendSentence) {
                    String string = ((SendSentence)it).getStringText();
                    Object object2 = ((SendSentence)it).getNlpStats();
                    if (object2 == null || (object2 = object2.obfuscatedRanges()) == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    object = TockObfuscatorService.INSTANCE.obfuscate(string, (List)object2);
                } else {
                    object = action3 instanceof SendChoice ? "(click) " + ((SendChoice)it).getIntentName() : (action3 instanceof SendAttachment ? "(send) " + ((SendAttachment)it).getUrl() : (action3 instanceof SendLocation ? "(send user location)" : null));
                }
                this.lastActionText = object;
            }
            UserTimelineCol userTimelineCol = oldTimeline;
            if (userTimelineCol != null) {
                UserTimelineCol it = userTimelineCol;
                boolean bl = false;
                this.applicationIds.addAll((Collection<String>)it.applicationIds);
            }
            Action action4 = newTimeline.getLastAction();
            if (action4 == null) break block5;
            Action it = action = action4;
            boolean bl = false;
            this.applicationIds.add(it.getApplicationId());
        }
    }

    @NotNull
    public final UserTimeline toUserTimeline() {
        return new UserTimeline(this.playerId, this.userPreferences.toUserPreferences(), this.userState.toUserState(), null, this.temporaryIds, 8, null);
    }

    @NotNull
    public final UserReport toUserReport() {
        return new UserReport(this.playerId, this.applicationIds, this.userPreferences.toUserPreferences(), this.userState.toUserState(), this.lastUpdateDate, this.lastActionText, this.lastUserActionDate);
    }

    @NotNull
    public final UserAnalytics toUserAnalytics() {
        ZoneId zoneId = DatesKt.getDefaultZoneId();
        LocalDate localDate = LocalDateTime.ofInstant(this.lastUserActionDate, zoneId).toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        LocalDateTime localDateTime = LocalDateTime.ofInstant(this.lastUserActionDate, zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return new UserAnalytics(this.playerId, this.applicationIds, localDate, localDateTime);
    }

    @NotNull
    public final Id<UserTimelineCol> component1() {
        return this._id;
    }

    @NotNull
    public final PlayerId component2() {
        return this.playerId;
    }

    @NotNull
    public final UserPreferencesWrapper component3() {
        return this.userPreferences;
    }

    @NotNull
    public final UserStateWrapper component4() {
        return this.userState;
    }

    @NotNull
    public final Set<String> component5() {
        return this.temporaryIds;
    }

    @NotNull
    public final Set<String> component6() {
        return this.applicationIds;
    }

    @Nullable
    public final String component7() {
        return this.lastActionText;
    }

    @NotNull
    public final Instant component8() {
        return this.lastUpdateDate;
    }

    @NotNull
    public final Instant component9() {
        return this.lastUserActionDate;
    }

    @Nullable
    public final String component10() {
        return this.namespace;
    }

    @NotNull
    public final Instant component11() {
        return this.creationDate;
    }

    @NotNull
    public final UserTimelineCol copy(@NotNull Id<UserTimelineCol> _id2, @NotNull PlayerId playerId2, @NotNull UserPreferencesWrapper userPreferences2, @NotNull UserStateWrapper userState2, @NotNull Set<String> temporaryIds2, @NotNull Set<String> applicationIds2, @Nullable String lastActionText, @NotNull Instant lastUpdateDate, @NotNull Instant lastUserActionDate, @Nullable String namespace, @NotNull Instant creationDate) {
        Intrinsics.checkNotNullParameter(_id2, (String)"_id");
        Intrinsics.checkNotNullParameter((Object)playerId2, (String)"playerId");
        Intrinsics.checkNotNullParameter((Object)userPreferences2, (String)"userPreferences");
        Intrinsics.checkNotNullParameter((Object)userState2, (String)"userState");
        Intrinsics.checkNotNullParameter(temporaryIds2, (String)"temporaryIds");
        Intrinsics.checkNotNullParameter(applicationIds2, (String)"applicationIds");
        Intrinsics.checkNotNullParameter((Object)lastUpdateDate, (String)"lastUpdateDate");
        Intrinsics.checkNotNullParameter((Object)lastUserActionDate, (String)"lastUserActionDate");
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        return new UserTimelineCol(_id2, playerId2, userPreferences2, userState2, temporaryIds2, applicationIds2, lastActionText, lastUpdateDate, lastUserActionDate, namespace, creationDate);
    }

    public static /* synthetic */ UserTimelineCol copy$default(UserTimelineCol userTimelineCol, Id id, PlayerId playerId2, UserPreferencesWrapper userPreferencesWrapper, UserStateWrapper userStateWrapper, Set set, Set set2, String string, Instant instant, Instant instant2, String string2, Instant instant3, int n, Object object) {
        if ((n & 1) != 0) {
            id = userTimelineCol._id;
        }
        if ((n & 2) != 0) {
            playerId2 = userTimelineCol.playerId;
        }
        if ((n & 4) != 0) {
            userPreferencesWrapper = userTimelineCol.userPreferences;
        }
        if ((n & 8) != 0) {
            userStateWrapper = userTimelineCol.userState;
        }
        if ((n & 0x10) != 0) {
            set = userTimelineCol.temporaryIds;
        }
        if ((n & 0x20) != 0) {
            set2 = userTimelineCol.applicationIds;
        }
        if ((n & 0x40) != 0) {
            string = userTimelineCol.lastActionText;
        }
        if ((n & 0x80) != 0) {
            instant = userTimelineCol.lastUpdateDate;
        }
        if ((n & 0x100) != 0) {
            instant2 = userTimelineCol.lastUserActionDate;
        }
        if ((n & 0x200) != 0) {
            string2 = userTimelineCol.namespace;
        }
        if ((n & 0x400) != 0) {
            instant3 = userTimelineCol.creationDate;
        }
        return userTimelineCol.copy(id, playerId2, userPreferencesWrapper, userStateWrapper, set, set2, string, instant, instant2, string2, instant3);
    }

    @NotNull
    public String toString() {
        return "UserTimelineCol(_id=" + this._id + ", playerId=" + this.playerId + ", userPreferences=" + this.userPreferences + ", userState=" + this.userState + ", temporaryIds=" + this.temporaryIds + ", applicationIds=" + this.applicationIds + ", lastActionText=" + this.lastActionText + ", lastUpdateDate=" + this.lastUpdateDate + ", lastUserActionDate=" + this.lastUserActionDate + ", namespace=" + this.namespace + ", creationDate=" + this.creationDate + ")";
    }

    public int hashCode() {
        int result = this._id.hashCode();
        result = result * 31 + this.playerId.hashCode();
        result = result * 31 + this.userPreferences.hashCode();
        result = result * 31 + this.userState.hashCode();
        result = result * 31 + ((Object)this.temporaryIds).hashCode();
        result = result * 31 + ((Object)this.applicationIds).hashCode();
        result = result * 31 + (this.lastActionText == null ? 0 : this.lastActionText.hashCode());
        result = result * 31 + this.lastUpdateDate.hashCode();
        result = result * 31 + this.lastUserActionDate.hashCode();
        result = result * 31 + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = result * 31 + this.creationDate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UserTimelineCol)) {
            return false;
        }
        UserTimelineCol userTimelineCol = (UserTimelineCol)other;
        if (!Intrinsics.areEqual(this._id, userTimelineCol._id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerId, (Object)userTimelineCol.playerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userPreferences, (Object)userTimelineCol.userPreferences)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.userState, (Object)userTimelineCol.userState)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.temporaryIds, userTimelineCol.temporaryIds)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.applicationIds, userTimelineCol.applicationIds)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastActionText, (Object)userTimelineCol.lastActionText)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdateDate, (Object)userTimelineCol.lastUpdateDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUserActionDate, (Object)userTimelineCol.lastUserActionDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)userTimelineCol.namespace)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.creationDate, (Object)userTimelineCol.creationDate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lai/tock/bot/mongo/UserTimelineCol$FlagsDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "", "", "Lai/tock/bot/mongo/UserTimelineCol$TimeBoxedFlagWrapper;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "Companion", "tock-bot-storage-mongo"})
    public static final class FlagsDeserializer
    extends JsonDeserializer<Map<String, ? extends TimeBoxedFlagWrapper>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final TypeReference<Map<String, TimeBoxedFlagWrapper>> reference = (TypeReference)new TypeReference<Map<String, ? extends TimeBoxedFlagWrapper>>(){};

        @NotNull
        public Map<String, TimeBoxedFlagWrapper> deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ObjectCodec mapper = jp.getCodec();
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                Object object = mapper.readValue(jp, reference);
                Intrinsics.checkNotNull((Object)object);
                map = (Map)object;
            } else {
                mapper.readTree(jp);
                map = MapsKt.emptyMap();
            }
            return map;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lai/tock/bot/mongo/UserTimelineCol$FlagsDeserializer$Companion;", "", "()V", "reference", "Lcom/fasterxml/jackson/core/type/TypeReference;", "", "", "Lai/tock/bot/mongo/UserTimelineCol$TimeBoxedFlagWrapper;", "getReference", "()Lcom/fasterxml/jackson/core/type/TypeReference;", "tock-bot-storage-mongo"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final TypeReference<Map<String, TimeBoxedFlagWrapper>> getReference() {
                return reference;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B#\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\tJ\u0013\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\tH\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u0003R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lai/tock/bot/mongo/UserTimelineCol$TimeBoxedFlagWrapper;", "", "flag", "Lai/tock/bot/engine/user/TimeBoxedFlag;", "doEncrypt", "", "(Lai/tock/bot/engine/user/TimeBoxedFlag;Z)V", "encrypted", "value", "", "expirationDate", "Ljava/time/Instant;", "(ZLjava/lang/String;Ljava/time/Instant;)V", "getEncrypted", "()Z", "getExpirationDate", "()Ljava/time/Instant;", "getValue", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "decryptValue", "equals", "other", "hashCode", "", "toString", "toTimeBoxedFlag", "tock-bot-storage-mongo"})
    public static final class TimeBoxedFlagWrapper {
        private final boolean encrypted;
        @NotNull
        private final String value;
        @Nullable
        private final Instant expirationDate;

        public TimeBoxedFlagWrapper(boolean encrypted, @NotNull String value, @Nullable Instant expirationDate) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.encrypted = encrypted;
            this.value = value;
            this.expirationDate = expirationDate;
        }

        public /* synthetic */ TimeBoxedFlagWrapper(boolean bl, String string, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                instant = Instant.now();
            }
            this(bl, string, instant);
        }

        public final boolean getEncrypted() {
            return this.encrypted;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        public TimeBoxedFlagWrapper(@NotNull TimeBoxedFlag flag, boolean doEncrypt) {
            Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
            this(doEncrypt, doEncrypt ? EncryptorsKt.encrypt((String)flag.getValue()) : flag.getValue(), flag.getExpirationDate());
        }

        @NotNull
        public final TimeBoxedFlag toTimeBoxedFlag() {
            return new TimeBoxedFlag(this.decryptValue(), this.expirationDate);
        }

        @NotNull
        public final String decryptValue() {
            return this.encrypted ? EncryptorsKt.decrypt((String)this.value) : this.value;
        }

        public final boolean component1() {
            return this.encrypted;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @Nullable
        public final Instant component3() {
            return this.expirationDate;
        }

        @NotNull
        public final TimeBoxedFlagWrapper copy(boolean encrypted, @NotNull String value, @Nullable Instant expirationDate) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new TimeBoxedFlagWrapper(encrypted, value, expirationDate);
        }

        public static /* synthetic */ TimeBoxedFlagWrapper copy$default(TimeBoxedFlagWrapper timeBoxedFlagWrapper, boolean bl, String string, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                bl = timeBoxedFlagWrapper.encrypted;
            }
            if ((n & 2) != 0) {
                string = timeBoxedFlagWrapper.value;
            }
            if ((n & 4) != 0) {
                instant = timeBoxedFlagWrapper.expirationDate;
            }
            return timeBoxedFlagWrapper.copy(bl, string, instant);
        }

        @NotNull
        public String toString() {
            return "TimeBoxedFlagWrapper(encrypted=" + this.encrypted + ", value=" + this.value + ", expirationDate=" + this.expirationDate + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.encrypted);
            result = result * 31 + this.value.hashCode();
            result = result * 31 + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeBoxedFlagWrapper)) {
                return false;
            }
            TimeBoxedFlagWrapper timeBoxedFlagWrapper = (TimeBoxedFlagWrapper)other;
            if (this.encrypted != timeBoxedFlagWrapper.encrypted) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)timeBoxedFlagWrapper.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expirationDate, (Object)timeBoxedFlagWrapper.expirationDate);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Bs\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010#\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\u0011H\u00c6\u0003Jw\u0010,\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010-\u001a\u00020\u00112\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0006H\u00d6\u0001J\u0006\u00102\u001a\u00020\u0003R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00063"}, d2={"Lai/tock/bot/mongo/UserTimelineCol$UserPreferencesWrapper;", "", "pref", "Lai/tock/bot/engine/user/UserPreferences;", "(Lai/tock/bot/engine/user/UserPreferences;)V", "firstName", "", "lastName", "email", "timezone", "Ljava/time/ZoneId;", "locale", "Ljava/util/Locale;", "picture", "gender", "initialLocale", "test", "", "encrypted", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/ZoneId;Ljava/util/Locale;Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;ZZ)V", "getEmail", "()Ljava/lang/String;", "getEncrypted", "()Z", "getFirstName", "getGender", "getInitialLocale", "()Ljava/util/Locale;", "getLastName", "getLocale", "getPicture", "getTest", "getTimezone", "()Ljava/time/ZoneId;", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "toUserPreferences", "tock-bot-storage-mongo"})
    @SourceDebugExtension(value={"SMAP\nUserTimelineCol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserTimelineCol.kt\nai/tock/bot/mongo/UserTimelineCol$UserPreferencesWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
    public static final class UserPreferencesWrapper {
        @Nullable
        private final String firstName;
        @Nullable
        private final String lastName;
        @Nullable
        private final String email;
        @NotNull
        private final ZoneId timezone;
        @NotNull
        private final Locale locale;
        @Nullable
        private final String picture;
        @Nullable
        private final String gender;
        @NotNull
        private final Locale initialLocale;
        private final boolean test;
        private final boolean encrypted;

        public UserPreferencesWrapper(@Nullable String firstName, @Nullable String lastName, @Nullable String email, @NotNull ZoneId timezone, @NotNull Locale locale, @Nullable String picture, @Nullable String gender, @NotNull Locale initialLocale, boolean test, boolean encrypted) {
            Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)initialLocale, (String)"initialLocale");
            this.firstName = firstName;
            this.lastName = lastName;
            this.email = email;
            this.timezone = timezone;
            this.locale = locale;
            this.picture = picture;
            this.gender = gender;
            this.initialLocale = initialLocale;
            this.test = test;
            this.encrypted = encrypted;
        }

        public /* synthetic */ UserPreferencesWrapper(String string, String string2, String string3, ZoneId zoneId, Locale locale, String string4, String string5, Locale locale2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                zoneId = DatesKt.getDefaultZoneId();
            }
            if ((n & 0x10) != 0) {
                locale = LocalesKt.getDefaultLocale();
            }
            if ((n & 0x20) != 0) {
                string4 = null;
            }
            if ((n & 0x40) != 0) {
                string5 = null;
            }
            if ((n & 0x80) != 0) {
                locale2 = locale;
            }
            if ((n & 0x100) != 0) {
                bl = false;
            }
            if ((n & 0x200) != 0) {
                bl2 = false;
            }
            this(string, string2, string3, zoneId, locale, string4, string5, locale2, bl, bl2);
        }

        @Nullable
        public final String getFirstName() {
            return this.firstName;
        }

        @Nullable
        public final String getLastName() {
            return this.lastName;
        }

        @Nullable
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public final ZoneId getTimezone() {
            return this.timezone;
        }

        @NotNull
        public final Locale getLocale() {
            return this.locale;
        }

        @Nullable
        public final String getPicture() {
            return this.picture;
        }

        @Nullable
        public final String getGender() {
            return this.gender;
        }

        @NotNull
        public final Locale getInitialLocale() {
            return this.initialLocale;
        }

        public final boolean getTest() {
            return this.test;
        }

        public final boolean getEncrypted() {
            return this.encrypted;
        }

        public UserPreferencesWrapper(@NotNull UserPreferences pref) {
            String string;
            String string2;
            String string3;
            ZoneId zoneId;
            Locale locale;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String it;
            UserPreferencesWrapper userPreferencesWrapper;
            String string10;
            Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
            UserPreferencesWrapper userPreferencesWrapper2 = this;
            String string11 = pref.getFirstName();
            if (string11 != null) {
                string10 = string11;
                userPreferencesWrapper = userPreferencesWrapper2;
                boolean bl = false;
                string9 = EncryptorsKt.getEncryptionEnabled() ? EncryptorsKt.encrypt((String)it) : it;
                userPreferencesWrapper2 = userPreferencesWrapper;
            } else {
                string9 = null;
            }
            String string12 = pref.getLastName();
            if (string12 != null) {
                it = string12;
                string8 = string9;
                userPreferencesWrapper = userPreferencesWrapper2;
                boolean bl = false;
                string7 = EncryptorsKt.getEncryptionEnabled() ? EncryptorsKt.encrypt((String)it) : it;
                userPreferencesWrapper2 = userPreferencesWrapper;
                string9 = string8;
                string6 = string7;
            } else {
                string6 = null;
            }
            String string13 = pref.getEmail();
            if (string13 != null) {
                it = string13;
                string7 = string6;
                string8 = string9;
                userPreferencesWrapper = userPreferencesWrapper2;
                boolean bl = false;
                string5 = EncryptorsKt.getEncryptionEnabled() ? EncryptorsKt.encrypt((String)it) : it;
                userPreferencesWrapper2 = userPreferencesWrapper;
                string9 = string8;
                string6 = string7;
                string4 = string5;
            } else {
                string4 = null;
            }
            ZoneId zoneId2 = pref.getTimezone();
            Locale locale2 = pref.getLocale();
            String string14 = pref.getPicture();
            if (string14 != null) {
                it = string14;
                locale = locale2;
                zoneId = zoneId2;
                string5 = string4;
                string7 = string6;
                string8 = string9;
                userPreferencesWrapper = userPreferencesWrapper2;
                boolean bl = false;
                string3 = EncryptorsKt.getEncryptionEnabled() ? EncryptorsKt.encrypt((String)it) : it;
                userPreferencesWrapper2 = userPreferencesWrapper;
                string9 = string8;
                string6 = string7;
                string4 = string5;
                zoneId2 = zoneId;
                locale2 = locale;
                string2 = string3;
            } else {
                string2 = null;
            }
            String string15 = pref.getGender();
            if (string15 != null) {
                it = string15;
                string3 = string2;
                locale = locale2;
                zoneId = zoneId2;
                string5 = string4;
                string7 = string6;
                string8 = string9;
                userPreferencesWrapper = userPreferencesWrapper2;
                boolean bl = false;
                String string16 = EncryptorsKt.getEncryptionEnabled() ? EncryptorsKt.encrypt((String)it) : string10;
                userPreferencesWrapper2 = userPreferencesWrapper;
                string9 = string8;
                string6 = string7;
                string4 = string5;
                zoneId2 = zoneId;
                locale2 = locale;
                string2 = string3;
                string = string16;
            } else {
                string = null;
            }
            userPreferencesWrapper2(string9, string6, string4, zoneId2, locale2, string2, string, pref.getInitialLocale(), pref.getTest(), EncryptorsKt.getEncryptionEnabled());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserPreferences toUserPreferences() {
            String string;
            String string2;
            String string3;
            ZoneId zoneId;
            Locale locale;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String it;
            String string10 = this.firstName;
            if (string10 != null) {
                it = string10;
                boolean bl = false;
                string9 = this.encrypted ? EncryptorsKt.decrypt((String)it) : it;
            } else {
                string9 = null;
            }
            String string11 = this.lastName;
            if (string11 != null) {
                it = string11;
                string8 = string9;
                boolean bl = false;
                string7 = this.encrypted ? EncryptorsKt.decrypt((String)it) : it;
                string9 = string8;
            } else {
                string7 = null;
            }
            String string12 = this.email;
            if (string12 != null) {
                it = string12;
                string6 = string7;
                string8 = string9;
                boolean bl = false;
                string5 = this.encrypted ? EncryptorsKt.decrypt((String)it) : it;
                string9 = string8;
                string7 = string6;
                string4 = string5;
            } else {
                string4 = null;
            }
            ZoneId zoneId2 = this.timezone;
            Locale locale2 = this.locale;
            String string13 = this.picture;
            if (string13 != null) {
                it = string13;
                locale = locale2;
                zoneId = zoneId2;
                string5 = string4;
                string6 = string7;
                string8 = string9;
                boolean bl = false;
                string3 = this.encrypted ? EncryptorsKt.decrypt((String)it) : it;
                string9 = string8;
                string7 = string6;
                string4 = string5;
                zoneId2 = zoneId;
                locale2 = locale;
                string2 = string3;
            } else {
                string2 = null;
            }
            String string14 = this.gender;
            if (string14 != null) {
                void var1_1;
                it = string14;
                string3 = string2;
                locale = locale2;
                zoneId = zoneId2;
                string5 = string4;
                string6 = string7;
                string8 = string9;
                boolean bl = false;
                String string15 = this.encrypted ? EncryptorsKt.decrypt((String)it) : var1_1;
                string9 = string8;
                string7 = string6;
                string4 = string5;
                zoneId2 = zoneId;
                locale2 = locale;
                string2 = string3;
                string = string15;
            } else {
                string = null;
            }
            Locale locale3 = this.initialLocale;
            boolean bl = this.test;
            String string16 = string;
            String string17 = string2;
            Locale locale4 = locale2;
            ZoneId zoneId3 = zoneId2;
            String string18 = string4;
            String string19 = string7;
            String string20 = string9;
            return new UserPreferences(string20, string19, string18, zoneId3, locale4, string17, string16, bl, locale3);
        }

        @Nullable
        public final String component1() {
            return this.firstName;
        }

        @Nullable
        public final String component2() {
            return this.lastName;
        }

        @Nullable
        public final String component3() {
            return this.email;
        }

        @NotNull
        public final ZoneId component4() {
            return this.timezone;
        }

        @NotNull
        public final Locale component5() {
            return this.locale;
        }

        @Nullable
        public final String component6() {
            return this.picture;
        }

        @Nullable
        public final String component7() {
            return this.gender;
        }

        @NotNull
        public final Locale component8() {
            return this.initialLocale;
        }

        public final boolean component9() {
            return this.test;
        }

        public final boolean component10() {
            return this.encrypted;
        }

        @NotNull
        public final UserPreferencesWrapper copy(@Nullable String firstName, @Nullable String lastName, @Nullable String email, @NotNull ZoneId timezone, @NotNull Locale locale, @Nullable String picture, @Nullable String gender, @NotNull Locale initialLocale, boolean test, boolean encrypted) {
            Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Intrinsics.checkNotNullParameter((Object)initialLocale, (String)"initialLocale");
            return new UserPreferencesWrapper(firstName, lastName, email, timezone, locale, picture, gender, initialLocale, test, encrypted);
        }

        public static /* synthetic */ UserPreferencesWrapper copy$default(UserPreferencesWrapper userPreferencesWrapper, String string, String string2, String string3, ZoneId zoneId, Locale locale, String string4, String string5, Locale locale2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = userPreferencesWrapper.firstName;
            }
            if ((n & 2) != 0) {
                string2 = userPreferencesWrapper.lastName;
            }
            if ((n & 4) != 0) {
                string3 = userPreferencesWrapper.email;
            }
            if ((n & 8) != 0) {
                zoneId = userPreferencesWrapper.timezone;
            }
            if ((n & 0x10) != 0) {
                locale = userPreferencesWrapper.locale;
            }
            if ((n & 0x20) != 0) {
                string4 = userPreferencesWrapper.picture;
            }
            if ((n & 0x40) != 0) {
                string5 = userPreferencesWrapper.gender;
            }
            if ((n & 0x80) != 0) {
                locale2 = userPreferencesWrapper.initialLocale;
            }
            if ((n & 0x100) != 0) {
                bl = userPreferencesWrapper.test;
            }
            if ((n & 0x200) != 0) {
                bl2 = userPreferencesWrapper.encrypted;
            }
            return userPreferencesWrapper.copy(string, string2, string3, zoneId, locale, string4, string5, locale2, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "UserPreferencesWrapper(firstName=" + this.firstName + ", lastName=" + this.lastName + ", email=" + this.email + ", timezone=" + this.timezone + ", locale=" + this.locale + ", picture=" + this.picture + ", gender=" + this.gender + ", initialLocale=" + this.initialLocale + ", test=" + this.test + ", encrypted=" + this.encrypted + ")";
        }

        public int hashCode() {
            int result = this.firstName == null ? 0 : this.firstName.hashCode();
            result = result * 31 + (this.lastName == null ? 0 : this.lastName.hashCode());
            result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
            result = result * 31 + this.timezone.hashCode();
            result = result * 31 + this.locale.hashCode();
            result = result * 31 + (this.picture == null ? 0 : this.picture.hashCode());
            result = result * 31 + (this.gender == null ? 0 : this.gender.hashCode());
            result = result * 31 + this.initialLocale.hashCode();
            result = result * 31 + Boolean.hashCode(this.test);
            result = result * 31 + Boolean.hashCode(this.encrypted);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserPreferencesWrapper)) {
                return false;
            }
            UserPreferencesWrapper userPreferencesWrapper = (UserPreferencesWrapper)other;
            if (!Intrinsics.areEqual((Object)this.firstName, (Object)userPreferencesWrapper.firstName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastName, (Object)userPreferencesWrapper.lastName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.email, (Object)userPreferencesWrapper.email)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timezone, (Object)userPreferencesWrapper.timezone)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.locale, (Object)userPreferencesWrapper.locale)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.picture, (Object)userPreferencesWrapper.picture)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gender, (Object)userPreferencesWrapper.gender)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.initialLocale, (Object)userPreferencesWrapper.initialLocale)) {
                return false;
            }
            if (this.test != userPreferencesWrapper.test) {
                return false;
            }
            return this.encrypted == userPreferencesWrapper.encrypted;
        }

        public UserPreferencesWrapper() {
            this(null, null, null, null, null, null, null, null, false, false, 1023, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B/\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0014\b\u0001\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lai/tock/bot/mongo/UserTimelineCol$UserStateWrapper;", "", "state", "Lai/tock/bot/engine/user/UserState;", "(Lai/tock/bot/engine/user/UserState;)V", "creationDate", "Ljava/time/Instant;", "lastUpdateDate", "flags", "", "", "Lai/tock/bot/mongo/UserTimelineCol$TimeBoxedFlagWrapper;", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/util/Map;)V", "getCreationDate", "()Ljava/time/Instant;", "getFlags", "()Ljava/util/Map;", "getLastUpdateDate", "toUserState", "tock-bot-storage-mongo"})
    @SourceDebugExtension(value={"SMAP\nUserTimelineCol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserTimelineCol.kt\nai/tock/bot/mongo/UserTimelineCol$UserStateWrapper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n462#2:246\n412#2:247\n462#2:252\n412#2:253\n1246#3,4:248\n1246#3,4:254\n*S KotlinDebug\n*F\n+ 1 UserTimelineCol.kt\nai/tock/bot/mongo/UserTimelineCol$UserStateWrapper\n*L\n185#1:246\n185#1:247\n196#1:252\n196#1:253\n185#1:248,4\n196#1:254,4\n*E\n"})
    public static final class UserStateWrapper {
        @NotNull
        private final Instant creationDate;
        @NotNull
        private final Instant lastUpdateDate;
        @NotNull
        private final Map<String, TimeBoxedFlagWrapper> flags;

        public UserStateWrapper(@NotNull Instant creationDate, @NotNull Instant lastUpdateDate, @JsonDeserialize(using=FlagsDeserializer.class) @NotNull Map<String, TimeBoxedFlagWrapper> flags2) {
            Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
            Intrinsics.checkNotNullParameter((Object)lastUpdateDate, (String)"lastUpdateDate");
            Intrinsics.checkNotNullParameter(flags2, (String)"flags");
            this.creationDate = creationDate;
            this.lastUpdateDate = lastUpdateDate;
            this.flags = flags2;
        }

        public /* synthetic */ UserStateWrapper(Instant instant, Instant instant2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Instant instant3 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now(...)");
                instant = instant3;
            }
            if ((n & 2) != 0) {
                instant2 = instant;
            }
            this(instant, instant2, map);
        }

        @NotNull
        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @NotNull
        public final Instant getLastUpdateDate() {
            return this.lastUpdateDate;
        }

        @NotNull
        public final Map<String, TimeBoxedFlagWrapper> getFlags() {
            return this.flags;
        }

        /*
         * WARNING - void declaration
         */
        public UserStateWrapper(@NotNull UserState state2) {
            Map map;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            Instant instant = state2.getCreationDate();
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            Map map2 = state2.getFlags();
            Instant instant3 = instant2;
            Instant instant4 = instant;
            UserStateWrapper userStateWrapper = this;
            boolean $i$f$mapValues = false;
            void var4_7 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                map = map3;
                boolean bl2 = false;
                TimeBoxedFlagWrapper timeBoxedFlagWrapper = new TimeBoxedFlagWrapper((TimeBoxedFlag)it.getValue(), MongoBotConfiguration.INSTANCE.hasToEncryptFlag((String)it.getKey()));
                map.put(k, timeBoxedFlagWrapper);
            }
            map = destination$iv$iv;
            userStateWrapper(instant4, instant3, map);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final UserState toUserState() {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map<String, TimeBoxedFlagWrapper> map = this.flags;
            Instant instant = this.creationDate;
            boolean $i$f$mapValues = false;
            void var3_4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                TimeBoxedFlag timeBoxedFlag = ((TimeBoxedFlagWrapper)it.getValue()).toTimeBoxedFlag();
                map3.put(k, timeBoxedFlag);
            }
            Map map4 = MapsKt.toMutableMap((Map)destination$iv$iv);
            Instant instant2 = instant;
            return new UserState(instant2, map4);
        }
    }
}

