/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.translator.deepl;

import ai.tock.shared.PropertiesKt;
import ai.tock.shared.TockProxyAuthenticator;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.translator.deepl.DeeplClient;
import ai.tock.translator.deepl.Translation;
import ai.tock.translator.deepl.TranslationResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B6\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u001e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0002J4\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/tock/translator/deepl/OkHttpDeeplClient;", "Lai/tock/translator/deepl/DeeplClient;", "apiURL", "", "apiKey", "okHttpCustomizer", "Lkotlin/Function1;", "Lokhttp3/OkHttpClient$Builder;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "client", "Lokhttp3/OkHttpClient;", "replaceSpecificPlaceholders", "Lkotlin/Pair;", "", "text", "revertSpecificPlaceholders", "placeholders", "translate", "sourceLang", "targetLang", "preserveFormatting", "", "glossaryId", "tock-deepl-translate"})
@SourceDebugExtension(value={"SMAP\nDeeplClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeeplClient.kt\nai/tock/translator/deepl/OkHttpDeeplClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,125:1\n1#2:126\n58#3:127\n51#3:128\n*S KotlinDebug\n*F\n+ 1 DeeplClient.kt\nai/tock/translator/deepl/OkHttpDeeplClient\n*L\n119#1:127\n119#1:128\n*E\n"})
public final class OkHttpDeeplClient
implements DeeplClient {
    @NotNull
    private final String apiURL;
    @Nullable
    private final String apiKey;
    @NotNull
    private final OkHttpClient client;

    /*
     * WARNING - void declaration
     */
    public OkHttpDeeplClient(@NotNull String apiURL, @Nullable String apiKey, @NotNull Function1<? super OkHttpClient.Builder, Unit> okHttpCustomizer) {
        void p0;
        Intrinsics.checkNotNullParameter((Object)apiURL, (String)"apiURL");
        Intrinsics.checkNotNullParameter(okHttpCustomizer, (String)"okHttpCustomizer");
        this.apiURL = apiURL;
        this.apiKey = apiKey;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        TockProxyAuthenticator.Companion companion = TockProxyAuthenticator.Companion;
        OkHttpClient.Builder builder2 = builder;
        OkHttpDeeplClient okHttpDeeplClient = this;
        boolean bl = false;
        companion.install((OkHttpClient.Builder)p0);
        okHttpCustomizer.invoke((Object)builder);
        okHttpDeeplClient.client = builder.build();
    }

    public /* synthetic */ OkHttpDeeplClient(String string, String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = PropertiesKt.property((String)"tock_translator_deepl_api_url", (String)"https://api.deepl.com/v2/translate");
        }
        if ((n & 2) != 0) {
            string2 = PropertiesKt.propertyOrNull((String)"tock_translator_deepl_api_key");
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, string2, (Function1<? super OkHttpClient.Builder, Unit>)function1);
    }

    private final Pair<String, List<String>> replaceSpecificPlaceholders(String text) {
        Pattern placeholderPattern = Pattern.compile("\\{:([^}]*)}");
        Matcher matcher = placeholderPattern.matcher(text);
        List placeholders = new ArrayList();
        while (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            placeholders.add(string);
        }
        String replacedText = matcher.replaceAll("_PLACEHOLDER_");
        return new Pair((Object)replacedText, (Object)placeholders);
    }

    private final String revertSpecificPlaceholders(String text, List<String> placeholders) {
        String resultText = text;
        for (String placeholder : placeholders) {
            resultText = StringsKt.replaceFirst$default((String)resultText, (String)"_PLACEHOLDER_", (String)("{:" + placeholder + "}"), (boolean)false, (int)4, null);
        }
        return resultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String translate(@NotNull String text, @NotNull String sourceLang, @NotNull String targetLang, boolean preserveFormatting, @Nullable String glossaryId) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)sourceLang, (String)"sourceLang");
        Intrinsics.checkNotNullParameter((Object)targetLang, (String)"targetLang");
        if (this.apiKey == null) {
            return text;
        }
        Pair<String, List<String>> pair = this.replaceSpecificPlaceholders(text);
        String textWithPlaceholders = (String)pair.component1();
        List originalPlaceholders = (List)pair.component2();
        FormBody.Builder formBuilder = new FormBody.Builder(null, 1, null);
        FormBody requestBody = formBuilder.add("text", textWithPlaceholders).add("source_lang", sourceLang).add("target_lang", targetLang).add("preserve_formatting", String.valueOf(preserveFormatting)).add("tag_handling", "xml").build();
        String string = glossaryId;
        if (string != null) {
            String it = string;
            boolean bl = false;
            formBuilder.add("glossary_id", it);
        }
        Request request = new Request.Builder().url(this.apiURL).addHeader("Authorization", "DeepL-Auth-Key " + this.apiKey).post((RequestBody)requestBody).build();
        Closeable closeable = (Closeable)this.client.newCall(request).execute();
        Throwable throwable = null;
        try {
            String string2;
            String translatedText;
            void $this$readValue$iv;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            ResponseBody responseBody = response.body();
            String responseBody2 = responseBody != null ? responseBody.string() : null;
            ObjectMapper objectMapper = JacksonKt.getMapper();
            String string3 = responseBody2;
            Intrinsics.checkNotNull((Object)string3);
            String content$iv = string3;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            TranslationResponse translationResponse = (TranslationResponse)$this$readValue$iv.readValue(content$iv, (TypeReference)new TypeReference<TranslationResponse>(){});
            Translation translation = (Translation)CollectionsKt.firstOrNull(translationResponse.getTranslations());
            String string4 = translatedText = translation != null ? translation.getText() : null;
            if (string4 != null) {
                String it = string4;
                boolean bl2 = false;
                string2 = this.revertSpecificPlaceholders(it, originalPlaceholders);
            } else {
                string2 = null;
            }
            String string5 = string2;
            return string5;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public OkHttpDeeplClient() {
        this(null, null, null, 7, null);
    }
}

