/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.genai.orchestratorclient.retrofit;

import ai.tock.genai.orchestratorclient.responses.ErrorResponse;
import ai.tock.genai.orchestratorclient.retrofit.GenAIOrchestratorBusinessError;
import ai.tock.genai.orchestratorclient.retrofit.GenAIOrchestratorValidationError;
import ai.tock.genai.orchestratorclient.retrofit.HTTPValidationErrorResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/tock/genai/orchestratorclient/retrofit/GenAIOrchestratorInterceptor;", "Lokhttp3/Interceptor;", "jsonObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "handleApiError", "", "response", "tock-gen-ai-orchestrator-client"})
public final class GenAIOrchestratorInterceptor
implements Interceptor {
    @NotNull
    private final ObjectMapper jsonObjectMapper;

    public GenAIOrchestratorInterceptor(@NotNull ObjectMapper jsonObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)jsonObjectMapper, (String)"jsonObjectMapper");
        this.jsonObjectMapper = jsonObjectMapper;
    }

    public /* synthetic */ GenAIOrchestratorInterceptor(ObjectMapper objectMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectMapper = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null);
        }
        this(objectMapper);
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        try {
            Response response = chain.proceed(chain.request());
            if (!response.isSuccessful()) {
                this.handleApiError(response);
            }
            return response;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw exc;
        }
    }

    private final void handleApiError(Response response) {
        ResponseBody responseBody = response.body();
        String errorBody = responseBody != null ? responseBody.string() : null;
        switch (response.code()) {
            case 400: {
                ErrorResponse errorResponse = (ErrorResponse)this.jsonObjectMapper.readValue(errorBody, ErrorResponse.class);
                Intrinsics.checkNotNull((Object)errorResponse);
                throw new GenAIOrchestratorBusinessError(null, errorResponse, 1, null);
            }
            case 422: {
                HTTPValidationErrorResponse errorResponse = (HTTPValidationErrorResponse)this.jsonObjectMapper.readValue(errorBody, HTTPValidationErrorResponse.class);
                throw new GenAIOrchestratorValidationError(null, errorResponse.getDetail(), 1, null);
            }
        }
        throw new Exception("Generative AI Orchestrator unknown error");
    }

    public GenAIOrchestratorInterceptor() {
        this(null, 1, null);
    }
}

