/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.iadvize.client.authentication;

import ai.tock.iadvize.client.ErrorsKt;
import ai.tock.iadvize.client.IadvizeApi;
import ai.tock.iadvize.client.IadvizeApiKt;
import ai.tock.iadvize.client.authentication.models.AuthResponse;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.security.credentials.CredentialsProvider;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\n\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lai/tock/iadvize/client/authentication/IadvizeAuthenticationClient;", "", "<init>", "()V", "credentialsProvider", "Lai/tock/shared/security/credentials/CredentialsProvider;", "getCredentialsProvider", "()Lai/tock/shared/security/credentials/CredentialsProvider;", "credentialsProvider$delegate", "Lkotlin/Lazy;", "iadvizeApi", "Lai/tock/iadvize/client/IadvizeApi;", "getIadvizeApi$tock_iadvize_client", "()Lai/tock/iadvize/client/IadvizeApi;", "setIadvizeApi$tock_iadvize_client", "(Lai/tock/iadvize/client/IadvizeApi;)V", "username", "", "getUsername", "()Ljava/lang/String;", "username$delegate", "password", "getPassword", "password$delegate", "getAccessToken", "getToken", "Lai/tock/iadvize/client/authentication/IadvizeAuthenticationClient$Token;", "Companion", "Token", "tock-iadvize-client"})
@SourceDebugExtension(value={"SMAP\nIadvizeAuthenticationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IadvizeAuthenticationClient.kt\nai/tock/iadvize/client/authentication/IadvizeAuthenticationClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IOCs.kt\nai/tock/shared/IOCsKt\n+ 4 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 5 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,89:1\n1#2:90\n53#3,2:91\n51#4:93\n277#5:94\n*S KotlinDebug\n*F\n+ 1 IadvizeAuthenticationClient.kt\nai/tock/iadvize/client/authentication/IadvizeAuthenticationClient\n*L\n43#1:91,2\n43#1:93\n43#1:94\n*E\n"})
public final class IadvizeAuthenticationClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy credentialsProvider$delegate = LazyKt.lazy(IadvizeAuthenticationClient::credentialsProvider_delegate$lambda$0);
    @NotNull
    private IadvizeApi iadvizeApi = IadvizeApiKt.createApi(logger);
    @NotNull
    private final Lazy username$delegate = LazyKt.lazy(() -> IadvizeAuthenticationClient.username_delegate$lambda$1(this));
    @NotNull
    private final Lazy password$delegate = LazyKt.lazy(() -> IadvizeAuthenticationClient.password_delegate$lambda$2(this));
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(IadvizeAuthenticationClient::logger$lambda$6);
    @NotNull
    private static final AtomicReference<Token> token = new AtomicReference();
    public static final int DELAY_SECONDS = 5;

    private final CredentialsProvider getCredentialsProvider() {
        Lazy lazy = this.credentialsProvider$delegate;
        return (CredentialsProvider)lazy.getValue();
    }

    @NotNull
    public final IadvizeApi getIadvizeApi$tock_iadvize_client() {
        return this.iadvizeApi;
    }

    public final void setIadvizeApi$tock_iadvize_client(@NotNull IadvizeApi iadvizeApi) {
        Intrinsics.checkNotNullParameter((Object)iadvizeApi, (String)"<set-?>");
        this.iadvizeApi = iadvizeApi;
    }

    private final String getUsername() {
        Lazy lazy = this.username$delegate;
        return (String)lazy.getValue();
    }

    private final String getPassword() {
        Lazy lazy = this.password$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getAccessToken() {
        Token t;
        block4: {
            block3: {
                t = token.get();
                if (t == null) break block3;
                LocalDateTime localDateTime = t.getExpireAt();
                boolean bl = localDateTime != null ? localDateTime.isBefore(LocalDateTime.now()) : false;
                if (!bl) break block4;
            }
            t = this.getToken();
        }
        return t.getValue();
    }

    private final Token getToken() {
        Token token;
        LocalDateTime localDateTime;
        String value;
        AuthResponse authResponse = (AuthResponse)this.iadvizeApi.createToken(this.getUsername(), this.getPassword(), "password").execute().body();
        if (authResponse != null) {
            AuthResponse it = authResponse;
            boolean bl = false;
            String string = it.getAccessToken();
            if (string == null) {
                ErrorsKt.authenticationFailedError();
                throw new KotlinNothingValueException();
            }
            value = string;
            Number number = it.getExpiresIn();
            if (number != null) {
                Number s = number;
                boolean bl2 = false;
                localDateTime = LocalDateTime.now().plusSeconds(s.longValue() - (long)5);
            } else {
                localDateTime = null;
            }
        } else {
            ErrorsKt.authenticationFailedError();
            throw new KotlinNothingValueException();
        }
        LocalDateTime time = localDateTime;
        Token t = token = new Token(value, time);
        boolean bl = false;
        IadvizeAuthenticationClient.token.set(t);
        return token;
    }

    private static final CredentialsProvider credentialsProvider_delegate$lambda$0() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (CredentialsProvider)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<CredentialsProvider>(){}, tag$iv).getValue()).invoke();
    }

    private static final String username_delegate$lambda$1(IadvizeAuthenticationClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getCredentialsProvider().getCredentials().getUsername();
    }

    private static final String password_delegate$lambda$2(IadvizeAuthenticationClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getCredentialsProvider().getCredentials().getPassword();
    }

    private static final Unit logger$lambda$6() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/tock/iadvize/client/authentication/IadvizeAuthenticationClient$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "token", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/tock/iadvize/client/authentication/IadvizeAuthenticationClient$Token;", "getToken", "()Ljava/util/concurrent/atomic/AtomicReference;", "DELAY_SECONDS", "", "tock-iadvize-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        @NotNull
        public final AtomicReference<Token> getToken() {
            return token;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lai/tock/iadvize/client/authentication/IadvizeAuthenticationClient$Token;", "", "value", "", "expireAt", "Ljava/time/LocalDateTime;", "<init>", "(Ljava/lang/String;Ljava/time/LocalDateTime;)V", "getValue", "()Ljava/lang/String;", "getExpireAt", "()Ljava/time/LocalDateTime;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-iadvize-client"})
    public static final class Token {
        @NotNull
        private final String value;
        @Nullable
        private final LocalDateTime expireAt;

        public Token(@NotNull String value, @Nullable LocalDateTime expireAt) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.expireAt = expireAt;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final LocalDateTime getExpireAt() {
            return this.expireAt;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @Nullable
        public final LocalDateTime component2() {
            return this.expireAt;
        }

        @NotNull
        public final Token copy(@NotNull String value, @Nullable LocalDateTime expireAt) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Token(value, expireAt);
        }

        public static /* synthetic */ Token copy$default(Token token, String string, LocalDateTime localDateTime, int n, Object object) {
            if ((n & 1) != 0) {
                string = token.value;
            }
            if ((n & 2) != 0) {
                localDateTime = token.expireAt;
            }
            return token.copy(string, localDateTime);
        }

        @NotNull
        public String toString() {
            return "Token(value=" + this.value + ", expireAt=" + this.expireAt + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + (this.expireAt == null ? 0 : this.expireAt.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)token.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.expireAt, (Object)token.expireAt);
        }
    }
}

