/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.iadvize.client;

import java.io.EOFException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lai/tock/iadvize/client/LoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lmu/KLogger;", "(Lmu/KLogger;)V", "getLogger", "()Lmu/KLogger;", "bodyEncoded", "", "headers", "Lokhttp3/Headers;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isPlaintext", "buffer", "Lokio/Buffer;", "tock-iadvize-client"})
@SourceDebugExtension(value={"SMAP\nretrofit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 retrofit.kt\nai/tock/iadvize/client/LoggingInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,186:1\n2642#2:187\n2642#2:192\n1#3:188\n1#3:193\n1#3:194\n29#4,3:189\n*S KotlinDebug\n*F\n+ 1 retrofit.kt\nai/tock/iadvize/client/LoggingInterceptor\n*L\n51#1:187\n94#1:192\n51#1:188\n94#1:193\n81#1:189,3\n*E\n"})
final class LoggingInterceptor
implements Interceptor {
    @NotNull
    private final KLogger logger;

    public LoggingInterceptor(@NotNull KLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Iterable iterable3;
        Pair it;
        Iterable iterable2;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Connection connection = chain.connection();
        Connection connection2 = connection;
        if (connection2 == null || (connection2 = connection2.protocol()) == null) {
            connection2 = Protocol.HTTP_1_1;
        }
        Connection protocol = connection2;
        Request request = chain.request();
        this.logger.info("--> " + request.method() + " " + request.url() + " " + (Protocol)protocol);
        Iterable $this$onEach$iv = (Iterable)request.headers();
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2418$iv = iterable2 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            it = (Pair)element$iv;
            boolean bl2 = false;
            this.logger.debug((Function0)new Function0<Object>((Pair<String, String>)it){
                final /* synthetic */ Pair<String, String> $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final Object invoke() {
                    return this.$it.getFirst() + ": " + this.$it.getSecond();
                }
            });
        }
        Headers requestHeaders2 = (Headers)iterable2;
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            this.logger.info("--> END " + request.method());
        } else if (this.bodyEncoded(requestHeaders2)) {
            this.logger.info("--> END " + request.method() + " (encoded body omitted)");
        } else {
            RequestBody $this$intercept_u24lambda_u242 = requestBody;
            boolean bl3 = false;
            Buffer buffer = new Buffer();
            $this$intercept_u24lambda_u242.writeTo((BufferedSink)buffer);
            if (this.isPlaintext(buffer)) {
                Object object = $this$intercept_u24lambda_u242.contentType();
                if (object == null || (object = object.charset(StandardCharsets.UTF_8)) == null) {
                    object = StandardCharsets.UTF_8;
                }
                Object it2 = object;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it2);
                this.logger.debug(buffer.readString((Charset)it2));
                this.logger.info("--> END " + request.method() + " (" + $this$intercept_u24lambda_u242.contentLength() + "-byte body)");
            } else {
                this.logger.info("--> END " + request.method() + " (binary " + $this$intercept_u24lambda_u242.contentLength() + "-byte body omitted)");
            }
        }
        Response response = null;
        Ref.ObjectRef responseBody = new Ref.ObjectRef();
        try {
            void $this$intercept_u24lambda_u245_u24lambda_u244;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl5 = false;
            response = chain.proceed(request);
            long it3 = System.currentTimeMillis() - start$iv;
            boolean iterable3 = false;
            it = response;
            Ref.ObjectRef bl2 = responseBody;
            boolean bl6 = false;
            this.logger.info("<-- " + $this$intercept_u24lambda_u245_u24lambda_u244.code() + " " + $this$intercept_u24lambda_u245_u24lambda_u244.message() + " " + request.url() + " (" + it3 + " ms)");
            bl2.element = $this$intercept_u24lambda_u245_u24lambda_u244.body();
        }
        catch (Exception e) {
            this.logger.error("<-- HTTP FAILED: " + e);
            throw e;
        }
        Iterable $this$onEach$iv2 = (Iterable)response.headers();
        boolean $i$f$onEach2 = false;
        Iterable $this$onEach_u24lambda_u2418$iv2 = iterable3 = $this$onEach$iv2;
        $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv2) {
            Pair it4 = (Pair)element$iv;
            boolean bl7 = false;
            this.logger.debug((Function0)new Function0<Object>((Pair<String, String>)it4){
                final /* synthetic */ Pair<String, String> $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final Object invoke() {
                    return this.$it.getFirst() + " : " + this.$it.getSecond();
                }
            });
        }
        Headers responseHeaders2 = (Headers)iterable3;
        if (!HttpHeaders.promisesBody((Response)response)) {
            this.logger.info("<-- END HTTP");
        } else if (this.bodyEncoded(responseHeaders2)) {
            this.logger.info("<-- END HTTP (encoded body omitted)");
        } else {
            Charset charset;
            Object object = responseBody.element;
            Intrinsics.checkNotNull((Object)object);
            ResponseBody $this$intercept_u24lambda_u248 = (ResponseBody)object;
            boolean bl8 = false;
            Iterable $this$intercept_u24lambda_u248_u24lambda_u247 = $this$onEach_u24lambda_u2418$iv2 = $this$intercept_u24lambda_u248.source();
            boolean bl9 = false;
            $this$intercept_u24lambda_u248_u24lambda_u247.request(Long.MAX_VALUE);
            Buffer buffer = $this$onEach_u24lambda_u2418$iv2.getBuffer();
            if (!this.isPlaintext(buffer)) {
                this.logger.info("");
                this.logger.info("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                return response;
            }
            MediaType mediaType = $this$intercept_u24lambda_u248.contentType();
            Charset charset2 = charset = mediaType != null ? mediaType.charset(StandardCharsets.UTF_8) : null;
            if ($this$intercept_u24lambda_u248.contentLength() != 0L) {
                this.logger.info("");
                Buffer buffer2 = buffer.clone();
                Charset charset3 = charset;
                Intrinsics.checkNotNull((Object)charset3);
                this.logger.debug(buffer2.readString(charset3));
            }
            this.logger.info("<-- END HTTP (" + buffer.size() + "-byte body)");
        }
        return response;
    }

    public final boolean isPlaintext(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                if (!Character.isISOControl(prefix.readUtf8CodePoint())) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private final boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true);
    }
}

